/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.validation.datarule;

import cdm.product.collateral.ReturnAmount;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ReturnAmountCustomElection")
@ImplementedBy(value=Default.class)
public interface ReturnAmountCustomElection
extends Validator<ReturnAmount> {
    public static final String NAME = "ReturnAmountCustomElection";
    public static final String DEFINITION = "if customElection exists then includesDefaultLanguage = False";

    public ValidationResult<ReturnAmount> validate(RosettaPath var1, ReturnAmount var2);

    public static class NoOp
    implements ReturnAmountCustomElection {
        @Override
        public ValidationResult<ReturnAmount> validate(RosettaPath path, ReturnAmount returnAmount) {
            return ValidationResult.success((String)ReturnAmountCustomElection.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReturnAmount", (RosettaPath)path, (String)ReturnAmountCustomElection.DEFINITION);
        }
    }

    public static class Default
    implements ReturnAmountCustomElection {
        @Override
        public ValidationResult<ReturnAmount> validate(RosettaPath path, ReturnAmount returnAmount) {
            ComparisonResult result = this.executeDataRule(returnAmount);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ReturnAmountCustomElection.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReturnAmount", (RosettaPath)path, (String)ReturnAmountCustomElection.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ReturnAmountCustomElection failed.";
            }
            return ValidationResult.failure((String)ReturnAmountCustomElection.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReturnAmount", (RosettaPath)path, (String)ReturnAmountCustomElection.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ReturnAmount returnAmount) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)returnAmount).map("getCustomElection", _returnAmount -> _returnAmount.getCustomElection())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)returnAmount).map("getIncludesDefaultLanguage", _returnAmount -> _returnAmount.getIncludesDefaultLanguage()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

