/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.Period;
import cdm.product.collateral.meta.SubstitutionProvisionsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface SubstitutionProvisions
extends RosettaModelObject {
    public static final SubstitutionProvisionsMeta metaData = new SubstitutionProvisionsMeta();

    public SubstitutionProvisions build();

    public SubstitutionProvisionsBuilder toBuilder();

    public ZonedDateTime getNoticeDeadlineDateTime();

    public Period getNoticeDeadlinePeriod();

    public Integer getNumberOfSubstitutionsAllowed();

    default public RosettaMetaData<? extends SubstitutionProvisions> metaData() {
        return metaData;
    }

    public static SubstitutionProvisionsBuilder builder() {
        return new SubstitutionProvisionsBuilderImpl();
    }

    default public Class<? extends SubstitutionProvisions> getType() {
        return SubstitutionProvisions.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("noticeDeadlineDateTime"), ZonedDateTime.class, (Object)this.getNoticeDeadlineDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfSubstitutionsAllowed"), Integer.class, (Object)this.getNumberOfSubstitutionsAllowed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("noticeDeadlinePeriod"), processor, Period.class, this.getNoticeDeadlinePeriod(), new AttributeMeta[0]);
    }

    public static class SubstitutionProvisionsBuilderImpl
    implements SubstitutionProvisionsBuilder {
        protected ZonedDateTime noticeDeadlineDateTime;
        protected Period.PeriodBuilder noticeDeadlinePeriod;
        protected Integer numberOfSubstitutionsAllowed;

        @Override
        public ZonedDateTime getNoticeDeadlineDateTime() {
            return this.noticeDeadlineDateTime;
        }

        @Override
        public Period.PeriodBuilder getNoticeDeadlinePeriod() {
            return this.noticeDeadlinePeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateNoticeDeadlinePeriod() {
            Period.PeriodBuilder result = this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod : (this.noticeDeadlinePeriod = Period.builder());
            return result;
        }

        @Override
        public Integer getNumberOfSubstitutionsAllowed() {
            return this.numberOfSubstitutionsAllowed;
        }

        @Override
        public SubstitutionProvisionsBuilder setNoticeDeadlineDateTime(ZonedDateTime noticeDeadlineDateTime) {
            this.noticeDeadlineDateTime = noticeDeadlineDateTime == null ? null : noticeDeadlineDateTime;
            return this;
        }

        @Override
        public SubstitutionProvisionsBuilder setNoticeDeadlinePeriod(Period noticeDeadlinePeriod) {
            this.noticeDeadlinePeriod = noticeDeadlinePeriod == null ? null : noticeDeadlinePeriod.toBuilder();
            return this;
        }

        @Override
        public SubstitutionProvisionsBuilder setNumberOfSubstitutionsAllowed(Integer numberOfSubstitutionsAllowed) {
            this.numberOfSubstitutionsAllowed = numberOfSubstitutionsAllowed == null ? null : numberOfSubstitutionsAllowed;
            return this;
        }

        @Override
        public SubstitutionProvisions build() {
            return new SubstitutionProvisionsImpl(this);
        }

        @Override
        public SubstitutionProvisionsBuilder toBuilder() {
            return this;
        }

        @Override
        public SubstitutionProvisionsBuilder prune() {
            if (this.noticeDeadlinePeriod != null && !this.noticeDeadlinePeriod.prune().hasData()) {
                this.noticeDeadlinePeriod = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNoticeDeadlineDateTime() != null) {
                return true;
            }
            if (this.getNoticeDeadlinePeriod() != null && this.getNoticeDeadlinePeriod().hasData()) {
                return true;
            }
            return this.getNumberOfSubstitutionsAllowed() != null;
        }

        public SubstitutionProvisionsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SubstitutionProvisionsBuilder o = (SubstitutionProvisionsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNoticeDeadlinePeriod(), (RosettaModelObjectBuilder)o.getNoticeDeadlinePeriod(), this::setNoticeDeadlinePeriod);
            merger.mergeBasic((Object)this.getNoticeDeadlineDateTime(), (Object)o.getNoticeDeadlineDateTime(), this::setNoticeDeadlineDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfSubstitutionsAllowed(), (Object)o.getNumberOfSubstitutionsAllowed(), this::setNumberOfSubstitutionsAllowed, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SubstitutionProvisions _that = this.getType().cast(o);
            if (!Objects.equals(this.noticeDeadlineDateTime, _that.getNoticeDeadlineDateTime())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlinePeriod, _that.getNoticeDeadlinePeriod())) {
                return false;
            }
            return Objects.equals(this.numberOfSubstitutionsAllowed, _that.getNumberOfSubstitutionsAllowed());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.noticeDeadlineDateTime != null ? this.noticeDeadlineDateTime.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod.hashCode() : 0);
            _result = 31 * _result + (this.numberOfSubstitutionsAllowed != null ? this.numberOfSubstitutionsAllowed.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SubstitutionProvisionsBuilder {noticeDeadlineDateTime=" + this.noticeDeadlineDateTime + ", noticeDeadlinePeriod=" + this.noticeDeadlinePeriod + ", numberOfSubstitutionsAllowed=" + this.numberOfSubstitutionsAllowed + '}';
        }
    }

    public static class SubstitutionProvisionsImpl
    implements SubstitutionProvisions {
        private final ZonedDateTime noticeDeadlineDateTime;
        private final Period noticeDeadlinePeriod;
        private final Integer numberOfSubstitutionsAllowed;

        protected SubstitutionProvisionsImpl(SubstitutionProvisionsBuilder builder) {
            this.noticeDeadlineDateTime = builder.getNoticeDeadlineDateTime();
            this.noticeDeadlinePeriod = Optional.ofNullable(builder.getNoticeDeadlinePeriod()).map(f -> f.build()).orElse(null);
            this.numberOfSubstitutionsAllowed = builder.getNumberOfSubstitutionsAllowed();
        }

        @Override
        public ZonedDateTime getNoticeDeadlineDateTime() {
            return this.noticeDeadlineDateTime;
        }

        @Override
        public Period getNoticeDeadlinePeriod() {
            return this.noticeDeadlinePeriod;
        }

        @Override
        public Integer getNumberOfSubstitutionsAllowed() {
            return this.numberOfSubstitutionsAllowed;
        }

        @Override
        public SubstitutionProvisions build() {
            return this;
        }

        @Override
        public SubstitutionProvisionsBuilder toBuilder() {
            SubstitutionProvisionsBuilder builder = SubstitutionProvisions.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SubstitutionProvisionsBuilder builder) {
            Optional.ofNullable(this.getNoticeDeadlineDateTime()).ifPresent(builder::setNoticeDeadlineDateTime);
            Optional.ofNullable(this.getNoticeDeadlinePeriod()).ifPresent(builder::setNoticeDeadlinePeriod);
            Optional.ofNullable(this.getNumberOfSubstitutionsAllowed()).ifPresent(builder::setNumberOfSubstitutionsAllowed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SubstitutionProvisions _that = this.getType().cast(o);
            if (!Objects.equals(this.noticeDeadlineDateTime, _that.getNoticeDeadlineDateTime())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlinePeriod, _that.getNoticeDeadlinePeriod())) {
                return false;
            }
            return Objects.equals(this.numberOfSubstitutionsAllowed, _that.getNumberOfSubstitutionsAllowed());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.noticeDeadlineDateTime != null ? this.noticeDeadlineDateTime.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod.hashCode() : 0);
            _result = 31 * _result + (this.numberOfSubstitutionsAllowed != null ? this.numberOfSubstitutionsAllowed.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SubstitutionProvisions {noticeDeadlineDateTime=" + this.noticeDeadlineDateTime + ", noticeDeadlinePeriod=" + this.noticeDeadlinePeriod + ", numberOfSubstitutionsAllowed=" + this.numberOfSubstitutionsAllowed + '}';
        }
    }

    public static interface SubstitutionProvisionsBuilder
    extends SubstitutionProvisions,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateNoticeDeadlinePeriod();

        @Override
        public Period.PeriodBuilder getNoticeDeadlinePeriod();

        public SubstitutionProvisionsBuilder setNoticeDeadlineDateTime(ZonedDateTime var1);

        public SubstitutionProvisionsBuilder setNoticeDeadlinePeriod(Period var1);

        public SubstitutionProvisionsBuilder setNumberOfSubstitutionsAllowed(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("noticeDeadlineDateTime"), ZonedDateTime.class, (Object)this.getNoticeDeadlineDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfSubstitutionsAllowed"), Integer.class, (Object)this.getNumberOfSubstitutionsAllowed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("noticeDeadlinePeriod"), processor, Period.PeriodBuilder.class, this.getNoticeDeadlinePeriod(), new AttributeMeta[0]);
        }

        public SubstitutionProvisionsBuilder prune();
    }
}

