/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.staticdata.asset.common.CollateralIssuerType;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.collateral.AgencyRatingCriteria;
import cdm.product.collateral.meta.IssuerCriteriaMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface IssuerCriteria
extends RosettaModelObject {
    public static final IssuerCriteriaMeta metaData = new IssuerCriteriaMeta();

    public IssuerCriteria build();

    public IssuerCriteriaBuilder toBuilder();

    public Boolean getCounterpartyOwnIssuePermitted();

    public List<? extends AgencyRatingCriteria> getIssuerAgencyRating();

    public List<? extends FieldWithMetaString> getIssuerCountryOfOrigin();

    public List<? extends LegalEntity> getIssuerName();

    public List<? extends CollateralIssuerType> getIssuerType();

    public List<? extends AgencyRatingCriteria> getSovereignAgencyRating();

    default public RosettaMetaData<? extends IssuerCriteria> metaData() {
        return metaData;
    }

    public static IssuerCriteriaBuilder builder() {
        return new IssuerCriteriaBuilderImpl();
    }

    default public Class<? extends IssuerCriteria> getType() {
        return IssuerCriteria.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("counterpartyOwnIssuePermitted"), Boolean.class, (Object)this.getCounterpartyOwnIssuePermitted(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerAgencyRating"), processor, AgencyRatingCriteria.class, this.getIssuerAgencyRating(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerCountryOfOrigin"), processor, FieldWithMetaString.class, this.getIssuerCountryOfOrigin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerName"), processor, LegalEntity.class, this.getIssuerName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerType"), processor, CollateralIssuerType.class, this.getIssuerType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sovereignAgencyRating"), processor, AgencyRatingCriteria.class, this.getSovereignAgencyRating(), new AttributeMeta[0]);
    }

    public static class IssuerCriteriaBuilderImpl
    implements IssuerCriteriaBuilder {
        protected Boolean counterpartyOwnIssuePermitted;
        protected List<AgencyRatingCriteria.AgencyRatingCriteriaBuilder> issuerAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> issuerCountryOfOrigin = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
        protected List<LegalEntity.LegalEntityBuilder> issuerName = new ArrayList<LegalEntity.LegalEntityBuilder>();
        protected List<CollateralIssuerType.CollateralIssuerTypeBuilder> issuerType = new ArrayList<CollateralIssuerType.CollateralIssuerTypeBuilder>();
        protected List<AgencyRatingCriteria.AgencyRatingCriteriaBuilder> sovereignAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();

        @Override
        public Boolean getCounterpartyOwnIssuePermitted() {
            return this.counterpartyOwnIssuePermitted;
        }

        @Override
        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getIssuerAgencyRating() {
            return this.issuerAgencyRating;
        }

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateIssuerAgencyRating(int _index) {
            if (this.issuerAgencyRating == null) {
                this.issuerAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
            }
            return (AgencyRatingCriteria.AgencyRatingCriteriaBuilder)this.getIndex(this.issuerAgencyRating, _index, () -> {
                AgencyRatingCriteria.AgencyRatingCriteriaBuilder newIssuerAgencyRating = AgencyRatingCriteria.builder();
                return newIssuerAgencyRating;
            });
        }

        @Override
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getIssuerCountryOfOrigin() {
            return this.issuerCountryOfOrigin;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIssuerCountryOfOrigin(int _index) {
            if (this.issuerCountryOfOrigin == null) {
                this.issuerCountryOfOrigin = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.issuerCountryOfOrigin, _index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newIssuerCountryOfOrigin = FieldWithMetaString.builder();
                return newIssuerCountryOfOrigin;
            });
        }

        @Override
        public List<? extends LegalEntity.LegalEntityBuilder> getIssuerName() {
            return this.issuerName;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateIssuerName(int _index) {
            if (this.issuerName == null) {
                this.issuerName = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.issuerName, _index, () -> {
                LegalEntity.LegalEntityBuilder newIssuerName = LegalEntity.builder();
                return newIssuerName;
            });
        }

        @Override
        public List<? extends CollateralIssuerType.CollateralIssuerTypeBuilder> getIssuerType() {
            return this.issuerType;
        }

        @Override
        public CollateralIssuerType.CollateralIssuerTypeBuilder getOrCreateIssuerType(int _index) {
            if (this.issuerType == null) {
                this.issuerType = new ArrayList<CollateralIssuerType.CollateralIssuerTypeBuilder>();
            }
            return (CollateralIssuerType.CollateralIssuerTypeBuilder)this.getIndex(this.issuerType, _index, () -> {
                CollateralIssuerType.CollateralIssuerTypeBuilder newIssuerType = CollateralIssuerType.builder();
                return newIssuerType;
            });
        }

        @Override
        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getSovereignAgencyRating() {
            return this.sovereignAgencyRating;
        }

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateSovereignAgencyRating(int _index) {
            if (this.sovereignAgencyRating == null) {
                this.sovereignAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
            }
            return (AgencyRatingCriteria.AgencyRatingCriteriaBuilder)this.getIndex(this.sovereignAgencyRating, _index, () -> {
                AgencyRatingCriteria.AgencyRatingCriteriaBuilder newSovereignAgencyRating = AgencyRatingCriteria.builder();
                return newSovereignAgencyRating;
            });
        }

        @Override
        public IssuerCriteriaBuilder setCounterpartyOwnIssuePermitted(Boolean counterpartyOwnIssuePermitted) {
            this.counterpartyOwnIssuePermitted = counterpartyOwnIssuePermitted == null ? null : counterpartyOwnIssuePermitted;
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria issuerAgencyRating) {
            if (issuerAgencyRating != null) {
                this.issuerAgencyRating.add(issuerAgencyRating.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria issuerAgencyRating, int _idx) {
            this.getIndex(this.issuerAgencyRating, _idx, () -> issuerAgencyRating.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerAgencyRating(List<? extends AgencyRatingCriteria> issuerAgencyRatings) {
            if (issuerAgencyRatings != null) {
                for (AgencyRatingCriteria agencyRatingCriteria : issuerAgencyRatings) {
                    this.issuerAgencyRating.add(agencyRatingCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder setIssuerAgencyRating(List<? extends AgencyRatingCriteria> issuerAgencyRatings) {
            this.issuerAgencyRating = issuerAgencyRatings == null ? new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>() : (List)issuerAgencyRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(FieldWithMetaString issuerCountryOfOrigin) {
            if (issuerCountryOfOrigin != null) {
                this.issuerCountryOfOrigin.add(issuerCountryOfOrigin.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(FieldWithMetaString issuerCountryOfOrigin, int _idx) {
            this.getIndex(this.issuerCountryOfOrigin, _idx, () -> issuerCountryOfOrigin.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOriginValue(String issuerCountryOfOrigin) {
            this.getOrCreateIssuerCountryOfOrigin(-1).setValue(issuerCountryOfOrigin);
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOriginValue(String issuerCountryOfOrigin, int _idx) {
            this.getOrCreateIssuerCountryOfOrigin(_idx).setValue(issuerCountryOfOrigin);
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(List<? extends FieldWithMetaString> issuerCountryOfOrigins) {
            if (issuerCountryOfOrigins != null) {
                for (FieldWithMetaString fieldWithMetaString : issuerCountryOfOrigins) {
                    this.issuerCountryOfOrigin.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder setIssuerCountryOfOrigin(List<? extends FieldWithMetaString> issuerCountryOfOrigins) {
            this.issuerCountryOfOrigin = issuerCountryOfOrigins == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)issuerCountryOfOrigins.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOriginValue(List<? extends String> issuerCountryOfOrigins) {
            if (issuerCountryOfOrigins != null) {
                for (String string : issuerCountryOfOrigins) {
                    this.addIssuerCountryOfOriginValue(string);
                }
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder setIssuerCountryOfOriginValue(List<? extends String> issuerCountryOfOrigins) {
            this.issuerCountryOfOrigin.clear();
            if (issuerCountryOfOrigins != null) {
                issuerCountryOfOrigins.forEach(this::addIssuerCountryOfOriginValue);
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerName(LegalEntity issuerName) {
            if (issuerName != null) {
                this.issuerName.add(issuerName.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerName(LegalEntity issuerName, int _idx) {
            this.getIndex(this.issuerName, _idx, () -> issuerName.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerName(List<? extends LegalEntity> issuerNames) {
            if (issuerNames != null) {
                for (LegalEntity legalEntity : issuerNames) {
                    this.issuerName.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder setIssuerName(List<? extends LegalEntity> issuerNames) {
            this.issuerName = issuerNames == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)issuerNames.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType issuerType) {
            if (issuerType != null) {
                this.issuerType.add(issuerType.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType issuerType, int _idx) {
            this.getIndex(this.issuerType, _idx, () -> issuerType.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerType(List<? extends CollateralIssuerType> issuerTypes) {
            if (issuerTypes != null) {
                for (CollateralIssuerType collateralIssuerType : issuerTypes) {
                    this.issuerType.add(collateralIssuerType.toBuilder());
                }
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder setIssuerType(List<? extends CollateralIssuerType> issuerTypes) {
            this.issuerType = issuerTypes == null ? new ArrayList<CollateralIssuerType.CollateralIssuerTypeBuilder>() : (List)issuerTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria sovereignAgencyRating) {
            if (sovereignAgencyRating != null) {
                this.sovereignAgencyRating.add(sovereignAgencyRating.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria sovereignAgencyRating, int _idx) {
            this.getIndex(this.sovereignAgencyRating, _idx, () -> sovereignAgencyRating.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addSovereignAgencyRating(List<? extends AgencyRatingCriteria> sovereignAgencyRatings) {
            if (sovereignAgencyRatings != null) {
                for (AgencyRatingCriteria agencyRatingCriteria : sovereignAgencyRatings) {
                    this.sovereignAgencyRating.add(agencyRatingCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder setSovereignAgencyRating(List<? extends AgencyRatingCriteria> sovereignAgencyRatings) {
            this.sovereignAgencyRating = sovereignAgencyRatings == null ? new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>() : (List)sovereignAgencyRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IssuerCriteria build() {
            return new IssuerCriteriaImpl(this);
        }

        @Override
        public IssuerCriteriaBuilder toBuilder() {
            return this;
        }

        @Override
        public IssuerCriteriaBuilder prune() {
            this.issuerAgencyRating = this.issuerAgencyRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.issuerCountryOfOrigin = this.issuerCountryOfOrigin.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.issuerName = this.issuerName.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.issuerType = this.issuerType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.sovereignAgencyRating = this.sovereignAgencyRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCounterpartyOwnIssuePermitted() != null) {
                return true;
            }
            if (this.getIssuerAgencyRating() != null && this.getIssuerAgencyRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIssuerCountryOfOrigin() != null && !this.getIssuerCountryOfOrigin().isEmpty()) {
                return true;
            }
            if (this.getIssuerName() != null && this.getIssuerName().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIssuerType() != null && this.getIssuerType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSovereignAgencyRating() != null && this.getSovereignAgencyRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public IssuerCriteriaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IssuerCriteriaBuilder o = (IssuerCriteriaBuilder)other;
            merger.mergeRosetta(this.getIssuerAgencyRating(), o.getIssuerAgencyRating(), this::getOrCreateIssuerAgencyRating);
            merger.mergeRosetta(this.getIssuerCountryOfOrigin(), o.getIssuerCountryOfOrigin(), this::getOrCreateIssuerCountryOfOrigin);
            merger.mergeRosetta(this.getIssuerName(), o.getIssuerName(), this::getOrCreateIssuerName);
            merger.mergeRosetta(this.getIssuerType(), o.getIssuerType(), this::getOrCreateIssuerType);
            merger.mergeRosetta(this.getSovereignAgencyRating(), o.getSovereignAgencyRating(), this::getOrCreateSovereignAgencyRating);
            merger.mergeBasic((Object)this.getCounterpartyOwnIssuePermitted(), (Object)o.getCounterpartyOwnIssuePermitted(), this::setCounterpartyOwnIssuePermitted, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IssuerCriteria _that = this.getType().cast(o);
            if (!Objects.equals(this.counterpartyOwnIssuePermitted, _that.getCounterpartyOwnIssuePermitted())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerAgencyRating, _that.getIssuerAgencyRating())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerCountryOfOrigin, _that.getIssuerCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerName, _that.getIssuerName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerType, _that.getIssuerType())) {
                return false;
            }
            return ListEquals.listEquals(this.sovereignAgencyRating, _that.getSovereignAgencyRating());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterpartyOwnIssuePermitted != null ? this.counterpartyOwnIssuePermitted.hashCode() : 0);
            _result = 31 * _result + (this.issuerAgencyRating != null ? this.issuerAgencyRating.hashCode() : 0);
            _result = 31 * _result + (this.issuerCountryOfOrigin != null ? this.issuerCountryOfOrigin.hashCode() : 0);
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            _result = 31 * _result + (this.issuerType != null ? this.issuerType.hashCode() : 0);
            _result = 31 * _result + (this.sovereignAgencyRating != null ? this.sovereignAgencyRating.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IssuerCriteriaBuilder {counterpartyOwnIssuePermitted=" + this.counterpartyOwnIssuePermitted + ", issuerAgencyRating=" + this.issuerAgencyRating + ", issuerCountryOfOrigin=" + this.issuerCountryOfOrigin + ", issuerName=" + this.issuerName + ", issuerType=" + this.issuerType + ", sovereignAgencyRating=" + this.sovereignAgencyRating + '}';
        }
    }

    public static class IssuerCriteriaImpl
    implements IssuerCriteria {
        private final Boolean counterpartyOwnIssuePermitted;
        private final List<? extends AgencyRatingCriteria> issuerAgencyRating;
        private final List<? extends FieldWithMetaString> issuerCountryOfOrigin;
        private final List<? extends LegalEntity> issuerName;
        private final List<? extends CollateralIssuerType> issuerType;
        private final List<? extends AgencyRatingCriteria> sovereignAgencyRating;

        protected IssuerCriteriaImpl(IssuerCriteriaBuilder builder) {
            this.counterpartyOwnIssuePermitted = builder.getCounterpartyOwnIssuePermitted();
            this.issuerAgencyRating = Optional.ofNullable(builder.getIssuerAgencyRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.issuerCountryOfOrigin = Optional.ofNullable(builder.getIssuerCountryOfOrigin()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.issuerName = Optional.ofNullable(builder.getIssuerName()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.issuerType = Optional.ofNullable(builder.getIssuerType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.sovereignAgencyRating = Optional.ofNullable(builder.getSovereignAgencyRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public Boolean getCounterpartyOwnIssuePermitted() {
            return this.counterpartyOwnIssuePermitted;
        }

        @Override
        public List<? extends AgencyRatingCriteria> getIssuerAgencyRating() {
            return this.issuerAgencyRating;
        }

        @Override
        public List<? extends FieldWithMetaString> getIssuerCountryOfOrigin() {
            return this.issuerCountryOfOrigin;
        }

        @Override
        public List<? extends LegalEntity> getIssuerName() {
            return this.issuerName;
        }

        @Override
        public List<? extends CollateralIssuerType> getIssuerType() {
            return this.issuerType;
        }

        @Override
        public List<? extends AgencyRatingCriteria> getSovereignAgencyRating() {
            return this.sovereignAgencyRating;
        }

        @Override
        public IssuerCriteria build() {
            return this;
        }

        @Override
        public IssuerCriteriaBuilder toBuilder() {
            IssuerCriteriaBuilder builder = IssuerCriteria.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IssuerCriteriaBuilder builder) {
            Optional.ofNullable(this.getCounterpartyOwnIssuePermitted()).ifPresent(builder::setCounterpartyOwnIssuePermitted);
            Optional.ofNullable(this.getIssuerAgencyRating()).ifPresent(builder::setIssuerAgencyRating);
            Optional.ofNullable(this.getIssuerCountryOfOrigin()).ifPresent(builder::setIssuerCountryOfOrigin);
            Optional.ofNullable(this.getIssuerName()).ifPresent(builder::setIssuerName);
            Optional.ofNullable(this.getIssuerType()).ifPresent(builder::setIssuerType);
            Optional.ofNullable(this.getSovereignAgencyRating()).ifPresent(builder::setSovereignAgencyRating);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IssuerCriteria _that = this.getType().cast(o);
            if (!Objects.equals(this.counterpartyOwnIssuePermitted, _that.getCounterpartyOwnIssuePermitted())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerAgencyRating, _that.getIssuerAgencyRating())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerCountryOfOrigin, _that.getIssuerCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerName, _that.getIssuerName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerType, _that.getIssuerType())) {
                return false;
            }
            return ListEquals.listEquals(this.sovereignAgencyRating, _that.getSovereignAgencyRating());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterpartyOwnIssuePermitted != null ? this.counterpartyOwnIssuePermitted.hashCode() : 0);
            _result = 31 * _result + (this.issuerAgencyRating != null ? this.issuerAgencyRating.hashCode() : 0);
            _result = 31 * _result + (this.issuerCountryOfOrigin != null ? this.issuerCountryOfOrigin.hashCode() : 0);
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            _result = 31 * _result + (this.issuerType != null ? this.issuerType.hashCode() : 0);
            _result = 31 * _result + (this.sovereignAgencyRating != null ? this.sovereignAgencyRating.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IssuerCriteria {counterpartyOwnIssuePermitted=" + this.counterpartyOwnIssuePermitted + ", issuerAgencyRating=" + this.issuerAgencyRating + ", issuerCountryOfOrigin=" + this.issuerCountryOfOrigin + ", issuerName=" + this.issuerName + ", issuerType=" + this.issuerType + ", sovereignAgencyRating=" + this.sovereignAgencyRating + '}';
        }
    }

    public static interface IssuerCriteriaBuilder
    extends IssuerCriteria,
    RosettaModelObjectBuilder {
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateIssuerAgencyRating(int var1);

        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getIssuerAgencyRating();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIssuerCountryOfOrigin(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getIssuerCountryOfOrigin();

        public LegalEntity.LegalEntityBuilder getOrCreateIssuerName(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getIssuerName();

        public CollateralIssuerType.CollateralIssuerTypeBuilder getOrCreateIssuerType(int var1);

        public List<? extends CollateralIssuerType.CollateralIssuerTypeBuilder> getIssuerType();

        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateSovereignAgencyRating(int var1);

        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getSovereignAgencyRating();

        public IssuerCriteriaBuilder setCounterpartyOwnIssuePermitted(Boolean var1);

        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria var1);

        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria var1, int var2);

        public IssuerCriteriaBuilder addIssuerAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public IssuerCriteriaBuilder setIssuerAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(FieldWithMetaString var1);

        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(FieldWithMetaString var1, int var2);

        public IssuerCriteriaBuilder addIssuerCountryOfOriginValue(String var1);

        public IssuerCriteriaBuilder addIssuerCountryOfOriginValue(String var1, int var2);

        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(List<? extends FieldWithMetaString> var1);

        public IssuerCriteriaBuilder setIssuerCountryOfOrigin(List<? extends FieldWithMetaString> var1);

        public IssuerCriteriaBuilder addIssuerCountryOfOriginValue(List<? extends String> var1);

        public IssuerCriteriaBuilder setIssuerCountryOfOriginValue(List<? extends String> var1);

        public IssuerCriteriaBuilder addIssuerName(LegalEntity var1);

        public IssuerCriteriaBuilder addIssuerName(LegalEntity var1, int var2);

        public IssuerCriteriaBuilder addIssuerName(List<? extends LegalEntity> var1);

        public IssuerCriteriaBuilder setIssuerName(List<? extends LegalEntity> var1);

        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType var1);

        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType var1, int var2);

        public IssuerCriteriaBuilder addIssuerType(List<? extends CollateralIssuerType> var1);

        public IssuerCriteriaBuilder setIssuerType(List<? extends CollateralIssuerType> var1);

        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria var1);

        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria var1, int var2);

        public IssuerCriteriaBuilder addSovereignAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public IssuerCriteriaBuilder setSovereignAgencyRating(List<? extends AgencyRatingCriteria> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("counterpartyOwnIssuePermitted"), Boolean.class, (Object)this.getCounterpartyOwnIssuePermitted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerAgencyRating"), processor, AgencyRatingCriteria.AgencyRatingCriteriaBuilder.class, this.getIssuerAgencyRating(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerCountryOfOrigin"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getIssuerCountryOfOrigin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerName"), processor, LegalEntity.LegalEntityBuilder.class, this.getIssuerName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerType"), processor, CollateralIssuerType.CollateralIssuerTypeBuilder.class, this.getIssuerType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sovereignAgencyRating"), processor, AgencyRatingCriteria.AgencyRatingCriteriaBuilder.class, this.getSovereignAgencyRating(), new AttributeMeta[0]);
        }

        public IssuerCriteriaBuilder prune();
    }
}

