/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.product.collateral.AssetCriteria;
import cdm.product.collateral.AverageTradingVolume;
import cdm.product.collateral.CollateralCriteriaBase;
import cdm.product.collateral.ConcentrationLimitTypeEnum;
import cdm.product.collateral.IssuerCriteria;
import cdm.product.collateral.meta.ConcentrationLimitCriteriaMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface ConcentrationLimitCriteria
extends CollateralCriteriaBase {
    public static final ConcentrationLimitCriteriaMeta metaData = new ConcentrationLimitCriteriaMeta();

    @Override
    public ConcentrationLimitCriteria build();

    @Override
    public ConcentrationLimitCriteriaBuilder toBuilder();

    public AverageTradingVolume getAverageTradingVolume();

    public ConcentrationLimitTypeEnum getConcentrationLimitType();

    default public RosettaMetaData<? extends ConcentrationLimitCriteria> metaData() {
        return metaData;
    }

    public static ConcentrationLimitCriteriaBuilder builder() {
        return new ConcentrationLimitCriteriaBuilderImpl();
    }

    default public Class<? extends ConcentrationLimitCriteria> getType() {
        return ConcentrationLimitCriteria.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        CollateralCriteriaBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("concentrationLimitType"), ConcentrationLimitTypeEnum.class, (Object)this.getConcentrationLimitType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averageTradingVolume"), processor, AverageTradingVolume.class, this.getAverageTradingVolume(), new AttributeMeta[0]);
    }

    public static class ConcentrationLimitCriteriaBuilderImpl
    extends CollateralCriteriaBase.CollateralCriteriaBaseBuilderImpl
    implements ConcentrationLimitCriteriaBuilder {
        protected AverageTradingVolume.AverageTradingVolumeBuilder averageTradingVolume;
        protected ConcentrationLimitTypeEnum concentrationLimitType;

        @Override
        public AverageTradingVolume.AverageTradingVolumeBuilder getAverageTradingVolume() {
            return this.averageTradingVolume;
        }

        @Override
        public AverageTradingVolume.AverageTradingVolumeBuilder getOrCreateAverageTradingVolume() {
            AverageTradingVolume.AverageTradingVolumeBuilder result = this.averageTradingVolume != null ? this.averageTradingVolume : (this.averageTradingVolume = AverageTradingVolume.builder());
            return result;
        }

        @Override
        public ConcentrationLimitTypeEnum getConcentrationLimitType() {
            return this.concentrationLimitType;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder setAverageTradingVolume(AverageTradingVolume averageTradingVolume) {
            this.averageTradingVolume = averageTradingVolume == null ? null : averageTradingVolume.toBuilder();
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder setConcentrationLimitType(ConcentrationLimitTypeEnum concentrationLimitType) {
            this.concentrationLimitType = concentrationLimitType == null ? null : concentrationLimitType;
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder addAsset(AssetCriteria asset) {
            if (asset != null) {
                this.asset.add(asset.toBuilder());
            }
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder addAsset(AssetCriteria asset, int _idx) {
            this.getIndex(this.asset, _idx, () -> asset.toBuilder());
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder addAsset(List<? extends AssetCriteria> assets) {
            if (assets != null) {
                for (AssetCriteria assetCriteria : assets) {
                    this.asset.add(assetCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder setAsset(List<? extends AssetCriteria> assets) {
            this.asset = assets == null ? new ArrayList() : (List)assets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder addIssuer(IssuerCriteria issuer) {
            if (issuer != null) {
                this.issuer.add(issuer.toBuilder());
            }
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder addIssuer(IssuerCriteria issuer, int _idx) {
            this.getIndex(this.issuer, _idx, () -> issuer.toBuilder());
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder addIssuer(List<? extends IssuerCriteria> issuers) {
            if (issuers != null) {
                for (IssuerCriteria issuerCriteria : issuers) {
                    this.issuer.add(issuerCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder setIssuer(List<? extends IssuerCriteria> issuers) {
            this.issuer = issuers == null ? new ArrayList() : (List)issuers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ConcentrationLimitCriteria build() {
            return new ConcentrationLimitCriteriaImpl(this);
        }

        @Override
        public ConcentrationLimitCriteriaBuilder toBuilder() {
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder prune() {
            super.prune();
            if (this.averageTradingVolume != null && !this.averageTradingVolume.prune().hasData()) {
                this.averageTradingVolume = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAverageTradingVolume() != null && this.getAverageTradingVolume().hasData()) {
                return true;
            }
            return this.getConcentrationLimitType() != null;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ConcentrationLimitCriteriaBuilder o = (ConcentrationLimitCriteriaBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAverageTradingVolume(), (RosettaModelObjectBuilder)o.getAverageTradingVolume(), this::setAverageTradingVolume);
            merger.mergeBasic((Object)this.getConcentrationLimitType(), (Object)o.getConcentrationLimitType(), this::setConcentrationLimitType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConcentrationLimitCriteria _that = (ConcentrationLimitCriteria)this.getType().cast(o);
            if (!Objects.equals(this.averageTradingVolume, _that.getAverageTradingVolume())) {
                return false;
            }
            return Objects.equals((Object)this.concentrationLimitType, (Object)_that.getConcentrationLimitType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averageTradingVolume != null ? this.averageTradingVolume.hashCode() : 0);
            _result = 31 * _result + (this.concentrationLimitType != null ? ((Object)((Object)this.concentrationLimitType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConcentrationLimitCriteriaBuilder {averageTradingVolume=" + this.averageTradingVolume + ", concentrationLimitType=" + (Object)((Object)this.concentrationLimitType) + '}' + " " + super.toString();
        }
    }

    public static class ConcentrationLimitCriteriaImpl
    extends CollateralCriteriaBase.CollateralCriteriaBaseImpl
    implements ConcentrationLimitCriteria {
        private final AverageTradingVolume averageTradingVolume;
        private final ConcentrationLimitTypeEnum concentrationLimitType;

        protected ConcentrationLimitCriteriaImpl(ConcentrationLimitCriteriaBuilder builder) {
            super(builder);
            this.averageTradingVolume = Optional.ofNullable(builder.getAverageTradingVolume()).map(f -> f.build()).orElse(null);
            this.concentrationLimitType = builder.getConcentrationLimitType();
        }

        @Override
        public AverageTradingVolume getAverageTradingVolume() {
            return this.averageTradingVolume;
        }

        @Override
        public ConcentrationLimitTypeEnum getConcentrationLimitType() {
            return this.concentrationLimitType;
        }

        @Override
        public ConcentrationLimitCriteria build() {
            return this;
        }

        @Override
        public ConcentrationLimitCriteriaBuilder toBuilder() {
            ConcentrationLimitCriteriaBuilder builder = ConcentrationLimitCriteria.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConcentrationLimitCriteriaBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAverageTradingVolume()).ifPresent(builder::setAverageTradingVolume);
            Optional.ofNullable(this.getConcentrationLimitType()).ifPresent(builder::setConcentrationLimitType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConcentrationLimitCriteria _that = (ConcentrationLimitCriteria)this.getType().cast(o);
            if (!Objects.equals(this.averageTradingVolume, _that.getAverageTradingVolume())) {
                return false;
            }
            return Objects.equals((Object)this.concentrationLimitType, (Object)_that.getConcentrationLimitType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averageTradingVolume != null ? this.averageTradingVolume.hashCode() : 0);
            _result = 31 * _result + (this.concentrationLimitType != null ? ((Object)((Object)this.concentrationLimitType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConcentrationLimitCriteria {averageTradingVolume=" + this.averageTradingVolume + ", concentrationLimitType=" + (Object)((Object)this.concentrationLimitType) + '}' + " " + super.toString();
        }
    }

    public static interface ConcentrationLimitCriteriaBuilder
    extends ConcentrationLimitCriteria,
    CollateralCriteriaBase.CollateralCriteriaBaseBuilder,
    RosettaModelObjectBuilder {
        public AverageTradingVolume.AverageTradingVolumeBuilder getOrCreateAverageTradingVolume();

        @Override
        public AverageTradingVolume.AverageTradingVolumeBuilder getAverageTradingVolume();

        public ConcentrationLimitCriteriaBuilder setAverageTradingVolume(AverageTradingVolume var1);

        public ConcentrationLimitCriteriaBuilder setConcentrationLimitType(ConcentrationLimitTypeEnum var1);

        @Override
        public ConcentrationLimitCriteriaBuilder addAsset(AssetCriteria var1);

        @Override
        public ConcentrationLimitCriteriaBuilder addAsset(AssetCriteria var1, int var2);

        @Override
        public ConcentrationLimitCriteriaBuilder addAsset(List<? extends AssetCriteria> var1);

        @Override
        public ConcentrationLimitCriteriaBuilder setAsset(List<? extends AssetCriteria> var1);

        @Override
        public ConcentrationLimitCriteriaBuilder addIssuer(IssuerCriteria var1);

        @Override
        public ConcentrationLimitCriteriaBuilder addIssuer(IssuerCriteria var1, int var2);

        @Override
        public ConcentrationLimitCriteriaBuilder addIssuer(List<? extends IssuerCriteria> var1);

        @Override
        public ConcentrationLimitCriteriaBuilder setIssuer(List<? extends IssuerCriteria> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            CollateralCriteriaBase.CollateralCriteriaBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("concentrationLimitType"), ConcentrationLimitTypeEnum.class, (Object)this.getConcentrationLimitType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averageTradingVolume"), processor, AverageTradingVolume.AverageTradingVolumeBuilder.class, this.getAverageTradingVolume(), new AttributeMeta[0]);
        }

        @Override
        public ConcentrationLimitCriteriaBuilder prune();
    }
}

