/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.math.MoneyRange;
import cdm.base.math.NumberRange;
import cdm.product.collateral.ConcentrationLimitCriteria;
import cdm.product.collateral.meta.ConcentrationLimitMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface ConcentrationLimit
extends RosettaModelObject {
    public static final ConcentrationLimitMeta metaData = new ConcentrationLimitMeta();

    public ConcentrationLimit build();

    public ConcentrationLimitBuilder toBuilder();

    public List<? extends ConcentrationLimitCriteria> getConcentrationLimitCriteria();

    public NumberRange getPercentageLimit();

    public MoneyRange getValueLimit();

    default public RosettaMetaData<? extends ConcentrationLimit> metaData() {
        return metaData;
    }

    public static ConcentrationLimitBuilder builder() {
        return new ConcentrationLimitBuilderImpl();
    }

    default public Class<? extends ConcentrationLimit> getType() {
        return ConcentrationLimit.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("concentrationLimitCriteria"), processor, ConcentrationLimitCriteria.class, this.getConcentrationLimitCriteria(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("percentageLimit"), processor, NumberRange.class, this.getPercentageLimit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valueLimit"), processor, MoneyRange.class, this.getValueLimit(), new AttributeMeta[0]);
    }

    public static class ConcentrationLimitBuilderImpl
    implements ConcentrationLimitBuilder {
        protected List<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder> concentrationLimitCriteria = new ArrayList<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder>();
        protected NumberRange.NumberRangeBuilder percentageLimit;
        protected MoneyRange.MoneyRangeBuilder valueLimit;

        @Override
        public List<? extends ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder> getConcentrationLimitCriteria() {
            return this.concentrationLimitCriteria;
        }

        @Override
        public ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder getOrCreateConcentrationLimitCriteria(int _index) {
            if (this.concentrationLimitCriteria == null) {
                this.concentrationLimitCriteria = new ArrayList<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder>();
            }
            return (ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder)this.getIndex(this.concentrationLimitCriteria, _index, () -> {
                ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder newConcentrationLimitCriteria = ConcentrationLimitCriteria.builder();
                return newConcentrationLimitCriteria;
            });
        }

        @Override
        public NumberRange.NumberRangeBuilder getPercentageLimit() {
            return this.percentageLimit;
        }

        @Override
        public NumberRange.NumberRangeBuilder getOrCreatePercentageLimit() {
            NumberRange.NumberRangeBuilder result = this.percentageLimit != null ? this.percentageLimit : (this.percentageLimit = NumberRange.builder());
            return result;
        }

        @Override
        public MoneyRange.MoneyRangeBuilder getValueLimit() {
            return this.valueLimit;
        }

        @Override
        public MoneyRange.MoneyRangeBuilder getOrCreateValueLimit() {
            MoneyRange.MoneyRangeBuilder result = this.valueLimit != null ? this.valueLimit : (this.valueLimit = MoneyRange.builder());
            return result;
        }

        @Override
        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria concentrationLimitCriteria) {
            if (concentrationLimitCriteria != null) {
                this.concentrationLimitCriteria.add(concentrationLimitCriteria.toBuilder());
            }
            return this;
        }

        @Override
        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria concentrationLimitCriteria, int _idx) {
            this.getIndex(this.concentrationLimitCriteria, _idx, () -> concentrationLimitCriteria.toBuilder());
            return this;
        }

        @Override
        public ConcentrationLimitBuilder addConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> concentrationLimitCriterias) {
            if (concentrationLimitCriterias != null) {
                for (ConcentrationLimitCriteria concentrationLimitCriteria : concentrationLimitCriterias) {
                    this.concentrationLimitCriteria.add(concentrationLimitCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ConcentrationLimitBuilder setConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> concentrationLimitCriterias) {
            this.concentrationLimitCriteria = concentrationLimitCriterias == null ? new ArrayList<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder>() : (List)concentrationLimitCriterias.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ConcentrationLimitBuilder setPercentageLimit(NumberRange percentageLimit) {
            this.percentageLimit = percentageLimit == null ? null : percentageLimit.toBuilder();
            return this;
        }

        @Override
        public ConcentrationLimitBuilder setValueLimit(MoneyRange valueLimit) {
            this.valueLimit = valueLimit == null ? null : valueLimit.toBuilder();
            return this;
        }

        @Override
        public ConcentrationLimit build() {
            return new ConcentrationLimitImpl(this);
        }

        @Override
        public ConcentrationLimitBuilder toBuilder() {
            return this;
        }

        @Override
        public ConcentrationLimitBuilder prune() {
            this.concentrationLimitCriteria = this.concentrationLimitCriteria.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.percentageLimit != null && !this.percentageLimit.prune().hasData()) {
                this.percentageLimit = null;
            }
            if (this.valueLimit != null && !this.valueLimit.prune().hasData()) {
                this.valueLimit = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getConcentrationLimitCriteria() != null && this.getConcentrationLimitCriteria().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPercentageLimit() != null && this.getPercentageLimit().hasData()) {
                return true;
            }
            return this.getValueLimit() != null && this.getValueLimit().hasData();
        }

        public ConcentrationLimitBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ConcentrationLimitBuilder o = (ConcentrationLimitBuilder)other;
            merger.mergeRosetta(this.getConcentrationLimitCriteria(), o.getConcentrationLimitCriteria(), this::getOrCreateConcentrationLimitCriteria);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPercentageLimit(), (RosettaModelObjectBuilder)o.getPercentageLimit(), this::setPercentageLimit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValueLimit(), (RosettaModelObjectBuilder)o.getValueLimit(), this::setValueLimit);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ConcentrationLimit _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.concentrationLimitCriteria, _that.getConcentrationLimitCriteria())) {
                return false;
            }
            if (!Objects.equals(this.percentageLimit, _that.getPercentageLimit())) {
                return false;
            }
            return Objects.equals(this.valueLimit, _that.getValueLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.concentrationLimitCriteria != null ? this.concentrationLimitCriteria.hashCode() : 0);
            _result = 31 * _result + (this.percentageLimit != null ? this.percentageLimit.hashCode() : 0);
            _result = 31 * _result + (this.valueLimit != null ? this.valueLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ConcentrationLimitBuilder {concentrationLimitCriteria=" + this.concentrationLimitCriteria + ", percentageLimit=" + this.percentageLimit + ", valueLimit=" + this.valueLimit + '}';
        }
    }

    public static class ConcentrationLimitImpl
    implements ConcentrationLimit {
        private final List<? extends ConcentrationLimitCriteria> concentrationLimitCriteria;
        private final NumberRange percentageLimit;
        private final MoneyRange valueLimit;

        protected ConcentrationLimitImpl(ConcentrationLimitBuilder builder) {
            this.concentrationLimitCriteria = Optional.ofNullable(builder.getConcentrationLimitCriteria()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.percentageLimit = Optional.ofNullable(builder.getPercentageLimit()).map(f -> f.build()).orElse(null);
            this.valueLimit = Optional.ofNullable(builder.getValueLimit()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends ConcentrationLimitCriteria> getConcentrationLimitCriteria() {
            return this.concentrationLimitCriteria;
        }

        @Override
        public NumberRange getPercentageLimit() {
            return this.percentageLimit;
        }

        @Override
        public MoneyRange getValueLimit() {
            return this.valueLimit;
        }

        @Override
        public ConcentrationLimit build() {
            return this;
        }

        @Override
        public ConcentrationLimitBuilder toBuilder() {
            ConcentrationLimitBuilder builder = ConcentrationLimit.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConcentrationLimitBuilder builder) {
            Optional.ofNullable(this.getConcentrationLimitCriteria()).ifPresent(builder::setConcentrationLimitCriteria);
            Optional.ofNullable(this.getPercentageLimit()).ifPresent(builder::setPercentageLimit);
            Optional.ofNullable(this.getValueLimit()).ifPresent(builder::setValueLimit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ConcentrationLimit _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.concentrationLimitCriteria, _that.getConcentrationLimitCriteria())) {
                return false;
            }
            if (!Objects.equals(this.percentageLimit, _that.getPercentageLimit())) {
                return false;
            }
            return Objects.equals(this.valueLimit, _that.getValueLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.concentrationLimitCriteria != null ? this.concentrationLimitCriteria.hashCode() : 0);
            _result = 31 * _result + (this.percentageLimit != null ? this.percentageLimit.hashCode() : 0);
            _result = 31 * _result + (this.valueLimit != null ? this.valueLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ConcentrationLimit {concentrationLimitCriteria=" + this.concentrationLimitCriteria + ", percentageLimit=" + this.percentageLimit + ", valueLimit=" + this.valueLimit + '}';
        }
    }

    public static interface ConcentrationLimitBuilder
    extends ConcentrationLimit,
    RosettaModelObjectBuilder {
        public ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder getOrCreateConcentrationLimitCriteria(int var1);

        public List<? extends ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder> getConcentrationLimitCriteria();

        public NumberRange.NumberRangeBuilder getOrCreatePercentageLimit();

        @Override
        public NumberRange.NumberRangeBuilder getPercentageLimit();

        public MoneyRange.MoneyRangeBuilder getOrCreateValueLimit();

        @Override
        public MoneyRange.MoneyRangeBuilder getValueLimit();

        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria var1);

        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria var1, int var2);

        public ConcentrationLimitBuilder addConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> var1);

        public ConcentrationLimitBuilder setConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> var1);

        public ConcentrationLimitBuilder setPercentageLimit(NumberRange var1);

        public ConcentrationLimitBuilder setValueLimit(MoneyRange var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("concentrationLimitCriteria"), processor, ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder.class, this.getConcentrationLimitCriteria(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("percentageLimit"), processor, NumberRange.NumberRangeBuilder.class, this.getPercentageLimit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valueLimit"), processor, MoneyRange.MoneyRangeBuilder.class, this.getValueLimit(), new AttributeMeta[0]);
        }

        public ConcentrationLimitBuilder prune();
    }
}

