/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.product.collateral.meta.CollateralValuationTreatmentMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CollateralValuationTreatment
extends RosettaModelObject {
    public static final CollateralValuationTreatmentMeta metaData = new CollateralValuationTreatmentMeta();

    public CollateralValuationTreatment build();

    public CollateralValuationTreatmentBuilder toBuilder();

    public BigDecimal getAdditionalHaircutPercentage();

    public BigDecimal getFxHaircutPercentage();

    public BigDecimal getHaircutPercentage();

    public BigDecimal getMarginPercentage();

    default public RosettaMetaData<? extends CollateralValuationTreatment> metaData() {
        return metaData;
    }

    public static CollateralValuationTreatmentBuilder builder() {
        return new CollateralValuationTreatmentBuilderImpl();
    }

    default public Class<? extends CollateralValuationTreatment> getType() {
        return CollateralValuationTreatment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("additionalHaircutPercentage"), BigDecimal.class, (Object)this.getAdditionalHaircutPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fxHaircutPercentage"), BigDecimal.class, (Object)this.getFxHaircutPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("haircutPercentage"), BigDecimal.class, (Object)this.getHaircutPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marginPercentage"), BigDecimal.class, (Object)this.getMarginPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralValuationTreatmentBuilderImpl
    implements CollateralValuationTreatmentBuilder {
        protected BigDecimal additionalHaircutPercentage;
        protected BigDecimal fxHaircutPercentage;
        protected BigDecimal haircutPercentage;
        protected BigDecimal marginPercentage;

        @Override
        public BigDecimal getAdditionalHaircutPercentage() {
            return this.additionalHaircutPercentage;
        }

        @Override
        public BigDecimal getFxHaircutPercentage() {
            return this.fxHaircutPercentage;
        }

        @Override
        public BigDecimal getHaircutPercentage() {
            return this.haircutPercentage;
        }

        @Override
        public BigDecimal getMarginPercentage() {
            return this.marginPercentage;
        }

        @Override
        public CollateralValuationTreatmentBuilder setAdditionalHaircutPercentage(BigDecimal additionalHaircutPercentage) {
            this.additionalHaircutPercentage = additionalHaircutPercentage == null ? null : additionalHaircutPercentage;
            return this;
        }

        @Override
        public CollateralValuationTreatmentBuilder setFxHaircutPercentage(BigDecimal fxHaircutPercentage) {
            this.fxHaircutPercentage = fxHaircutPercentage == null ? null : fxHaircutPercentage;
            return this;
        }

        @Override
        public CollateralValuationTreatmentBuilder setHaircutPercentage(BigDecimal haircutPercentage) {
            this.haircutPercentage = haircutPercentage == null ? null : haircutPercentage;
            return this;
        }

        @Override
        public CollateralValuationTreatmentBuilder setMarginPercentage(BigDecimal marginPercentage) {
            this.marginPercentage = marginPercentage == null ? null : marginPercentage;
            return this;
        }

        @Override
        public CollateralValuationTreatment build() {
            return new CollateralValuationTreatmentImpl(this);
        }

        @Override
        public CollateralValuationTreatmentBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralValuationTreatmentBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getAdditionalHaircutPercentage() != null) {
                return true;
            }
            if (this.getFxHaircutPercentage() != null) {
                return true;
            }
            if (this.getHaircutPercentage() != null) {
                return true;
            }
            return this.getMarginPercentage() != null;
        }

        public CollateralValuationTreatmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralValuationTreatmentBuilder o = (CollateralValuationTreatmentBuilder)other;
            merger.mergeBasic((Object)this.getAdditionalHaircutPercentage(), (Object)o.getAdditionalHaircutPercentage(), this::setAdditionalHaircutPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFxHaircutPercentage(), (Object)o.getFxHaircutPercentage(), this::setFxHaircutPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getHaircutPercentage(), (Object)o.getHaircutPercentage(), this::setHaircutPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMarginPercentage(), (Object)o.getMarginPercentage(), this::setMarginPercentage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralValuationTreatment _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalHaircutPercentage, _that.getAdditionalHaircutPercentage())) {
                return false;
            }
            if (!Objects.equals(this.fxHaircutPercentage, _that.getFxHaircutPercentage())) {
                return false;
            }
            if (!Objects.equals(this.haircutPercentage, _that.getHaircutPercentage())) {
                return false;
            }
            return Objects.equals(this.marginPercentage, _that.getMarginPercentage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalHaircutPercentage != null ? this.additionalHaircutPercentage.hashCode() : 0);
            _result = 31 * _result + (this.fxHaircutPercentage != null ? this.fxHaircutPercentage.hashCode() : 0);
            _result = 31 * _result + (this.haircutPercentage != null ? this.haircutPercentage.hashCode() : 0);
            _result = 31 * _result + (this.marginPercentage != null ? this.marginPercentage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralValuationTreatmentBuilder {additionalHaircutPercentage=" + this.additionalHaircutPercentage + ", fxHaircutPercentage=" + this.fxHaircutPercentage + ", haircutPercentage=" + this.haircutPercentage + ", marginPercentage=" + this.marginPercentage + '}';
        }
    }

    public static class CollateralValuationTreatmentImpl
    implements CollateralValuationTreatment {
        private final BigDecimal additionalHaircutPercentage;
        private final BigDecimal fxHaircutPercentage;
        private final BigDecimal haircutPercentage;
        private final BigDecimal marginPercentage;

        protected CollateralValuationTreatmentImpl(CollateralValuationTreatmentBuilder builder) {
            this.additionalHaircutPercentage = builder.getAdditionalHaircutPercentage();
            this.fxHaircutPercentage = builder.getFxHaircutPercentage();
            this.haircutPercentage = builder.getHaircutPercentage();
            this.marginPercentage = builder.getMarginPercentage();
        }

        @Override
        public BigDecimal getAdditionalHaircutPercentage() {
            return this.additionalHaircutPercentage;
        }

        @Override
        public BigDecimal getFxHaircutPercentage() {
            return this.fxHaircutPercentage;
        }

        @Override
        public BigDecimal getHaircutPercentage() {
            return this.haircutPercentage;
        }

        @Override
        public BigDecimal getMarginPercentage() {
            return this.marginPercentage;
        }

        @Override
        public CollateralValuationTreatment build() {
            return this;
        }

        @Override
        public CollateralValuationTreatmentBuilder toBuilder() {
            CollateralValuationTreatmentBuilder builder = CollateralValuationTreatment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralValuationTreatmentBuilder builder) {
            Optional.ofNullable(this.getAdditionalHaircutPercentage()).ifPresent(builder::setAdditionalHaircutPercentage);
            Optional.ofNullable(this.getFxHaircutPercentage()).ifPresent(builder::setFxHaircutPercentage);
            Optional.ofNullable(this.getHaircutPercentage()).ifPresent(builder::setHaircutPercentage);
            Optional.ofNullable(this.getMarginPercentage()).ifPresent(builder::setMarginPercentage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralValuationTreatment _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalHaircutPercentage, _that.getAdditionalHaircutPercentage())) {
                return false;
            }
            if (!Objects.equals(this.fxHaircutPercentage, _that.getFxHaircutPercentage())) {
                return false;
            }
            if (!Objects.equals(this.haircutPercentage, _that.getHaircutPercentage())) {
                return false;
            }
            return Objects.equals(this.marginPercentage, _that.getMarginPercentage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalHaircutPercentage != null ? this.additionalHaircutPercentage.hashCode() : 0);
            _result = 31 * _result + (this.fxHaircutPercentage != null ? this.fxHaircutPercentage.hashCode() : 0);
            _result = 31 * _result + (this.haircutPercentage != null ? this.haircutPercentage.hashCode() : 0);
            _result = 31 * _result + (this.marginPercentage != null ? this.marginPercentage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralValuationTreatment {additionalHaircutPercentage=" + this.additionalHaircutPercentage + ", fxHaircutPercentage=" + this.fxHaircutPercentage + ", haircutPercentage=" + this.haircutPercentage + ", marginPercentage=" + this.marginPercentage + '}';
        }
    }

    public static interface CollateralValuationTreatmentBuilder
    extends CollateralValuationTreatment,
    RosettaModelObjectBuilder {
        public CollateralValuationTreatmentBuilder setAdditionalHaircutPercentage(BigDecimal var1);

        public CollateralValuationTreatmentBuilder setFxHaircutPercentage(BigDecimal var1);

        public CollateralValuationTreatmentBuilder setHaircutPercentage(BigDecimal var1);

        public CollateralValuationTreatmentBuilder setMarginPercentage(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("additionalHaircutPercentage"), BigDecimal.class, (Object)this.getAdditionalHaircutPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fxHaircutPercentage"), BigDecimal.class, (Object)this.getFxHaircutPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("haircutPercentage"), BigDecimal.class, (Object)this.getHaircutPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marginPercentage"), BigDecimal.class, (Object)this.getMarginPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CollateralValuationTreatmentBuilder prune();
    }
}

