/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.product.collateral.CollateralValuationTreatment;
import cdm.product.collateral.ConcentrationLimit;
import cdm.product.collateral.meta.CollateralTreatmentMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CollateralTreatment
extends RosettaModelObject {
    public static final CollateralTreatmentMeta metaData = new CollateralTreatmentMeta();

    public CollateralTreatment build();

    public CollateralTreatmentBuilder toBuilder();

    public List<? extends ConcentrationLimit> getConcentrationLimit();

    public Boolean getIsIncluded();

    public CollateralValuationTreatment getValuationTreatment();

    default public RosettaMetaData<? extends CollateralTreatment> metaData() {
        return metaData;
    }

    public static CollateralTreatmentBuilder builder() {
        return new CollateralTreatmentBuilderImpl();
    }

    default public Class<? extends CollateralTreatment> getType() {
        return CollateralTreatment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("isIncluded"), Boolean.class, (Object)this.getIsIncluded(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("concentrationLimit"), processor, ConcentrationLimit.class, this.getConcentrationLimit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationTreatment"), processor, CollateralValuationTreatment.class, this.getValuationTreatment(), new AttributeMeta[0]);
    }

    public static class CollateralTreatmentBuilderImpl
    implements CollateralTreatmentBuilder {
        protected List<ConcentrationLimit.ConcentrationLimitBuilder> concentrationLimit = new ArrayList<ConcentrationLimit.ConcentrationLimitBuilder>();
        protected Boolean isIncluded;
        protected CollateralValuationTreatment.CollateralValuationTreatmentBuilder valuationTreatment;

        @Override
        public List<? extends ConcentrationLimit.ConcentrationLimitBuilder> getConcentrationLimit() {
            return this.concentrationLimit;
        }

        @Override
        public ConcentrationLimit.ConcentrationLimitBuilder getOrCreateConcentrationLimit(int _index) {
            if (this.concentrationLimit == null) {
                this.concentrationLimit = new ArrayList<ConcentrationLimit.ConcentrationLimitBuilder>();
            }
            return (ConcentrationLimit.ConcentrationLimitBuilder)this.getIndex(this.concentrationLimit, _index, () -> {
                ConcentrationLimit.ConcentrationLimitBuilder newConcentrationLimit = ConcentrationLimit.builder();
                return newConcentrationLimit;
            });
        }

        @Override
        public Boolean getIsIncluded() {
            return this.isIncluded;
        }

        @Override
        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getValuationTreatment() {
            return this.valuationTreatment;
        }

        @Override
        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getOrCreateValuationTreatment() {
            CollateralValuationTreatment.CollateralValuationTreatmentBuilder result = this.valuationTreatment != null ? this.valuationTreatment : (this.valuationTreatment = CollateralValuationTreatment.builder());
            return result;
        }

        @Override
        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit concentrationLimit) {
            if (concentrationLimit != null) {
                this.concentrationLimit.add(concentrationLimit.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit concentrationLimit, int _idx) {
            this.getIndex(this.concentrationLimit, _idx, () -> concentrationLimit.toBuilder());
            return this;
        }

        @Override
        public CollateralTreatmentBuilder addConcentrationLimit(List<? extends ConcentrationLimit> concentrationLimits) {
            if (concentrationLimits != null) {
                for (ConcentrationLimit concentrationLimit : concentrationLimits) {
                    this.concentrationLimit.add(concentrationLimit.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralTreatmentBuilder setConcentrationLimit(List<? extends ConcentrationLimit> concentrationLimits) {
            this.concentrationLimit = concentrationLimits == null ? new ArrayList<ConcentrationLimit.ConcentrationLimitBuilder>() : (List)concentrationLimits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralTreatmentBuilder setIsIncluded(Boolean isIncluded) {
            this.isIncluded = isIncluded == null ? null : isIncluded;
            return this;
        }

        @Override
        public CollateralTreatmentBuilder setValuationTreatment(CollateralValuationTreatment valuationTreatment) {
            this.valuationTreatment = valuationTreatment == null ? null : valuationTreatment.toBuilder();
            return this;
        }

        @Override
        public CollateralTreatment build() {
            return new CollateralTreatmentImpl(this);
        }

        @Override
        public CollateralTreatmentBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralTreatmentBuilder prune() {
            this.concentrationLimit = this.concentrationLimit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.valuationTreatment != null && !this.valuationTreatment.prune().hasData()) {
                this.valuationTreatment = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getConcentrationLimit() != null && this.getConcentrationLimit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIsIncluded() != null) {
                return true;
            }
            return this.getValuationTreatment() != null && this.getValuationTreatment().hasData();
        }

        public CollateralTreatmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralTreatmentBuilder o = (CollateralTreatmentBuilder)other;
            merger.mergeRosetta(this.getConcentrationLimit(), o.getConcentrationLimit(), this::getOrCreateConcentrationLimit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationTreatment(), (RosettaModelObjectBuilder)o.getValuationTreatment(), this::setValuationTreatment);
            merger.mergeBasic((Object)this.getIsIncluded(), (Object)o.getIsIncluded(), this::setIsIncluded, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralTreatment _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.concentrationLimit, _that.getConcentrationLimit())) {
                return false;
            }
            if (!Objects.equals(this.isIncluded, _that.getIsIncluded())) {
                return false;
            }
            return Objects.equals(this.valuationTreatment, _that.getValuationTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.concentrationLimit != null ? this.concentrationLimit.hashCode() : 0);
            _result = 31 * _result + (this.isIncluded != null ? this.isIncluded.hashCode() : 0);
            _result = 31 * _result + (this.valuationTreatment != null ? this.valuationTreatment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralTreatmentBuilder {concentrationLimit=" + this.concentrationLimit + ", isIncluded=" + this.isIncluded + ", valuationTreatment=" + this.valuationTreatment + '}';
        }
    }

    public static class CollateralTreatmentImpl
    implements CollateralTreatment {
        private final List<? extends ConcentrationLimit> concentrationLimit;
        private final Boolean isIncluded;
        private final CollateralValuationTreatment valuationTreatment;

        protected CollateralTreatmentImpl(CollateralTreatmentBuilder builder) {
            this.concentrationLimit = Optional.ofNullable(builder.getConcentrationLimit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.isIncluded = builder.getIsIncluded();
            this.valuationTreatment = Optional.ofNullable(builder.getValuationTreatment()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends ConcentrationLimit> getConcentrationLimit() {
            return this.concentrationLimit;
        }

        @Override
        public Boolean getIsIncluded() {
            return this.isIncluded;
        }

        @Override
        public CollateralValuationTreatment getValuationTreatment() {
            return this.valuationTreatment;
        }

        @Override
        public CollateralTreatment build() {
            return this;
        }

        @Override
        public CollateralTreatmentBuilder toBuilder() {
            CollateralTreatmentBuilder builder = CollateralTreatment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralTreatmentBuilder builder) {
            Optional.ofNullable(this.getConcentrationLimit()).ifPresent(builder::setConcentrationLimit);
            Optional.ofNullable(this.getIsIncluded()).ifPresent(builder::setIsIncluded);
            Optional.ofNullable(this.getValuationTreatment()).ifPresent(builder::setValuationTreatment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralTreatment _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.concentrationLimit, _that.getConcentrationLimit())) {
                return false;
            }
            if (!Objects.equals(this.isIncluded, _that.getIsIncluded())) {
                return false;
            }
            return Objects.equals(this.valuationTreatment, _that.getValuationTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.concentrationLimit != null ? this.concentrationLimit.hashCode() : 0);
            _result = 31 * _result + (this.isIncluded != null ? this.isIncluded.hashCode() : 0);
            _result = 31 * _result + (this.valuationTreatment != null ? this.valuationTreatment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralTreatment {concentrationLimit=" + this.concentrationLimit + ", isIncluded=" + this.isIncluded + ", valuationTreatment=" + this.valuationTreatment + '}';
        }
    }

    public static interface CollateralTreatmentBuilder
    extends CollateralTreatment,
    RosettaModelObjectBuilder {
        public ConcentrationLimit.ConcentrationLimitBuilder getOrCreateConcentrationLimit(int var1);

        public List<? extends ConcentrationLimit.ConcentrationLimitBuilder> getConcentrationLimit();

        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getOrCreateValuationTreatment();

        @Override
        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getValuationTreatment();

        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit var1);

        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit var1, int var2);

        public CollateralTreatmentBuilder addConcentrationLimit(List<? extends ConcentrationLimit> var1);

        public CollateralTreatmentBuilder setConcentrationLimit(List<? extends ConcentrationLimit> var1);

        public CollateralTreatmentBuilder setIsIncluded(Boolean var1);

        public CollateralTreatmentBuilder setValuationTreatment(CollateralValuationTreatment var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("isIncluded"), Boolean.class, (Object)this.getIsIncluded(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("concentrationLimit"), processor, ConcentrationLimit.ConcentrationLimitBuilder.class, this.getConcentrationLimit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationTreatment"), processor, CollateralValuationTreatment.CollateralValuationTreatmentBuilder.class, this.getValuationTreatment(), new AttributeMeta[0]);
        }

        public CollateralTreatmentBuilder prune();
    }
}

