/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.CalculationFrequency;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.product.collateral.CollateralInterestCalculationParameters;
import cdm.product.collateral.CollateralInterestHandlingParameters;
import cdm.product.collateral.CollateralMarginTypeEnum;
import cdm.product.collateral.meta.CollateralInterestParametersMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CollateralInterestParameters
extends RosettaModelObject {
    public static final CollateralInterestParametersMeta metaData = new CollateralInterestParametersMeta();

    public CollateralInterestParameters build();

    public CollateralInterestParametersBuilder toBuilder();

    public String getCurrency();

    public CalculationFrequency getInterestCalculationFrequency();

    public CollateralInterestCalculationParameters getInterestCalculationParameters();

    public CollateralInterestHandlingParameters getInterestHandlingParameters();

    public CollateralMarginTypeEnum getMarginType();

    public CounterpartyRoleEnum getPostingParty();

    default public RosettaMetaData<? extends CollateralInterestParameters> metaData() {
        return metaData;
    }

    public static CollateralInterestParametersBuilder builder() {
        return new CollateralInterestParametersBuilderImpl();
    }

    default public Class<? extends CollateralInterestParameters> getType() {
        return CollateralInterestParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("currency"), String.class, (Object)this.getCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marginType"), CollateralMarginTypeEnum.class, (Object)this.getMarginType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("postingParty"), CounterpartyRoleEnum.class, (Object)this.getPostingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestCalculationFrequency"), processor, CalculationFrequency.class, this.getInterestCalculationFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestCalculationParameters"), processor, CollateralInterestCalculationParameters.class, this.getInterestCalculationParameters(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestHandlingParameters"), processor, CollateralInterestHandlingParameters.class, this.getInterestHandlingParameters(), new AttributeMeta[0]);
    }

    public static class CollateralInterestParametersBuilderImpl
    implements CollateralInterestParametersBuilder {
        protected String currency;
        protected CalculationFrequency.CalculationFrequencyBuilder interestCalculationFrequency;
        protected CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder interestCalculationParameters;
        protected CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder interestHandlingParameters;
        protected CollateralMarginTypeEnum marginType;
        protected CounterpartyRoleEnum postingParty;

        @Override
        public String getCurrency() {
            return this.currency;
        }

        @Override
        public CalculationFrequency.CalculationFrequencyBuilder getInterestCalculationFrequency() {
            return this.interestCalculationFrequency;
        }

        @Override
        public CalculationFrequency.CalculationFrequencyBuilder getOrCreateInterestCalculationFrequency() {
            CalculationFrequency.CalculationFrequencyBuilder result = this.interestCalculationFrequency != null ? this.interestCalculationFrequency : (this.interestCalculationFrequency = CalculationFrequency.builder());
            return result;
        }

        @Override
        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getInterestCalculationParameters() {
            return this.interestCalculationParameters;
        }

        @Override
        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getOrCreateInterestCalculationParameters() {
            CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder result = this.interestCalculationParameters != null ? this.interestCalculationParameters : (this.interestCalculationParameters = CollateralInterestCalculationParameters.builder());
            return result;
        }

        @Override
        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getInterestHandlingParameters() {
            return this.interestHandlingParameters;
        }

        @Override
        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getOrCreateInterestHandlingParameters() {
            CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder result = this.interestHandlingParameters != null ? this.interestHandlingParameters : (this.interestHandlingParameters = CollateralInterestHandlingParameters.builder());
            return result;
        }

        @Override
        public CollateralMarginTypeEnum getMarginType() {
            return this.marginType;
        }

        @Override
        public CounterpartyRoleEnum getPostingParty() {
            return this.postingParty;
        }

        @Override
        public CollateralInterestParametersBuilder setCurrency(String currency) {
            this.currency = currency == null ? null : currency;
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder setInterestCalculationFrequency(CalculationFrequency interestCalculationFrequency) {
            this.interestCalculationFrequency = interestCalculationFrequency == null ? null : interestCalculationFrequency.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder setInterestCalculationParameters(CollateralInterestCalculationParameters interestCalculationParameters) {
            this.interestCalculationParameters = interestCalculationParameters == null ? null : interestCalculationParameters.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder setInterestHandlingParameters(CollateralInterestHandlingParameters interestHandlingParameters) {
            this.interestHandlingParameters = interestHandlingParameters == null ? null : interestHandlingParameters.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder setMarginType(CollateralMarginTypeEnum marginType) {
            this.marginType = marginType == null ? null : marginType;
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder setPostingParty(CounterpartyRoleEnum postingParty) {
            this.postingParty = postingParty == null ? null : postingParty;
            return this;
        }

        @Override
        public CollateralInterestParameters build() {
            return new CollateralInterestParametersImpl(this);
        }

        @Override
        public CollateralInterestParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder prune() {
            if (this.interestCalculationFrequency != null && !this.interestCalculationFrequency.prune().hasData()) {
                this.interestCalculationFrequency = null;
            }
            if (this.interestCalculationParameters != null && !this.interestCalculationParameters.prune().hasData()) {
                this.interestCalculationParameters = null;
            }
            if (this.interestHandlingParameters != null && !this.interestHandlingParameters.prune().hasData()) {
                this.interestHandlingParameters = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getInterestCalculationFrequency() != null && this.getInterestCalculationFrequency().hasData()) {
                return true;
            }
            if (this.getInterestCalculationParameters() != null && this.getInterestCalculationParameters().hasData()) {
                return true;
            }
            if (this.getInterestHandlingParameters() != null && this.getInterestHandlingParameters().hasData()) {
                return true;
            }
            if (this.getMarginType() != null) {
                return true;
            }
            return this.getPostingParty() != null;
        }

        public CollateralInterestParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralInterestParametersBuilder o = (CollateralInterestParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestCalculationFrequency(), (RosettaModelObjectBuilder)o.getInterestCalculationFrequency(), this::setInterestCalculationFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestCalculationParameters(), (RosettaModelObjectBuilder)o.getInterestCalculationParameters(), this::setInterestCalculationParameters);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestHandlingParameters(), (RosettaModelObjectBuilder)o.getInterestHandlingParameters(), this::setInterestHandlingParameters);
            merger.mergeBasic((Object)this.getCurrency(), (Object)o.getCurrency(), this::setCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMarginType(), (Object)o.getMarginType(), this::setMarginType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPostingParty(), (Object)o.getPostingParty(), this::setPostingParty, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationFrequency, _that.getInterestCalculationFrequency())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationParameters, _that.getInterestCalculationParameters())) {
                return false;
            }
            if (!Objects.equals(this.interestHandlingParameters, _that.getInterestHandlingParameters())) {
                return false;
            }
            if (!Objects.equals((Object)this.marginType, (Object)_that.getMarginType())) {
                return false;
            }
            return Objects.equals((Object)this.postingParty, (Object)_that.getPostingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationFrequency != null ? this.interestCalculationFrequency.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationParameters != null ? this.interestCalculationParameters.hashCode() : 0);
            _result = 31 * _result + (this.interestHandlingParameters != null ? this.interestHandlingParameters.hashCode() : 0);
            _result = 31 * _result + (this.marginType != null ? ((Object)((Object)this.marginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.postingParty != null ? ((Object)((Object)this.postingParty)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestParametersBuilder {currency=" + this.currency + ", interestCalculationFrequency=" + this.interestCalculationFrequency + ", interestCalculationParameters=" + this.interestCalculationParameters + ", interestHandlingParameters=" + this.interestHandlingParameters + ", marginType=" + (Object)((Object)this.marginType) + ", postingParty=" + (Object)((Object)this.postingParty) + '}';
        }
    }

    public static class CollateralInterestParametersImpl
    implements CollateralInterestParameters {
        private final String currency;
        private final CalculationFrequency interestCalculationFrequency;
        private final CollateralInterestCalculationParameters interestCalculationParameters;
        private final CollateralInterestHandlingParameters interestHandlingParameters;
        private final CollateralMarginTypeEnum marginType;
        private final CounterpartyRoleEnum postingParty;

        protected CollateralInterestParametersImpl(CollateralInterestParametersBuilder builder) {
            this.currency = builder.getCurrency();
            this.interestCalculationFrequency = Optional.ofNullable(builder.getInterestCalculationFrequency()).map(f -> f.build()).orElse(null);
            this.interestCalculationParameters = Optional.ofNullable(builder.getInterestCalculationParameters()).map(f -> f.build()).orElse(null);
            this.interestHandlingParameters = Optional.ofNullable(builder.getInterestHandlingParameters()).map(f -> f.build()).orElse(null);
            this.marginType = builder.getMarginType();
            this.postingParty = builder.getPostingParty();
        }

        @Override
        public String getCurrency() {
            return this.currency;
        }

        @Override
        public CalculationFrequency getInterestCalculationFrequency() {
            return this.interestCalculationFrequency;
        }

        @Override
        public CollateralInterestCalculationParameters getInterestCalculationParameters() {
            return this.interestCalculationParameters;
        }

        @Override
        public CollateralInterestHandlingParameters getInterestHandlingParameters() {
            return this.interestHandlingParameters;
        }

        @Override
        public CollateralMarginTypeEnum getMarginType() {
            return this.marginType;
        }

        @Override
        public CounterpartyRoleEnum getPostingParty() {
            return this.postingParty;
        }

        @Override
        public CollateralInterestParameters build() {
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder toBuilder() {
            CollateralInterestParametersBuilder builder = CollateralInterestParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralInterestParametersBuilder builder) {
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getInterestCalculationFrequency()).ifPresent(builder::setInterestCalculationFrequency);
            Optional.ofNullable(this.getInterestCalculationParameters()).ifPresent(builder::setInterestCalculationParameters);
            Optional.ofNullable(this.getInterestHandlingParameters()).ifPresent(builder::setInterestHandlingParameters);
            Optional.ofNullable(this.getMarginType()).ifPresent(builder::setMarginType);
            Optional.ofNullable(this.getPostingParty()).ifPresent(builder::setPostingParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationFrequency, _that.getInterestCalculationFrequency())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationParameters, _that.getInterestCalculationParameters())) {
                return false;
            }
            if (!Objects.equals(this.interestHandlingParameters, _that.getInterestHandlingParameters())) {
                return false;
            }
            if (!Objects.equals((Object)this.marginType, (Object)_that.getMarginType())) {
                return false;
            }
            return Objects.equals((Object)this.postingParty, (Object)_that.getPostingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationFrequency != null ? this.interestCalculationFrequency.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationParameters != null ? this.interestCalculationParameters.hashCode() : 0);
            _result = 31 * _result + (this.interestHandlingParameters != null ? this.interestHandlingParameters.hashCode() : 0);
            _result = 31 * _result + (this.marginType != null ? ((Object)((Object)this.marginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.postingParty != null ? ((Object)((Object)this.postingParty)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestParameters {currency=" + this.currency + ", interestCalculationFrequency=" + this.interestCalculationFrequency + ", interestCalculationParameters=" + this.interestCalculationParameters + ", interestHandlingParameters=" + this.interestHandlingParameters + ", marginType=" + (Object)((Object)this.marginType) + ", postingParty=" + (Object)((Object)this.postingParty) + '}';
        }
    }

    public static interface CollateralInterestParametersBuilder
    extends CollateralInterestParameters,
    RosettaModelObjectBuilder {
        public CalculationFrequency.CalculationFrequencyBuilder getOrCreateInterestCalculationFrequency();

        @Override
        public CalculationFrequency.CalculationFrequencyBuilder getInterestCalculationFrequency();

        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getOrCreateInterestCalculationParameters();

        @Override
        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getInterestCalculationParameters();

        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getOrCreateInterestHandlingParameters();

        @Override
        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getInterestHandlingParameters();

        public CollateralInterestParametersBuilder setCurrency(String var1);

        public CollateralInterestParametersBuilder setInterestCalculationFrequency(CalculationFrequency var1);

        public CollateralInterestParametersBuilder setInterestCalculationParameters(CollateralInterestCalculationParameters var1);

        public CollateralInterestParametersBuilder setInterestHandlingParameters(CollateralInterestHandlingParameters var1);

        public CollateralInterestParametersBuilder setMarginType(CollateralMarginTypeEnum var1);

        public CollateralInterestParametersBuilder setPostingParty(CounterpartyRoleEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("currency"), String.class, (Object)this.getCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marginType"), CollateralMarginTypeEnum.class, (Object)this.getMarginType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("postingParty"), CounterpartyRoleEnum.class, (Object)this.getPostingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestCalculationFrequency"), processor, CalculationFrequency.CalculationFrequencyBuilder.class, this.getInterestCalculationFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestCalculationParameters"), processor, CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder.class, this.getInterestCalculationParameters(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestHandlingParameters"), processor, CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder.class, this.getInterestHandlingParameters(), new AttributeMeta[0]);
        }

        public CollateralInterestParametersBuilder prune();
    }
}

