/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.DayTypeEnum;
import cdm.product.collateral.meta.CollateralInterestNotificationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CollateralInterestNotification
extends RosettaModelObject {
    public static final CollateralInterestNotificationMeta metaData = new CollateralInterestNotificationMeta();

    public CollateralInterestNotification build();

    public CollateralInterestNotificationBuilder toBuilder();

    public DayTypeEnum getNotificationDayType();

    public LocalTime getNotificationTime();

    public BigDecimal getOffset();

    public String getTrigger();

    default public RosettaMetaData<? extends CollateralInterestNotification> metaData() {
        return metaData;
    }

    public static CollateralInterestNotificationBuilder builder() {
        return new CollateralInterestNotificationBuilderImpl();
    }

    default public Class<? extends CollateralInterestNotification> getType() {
        return CollateralInterestNotification.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("notificationDayType"), DayTypeEnum.class, (Object)this.getNotificationDayType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notificationTime"), LocalTime.class, (Object)this.getNotificationTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("offset"), BigDecimal.class, (Object)this.getOffset(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("trigger"), String.class, (Object)this.getTrigger(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralInterestNotificationBuilderImpl
    implements CollateralInterestNotificationBuilder {
        protected DayTypeEnum notificationDayType;
        protected LocalTime notificationTime;
        protected BigDecimal offset;
        protected String trigger;

        @Override
        public DayTypeEnum getNotificationDayType() {
            return this.notificationDayType;
        }

        @Override
        public LocalTime getNotificationTime() {
            return this.notificationTime;
        }

        @Override
        public BigDecimal getOffset() {
            return this.offset;
        }

        @Override
        public String getTrigger() {
            return this.trigger;
        }

        @Override
        public CollateralInterestNotificationBuilder setNotificationDayType(DayTypeEnum notificationDayType) {
            this.notificationDayType = notificationDayType == null ? null : notificationDayType;
            return this;
        }

        @Override
        public CollateralInterestNotificationBuilder setNotificationTime(LocalTime notificationTime) {
            this.notificationTime = notificationTime == null ? null : notificationTime;
            return this;
        }

        @Override
        public CollateralInterestNotificationBuilder setOffset(BigDecimal offset) {
            this.offset = offset == null ? null : offset;
            return this;
        }

        @Override
        public CollateralInterestNotificationBuilder setTrigger(String trigger) {
            this.trigger = trigger == null ? null : trigger;
            return this;
        }

        @Override
        public CollateralInterestNotification build() {
            return new CollateralInterestNotificationImpl(this);
        }

        @Override
        public CollateralInterestNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralInterestNotificationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getNotificationDayType() != null) {
                return true;
            }
            if (this.getNotificationTime() != null) {
                return true;
            }
            if (this.getOffset() != null) {
                return true;
            }
            return this.getTrigger() != null;
        }

        public CollateralInterestNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralInterestNotificationBuilder o = (CollateralInterestNotificationBuilder)other;
            merger.mergeBasic((Object)this.getNotificationDayType(), (Object)o.getNotificationDayType(), this::setNotificationDayType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotificationTime(), (Object)o.getNotificationTime(), this::setNotificationTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOffset(), (Object)o.getOffset(), this::setOffset, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTrigger(), (Object)o.getTrigger(), this::setTrigger, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestNotification _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.notificationDayType, (Object)_that.getNotificationDayType())) {
                return false;
            }
            if (!Objects.equals(this.notificationTime, _that.getNotificationTime())) {
                return false;
            }
            if (!Objects.equals(this.offset, _that.getOffset())) {
                return false;
            }
            return Objects.equals(this.trigger, _that.getTrigger());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notificationDayType != null ? ((Object)((Object)this.notificationDayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notificationTime != null ? this.notificationTime.hashCode() : 0);
            _result = 31 * _result + (this.offset != null ? this.offset.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestNotificationBuilder {notificationDayType=" + (Object)((Object)this.notificationDayType) + ", notificationTime=" + this.notificationTime + ", offset=" + this.offset + ", trigger=" + this.trigger + '}';
        }
    }

    public static class CollateralInterestNotificationImpl
    implements CollateralInterestNotification {
        private final DayTypeEnum notificationDayType;
        private final LocalTime notificationTime;
        private final BigDecimal offset;
        private final String trigger;

        protected CollateralInterestNotificationImpl(CollateralInterestNotificationBuilder builder) {
            this.notificationDayType = builder.getNotificationDayType();
            this.notificationTime = builder.getNotificationTime();
            this.offset = builder.getOffset();
            this.trigger = builder.getTrigger();
        }

        @Override
        public DayTypeEnum getNotificationDayType() {
            return this.notificationDayType;
        }

        @Override
        public LocalTime getNotificationTime() {
            return this.notificationTime;
        }

        @Override
        public BigDecimal getOffset() {
            return this.offset;
        }

        @Override
        public String getTrigger() {
            return this.trigger;
        }

        @Override
        public CollateralInterestNotification build() {
            return this;
        }

        @Override
        public CollateralInterestNotificationBuilder toBuilder() {
            CollateralInterestNotificationBuilder builder = CollateralInterestNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralInterestNotificationBuilder builder) {
            Optional.ofNullable(this.getNotificationDayType()).ifPresent(builder::setNotificationDayType);
            Optional.ofNullable(this.getNotificationTime()).ifPresent(builder::setNotificationTime);
            Optional.ofNullable(this.getOffset()).ifPresent(builder::setOffset);
            Optional.ofNullable(this.getTrigger()).ifPresent(builder::setTrigger);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestNotification _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.notificationDayType, (Object)_that.getNotificationDayType())) {
                return false;
            }
            if (!Objects.equals(this.notificationTime, _that.getNotificationTime())) {
                return false;
            }
            if (!Objects.equals(this.offset, _that.getOffset())) {
                return false;
            }
            return Objects.equals(this.trigger, _that.getTrigger());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notificationDayType != null ? ((Object)((Object)this.notificationDayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notificationTime != null ? this.notificationTime.hashCode() : 0);
            _result = 31 * _result + (this.offset != null ? this.offset.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestNotification {notificationDayType=" + (Object)((Object)this.notificationDayType) + ", notificationTime=" + this.notificationTime + ", offset=" + this.offset + ", trigger=" + this.trigger + '}';
        }
    }

    public static interface CollateralInterestNotificationBuilder
    extends CollateralInterestNotification,
    RosettaModelObjectBuilder {
        public CollateralInterestNotificationBuilder setNotificationDayType(DayTypeEnum var1);

        public CollateralInterestNotificationBuilder setNotificationTime(LocalTime var1);

        public CollateralInterestNotificationBuilder setOffset(BigDecimal var1);

        public CollateralInterestNotificationBuilder setTrigger(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("notificationDayType"), DayTypeEnum.class, (Object)this.getNotificationDayType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notificationTime"), LocalTime.class, (Object)this.getNotificationTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("offset"), BigDecimal.class, (Object)this.getOffset(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("trigger"), String.class, (Object)this.getTrigger(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CollateralInterestNotificationBuilder prune();
    }
}

