/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.math.NumberBound;
import cdm.product.collateral.AlternativeToInterestAmountEnum;
import cdm.product.collateral.CollateralInterestHandlingEnum;
import cdm.product.collateral.CollateralInterestNotification;
import cdm.product.collateral.InterestAmountApplication;
import cdm.product.collateral.meta.CollateralInterestHandlingParametersMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CollateralInterestHandlingParameters
extends RosettaModelObject {
    public static final CollateralInterestHandlingParametersMeta metaData = new CollateralInterestHandlingParametersMeta();

    public CollateralInterestHandlingParameters build();

    public CollateralInterestHandlingParametersBuilder toBuilder();

    public Boolean getAccrueInterestOnUnsettledInterest();

    public String getAlternativeProvision();

    public AlternativeToInterestAmountEnum getAlternativeToInterestAmount();

    public LocalTime getCutoffTime();

    public Boolean getIncludeAccrualInMarginCalc();

    public InterestAmountApplication getInterestAmountApplication();

    public CollateralInterestHandlingEnum getInterestPaymentHandling();

    public NumberBound getInterestRolloverLimit();

    public Boolean getNetInterestWithMarginCalls();

    public Boolean getNetPostedAndHeldInterest();

    public CollateralInterestNotification getNotification();

    public Boolean getOnFullReturn();

    public Boolean getOnPartialReturn();

    public List<BusinessCenterEnum> getPaymentBusinessCenter();

    public NumberBound getWriteoffLimit();

    default public RosettaMetaData<? extends CollateralInterestHandlingParameters> metaData() {
        return metaData;
    }

    public static CollateralInterestHandlingParametersBuilder builder() {
        return new CollateralInterestHandlingParametersBuilderImpl();
    }

    default public Class<? extends CollateralInterestHandlingParameters> getType() {
        return CollateralInterestHandlingParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("accrueInterestOnUnsettledInterest"), Boolean.class, (Object)this.getAccrueInterestOnUnsettledInterest(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("alternativeProvision"), String.class, (Object)this.getAlternativeProvision(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("alternativeToInterestAmount"), AlternativeToInterestAmountEnum.class, (Object)this.getAlternativeToInterestAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cutoffTime"), LocalTime.class, (Object)this.getCutoffTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("includeAccrualInMarginCalc"), Boolean.class, (Object)this.getIncludeAccrualInMarginCalc(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("interestPaymentHandling"), CollateralInterestHandlingEnum.class, (Object)this.getInterestPaymentHandling(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("netInterestWithMarginCalls"), Boolean.class, (Object)this.getNetInterestWithMarginCalls(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("netPostedAndHeldInterest"), Boolean.class, (Object)this.getNetPostedAndHeldInterest(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("onFullReturn"), Boolean.class, (Object)this.getOnFullReturn(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("onPartialReturn"), Boolean.class, (Object)this.getOnPartialReturn(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentBusinessCenter"), BusinessCenterEnum.class, this.getPaymentBusinessCenter(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestAmountApplication"), processor, InterestAmountApplication.class, this.getInterestAmountApplication(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestRolloverLimit"), processor, NumberBound.class, this.getInterestRolloverLimit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notification"), processor, CollateralInterestNotification.class, this.getNotification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("writeoffLimit"), processor, NumberBound.class, this.getWriteoffLimit(), new AttributeMeta[0]);
    }

    public static class CollateralInterestHandlingParametersBuilderImpl
    implements CollateralInterestHandlingParametersBuilder {
        protected Boolean accrueInterestOnUnsettledInterest;
        protected String alternativeProvision;
        protected AlternativeToInterestAmountEnum alternativeToInterestAmount;
        protected LocalTime cutoffTime;
        protected Boolean includeAccrualInMarginCalc;
        protected InterestAmountApplication.InterestAmountApplicationBuilder interestAmountApplication;
        protected CollateralInterestHandlingEnum interestPaymentHandling;
        protected NumberBound.NumberBoundBuilder interestRolloverLimit;
        protected Boolean netInterestWithMarginCalls;
        protected Boolean netPostedAndHeldInterest;
        protected CollateralInterestNotification.CollateralInterestNotificationBuilder notification;
        protected Boolean onFullReturn;
        protected Boolean onPartialReturn;
        protected List<BusinessCenterEnum> paymentBusinessCenter = new ArrayList<BusinessCenterEnum>();
        protected NumberBound.NumberBoundBuilder writeoffLimit;

        @Override
        public Boolean getAccrueInterestOnUnsettledInterest() {
            return this.accrueInterestOnUnsettledInterest;
        }

        @Override
        public String getAlternativeProvision() {
            return this.alternativeProvision;
        }

        @Override
        public AlternativeToInterestAmountEnum getAlternativeToInterestAmount() {
            return this.alternativeToInterestAmount;
        }

        @Override
        public LocalTime getCutoffTime() {
            return this.cutoffTime;
        }

        @Override
        public Boolean getIncludeAccrualInMarginCalc() {
            return this.includeAccrualInMarginCalc;
        }

        @Override
        public InterestAmountApplication.InterestAmountApplicationBuilder getInterestAmountApplication() {
            return this.interestAmountApplication;
        }

        @Override
        public InterestAmountApplication.InterestAmountApplicationBuilder getOrCreateInterestAmountApplication() {
            InterestAmountApplication.InterestAmountApplicationBuilder result = this.interestAmountApplication != null ? this.interestAmountApplication : (this.interestAmountApplication = InterestAmountApplication.builder());
            return result;
        }

        @Override
        public CollateralInterestHandlingEnum getInterestPaymentHandling() {
            return this.interestPaymentHandling;
        }

        @Override
        public NumberBound.NumberBoundBuilder getInterestRolloverLimit() {
            return this.interestRolloverLimit;
        }

        @Override
        public NumberBound.NumberBoundBuilder getOrCreateInterestRolloverLimit() {
            NumberBound.NumberBoundBuilder result = this.interestRolloverLimit != null ? this.interestRolloverLimit : (this.interestRolloverLimit = NumberBound.builder());
            return result;
        }

        @Override
        public Boolean getNetInterestWithMarginCalls() {
            return this.netInterestWithMarginCalls;
        }

        @Override
        public Boolean getNetPostedAndHeldInterest() {
            return this.netPostedAndHeldInterest;
        }

        @Override
        public CollateralInterestNotification.CollateralInterestNotificationBuilder getNotification() {
            return this.notification;
        }

        @Override
        public CollateralInterestNotification.CollateralInterestNotificationBuilder getOrCreateNotification() {
            CollateralInterestNotification.CollateralInterestNotificationBuilder result = this.notification != null ? this.notification : (this.notification = CollateralInterestNotification.builder());
            return result;
        }

        @Override
        public Boolean getOnFullReturn() {
            return this.onFullReturn;
        }

        @Override
        public Boolean getOnPartialReturn() {
            return this.onPartialReturn;
        }

        @Override
        public List<BusinessCenterEnum> getPaymentBusinessCenter() {
            return this.paymentBusinessCenter;
        }

        @Override
        public NumberBound.NumberBoundBuilder getWriteoffLimit() {
            return this.writeoffLimit;
        }

        @Override
        public NumberBound.NumberBoundBuilder getOrCreateWriteoffLimit() {
            NumberBound.NumberBoundBuilder result = this.writeoffLimit != null ? this.writeoffLimit : (this.writeoffLimit = NumberBound.builder());
            return result;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setAccrueInterestOnUnsettledInterest(Boolean accrueInterestOnUnsettledInterest) {
            this.accrueInterestOnUnsettledInterest = accrueInterestOnUnsettledInterest == null ? null : accrueInterestOnUnsettledInterest;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setAlternativeProvision(String alternativeProvision) {
            this.alternativeProvision = alternativeProvision == null ? null : alternativeProvision;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setAlternativeToInterestAmount(AlternativeToInterestAmountEnum alternativeToInterestAmount) {
            this.alternativeToInterestAmount = alternativeToInterestAmount == null ? null : alternativeToInterestAmount;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setCutoffTime(LocalTime cutoffTime) {
            this.cutoffTime = cutoffTime == null ? null : cutoffTime;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setIncludeAccrualInMarginCalc(Boolean includeAccrualInMarginCalc) {
            this.includeAccrualInMarginCalc = includeAccrualInMarginCalc == null ? null : includeAccrualInMarginCalc;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setInterestAmountApplication(InterestAmountApplication interestAmountApplication) {
            this.interestAmountApplication = interestAmountApplication == null ? null : interestAmountApplication.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setInterestPaymentHandling(CollateralInterestHandlingEnum interestPaymentHandling) {
            this.interestPaymentHandling = interestPaymentHandling == null ? null : interestPaymentHandling;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setInterestRolloverLimit(NumberBound interestRolloverLimit) {
            this.interestRolloverLimit = interestRolloverLimit == null ? null : interestRolloverLimit.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setNetInterestWithMarginCalls(Boolean netInterestWithMarginCalls) {
            this.netInterestWithMarginCalls = netInterestWithMarginCalls == null ? null : netInterestWithMarginCalls;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setNetPostedAndHeldInterest(Boolean netPostedAndHeldInterest) {
            this.netPostedAndHeldInterest = netPostedAndHeldInterest == null ? null : netPostedAndHeldInterest;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setNotification(CollateralInterestNotification notification) {
            this.notification = notification == null ? null : notification.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setOnFullReturn(Boolean onFullReturn) {
            this.onFullReturn = onFullReturn == null ? null : onFullReturn;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setOnPartialReturn(Boolean onPartialReturn) {
            this.onPartialReturn = onPartialReturn == null ? null : onPartialReturn;
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder addPaymentBusinessCenter(BusinessCenterEnum paymentBusinessCenter) {
            if (paymentBusinessCenter != null) {
                this.paymentBusinessCenter.add(paymentBusinessCenter);
            }
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder addPaymentBusinessCenter(BusinessCenterEnum paymentBusinessCenter, int _idx) {
            this.getIndex(this.paymentBusinessCenter, _idx, () -> paymentBusinessCenter);
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder addPaymentBusinessCenter(List<? extends BusinessCenterEnum> paymentBusinessCenters) {
            if (paymentBusinessCenters != null) {
                for (BusinessCenterEnum businessCenterEnum : paymentBusinessCenters) {
                    this.paymentBusinessCenter.add(businessCenterEnum);
                }
            }
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setPaymentBusinessCenter(List<? extends BusinessCenterEnum> paymentBusinessCenters) {
            this.paymentBusinessCenter = paymentBusinessCenters == null ? new ArrayList<BusinessCenterEnum>() : (List)paymentBusinessCenters.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder setWriteoffLimit(NumberBound writeoffLimit) {
            this.writeoffLimit = writeoffLimit == null ? null : writeoffLimit.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestHandlingParameters build() {
            return new CollateralInterestHandlingParametersImpl(this);
        }

        @Override
        public CollateralInterestHandlingParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder prune() {
            if (this.interestAmountApplication != null && !this.interestAmountApplication.prune().hasData()) {
                this.interestAmountApplication = null;
            }
            if (this.interestRolloverLimit != null && !this.interestRolloverLimit.prune().hasData()) {
                this.interestRolloverLimit = null;
            }
            if (this.notification != null && !this.notification.prune().hasData()) {
                this.notification = null;
            }
            if (this.writeoffLimit != null && !this.writeoffLimit.prune().hasData()) {
                this.writeoffLimit = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccrueInterestOnUnsettledInterest() != null) {
                return true;
            }
            if (this.getAlternativeProvision() != null) {
                return true;
            }
            if (this.getAlternativeToInterestAmount() != null) {
                return true;
            }
            if (this.getCutoffTime() != null) {
                return true;
            }
            if (this.getIncludeAccrualInMarginCalc() != null) {
                return true;
            }
            if (this.getInterestAmountApplication() != null && this.getInterestAmountApplication().hasData()) {
                return true;
            }
            if (this.getInterestPaymentHandling() != null) {
                return true;
            }
            if (this.getInterestRolloverLimit() != null && this.getInterestRolloverLimit().hasData()) {
                return true;
            }
            if (this.getNetInterestWithMarginCalls() != null) {
                return true;
            }
            if (this.getNetPostedAndHeldInterest() != null) {
                return true;
            }
            if (this.getNotification() != null && this.getNotification().hasData()) {
                return true;
            }
            if (this.getOnFullReturn() != null) {
                return true;
            }
            if (this.getOnPartialReturn() != null) {
                return true;
            }
            if (this.getPaymentBusinessCenter() != null && !this.getPaymentBusinessCenter().isEmpty()) {
                return true;
            }
            return this.getWriteoffLimit() != null && this.getWriteoffLimit().hasData();
        }

        public CollateralInterestHandlingParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralInterestHandlingParametersBuilder o = (CollateralInterestHandlingParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestAmountApplication(), (RosettaModelObjectBuilder)o.getInterestAmountApplication(), this::setInterestAmountApplication);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestRolloverLimit(), (RosettaModelObjectBuilder)o.getInterestRolloverLimit(), this::setInterestRolloverLimit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotification(), (RosettaModelObjectBuilder)o.getNotification(), this::setNotification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWriteoffLimit(), (RosettaModelObjectBuilder)o.getWriteoffLimit(), this::setWriteoffLimit);
            merger.mergeBasic((Object)this.getAccrueInterestOnUnsettledInterest(), (Object)o.getAccrueInterestOnUnsettledInterest(), this::setAccrueInterestOnUnsettledInterest, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAlternativeProvision(), (Object)o.getAlternativeProvision(), this::setAlternativeProvision, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAlternativeToInterestAmount(), (Object)o.getAlternativeToInterestAmount(), this::setAlternativeToInterestAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCutoffTime(), (Object)o.getCutoffTime(), this::setCutoffTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIncludeAccrualInMarginCalc(), (Object)o.getIncludeAccrualInMarginCalc(), this::setIncludeAccrualInMarginCalc, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInterestPaymentHandling(), (Object)o.getInterestPaymentHandling(), this::setInterestPaymentHandling, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNetInterestWithMarginCalls(), (Object)o.getNetInterestWithMarginCalls(), this::setNetInterestWithMarginCalls, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNetPostedAndHeldInterest(), (Object)o.getNetPostedAndHeldInterest(), this::setNetPostedAndHeldInterest, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOnFullReturn(), (Object)o.getOnFullReturn(), this::setOnFullReturn, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOnPartialReturn(), (Object)o.getOnPartialReturn(), this::setOnPartialReturn, new AttributeMeta[0]);
            merger.mergeBasic(this.getPaymentBusinessCenter(), o.getPaymentBusinessCenter(), this::addPaymentBusinessCenter);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestHandlingParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.accrueInterestOnUnsettledInterest, _that.getAccrueInterestOnUnsettledInterest())) {
                return false;
            }
            if (!Objects.equals(this.alternativeProvision, _that.getAlternativeProvision())) {
                return false;
            }
            if (!Objects.equals((Object)this.alternativeToInterestAmount, (Object)_that.getAlternativeToInterestAmount())) {
                return false;
            }
            if (!Objects.equals(this.cutoffTime, _that.getCutoffTime())) {
                return false;
            }
            if (!Objects.equals(this.includeAccrualInMarginCalc, _that.getIncludeAccrualInMarginCalc())) {
                return false;
            }
            if (!Objects.equals(this.interestAmountApplication, _that.getInterestAmountApplication())) {
                return false;
            }
            if (!Objects.equals((Object)this.interestPaymentHandling, (Object)_that.getInterestPaymentHandling())) {
                return false;
            }
            if (!Objects.equals(this.interestRolloverLimit, _that.getInterestRolloverLimit())) {
                return false;
            }
            if (!Objects.equals(this.netInterestWithMarginCalls, _that.getNetInterestWithMarginCalls())) {
                return false;
            }
            if (!Objects.equals(this.netPostedAndHeldInterest, _that.getNetPostedAndHeldInterest())) {
                return false;
            }
            if (!Objects.equals(this.notification, _that.getNotification())) {
                return false;
            }
            if (!Objects.equals(this.onFullReturn, _that.getOnFullReturn())) {
                return false;
            }
            if (!Objects.equals(this.onPartialReturn, _that.getOnPartialReturn())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentBusinessCenter, _that.getPaymentBusinessCenter())) {
                return false;
            }
            return Objects.equals(this.writeoffLimit, _that.getWriteoffLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrueInterestOnUnsettledInterest != null ? this.accrueInterestOnUnsettledInterest.hashCode() : 0);
            _result = 31 * _result + (this.alternativeProvision != null ? this.alternativeProvision.hashCode() : 0);
            _result = 31 * _result + (this.alternativeToInterestAmount != null ? ((Object)((Object)this.alternativeToInterestAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cutoffTime != null ? this.cutoffTime.hashCode() : 0);
            _result = 31 * _result + (this.includeAccrualInMarginCalc != null ? this.includeAccrualInMarginCalc.hashCode() : 0);
            _result = 31 * _result + (this.interestAmountApplication != null ? this.interestAmountApplication.hashCode() : 0);
            _result = 31 * _result + (this.interestPaymentHandling != null ? ((Object)((Object)this.interestPaymentHandling)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.interestRolloverLimit != null ? this.interestRolloverLimit.hashCode() : 0);
            _result = 31 * _result + (this.netInterestWithMarginCalls != null ? this.netInterestWithMarginCalls.hashCode() : 0);
            _result = 31 * _result + (this.netPostedAndHeldInterest != null ? this.netPostedAndHeldInterest.hashCode() : 0);
            _result = 31 * _result + (this.notification != null ? this.notification.hashCode() : 0);
            _result = 31 * _result + (this.onFullReturn != null ? this.onFullReturn.hashCode() : 0);
            _result = 31 * _result + (this.onPartialReturn != null ? this.onPartialReturn.hashCode() : 0);
            _result = 31 * _result + (this.paymentBusinessCenter != null ? this.paymentBusinessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.writeoffLimit != null ? this.writeoffLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestHandlingParametersBuilder {accrueInterestOnUnsettledInterest=" + this.accrueInterestOnUnsettledInterest + ", alternativeProvision=" + this.alternativeProvision + ", alternativeToInterestAmount=" + (Object)((Object)this.alternativeToInterestAmount) + ", cutoffTime=" + this.cutoffTime + ", includeAccrualInMarginCalc=" + this.includeAccrualInMarginCalc + ", interestAmountApplication=" + this.interestAmountApplication + ", interestPaymentHandling=" + (Object)((Object)this.interestPaymentHandling) + ", interestRolloverLimit=" + this.interestRolloverLimit + ", netInterestWithMarginCalls=" + this.netInterestWithMarginCalls + ", netPostedAndHeldInterest=" + this.netPostedAndHeldInterest + ", notification=" + this.notification + ", onFullReturn=" + this.onFullReturn + ", onPartialReturn=" + this.onPartialReturn + ", paymentBusinessCenter=" + this.paymentBusinessCenter + ", writeoffLimit=" + this.writeoffLimit + '}';
        }
    }

    public static class CollateralInterestHandlingParametersImpl
    implements CollateralInterestHandlingParameters {
        private final Boolean accrueInterestOnUnsettledInterest;
        private final String alternativeProvision;
        private final AlternativeToInterestAmountEnum alternativeToInterestAmount;
        private final LocalTime cutoffTime;
        private final Boolean includeAccrualInMarginCalc;
        private final InterestAmountApplication interestAmountApplication;
        private final CollateralInterestHandlingEnum interestPaymentHandling;
        private final NumberBound interestRolloverLimit;
        private final Boolean netInterestWithMarginCalls;
        private final Boolean netPostedAndHeldInterest;
        private final CollateralInterestNotification notification;
        private final Boolean onFullReturn;
        private final Boolean onPartialReturn;
        private final List<BusinessCenterEnum> paymentBusinessCenter;
        private final NumberBound writeoffLimit;

        protected CollateralInterestHandlingParametersImpl(CollateralInterestHandlingParametersBuilder builder) {
            this.accrueInterestOnUnsettledInterest = builder.getAccrueInterestOnUnsettledInterest();
            this.alternativeProvision = builder.getAlternativeProvision();
            this.alternativeToInterestAmount = builder.getAlternativeToInterestAmount();
            this.cutoffTime = builder.getCutoffTime();
            this.includeAccrualInMarginCalc = builder.getIncludeAccrualInMarginCalc();
            this.interestAmountApplication = Optional.ofNullable(builder.getInterestAmountApplication()).map(f -> f.build()).orElse(null);
            this.interestPaymentHandling = builder.getInterestPaymentHandling();
            this.interestRolloverLimit = Optional.ofNullable(builder.getInterestRolloverLimit()).map(f -> f.build()).orElse(null);
            this.netInterestWithMarginCalls = builder.getNetInterestWithMarginCalls();
            this.netPostedAndHeldInterest = builder.getNetPostedAndHeldInterest();
            this.notification = Optional.ofNullable(builder.getNotification()).map(f -> f.build()).orElse(null);
            this.onFullReturn = builder.getOnFullReturn();
            this.onPartialReturn = builder.getOnPartialReturn();
            this.paymentBusinessCenter = Optional.ofNullable(builder.getPaymentBusinessCenter()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.writeoffLimit = Optional.ofNullable(builder.getWriteoffLimit()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Boolean getAccrueInterestOnUnsettledInterest() {
            return this.accrueInterestOnUnsettledInterest;
        }

        @Override
        public String getAlternativeProvision() {
            return this.alternativeProvision;
        }

        @Override
        public AlternativeToInterestAmountEnum getAlternativeToInterestAmount() {
            return this.alternativeToInterestAmount;
        }

        @Override
        public LocalTime getCutoffTime() {
            return this.cutoffTime;
        }

        @Override
        public Boolean getIncludeAccrualInMarginCalc() {
            return this.includeAccrualInMarginCalc;
        }

        @Override
        public InterestAmountApplication getInterestAmountApplication() {
            return this.interestAmountApplication;
        }

        @Override
        public CollateralInterestHandlingEnum getInterestPaymentHandling() {
            return this.interestPaymentHandling;
        }

        @Override
        public NumberBound getInterestRolloverLimit() {
            return this.interestRolloverLimit;
        }

        @Override
        public Boolean getNetInterestWithMarginCalls() {
            return this.netInterestWithMarginCalls;
        }

        @Override
        public Boolean getNetPostedAndHeldInterest() {
            return this.netPostedAndHeldInterest;
        }

        @Override
        public CollateralInterestNotification getNotification() {
            return this.notification;
        }

        @Override
        public Boolean getOnFullReturn() {
            return this.onFullReturn;
        }

        @Override
        public Boolean getOnPartialReturn() {
            return this.onPartialReturn;
        }

        @Override
        public List<BusinessCenterEnum> getPaymentBusinessCenter() {
            return this.paymentBusinessCenter;
        }

        @Override
        public NumberBound getWriteoffLimit() {
            return this.writeoffLimit;
        }

        @Override
        public CollateralInterestHandlingParameters build() {
            return this;
        }

        @Override
        public CollateralInterestHandlingParametersBuilder toBuilder() {
            CollateralInterestHandlingParametersBuilder builder = CollateralInterestHandlingParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralInterestHandlingParametersBuilder builder) {
            Optional.ofNullable(this.getAccrueInterestOnUnsettledInterest()).ifPresent(builder::setAccrueInterestOnUnsettledInterest);
            Optional.ofNullable(this.getAlternativeProvision()).ifPresent(builder::setAlternativeProvision);
            Optional.ofNullable(this.getAlternativeToInterestAmount()).ifPresent(builder::setAlternativeToInterestAmount);
            Optional.ofNullable(this.getCutoffTime()).ifPresent(builder::setCutoffTime);
            Optional.ofNullable(this.getIncludeAccrualInMarginCalc()).ifPresent(builder::setIncludeAccrualInMarginCalc);
            Optional.ofNullable(this.getInterestAmountApplication()).ifPresent(builder::setInterestAmountApplication);
            Optional.ofNullable(this.getInterestPaymentHandling()).ifPresent(builder::setInterestPaymentHandling);
            Optional.ofNullable(this.getInterestRolloverLimit()).ifPresent(builder::setInterestRolloverLimit);
            Optional.ofNullable(this.getNetInterestWithMarginCalls()).ifPresent(builder::setNetInterestWithMarginCalls);
            Optional.ofNullable(this.getNetPostedAndHeldInterest()).ifPresent(builder::setNetPostedAndHeldInterest);
            Optional.ofNullable(this.getNotification()).ifPresent(builder::setNotification);
            Optional.ofNullable(this.getOnFullReturn()).ifPresent(builder::setOnFullReturn);
            Optional.ofNullable(this.getOnPartialReturn()).ifPresent(builder::setOnPartialReturn);
            Optional.ofNullable(this.getPaymentBusinessCenter()).ifPresent(builder::setPaymentBusinessCenter);
            Optional.ofNullable(this.getWriteoffLimit()).ifPresent(builder::setWriteoffLimit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestHandlingParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.accrueInterestOnUnsettledInterest, _that.getAccrueInterestOnUnsettledInterest())) {
                return false;
            }
            if (!Objects.equals(this.alternativeProvision, _that.getAlternativeProvision())) {
                return false;
            }
            if (!Objects.equals((Object)this.alternativeToInterestAmount, (Object)_that.getAlternativeToInterestAmount())) {
                return false;
            }
            if (!Objects.equals(this.cutoffTime, _that.getCutoffTime())) {
                return false;
            }
            if (!Objects.equals(this.includeAccrualInMarginCalc, _that.getIncludeAccrualInMarginCalc())) {
                return false;
            }
            if (!Objects.equals(this.interestAmountApplication, _that.getInterestAmountApplication())) {
                return false;
            }
            if (!Objects.equals((Object)this.interestPaymentHandling, (Object)_that.getInterestPaymentHandling())) {
                return false;
            }
            if (!Objects.equals(this.interestRolloverLimit, _that.getInterestRolloverLimit())) {
                return false;
            }
            if (!Objects.equals(this.netInterestWithMarginCalls, _that.getNetInterestWithMarginCalls())) {
                return false;
            }
            if (!Objects.equals(this.netPostedAndHeldInterest, _that.getNetPostedAndHeldInterest())) {
                return false;
            }
            if (!Objects.equals(this.notification, _that.getNotification())) {
                return false;
            }
            if (!Objects.equals(this.onFullReturn, _that.getOnFullReturn())) {
                return false;
            }
            if (!Objects.equals(this.onPartialReturn, _that.getOnPartialReturn())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentBusinessCenter, _that.getPaymentBusinessCenter())) {
                return false;
            }
            return Objects.equals(this.writeoffLimit, _that.getWriteoffLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrueInterestOnUnsettledInterest != null ? this.accrueInterestOnUnsettledInterest.hashCode() : 0);
            _result = 31 * _result + (this.alternativeProvision != null ? this.alternativeProvision.hashCode() : 0);
            _result = 31 * _result + (this.alternativeToInterestAmount != null ? ((Object)((Object)this.alternativeToInterestAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cutoffTime != null ? this.cutoffTime.hashCode() : 0);
            _result = 31 * _result + (this.includeAccrualInMarginCalc != null ? this.includeAccrualInMarginCalc.hashCode() : 0);
            _result = 31 * _result + (this.interestAmountApplication != null ? this.interestAmountApplication.hashCode() : 0);
            _result = 31 * _result + (this.interestPaymentHandling != null ? ((Object)((Object)this.interestPaymentHandling)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.interestRolloverLimit != null ? this.interestRolloverLimit.hashCode() : 0);
            _result = 31 * _result + (this.netInterestWithMarginCalls != null ? this.netInterestWithMarginCalls.hashCode() : 0);
            _result = 31 * _result + (this.netPostedAndHeldInterest != null ? this.netPostedAndHeldInterest.hashCode() : 0);
            _result = 31 * _result + (this.notification != null ? this.notification.hashCode() : 0);
            _result = 31 * _result + (this.onFullReturn != null ? this.onFullReturn.hashCode() : 0);
            _result = 31 * _result + (this.onPartialReturn != null ? this.onPartialReturn.hashCode() : 0);
            _result = 31 * _result + (this.paymentBusinessCenter != null ? this.paymentBusinessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.writeoffLimit != null ? this.writeoffLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestHandlingParameters {accrueInterestOnUnsettledInterest=" + this.accrueInterestOnUnsettledInterest + ", alternativeProvision=" + this.alternativeProvision + ", alternativeToInterestAmount=" + (Object)((Object)this.alternativeToInterestAmount) + ", cutoffTime=" + this.cutoffTime + ", includeAccrualInMarginCalc=" + this.includeAccrualInMarginCalc + ", interestAmountApplication=" + this.interestAmountApplication + ", interestPaymentHandling=" + (Object)((Object)this.interestPaymentHandling) + ", interestRolloverLimit=" + this.interestRolloverLimit + ", netInterestWithMarginCalls=" + this.netInterestWithMarginCalls + ", netPostedAndHeldInterest=" + this.netPostedAndHeldInterest + ", notification=" + this.notification + ", onFullReturn=" + this.onFullReturn + ", onPartialReturn=" + this.onPartialReturn + ", paymentBusinessCenter=" + this.paymentBusinessCenter + ", writeoffLimit=" + this.writeoffLimit + '}';
        }
    }

    public static interface CollateralInterestHandlingParametersBuilder
    extends CollateralInterestHandlingParameters,
    RosettaModelObjectBuilder {
        public InterestAmountApplication.InterestAmountApplicationBuilder getOrCreateInterestAmountApplication();

        @Override
        public InterestAmountApplication.InterestAmountApplicationBuilder getInterestAmountApplication();

        public NumberBound.NumberBoundBuilder getOrCreateInterestRolloverLimit();

        @Override
        public NumberBound.NumberBoundBuilder getInterestRolloverLimit();

        public CollateralInterestNotification.CollateralInterestNotificationBuilder getOrCreateNotification();

        @Override
        public CollateralInterestNotification.CollateralInterestNotificationBuilder getNotification();

        public NumberBound.NumberBoundBuilder getOrCreateWriteoffLimit();

        @Override
        public NumberBound.NumberBoundBuilder getWriteoffLimit();

        public CollateralInterestHandlingParametersBuilder setAccrueInterestOnUnsettledInterest(Boolean var1);

        public CollateralInterestHandlingParametersBuilder setAlternativeProvision(String var1);

        public CollateralInterestHandlingParametersBuilder setAlternativeToInterestAmount(AlternativeToInterestAmountEnum var1);

        public CollateralInterestHandlingParametersBuilder setCutoffTime(LocalTime var1);

        public CollateralInterestHandlingParametersBuilder setIncludeAccrualInMarginCalc(Boolean var1);

        public CollateralInterestHandlingParametersBuilder setInterestAmountApplication(InterestAmountApplication var1);

        public CollateralInterestHandlingParametersBuilder setInterestPaymentHandling(CollateralInterestHandlingEnum var1);

        public CollateralInterestHandlingParametersBuilder setInterestRolloverLimit(NumberBound var1);

        public CollateralInterestHandlingParametersBuilder setNetInterestWithMarginCalls(Boolean var1);

        public CollateralInterestHandlingParametersBuilder setNetPostedAndHeldInterest(Boolean var1);

        public CollateralInterestHandlingParametersBuilder setNotification(CollateralInterestNotification var1);

        public CollateralInterestHandlingParametersBuilder setOnFullReturn(Boolean var1);

        public CollateralInterestHandlingParametersBuilder setOnPartialReturn(Boolean var1);

        public CollateralInterestHandlingParametersBuilder addPaymentBusinessCenter(BusinessCenterEnum var1);

        public CollateralInterestHandlingParametersBuilder addPaymentBusinessCenter(BusinessCenterEnum var1, int var2);

        public CollateralInterestHandlingParametersBuilder addPaymentBusinessCenter(List<? extends BusinessCenterEnum> var1);

        public CollateralInterestHandlingParametersBuilder setPaymentBusinessCenter(List<? extends BusinessCenterEnum> var1);

        public CollateralInterestHandlingParametersBuilder setWriteoffLimit(NumberBound var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("accrueInterestOnUnsettledInterest"), Boolean.class, (Object)this.getAccrueInterestOnUnsettledInterest(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("alternativeProvision"), String.class, (Object)this.getAlternativeProvision(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("alternativeToInterestAmount"), AlternativeToInterestAmountEnum.class, (Object)this.getAlternativeToInterestAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cutoffTime"), LocalTime.class, (Object)this.getCutoffTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("includeAccrualInMarginCalc"), Boolean.class, (Object)this.getIncludeAccrualInMarginCalc(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("interestPaymentHandling"), CollateralInterestHandlingEnum.class, (Object)this.getInterestPaymentHandling(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("netInterestWithMarginCalls"), Boolean.class, (Object)this.getNetInterestWithMarginCalls(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("netPostedAndHeldInterest"), Boolean.class, (Object)this.getNetPostedAndHeldInterest(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("onFullReturn"), Boolean.class, (Object)this.getOnFullReturn(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("onPartialReturn"), Boolean.class, (Object)this.getOnPartialReturn(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentBusinessCenter"), BusinessCenterEnum.class, this.getPaymentBusinessCenter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestAmountApplication"), processor, InterestAmountApplication.InterestAmountApplicationBuilder.class, this.getInterestAmountApplication(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestRolloverLimit"), processor, NumberBound.NumberBoundBuilder.class, this.getInterestRolloverLimit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notification"), processor, CollateralInterestNotification.CollateralInterestNotificationBuilder.class, this.getNotification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("writeoffLimit"), processor, NumberBound.NumberBoundBuilder.class, this.getWriteoffLimit(), new AttributeMeta[0]);
        }

        public CollateralInterestHandlingParametersBuilder prune();
    }
}

