/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.CompoundingTypeEnum;
import cdm.base.datetime.RoundingFrequencyEnum;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.math.Rounding;
import cdm.product.collateral.CollateralAgreementFloatingRate;
import cdm.product.collateral.meta.CollateralInterestCalculationParametersMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CollateralInterestCalculationParameters
extends RosettaModelObject {
    public static final CollateralInterestCalculationParametersMeta metaData = new CollateralInterestCalculationParametersMeta();

    public CollateralInterestCalculationParameters build();

    public CollateralInterestCalculationParametersBuilder toBuilder();

    public List<BusinessCenterEnum> getCompoundingBusinessCenter();

    public CompoundingTypeEnum getCompoundingType();

    public DayCountFractionEnum getDayCountFraction();

    public BigDecimal getFixedRate();

    public CollateralAgreementFloatingRate getFloatingRate();

    public Boolean getInBaseCurrency();

    public Rounding getRounding();

    public RoundingFrequencyEnum getRoundingFrequency();

    public BigDecimal getWithholdingTaxRate();

    default public RosettaMetaData<? extends CollateralInterestCalculationParameters> metaData() {
        return metaData;
    }

    public static CollateralInterestCalculationParametersBuilder builder() {
        return new CollateralInterestCalculationParametersBuilderImpl();
    }

    default public Class<? extends CollateralInterestCalculationParameters> getType() {
        return CollateralInterestCalculationParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("compoundingBusinessCenter"), BusinessCenterEnum.class, this.getCompoundingBusinessCenter(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundingType"), CompoundingTypeEnum.class, (Object)this.getCompoundingType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayCountFraction"), DayCountFractionEnum.class, (Object)this.getDayCountFraction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("inBaseCurrency"), Boolean.class, (Object)this.getInBaseCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("roundingFrequency"), RoundingFrequencyEnum.class, (Object)this.getRoundingFrequency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("withholdingTaxRate"), BigDecimal.class, (Object)this.getWithholdingTaxRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRate"), processor, CollateralAgreementFloatingRate.class, this.getFloatingRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
    }

    public static class CollateralInterestCalculationParametersBuilderImpl
    implements CollateralInterestCalculationParametersBuilder {
        protected List<BusinessCenterEnum> compoundingBusinessCenter = new ArrayList<BusinessCenterEnum>();
        protected CompoundingTypeEnum compoundingType;
        protected DayCountFractionEnum dayCountFraction;
        protected BigDecimal fixedRate;
        protected CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder floatingRate;
        protected Boolean inBaseCurrency;
        protected Rounding.RoundingBuilder rounding;
        protected RoundingFrequencyEnum roundingFrequency;
        protected BigDecimal withholdingTaxRate;

        @Override
        public List<BusinessCenterEnum> getCompoundingBusinessCenter() {
            return this.compoundingBusinessCenter;
        }

        @Override
        public CompoundingTypeEnum getCompoundingType() {
            return this.compoundingType;
        }

        @Override
        public DayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getOrCreateFloatingRate() {
            CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder result = this.floatingRate != null ? this.floatingRate : (this.floatingRate = CollateralAgreementFloatingRate.builder());
            return result;
        }

        @Override
        public Boolean getInBaseCurrency() {
            return this.inBaseCurrency;
        }

        @Override
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        public RoundingFrequencyEnum getRoundingFrequency() {
            return this.roundingFrequency;
        }

        @Override
        public BigDecimal getWithholdingTaxRate() {
            return this.withholdingTaxRate;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum compoundingBusinessCenter) {
            if (compoundingBusinessCenter != null) {
                this.compoundingBusinessCenter.add(compoundingBusinessCenter);
            }
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum compoundingBusinessCenter, int _idx) {
            this.getIndex(this.compoundingBusinessCenter, _idx, () -> compoundingBusinessCenter);
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(List<? extends BusinessCenterEnum> compoundingBusinessCenters) {
            if (compoundingBusinessCenters != null) {
                for (BusinessCenterEnum businessCenterEnum : compoundingBusinessCenters) {
                    this.compoundingBusinessCenter.add(businessCenterEnum);
                }
            }
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setCompoundingBusinessCenter(List<? extends BusinessCenterEnum> compoundingBusinessCenters) {
            this.compoundingBusinessCenter = compoundingBusinessCenters == null ? new ArrayList<BusinessCenterEnum>() : (List)compoundingBusinessCenters.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setCompoundingType(CompoundingTypeEnum compoundingType) {
            this.compoundingType = compoundingType == null ? null : compoundingType;
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setDayCountFraction(DayCountFractionEnum dayCountFraction) {
            this.dayCountFraction = dayCountFraction == null ? null : dayCountFraction;
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setFixedRate(BigDecimal fixedRate) {
            this.fixedRate = fixedRate == null ? null : fixedRate;
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setFloatingRate(CollateralAgreementFloatingRate floatingRate) {
            this.floatingRate = floatingRate == null ? null : floatingRate.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setInBaseCurrency(Boolean inBaseCurrency) {
            this.inBaseCurrency = inBaseCurrency == null ? null : inBaseCurrency;
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setRounding(Rounding rounding) {
            this.rounding = rounding == null ? null : rounding.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setRoundingFrequency(RoundingFrequencyEnum roundingFrequency) {
            this.roundingFrequency = roundingFrequency == null ? null : roundingFrequency;
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder setWithholdingTaxRate(BigDecimal withholdingTaxRate) {
            this.withholdingTaxRate = withholdingTaxRate == null ? null : withholdingTaxRate;
            return this;
        }

        @Override
        public CollateralInterestCalculationParameters build() {
            return new CollateralInterestCalculationParametersImpl(this);
        }

        @Override
        public CollateralInterestCalculationParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder prune() {
            if (this.floatingRate != null && !this.floatingRate.prune().hasData()) {
                this.floatingRate = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCompoundingBusinessCenter() != null && !this.getCompoundingBusinessCenter().isEmpty()) {
                return true;
            }
            if (this.getCompoundingType() != null) {
                return true;
            }
            if (this.getDayCountFraction() != null) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            if (this.getFloatingRate() != null && this.getFloatingRate().hasData()) {
                return true;
            }
            if (this.getInBaseCurrency() != null) {
                return true;
            }
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            if (this.getRoundingFrequency() != null) {
                return true;
            }
            return this.getWithholdingTaxRate() != null;
        }

        public CollateralInterestCalculationParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralInterestCalculationParametersBuilder o = (CollateralInterestCalculationParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRate(), (RosettaModelObjectBuilder)o.getFloatingRate(), this::setFloatingRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeBasic(this.getCompoundingBusinessCenter(), o.getCompoundingBusinessCenter(), this::addCompoundingBusinessCenter);
            merger.mergeBasic((Object)this.getCompoundingType(), (Object)o.getCompoundingType(), this::setCompoundingType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayCountFraction(), (Object)o.getDayCountFraction(), this::setDayCountFraction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInBaseCurrency(), (Object)o.getInBaseCurrency(), this::setInBaseCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRoundingFrequency(), (Object)o.getRoundingFrequency(), this::setRoundingFrequency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWithholdingTaxRate(), (Object)o.getWithholdingTaxRate(), this::setWithholdingTaxRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestCalculationParameters _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.compoundingBusinessCenter, _that.getCompoundingBusinessCenter())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingType, (Object)_that.getCompoundingType())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayCountFraction, (Object)_that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.inBaseCurrency, _that.getInBaseCurrency())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.roundingFrequency, (Object)_that.getRoundingFrequency())) {
                return false;
            }
            return Objects.equals(this.withholdingTaxRate, _that.getWithholdingTaxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.compoundingBusinessCenter != null ? this.compoundingBusinessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.compoundingType != null ? ((Object)((Object)this.compoundingType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? ((Object)((Object)this.dayCountFraction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.inBaseCurrency != null ? this.inBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.roundingFrequency != null ? ((Object)((Object)this.roundingFrequency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.withholdingTaxRate != null ? this.withholdingTaxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestCalculationParametersBuilder {compoundingBusinessCenter=" + this.compoundingBusinessCenter + ", compoundingType=" + (Object)((Object)this.compoundingType) + ", dayCountFraction=" + (Object)((Object)this.dayCountFraction) + ", fixedRate=" + this.fixedRate + ", floatingRate=" + this.floatingRate + ", inBaseCurrency=" + this.inBaseCurrency + ", rounding=" + this.rounding + ", roundingFrequency=" + (Object)((Object)this.roundingFrequency) + ", withholdingTaxRate=" + this.withholdingTaxRate + '}';
        }
    }

    public static class CollateralInterestCalculationParametersImpl
    implements CollateralInterestCalculationParameters {
        private final List<BusinessCenterEnum> compoundingBusinessCenter;
        private final CompoundingTypeEnum compoundingType;
        private final DayCountFractionEnum dayCountFraction;
        private final BigDecimal fixedRate;
        private final CollateralAgreementFloatingRate floatingRate;
        private final Boolean inBaseCurrency;
        private final Rounding rounding;
        private final RoundingFrequencyEnum roundingFrequency;
        private final BigDecimal withholdingTaxRate;

        protected CollateralInterestCalculationParametersImpl(CollateralInterestCalculationParametersBuilder builder) {
            this.compoundingBusinessCenter = Optional.ofNullable(builder.getCompoundingBusinessCenter()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.compoundingType = builder.getCompoundingType();
            this.dayCountFraction = builder.getDayCountFraction();
            this.fixedRate = builder.getFixedRate();
            this.floatingRate = Optional.ofNullable(builder.getFloatingRate()).map(f -> f.build()).orElse(null);
            this.inBaseCurrency = builder.getInBaseCurrency();
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.roundingFrequency = builder.getRoundingFrequency();
            this.withholdingTaxRate = builder.getWithholdingTaxRate();
        }

        @Override
        public List<BusinessCenterEnum> getCompoundingBusinessCenter() {
            return this.compoundingBusinessCenter;
        }

        @Override
        public CompoundingTypeEnum getCompoundingType() {
            return this.compoundingType;
        }

        @Override
        public DayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public CollateralAgreementFloatingRate getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public Boolean getInBaseCurrency() {
            return this.inBaseCurrency;
        }

        @Override
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        public RoundingFrequencyEnum getRoundingFrequency() {
            return this.roundingFrequency;
        }

        @Override
        public BigDecimal getWithholdingTaxRate() {
            return this.withholdingTaxRate;
        }

        @Override
        public CollateralInterestCalculationParameters build() {
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder toBuilder() {
            CollateralInterestCalculationParametersBuilder builder = CollateralInterestCalculationParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralInterestCalculationParametersBuilder builder) {
            Optional.ofNullable(this.getCompoundingBusinessCenter()).ifPresent(builder::setCompoundingBusinessCenter);
            Optional.ofNullable(this.getCompoundingType()).ifPresent(builder::setCompoundingType);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getFloatingRate()).ifPresent(builder::setFloatingRate);
            Optional.ofNullable(this.getInBaseCurrency()).ifPresent(builder::setInBaseCurrency);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getRoundingFrequency()).ifPresent(builder::setRoundingFrequency);
            Optional.ofNullable(this.getWithholdingTaxRate()).ifPresent(builder::setWithholdingTaxRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestCalculationParameters _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.compoundingBusinessCenter, _that.getCompoundingBusinessCenter())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingType, (Object)_that.getCompoundingType())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayCountFraction, (Object)_that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.inBaseCurrency, _that.getInBaseCurrency())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.roundingFrequency, (Object)_that.getRoundingFrequency())) {
                return false;
            }
            return Objects.equals(this.withholdingTaxRate, _that.getWithholdingTaxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.compoundingBusinessCenter != null ? this.compoundingBusinessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.compoundingType != null ? ((Object)((Object)this.compoundingType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? ((Object)((Object)this.dayCountFraction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.inBaseCurrency != null ? this.inBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.roundingFrequency != null ? ((Object)((Object)this.roundingFrequency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.withholdingTaxRate != null ? this.withholdingTaxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestCalculationParameters {compoundingBusinessCenter=" + this.compoundingBusinessCenter + ", compoundingType=" + (Object)((Object)this.compoundingType) + ", dayCountFraction=" + (Object)((Object)this.dayCountFraction) + ", fixedRate=" + this.fixedRate + ", floatingRate=" + this.floatingRate + ", inBaseCurrency=" + this.inBaseCurrency + ", rounding=" + this.rounding + ", roundingFrequency=" + (Object)((Object)this.roundingFrequency) + ", withholdingTaxRate=" + this.withholdingTaxRate + '}';
        }
    }

    public static interface CollateralInterestCalculationParametersBuilder
    extends CollateralInterestCalculationParameters,
    RosettaModelObjectBuilder {
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getOrCreateFloatingRate();

        @Override
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getFloatingRate();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum var1);

        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum var1, int var2);

        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(List<? extends BusinessCenterEnum> var1);

        public CollateralInterestCalculationParametersBuilder setCompoundingBusinessCenter(List<? extends BusinessCenterEnum> var1);

        public CollateralInterestCalculationParametersBuilder setCompoundingType(CompoundingTypeEnum var1);

        public CollateralInterestCalculationParametersBuilder setDayCountFraction(DayCountFractionEnum var1);

        public CollateralInterestCalculationParametersBuilder setFixedRate(BigDecimal var1);

        public CollateralInterestCalculationParametersBuilder setFloatingRate(CollateralAgreementFloatingRate var1);

        public CollateralInterestCalculationParametersBuilder setInBaseCurrency(Boolean var1);

        public CollateralInterestCalculationParametersBuilder setRounding(Rounding var1);

        public CollateralInterestCalculationParametersBuilder setRoundingFrequency(RoundingFrequencyEnum var1);

        public CollateralInterestCalculationParametersBuilder setWithholdingTaxRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("compoundingBusinessCenter"), BusinessCenterEnum.class, this.getCompoundingBusinessCenter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundingType"), CompoundingTypeEnum.class, (Object)this.getCompoundingType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayCountFraction"), DayCountFractionEnum.class, (Object)this.getDayCountFraction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("inBaseCurrency"), Boolean.class, (Object)this.getInBaseCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("roundingFrequency"), RoundingFrequencyEnum.class, (Object)this.getRoundingFrequency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("withholdingTaxRate"), BigDecimal.class, (Object)this.getWithholdingTaxRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRate"), processor, CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder.class, this.getFloatingRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
        }

        public CollateralInterestCalculationParametersBuilder prune();
    }
}

