/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.product.collateral.AssetCriteria;
import cdm.product.collateral.IssuerCriteria;
import cdm.product.collateral.meta.CollateralCriteriaBaseMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CollateralCriteriaBase
extends RosettaModelObject {
    public static final CollateralCriteriaBaseMeta metaData = new CollateralCriteriaBaseMeta();

    public CollateralCriteriaBase build();

    public CollateralCriteriaBaseBuilder toBuilder();

    public List<? extends AssetCriteria> getAsset();

    public List<? extends IssuerCriteria> getIssuer();

    default public RosettaMetaData<? extends CollateralCriteriaBase> metaData() {
        return metaData;
    }

    public static CollateralCriteriaBaseBuilder builder() {
        return new CollateralCriteriaBaseBuilderImpl();
    }

    default public Class<? extends CollateralCriteriaBase> getType() {
        return CollateralCriteriaBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("asset"), processor, AssetCriteria.class, this.getAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuer"), processor, IssuerCriteria.class, this.getIssuer(), new AttributeMeta[0]);
    }

    public static class CollateralCriteriaBaseBuilderImpl
    implements CollateralCriteriaBaseBuilder {
        protected List<AssetCriteria.AssetCriteriaBuilder> asset = new ArrayList<AssetCriteria.AssetCriteriaBuilder>();
        protected List<IssuerCriteria.IssuerCriteriaBuilder> issuer = new ArrayList<IssuerCriteria.IssuerCriteriaBuilder>();

        @Override
        public List<? extends AssetCriteria.AssetCriteriaBuilder> getAsset() {
            return this.asset;
        }

        @Override
        public AssetCriteria.AssetCriteriaBuilder getOrCreateAsset(int _index) {
            if (this.asset == null) {
                this.asset = new ArrayList<AssetCriteria.AssetCriteriaBuilder>();
            }
            return (AssetCriteria.AssetCriteriaBuilder)this.getIndex(this.asset, _index, () -> {
                AssetCriteria.AssetCriteriaBuilder newAsset = AssetCriteria.builder();
                return newAsset;
            });
        }

        @Override
        public List<? extends IssuerCriteria.IssuerCriteriaBuilder> getIssuer() {
            return this.issuer;
        }

        @Override
        public IssuerCriteria.IssuerCriteriaBuilder getOrCreateIssuer(int _index) {
            if (this.issuer == null) {
                this.issuer = new ArrayList<IssuerCriteria.IssuerCriteriaBuilder>();
            }
            return (IssuerCriteria.IssuerCriteriaBuilder)this.getIndex(this.issuer, _index, () -> {
                IssuerCriteria.IssuerCriteriaBuilder newIssuer = IssuerCriteria.builder();
                return newIssuer;
            });
        }

        @Override
        public CollateralCriteriaBaseBuilder addAsset(AssetCriteria asset) {
            if (asset != null) {
                this.asset.add(asset.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder addAsset(AssetCriteria asset, int _idx) {
            this.getIndex(this.asset, _idx, () -> asset.toBuilder());
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder addAsset(List<? extends AssetCriteria> assets) {
            if (assets != null) {
                for (AssetCriteria assetCriteria : assets) {
                    this.asset.add(assetCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder setAsset(List<? extends AssetCriteria> assets) {
            this.asset = assets == null ? new ArrayList<AssetCriteria.AssetCriteriaBuilder>() : (List)assets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder addIssuer(IssuerCriteria issuer) {
            if (issuer != null) {
                this.issuer.add(issuer.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder addIssuer(IssuerCriteria issuer, int _idx) {
            this.getIndex(this.issuer, _idx, () -> issuer.toBuilder());
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder addIssuer(List<? extends IssuerCriteria> issuers) {
            if (issuers != null) {
                for (IssuerCriteria issuerCriteria : issuers) {
                    this.issuer.add(issuerCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder setIssuer(List<? extends IssuerCriteria> issuers) {
            this.issuer = issuers == null ? new ArrayList<IssuerCriteria.IssuerCriteriaBuilder>() : (List)issuers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralCriteriaBase build() {
            return new CollateralCriteriaBaseImpl(this);
        }

        @Override
        public CollateralCriteriaBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder prune() {
            this.asset = this.asset.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.issuer = this.issuer.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAsset() != null && this.getAsset().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getIssuer() != null && this.getIssuer().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CollateralCriteriaBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralCriteriaBaseBuilder o = (CollateralCriteriaBaseBuilder)other;
            merger.mergeRosetta(this.getAsset(), o.getAsset(), this::getOrCreateAsset);
            merger.mergeRosetta(this.getIssuer(), o.getIssuer(), this::getOrCreateIssuer);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralCriteriaBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.asset, _that.getAsset())) {
                return false;
            }
            return ListEquals.listEquals(this.issuer, _that.getIssuer());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralCriteriaBaseBuilder {asset=" + this.asset + ", issuer=" + this.issuer + '}';
        }
    }

    public static class CollateralCriteriaBaseImpl
    implements CollateralCriteriaBase {
        private final List<? extends AssetCriteria> asset;
        private final List<? extends IssuerCriteria> issuer;

        protected CollateralCriteriaBaseImpl(CollateralCriteriaBaseBuilder builder) {
            this.asset = Optional.ofNullable(builder.getAsset()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.issuer = Optional.ofNullable(builder.getIssuer()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends AssetCriteria> getAsset() {
            return this.asset;
        }

        @Override
        public List<? extends IssuerCriteria> getIssuer() {
            return this.issuer;
        }

        @Override
        public CollateralCriteriaBase build() {
            return this;
        }

        @Override
        public CollateralCriteriaBaseBuilder toBuilder() {
            CollateralCriteriaBaseBuilder builder = CollateralCriteriaBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralCriteriaBaseBuilder builder) {
            Optional.ofNullable(this.getAsset()).ifPresent(builder::setAsset);
            Optional.ofNullable(this.getIssuer()).ifPresent(builder::setIssuer);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralCriteriaBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.asset, _that.getAsset())) {
                return false;
            }
            return ListEquals.listEquals(this.issuer, _that.getIssuer());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralCriteriaBase {asset=" + this.asset + ", issuer=" + this.issuer + '}';
        }
    }

    public static interface CollateralCriteriaBaseBuilder
    extends CollateralCriteriaBase,
    RosettaModelObjectBuilder {
        public AssetCriteria.AssetCriteriaBuilder getOrCreateAsset(int var1);

        public List<? extends AssetCriteria.AssetCriteriaBuilder> getAsset();

        public IssuerCriteria.IssuerCriteriaBuilder getOrCreateIssuer(int var1);

        public List<? extends IssuerCriteria.IssuerCriteriaBuilder> getIssuer();

        public CollateralCriteriaBaseBuilder addAsset(AssetCriteria var1);

        public CollateralCriteriaBaseBuilder addAsset(AssetCriteria var1, int var2);

        public CollateralCriteriaBaseBuilder addAsset(List<? extends AssetCriteria> var1);

        public CollateralCriteriaBaseBuilder setAsset(List<? extends AssetCriteria> var1);

        public CollateralCriteriaBaseBuilder addIssuer(IssuerCriteria var1);

        public CollateralCriteriaBaseBuilder addIssuer(IssuerCriteria var1, int var2);

        public CollateralCriteriaBaseBuilder addIssuer(List<? extends IssuerCriteria> var1);

        public CollateralCriteriaBaseBuilder setIssuer(List<? extends IssuerCriteria> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("asset"), processor, AssetCriteria.AssetCriteriaBuilder.class, this.getAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuer"), processor, IssuerCriteria.IssuerCriteriaBuilder.class, this.getIssuer(), new AttributeMeta[0]);
        }

        public CollateralCriteriaBaseBuilder prune();
    }
}

