/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.product.collateral.CollateralProvisions;
import cdm.product.collateral.IndependentAmount;
import cdm.product.collateral.meta.CollateralMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Collateral
extends RosettaModelObject {
    public static final CollateralMeta metaData = new CollateralMeta();

    public Collateral build();

    public CollateralBuilder toBuilder();

    public List<? extends ReferenceWithMetaCollateralPortfolio> getCollateralPortfolio();

    public CollateralProvisions getCollateralProvisions();

    public IndependentAmount getIndependentAmount();

    public List<? extends Identifier> getPortfolioIdentifier();

    default public RosettaMetaData<? extends Collateral> metaData() {
        return metaData;
    }

    public static CollateralBuilder builder() {
        return new CollateralBuilderImpl();
    }

    default public Class<? extends Collateral> getType() {
        return Collateral.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralProvisions"), processor, CollateralProvisions.class, this.getCollateralProvisions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("independentAmount"), processor, IndependentAmount.class, this.getIndependentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
    }

    public static class CollateralBuilderImpl
    implements CollateralBuilder {
        protected List<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder> collateralPortfolio = new ArrayList<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder>();
        protected CollateralProvisions.CollateralProvisionsBuilder collateralProvisions;
        protected IndependentAmount.IndependentAmountBuilder independentAmount;
        protected List<Identifier.IdentifierBuilder> portfolioIdentifier = new ArrayList<Identifier.IdentifierBuilder>();

        @Override
        public List<? extends ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder> getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio(int _index) {
            if (this.collateralPortfolio == null) {
                this.collateralPortfolio = new ArrayList<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder>();
            }
            return (ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder)this.getIndex(this.collateralPortfolio, _index, () -> {
                ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder newCollateralPortfolio = ReferenceWithMetaCollateralPortfolio.builder();
                return newCollateralPortfolio;
            });
        }

        @Override
        public CollateralProvisions.CollateralProvisionsBuilder getCollateralProvisions() {
            return this.collateralProvisions;
        }

        @Override
        public CollateralProvisions.CollateralProvisionsBuilder getOrCreateCollateralProvisions() {
            CollateralProvisions.CollateralProvisionsBuilder result = this.collateralProvisions != null ? this.collateralProvisions : (this.collateralProvisions = CollateralProvisions.builder());
            return result;
        }

        @Override
        public IndependentAmount.IndependentAmountBuilder getIndependentAmount() {
            return this.independentAmount;
        }

        @Override
        public IndependentAmount.IndependentAmountBuilder getOrCreateIndependentAmount() {
            IndependentAmount.IndependentAmountBuilder result = this.independentAmount != null ? this.independentAmount : (this.independentAmount = IndependentAmount.builder());
            return result;
        }

        @Override
        public List<? extends Identifier.IdentifierBuilder> getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier(int _index) {
            if (this.portfolioIdentifier == null) {
                this.portfolioIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.portfolioIdentifier, _index, () -> {
                Identifier.IdentifierBuilder newPortfolioIdentifier = Identifier.builder();
                return newPortfolioIdentifier;
            });
        }

        @Override
        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio collateralPortfolio) {
            if (collateralPortfolio != null) {
                this.collateralPortfolio.add(collateralPortfolio.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio collateralPortfolio, int _idx) {
            this.getIndex(this.collateralPortfolio, _idx, () -> collateralPortfolio.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio collateralPortfolio) {
            this.getOrCreateCollateralPortfolio(-1).setValue(collateralPortfolio.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio collateralPortfolio, int _idx) {
            this.getOrCreateCollateralPortfolio(_idx).setValue(collateralPortfolio.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> collateralPortfolios) {
            if (collateralPortfolios != null) {
                for (ReferenceWithMetaCollateralPortfolio referenceWithMetaCollateralPortfolio : collateralPortfolios) {
                    this.collateralPortfolio.add(referenceWithMetaCollateralPortfolio.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralBuilder setCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> collateralPortfolios) {
            this.collateralPortfolio = collateralPortfolios == null ? new ArrayList<ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder>() : (List)collateralPortfolios.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralBuilder addCollateralPortfolioValue(List<? extends CollateralPortfolio> collateralPortfolios) {
            if (collateralPortfolios != null) {
                for (CollateralPortfolio collateralPortfolio : collateralPortfolios) {
                    this.addCollateralPortfolioValue(collateralPortfolio);
                }
            }
            return this;
        }

        @Override
        public CollateralBuilder setCollateralPortfolioValue(List<? extends CollateralPortfolio> collateralPortfolios) {
            this.collateralPortfolio.clear();
            if (collateralPortfolios != null) {
                collateralPortfolios.forEach(this::addCollateralPortfolioValue);
            }
            return this;
        }

        @Override
        public CollateralBuilder setCollateralProvisions(CollateralProvisions collateralProvisions) {
            this.collateralProvisions = collateralProvisions == null ? null : collateralProvisions.toBuilder();
            return this;
        }

        @Override
        public CollateralBuilder setIndependentAmount(IndependentAmount independentAmount) {
            this.independentAmount = independentAmount == null ? null : independentAmount.toBuilder();
            return this;
        }

        @Override
        public CollateralBuilder addPortfolioIdentifier(Identifier portfolioIdentifier) {
            if (portfolioIdentifier != null) {
                this.portfolioIdentifier.add(portfolioIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralBuilder addPortfolioIdentifier(Identifier portfolioIdentifier, int _idx) {
            this.getIndex(this.portfolioIdentifier, _idx, () -> portfolioIdentifier.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addPortfolioIdentifier(List<? extends Identifier> portfolioIdentifiers) {
            if (portfolioIdentifiers != null) {
                for (Identifier identifier : portfolioIdentifiers) {
                    this.portfolioIdentifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CollateralBuilder setPortfolioIdentifier(List<? extends Identifier> portfolioIdentifiers) {
            this.portfolioIdentifier = portfolioIdentifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)portfolioIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Collateral build() {
            return new CollateralImpl(this);
        }

        @Override
        public CollateralBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralBuilder prune() {
            this.collateralPortfolio = this.collateralPortfolio.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.collateralProvisions != null && !this.collateralProvisions.prune().hasData()) {
                this.collateralProvisions = null;
            }
            if (this.independentAmount != null && !this.independentAmount.prune().hasData()) {
                this.independentAmount = null;
            }
            this.portfolioIdentifier = this.portfolioIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralPortfolio() != null && this.getCollateralPortfolio().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralProvisions() != null && this.getCollateralProvisions().hasData()) {
                return true;
            }
            if (this.getIndependentAmount() != null && this.getIndependentAmount().hasData()) {
                return true;
            }
            return this.getPortfolioIdentifier() != null && this.getPortfolioIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CollateralBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralBuilder o = (CollateralBuilder)other;
            merger.mergeRosetta(this.getCollateralPortfolio(), o.getCollateralPortfolio(), this::getOrCreateCollateralPortfolio);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralProvisions(), (RosettaModelObjectBuilder)o.getCollateralProvisions(), this::setCollateralProvisions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndependentAmount(), (RosettaModelObjectBuilder)o.getIndependentAmount(), this::setIndependentAmount);
            merger.mergeRosetta(this.getPortfolioIdentifier(), o.getPortfolioIdentifier(), this::getOrCreatePortfolioIdentifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Collateral _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.collateralProvisions, _that.getCollateralProvisions())) {
                return false;
            }
            if (!Objects.equals(this.independentAmount, _that.getIndependentAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolioIdentifier, _that.getPortfolioIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.collateralProvisions != null ? this.collateralProvisions.hashCode() : 0);
            _result = 31 * _result + (this.independentAmount != null ? this.independentAmount.hashCode() : 0);
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralBuilder {collateralPortfolio=" + this.collateralPortfolio + ", collateralProvisions=" + this.collateralProvisions + ", independentAmount=" + this.independentAmount + ", portfolioIdentifier=" + this.portfolioIdentifier + '}';
        }
    }

    public static class CollateralImpl
    implements Collateral {
        private final List<? extends ReferenceWithMetaCollateralPortfolio> collateralPortfolio;
        private final CollateralProvisions collateralProvisions;
        private final IndependentAmount independentAmount;
        private final List<? extends Identifier> portfolioIdentifier;

        protected CollateralImpl(CollateralBuilder builder) {
            this.collateralPortfolio = Optional.ofNullable(builder.getCollateralPortfolio()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralProvisions = Optional.ofNullable(builder.getCollateralProvisions()).map(f -> f.build()).orElse(null);
            this.independentAmount = Optional.ofNullable(builder.getIndependentAmount()).map(f -> f.build()).orElse(null);
            this.portfolioIdentifier = Optional.ofNullable(builder.getPortfolioIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends ReferenceWithMetaCollateralPortfolio> getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        public CollateralProvisions getCollateralProvisions() {
            return this.collateralProvisions;
        }

        @Override
        public IndependentAmount getIndependentAmount() {
            return this.independentAmount;
        }

        @Override
        public List<? extends Identifier> getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        public Collateral build() {
            return this;
        }

        @Override
        public CollateralBuilder toBuilder() {
            CollateralBuilder builder = Collateral.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralBuilder builder) {
            Optional.ofNullable(this.getCollateralPortfolio()).ifPresent(builder::setCollateralPortfolio);
            Optional.ofNullable(this.getCollateralProvisions()).ifPresent(builder::setCollateralProvisions);
            Optional.ofNullable(this.getIndependentAmount()).ifPresent(builder::setIndependentAmount);
            Optional.ofNullable(this.getPortfolioIdentifier()).ifPresent(builder::setPortfolioIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Collateral _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.collateralProvisions, _that.getCollateralProvisions())) {
                return false;
            }
            if (!Objects.equals(this.independentAmount, _that.getIndependentAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolioIdentifier, _that.getPortfolioIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.collateralProvisions != null ? this.collateralProvisions.hashCode() : 0);
            _result = 31 * _result + (this.independentAmount != null ? this.independentAmount.hashCode() : 0);
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Collateral {collateralPortfolio=" + this.collateralPortfolio + ", collateralProvisions=" + this.collateralProvisions + ", independentAmount=" + this.independentAmount + ", portfolioIdentifier=" + this.portfolioIdentifier + '}';
        }
    }

    public static interface CollateralBuilder
    extends Collateral,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio(int var1);

        public List<? extends ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder> getCollateralPortfolio();

        public CollateralProvisions.CollateralProvisionsBuilder getOrCreateCollateralProvisions();

        @Override
        public CollateralProvisions.CollateralProvisionsBuilder getCollateralProvisions();

        public IndependentAmount.IndependentAmountBuilder getOrCreateIndependentAmount();

        @Override
        public IndependentAmount.IndependentAmountBuilder getIndependentAmount();

        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getPortfolioIdentifier();

        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        public CollateralBuilder addCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1, int var2);

        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio var1);

        public CollateralBuilder addCollateralPortfolioValue(CollateralPortfolio var1, int var2);

        public CollateralBuilder addCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> var1);

        public CollateralBuilder setCollateralPortfolio(List<? extends ReferenceWithMetaCollateralPortfolio> var1);

        public CollateralBuilder addCollateralPortfolioValue(List<? extends CollateralPortfolio> var1);

        public CollateralBuilder setCollateralPortfolioValue(List<? extends CollateralPortfolio> var1);

        public CollateralBuilder setCollateralProvisions(CollateralProvisions var1);

        public CollateralBuilder setIndependentAmount(IndependentAmount var1);

        public CollateralBuilder addPortfolioIdentifier(Identifier var1);

        public CollateralBuilder addPortfolioIdentifier(Identifier var1, int var2);

        public CollateralBuilder addPortfolioIdentifier(List<? extends Identifier> var1);

        public CollateralBuilder setPortfolioIdentifier(List<? extends Identifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralProvisions"), processor, CollateralProvisions.CollateralProvisionsBuilder.class, this.getCollateralProvisions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("independentAmount"), processor, IndependentAmount.IndependentAmountBuilder.class, this.getIndependentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
        }

        public CollateralBuilder prune();
    }
}

