/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.PeriodRange;
import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.CollateralTaxonomy;
import cdm.base.staticdata.asset.common.MaturityTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.collateral.AgencyRatingCriteria;
import cdm.product.collateral.ListingType;
import cdm.product.collateral.meta.AssetCriteriaMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface AssetCriteria
extends RosettaModelObject {
    public static final AssetCriteriaMeta metaData = new AssetCriteriaMeta();

    public AssetCriteria build();

    public AssetCriteriaBuilder toBuilder();

    public List<? extends AgencyRatingCriteria> getAgencyRating();

    public List<? extends FieldWithMetaString> getAssetCountryOfOrigin();

    public List<? extends AssetType> getCollateralAssetType();

    public List<? extends CollateralTaxonomy> getCollateralTaxonomy();

    public List<? extends FieldWithMetaString> getDenominatedCurrency();

    public Boolean getDomesticCurrencyIssued();

    public ListingType getListing();

    public PeriodRange getMaturityRange();

    public MaturityTypeEnum getMaturityType();

    public List<? extends ProductIdentifier> getProductIdentifier();

    default public RosettaMetaData<? extends AssetCriteria> metaData() {
        return metaData;
    }

    public static AssetCriteriaBuilder builder() {
        return new AssetCriteriaBuilderImpl();
    }

    default public Class<? extends AssetCriteria> getType() {
        return AssetCriteria.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("domesticCurrencyIssued"), Boolean.class, (Object)this.getDomesticCurrencyIssued(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityType"), MaturityTypeEnum.class, (Object)this.getMaturityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agencyRating"), processor, AgencyRatingCriteria.class, this.getAgencyRating(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetCountryOfOrigin"), processor, FieldWithMetaString.class, this.getAssetCountryOfOrigin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralAssetType"), processor, AssetType.class, this.getCollateralAssetType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralTaxonomy"), processor, CollateralTaxonomy.class, this.getCollateralTaxonomy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("denominatedCurrency"), processor, FieldWithMetaString.class, this.getDenominatedCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("listing"), processor, ListingType.class, this.getListing(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maturityRange"), processor, PeriodRange.class, this.getMaturityRange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, ProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
    }

    public static class AssetCriteriaBuilderImpl
    implements AssetCriteriaBuilder {
        protected List<AgencyRatingCriteria.AgencyRatingCriteriaBuilder> agencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> assetCountryOfOrigin = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
        protected List<AssetType.AssetTypeBuilder> collateralAssetType = new ArrayList<AssetType.AssetTypeBuilder>();
        protected List<CollateralTaxonomy.CollateralTaxonomyBuilder> collateralTaxonomy = new ArrayList<CollateralTaxonomy.CollateralTaxonomyBuilder>();
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> denominatedCurrency = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
        protected Boolean domesticCurrencyIssued;
        protected ListingType.ListingTypeBuilder listing;
        protected PeriodRange.PeriodRangeBuilder maturityRange;
        protected MaturityTypeEnum maturityType;
        protected List<ProductIdentifier.ProductIdentifierBuilder> productIdentifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();

        @Override
        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getAgencyRating() {
            return this.agencyRating;
        }

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateAgencyRating(int _index) {
            if (this.agencyRating == null) {
                this.agencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
            }
            return (AgencyRatingCriteria.AgencyRatingCriteriaBuilder)this.getIndex(this.agencyRating, _index, () -> {
                AgencyRatingCriteria.AgencyRatingCriteriaBuilder newAgencyRating = AgencyRatingCriteria.builder();
                return newAgencyRating;
            });
        }

        @Override
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getAssetCountryOfOrigin() {
            return this.assetCountryOfOrigin;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAssetCountryOfOrigin(int _index) {
            if (this.assetCountryOfOrigin == null) {
                this.assetCountryOfOrigin = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.assetCountryOfOrigin, _index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newAssetCountryOfOrigin = FieldWithMetaString.builder();
                return newAssetCountryOfOrigin;
            });
        }

        @Override
        public List<? extends AssetType.AssetTypeBuilder> getCollateralAssetType() {
            return this.collateralAssetType;
        }

        @Override
        public AssetType.AssetTypeBuilder getOrCreateCollateralAssetType(int _index) {
            if (this.collateralAssetType == null) {
                this.collateralAssetType = new ArrayList<AssetType.AssetTypeBuilder>();
            }
            return (AssetType.AssetTypeBuilder)this.getIndex(this.collateralAssetType, _index, () -> {
                AssetType.AssetTypeBuilder newCollateralAssetType = AssetType.builder();
                return newCollateralAssetType;
            });
        }

        @Override
        public List<? extends CollateralTaxonomy.CollateralTaxonomyBuilder> getCollateralTaxonomy() {
            return this.collateralTaxonomy;
        }

        @Override
        public CollateralTaxonomy.CollateralTaxonomyBuilder getOrCreateCollateralTaxonomy(int _index) {
            if (this.collateralTaxonomy == null) {
                this.collateralTaxonomy = new ArrayList<CollateralTaxonomy.CollateralTaxonomyBuilder>();
            }
            return (CollateralTaxonomy.CollateralTaxonomyBuilder)this.getIndex(this.collateralTaxonomy, _index, () -> {
                CollateralTaxonomy.CollateralTaxonomyBuilder newCollateralTaxonomy = CollateralTaxonomy.builder();
                return newCollateralTaxonomy;
            });
        }

        @Override
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getDenominatedCurrency() {
            return this.denominatedCurrency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateDenominatedCurrency(int _index) {
            if (this.denominatedCurrency == null) {
                this.denominatedCurrency = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.denominatedCurrency, _index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newDenominatedCurrency = FieldWithMetaString.builder();
                return newDenominatedCurrency;
            });
        }

        @Override
        public Boolean getDomesticCurrencyIssued() {
            return this.domesticCurrencyIssued;
        }

        @Override
        public ListingType.ListingTypeBuilder getListing() {
            return this.listing;
        }

        @Override
        public ListingType.ListingTypeBuilder getOrCreateListing() {
            ListingType.ListingTypeBuilder result = this.listing != null ? this.listing : (this.listing = ListingType.builder());
            return result;
        }

        @Override
        public PeriodRange.PeriodRangeBuilder getMaturityRange() {
            return this.maturityRange;
        }

        @Override
        public PeriodRange.PeriodRangeBuilder getOrCreateMaturityRange() {
            PeriodRange.PeriodRangeBuilder result = this.maturityRange != null ? this.maturityRange : (this.maturityRange = PeriodRange.builder());
            return result;
        }

        @Override
        public MaturityTypeEnum getMaturityType() {
            return this.maturityType;
        }

        @Override
        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        public ProductIdentifier.ProductIdentifierBuilder getOrCreateProductIdentifier(int _index) {
            if (this.productIdentifier == null) {
                this.productIdentifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            }
            return (ProductIdentifier.ProductIdentifierBuilder)this.getIndex(this.productIdentifier, _index, () -> {
                ProductIdentifier.ProductIdentifierBuilder newProductIdentifier = ProductIdentifier.builder();
                return newProductIdentifier;
            });
        }

        @Override
        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria agencyRating) {
            if (agencyRating != null) {
                this.agencyRating.add(agencyRating.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria agencyRating, int _idx) {
            this.getIndex(this.agencyRating, _idx, () -> agencyRating.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAgencyRating(List<? extends AgencyRatingCriteria> agencyRatings) {
            if (agencyRatings != null) {
                for (AgencyRatingCriteria agencyRatingCriteria : agencyRatings) {
                    this.agencyRating.add(agencyRatingCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setAgencyRating(List<? extends AgencyRatingCriteria> agencyRatings) {
            this.agencyRating = agencyRatings == null ? new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>() : (List)agencyRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOrigin(FieldWithMetaString assetCountryOfOrigin) {
            if (assetCountryOfOrigin != null) {
                this.assetCountryOfOrigin.add(assetCountryOfOrigin.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOrigin(FieldWithMetaString assetCountryOfOrigin, int _idx) {
            this.getIndex(this.assetCountryOfOrigin, _idx, () -> assetCountryOfOrigin.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOriginValue(String assetCountryOfOrigin) {
            this.getOrCreateAssetCountryOfOrigin(-1).setValue(assetCountryOfOrigin);
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOriginValue(String assetCountryOfOrigin, int _idx) {
            this.getOrCreateAssetCountryOfOrigin(_idx).setValue(assetCountryOfOrigin);
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOrigin(List<? extends FieldWithMetaString> assetCountryOfOrigins) {
            if (assetCountryOfOrigins != null) {
                for (FieldWithMetaString fieldWithMetaString : assetCountryOfOrigins) {
                    this.assetCountryOfOrigin.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setAssetCountryOfOrigin(List<? extends FieldWithMetaString> assetCountryOfOrigins) {
            this.assetCountryOfOrigin = assetCountryOfOrigins == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)assetCountryOfOrigins.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetCriteriaBuilder addAssetCountryOfOriginValue(List<? extends String> assetCountryOfOrigins) {
            if (assetCountryOfOrigins != null) {
                for (String string : assetCountryOfOrigins) {
                    this.addAssetCountryOfOriginValue(string);
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setAssetCountryOfOriginValue(List<? extends String> assetCountryOfOrigins) {
            this.assetCountryOfOrigin.clear();
            if (assetCountryOfOrigins != null) {
                assetCountryOfOrigins.forEach(this::addAssetCountryOfOriginValue);
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralAssetType(AssetType collateralAssetType) {
            if (collateralAssetType != null) {
                this.collateralAssetType.add(collateralAssetType.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralAssetType(AssetType collateralAssetType, int _idx) {
            this.getIndex(this.collateralAssetType, _idx, () -> collateralAssetType.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralAssetType(List<? extends AssetType> collateralAssetTypes) {
            if (collateralAssetTypes != null) {
                for (AssetType assetType : collateralAssetTypes) {
                    this.collateralAssetType.add(assetType.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setCollateralAssetType(List<? extends AssetType> collateralAssetTypes) {
            this.collateralAssetType = collateralAssetTypes == null ? new ArrayList<AssetType.AssetTypeBuilder>() : (List)collateralAssetTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy collateralTaxonomy) {
            if (collateralTaxonomy != null) {
                this.collateralTaxonomy.add(collateralTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy collateralTaxonomy, int _idx) {
            this.getIndex(this.collateralTaxonomy, _idx, () -> collateralTaxonomy.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addCollateralTaxonomy(List<? extends CollateralTaxonomy> collateralTaxonomys) {
            if (collateralTaxonomys != null) {
                for (CollateralTaxonomy collateralTaxonomy : collateralTaxonomys) {
                    this.collateralTaxonomy.add(collateralTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setCollateralTaxonomy(List<? extends CollateralTaxonomy> collateralTaxonomys) {
            this.collateralTaxonomy = collateralTaxonomys == null ? new ArrayList<CollateralTaxonomy.CollateralTaxonomyBuilder>() : (List)collateralTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrency(FieldWithMetaString denominatedCurrency) {
            if (denominatedCurrency != null) {
                this.denominatedCurrency.add(denominatedCurrency.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrency(FieldWithMetaString denominatedCurrency, int _idx) {
            this.getIndex(this.denominatedCurrency, _idx, () -> denominatedCurrency.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrencyValue(String denominatedCurrency) {
            this.getOrCreateDenominatedCurrency(-1).setValue(denominatedCurrency);
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrencyValue(String denominatedCurrency, int _idx) {
            this.getOrCreateDenominatedCurrency(_idx).setValue(denominatedCurrency);
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrency(List<? extends FieldWithMetaString> denominatedCurrencys) {
            if (denominatedCurrencys != null) {
                for (FieldWithMetaString fieldWithMetaString : denominatedCurrencys) {
                    this.denominatedCurrency.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setDenominatedCurrency(List<? extends FieldWithMetaString> denominatedCurrencys) {
            this.denominatedCurrency = denominatedCurrencys == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)denominatedCurrencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetCriteriaBuilder addDenominatedCurrencyValue(List<? extends String> denominatedCurrencys) {
            if (denominatedCurrencys != null) {
                for (String string : denominatedCurrencys) {
                    this.addDenominatedCurrencyValue(string);
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setDenominatedCurrencyValue(List<? extends String> denominatedCurrencys) {
            this.denominatedCurrency.clear();
            if (denominatedCurrencys != null) {
                denominatedCurrencys.forEach(this::addDenominatedCurrencyValue);
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setDomesticCurrencyIssued(Boolean domesticCurrencyIssued) {
            this.domesticCurrencyIssued = domesticCurrencyIssued == null ? null : domesticCurrencyIssued;
            return this;
        }

        @Override
        public AssetCriteriaBuilder setListing(ListingType listing) {
            this.listing = listing == null ? null : listing.toBuilder();
            return this;
        }

        @Override
        public AssetCriteriaBuilder setMaturityRange(PeriodRange maturityRange) {
            this.maturityRange = maturityRange == null ? null : maturityRange.toBuilder();
            return this;
        }

        @Override
        public AssetCriteriaBuilder setMaturityType(MaturityTypeEnum maturityType) {
            this.maturityType = maturityType == null ? null : maturityType;
            return this;
        }

        @Override
        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier productIdentifier) {
            if (productIdentifier != null) {
                this.productIdentifier.add(productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier productIdentifier, int _idx) {
            this.getIndex(this.productIdentifier, _idx, () -> productIdentifier.toBuilder());
            return this;
        }

        @Override
        public AssetCriteriaBuilder addProductIdentifier(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.productIdentifier.add(productIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AssetCriteriaBuilder setProductIdentifier(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList<ProductIdentifier.ProductIdentifierBuilder>() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetCriteria build() {
            return new AssetCriteriaImpl(this);
        }

        @Override
        public AssetCriteriaBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetCriteriaBuilder prune() {
            this.agencyRating = this.agencyRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.assetCountryOfOrigin = this.assetCountryOfOrigin.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralAssetType = this.collateralAssetType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralTaxonomy = this.collateralTaxonomy.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.denominatedCurrency = this.denominatedCurrency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.listing != null && !this.listing.prune().hasData()) {
                this.listing = null;
            }
            if (this.maturityRange != null && !this.maturityRange.prune().hasData()) {
                this.maturityRange = null;
            }
            this.productIdentifier = this.productIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAgencyRating() != null && this.getAgencyRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAssetCountryOfOrigin() != null && !this.getAssetCountryOfOrigin().isEmpty()) {
                return true;
            }
            if (this.getCollateralAssetType() != null && this.getCollateralAssetType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralTaxonomy() != null && this.getCollateralTaxonomy().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDenominatedCurrency() != null && !this.getDenominatedCurrency().isEmpty()) {
                return true;
            }
            if (this.getDomesticCurrencyIssued() != null) {
                return true;
            }
            if (this.getListing() != null && this.getListing().hasData()) {
                return true;
            }
            if (this.getMaturityRange() != null && this.getMaturityRange().hasData()) {
                return true;
            }
            if (this.getMaturityType() != null) {
                return true;
            }
            return this.getProductIdentifier() != null && this.getProductIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AssetCriteriaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetCriteriaBuilder o = (AssetCriteriaBuilder)other;
            merger.mergeRosetta(this.getAgencyRating(), o.getAgencyRating(), this::getOrCreateAgencyRating);
            merger.mergeRosetta(this.getAssetCountryOfOrigin(), o.getAssetCountryOfOrigin(), this::getOrCreateAssetCountryOfOrigin);
            merger.mergeRosetta(this.getCollateralAssetType(), o.getCollateralAssetType(), this::getOrCreateCollateralAssetType);
            merger.mergeRosetta(this.getCollateralTaxonomy(), o.getCollateralTaxonomy(), this::getOrCreateCollateralTaxonomy);
            merger.mergeRosetta(this.getDenominatedCurrency(), o.getDenominatedCurrency(), this::getOrCreateDenominatedCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getListing(), (RosettaModelObjectBuilder)o.getListing(), this::setListing);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaturityRange(), (RosettaModelObjectBuilder)o.getMaturityRange(), this::setMaturityRange);
            merger.mergeRosetta(this.getProductIdentifier(), o.getProductIdentifier(), this::getOrCreateProductIdentifier);
            merger.mergeBasic((Object)this.getDomesticCurrencyIssued(), (Object)o.getDomesticCurrencyIssued(), this::setDomesticCurrencyIssued, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityType(), (Object)o.getMaturityType(), this::setMaturityType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetCriteria _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.agencyRating, _that.getAgencyRating())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetCountryOfOrigin, _that.getAssetCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralAssetType, _that.getCollateralAssetType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralTaxonomy, _that.getCollateralTaxonomy())) {
                return false;
            }
            if (!ListEquals.listEquals(this.denominatedCurrency, _that.getDenominatedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.domesticCurrencyIssued, _that.getDomesticCurrencyIssued())) {
                return false;
            }
            if (!Objects.equals(this.listing, _that.getListing())) {
                return false;
            }
            if (!Objects.equals(this.maturityRange, _that.getMaturityRange())) {
                return false;
            }
            if (!Objects.equals((Object)this.maturityType, (Object)_that.getMaturityType())) {
                return false;
            }
            return ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agencyRating != null ? this.agencyRating.hashCode() : 0);
            _result = 31 * _result + (this.assetCountryOfOrigin != null ? this.assetCountryOfOrigin.hashCode() : 0);
            _result = 31 * _result + (this.collateralAssetType != null ? this.collateralAssetType.hashCode() : 0);
            _result = 31 * _result + (this.collateralTaxonomy != null ? this.collateralTaxonomy.hashCode() : 0);
            _result = 31 * _result + (this.denominatedCurrency != null ? this.denominatedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.domesticCurrencyIssued != null ? this.domesticCurrencyIssued.hashCode() : 0);
            _result = 31 * _result + (this.listing != null ? this.listing.hashCode() : 0);
            _result = 31 * _result + (this.maturityRange != null ? this.maturityRange.hashCode() : 0);
            _result = 31 * _result + (this.maturityType != null ? ((Object)((Object)this.maturityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetCriteriaBuilder {agencyRating=" + this.agencyRating + ", assetCountryOfOrigin=" + this.assetCountryOfOrigin + ", collateralAssetType=" + this.collateralAssetType + ", collateralTaxonomy=" + this.collateralTaxonomy + ", denominatedCurrency=" + this.denominatedCurrency + ", domesticCurrencyIssued=" + this.domesticCurrencyIssued + ", listing=" + this.listing + ", maturityRange=" + this.maturityRange + ", maturityType=" + (Object)((Object)this.maturityType) + ", productIdentifier=" + this.productIdentifier + '}';
        }
    }

    public static class AssetCriteriaImpl
    implements AssetCriteria {
        private final List<? extends AgencyRatingCriteria> agencyRating;
        private final List<? extends FieldWithMetaString> assetCountryOfOrigin;
        private final List<? extends AssetType> collateralAssetType;
        private final List<? extends CollateralTaxonomy> collateralTaxonomy;
        private final List<? extends FieldWithMetaString> denominatedCurrency;
        private final Boolean domesticCurrencyIssued;
        private final ListingType listing;
        private final PeriodRange maturityRange;
        private final MaturityTypeEnum maturityType;
        private final List<? extends ProductIdentifier> productIdentifier;

        protected AssetCriteriaImpl(AssetCriteriaBuilder builder) {
            this.agencyRating = Optional.ofNullable(builder.getAgencyRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.assetCountryOfOrigin = Optional.ofNullable(builder.getAssetCountryOfOrigin()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralAssetType = Optional.ofNullable(builder.getCollateralAssetType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralTaxonomy = Optional.ofNullable(builder.getCollateralTaxonomy()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.denominatedCurrency = Optional.ofNullable(builder.getDenominatedCurrency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.domesticCurrencyIssued = builder.getDomesticCurrencyIssued();
            this.listing = Optional.ofNullable(builder.getListing()).map(f -> f.build()).orElse(null);
            this.maturityRange = Optional.ofNullable(builder.getMaturityRange()).map(f -> f.build()).orElse(null);
            this.maturityType = builder.getMaturityType();
            this.productIdentifier = Optional.ofNullable(builder.getProductIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public List<? extends AgencyRatingCriteria> getAgencyRating() {
            return this.agencyRating;
        }

        @Override
        public List<? extends FieldWithMetaString> getAssetCountryOfOrigin() {
            return this.assetCountryOfOrigin;
        }

        @Override
        public List<? extends AssetType> getCollateralAssetType() {
            return this.collateralAssetType;
        }

        @Override
        public List<? extends CollateralTaxonomy> getCollateralTaxonomy() {
            return this.collateralTaxonomy;
        }

        @Override
        public List<? extends FieldWithMetaString> getDenominatedCurrency() {
            return this.denominatedCurrency;
        }

        @Override
        public Boolean getDomesticCurrencyIssued() {
            return this.domesticCurrencyIssued;
        }

        @Override
        public ListingType getListing() {
            return this.listing;
        }

        @Override
        public PeriodRange getMaturityRange() {
            return this.maturityRange;
        }

        @Override
        public MaturityTypeEnum getMaturityType() {
            return this.maturityType;
        }

        @Override
        public List<? extends ProductIdentifier> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        public AssetCriteria build() {
            return this;
        }

        @Override
        public AssetCriteriaBuilder toBuilder() {
            AssetCriteriaBuilder builder = AssetCriteria.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetCriteriaBuilder builder) {
            Optional.ofNullable(this.getAgencyRating()).ifPresent(builder::setAgencyRating);
            Optional.ofNullable(this.getAssetCountryOfOrigin()).ifPresent(builder::setAssetCountryOfOrigin);
            Optional.ofNullable(this.getCollateralAssetType()).ifPresent(builder::setCollateralAssetType);
            Optional.ofNullable(this.getCollateralTaxonomy()).ifPresent(builder::setCollateralTaxonomy);
            Optional.ofNullable(this.getDenominatedCurrency()).ifPresent(builder::setDenominatedCurrency);
            Optional.ofNullable(this.getDomesticCurrencyIssued()).ifPresent(builder::setDomesticCurrencyIssued);
            Optional.ofNullable(this.getListing()).ifPresent(builder::setListing);
            Optional.ofNullable(this.getMaturityRange()).ifPresent(builder::setMaturityRange);
            Optional.ofNullable(this.getMaturityType()).ifPresent(builder::setMaturityType);
            Optional.ofNullable(this.getProductIdentifier()).ifPresent(builder::setProductIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetCriteria _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.agencyRating, _that.getAgencyRating())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assetCountryOfOrigin, _that.getAssetCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralAssetType, _that.getCollateralAssetType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralTaxonomy, _that.getCollateralTaxonomy())) {
                return false;
            }
            if (!ListEquals.listEquals(this.denominatedCurrency, _that.getDenominatedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.domesticCurrencyIssued, _that.getDomesticCurrencyIssued())) {
                return false;
            }
            if (!Objects.equals(this.listing, _that.getListing())) {
                return false;
            }
            if (!Objects.equals(this.maturityRange, _that.getMaturityRange())) {
                return false;
            }
            if (!Objects.equals((Object)this.maturityType, (Object)_that.getMaturityType())) {
                return false;
            }
            return ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agencyRating != null ? this.agencyRating.hashCode() : 0);
            _result = 31 * _result + (this.assetCountryOfOrigin != null ? this.assetCountryOfOrigin.hashCode() : 0);
            _result = 31 * _result + (this.collateralAssetType != null ? this.collateralAssetType.hashCode() : 0);
            _result = 31 * _result + (this.collateralTaxonomy != null ? this.collateralTaxonomy.hashCode() : 0);
            _result = 31 * _result + (this.denominatedCurrency != null ? this.denominatedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.domesticCurrencyIssued != null ? this.domesticCurrencyIssued.hashCode() : 0);
            _result = 31 * _result + (this.listing != null ? this.listing.hashCode() : 0);
            _result = 31 * _result + (this.maturityRange != null ? this.maturityRange.hashCode() : 0);
            _result = 31 * _result + (this.maturityType != null ? ((Object)((Object)this.maturityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetCriteria {agencyRating=" + this.agencyRating + ", assetCountryOfOrigin=" + this.assetCountryOfOrigin + ", collateralAssetType=" + this.collateralAssetType + ", collateralTaxonomy=" + this.collateralTaxonomy + ", denominatedCurrency=" + this.denominatedCurrency + ", domesticCurrencyIssued=" + this.domesticCurrencyIssued + ", listing=" + this.listing + ", maturityRange=" + this.maturityRange + ", maturityType=" + (Object)((Object)this.maturityType) + ", productIdentifier=" + this.productIdentifier + '}';
        }
    }

    public static interface AssetCriteriaBuilder
    extends AssetCriteria,
    RosettaModelObjectBuilder {
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateAgencyRating(int var1);

        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getAgencyRating();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAssetCountryOfOrigin(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getAssetCountryOfOrigin();

        public AssetType.AssetTypeBuilder getOrCreateCollateralAssetType(int var1);

        public List<? extends AssetType.AssetTypeBuilder> getCollateralAssetType();

        public CollateralTaxonomy.CollateralTaxonomyBuilder getOrCreateCollateralTaxonomy(int var1);

        public List<? extends CollateralTaxonomy.CollateralTaxonomyBuilder> getCollateralTaxonomy();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateDenominatedCurrency(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getDenominatedCurrency();

        public ListingType.ListingTypeBuilder getOrCreateListing();

        @Override
        public ListingType.ListingTypeBuilder getListing();

        public PeriodRange.PeriodRangeBuilder getOrCreateMaturityRange();

        @Override
        public PeriodRange.PeriodRangeBuilder getMaturityRange();

        public ProductIdentifier.ProductIdentifierBuilder getOrCreateProductIdentifier(int var1);

        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getProductIdentifier();

        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria var1);

        public AssetCriteriaBuilder addAgencyRating(AgencyRatingCriteria var1, int var2);

        public AssetCriteriaBuilder addAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public AssetCriteriaBuilder setAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public AssetCriteriaBuilder addAssetCountryOfOrigin(FieldWithMetaString var1);

        public AssetCriteriaBuilder addAssetCountryOfOrigin(FieldWithMetaString var1, int var2);

        public AssetCriteriaBuilder addAssetCountryOfOriginValue(String var1);

        public AssetCriteriaBuilder addAssetCountryOfOriginValue(String var1, int var2);

        public AssetCriteriaBuilder addAssetCountryOfOrigin(List<? extends FieldWithMetaString> var1);

        public AssetCriteriaBuilder setAssetCountryOfOrigin(List<? extends FieldWithMetaString> var1);

        public AssetCriteriaBuilder addAssetCountryOfOriginValue(List<? extends String> var1);

        public AssetCriteriaBuilder setAssetCountryOfOriginValue(List<? extends String> var1);

        public AssetCriteriaBuilder addCollateralAssetType(AssetType var1);

        public AssetCriteriaBuilder addCollateralAssetType(AssetType var1, int var2);

        public AssetCriteriaBuilder addCollateralAssetType(List<? extends AssetType> var1);

        public AssetCriteriaBuilder setCollateralAssetType(List<? extends AssetType> var1);

        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy var1);

        public AssetCriteriaBuilder addCollateralTaxonomy(CollateralTaxonomy var1, int var2);

        public AssetCriteriaBuilder addCollateralTaxonomy(List<? extends CollateralTaxonomy> var1);

        public AssetCriteriaBuilder setCollateralTaxonomy(List<? extends CollateralTaxonomy> var1);

        public AssetCriteriaBuilder addDenominatedCurrency(FieldWithMetaString var1);

        public AssetCriteriaBuilder addDenominatedCurrency(FieldWithMetaString var1, int var2);

        public AssetCriteriaBuilder addDenominatedCurrencyValue(String var1);

        public AssetCriteriaBuilder addDenominatedCurrencyValue(String var1, int var2);

        public AssetCriteriaBuilder addDenominatedCurrency(List<? extends FieldWithMetaString> var1);

        public AssetCriteriaBuilder setDenominatedCurrency(List<? extends FieldWithMetaString> var1);

        public AssetCriteriaBuilder addDenominatedCurrencyValue(List<? extends String> var1);

        public AssetCriteriaBuilder setDenominatedCurrencyValue(List<? extends String> var1);

        public AssetCriteriaBuilder setDomesticCurrencyIssued(Boolean var1);

        public AssetCriteriaBuilder setListing(ListingType var1);

        public AssetCriteriaBuilder setMaturityRange(PeriodRange var1);

        public AssetCriteriaBuilder setMaturityType(MaturityTypeEnum var1);

        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier var1);

        public AssetCriteriaBuilder addProductIdentifier(ProductIdentifier var1, int var2);

        public AssetCriteriaBuilder addProductIdentifier(List<? extends ProductIdentifier> var1);

        public AssetCriteriaBuilder setProductIdentifier(List<? extends ProductIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("domesticCurrencyIssued"), Boolean.class, (Object)this.getDomesticCurrencyIssued(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityType"), MaturityTypeEnum.class, (Object)this.getMaturityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agencyRating"), processor, AgencyRatingCriteria.AgencyRatingCriteriaBuilder.class, this.getAgencyRating(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetCountryOfOrigin"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getAssetCountryOfOrigin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralAssetType"), processor, AssetType.AssetTypeBuilder.class, this.getCollateralAssetType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralTaxonomy"), processor, CollateralTaxonomy.CollateralTaxonomyBuilder.class, this.getCollateralTaxonomy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("denominatedCurrency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getDenominatedCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("listing"), processor, ListingType.ListingTypeBuilder.class, this.getListing(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maturityRange"), processor, PeriodRange.PeriodRangeBuilder.class, this.getMaturityRange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, ProductIdentifier.ProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
        }

        public AssetCriteriaBuilder prune();
    }
}

