/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.ReferencePool;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ReferencePoolFpML_cd_44_basketPercentage")
@ImplementedBy(value=Default.class)
public interface ReferencePoolFpMLCd44BasketPercentage
extends Validator<ReferencePool> {
    public static final String NAME = "ReferencePoolFpML_cd_44_basketPercentage";
    public static final String DEFINITION = "if referencePoolItem -> constituentWeight -> basketPercentage exists then referencePoolItem -> constituentWeight -> openUnits is absent";

    public ValidationResult<ReferencePool> validate(RosettaPath var1, ReferencePool var2);

    public static class NoOp
    implements ReferencePoolFpMLCd44BasketPercentage {
        @Override
        public ValidationResult<ReferencePool> validate(RosettaPath path, ReferencePool referencePool) {
            return ValidationResult.success((String)ReferencePoolFpMLCd44BasketPercentage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferencePool", (RosettaPath)path, (String)ReferencePoolFpMLCd44BasketPercentage.DEFINITION);
        }
    }

    public static class Default
    implements ReferencePoolFpMLCd44BasketPercentage {
        @Override
        public ValidationResult<ReferencePool> validate(RosettaPath path, ReferencePool referencePool) {
            ComparisonResult result = this.executeDataRule(referencePool);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ReferencePoolFpMLCd44BasketPercentage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferencePool", (RosettaPath)path, (String)ReferencePoolFpMLCd44BasketPercentage.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ReferencePoolFpML_cd_44_basketPercentage failed.";
            }
            return ValidationResult.failure((String)ReferencePoolFpMLCd44BasketPercentage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferencePool", (RosettaPath)path, (String)ReferencePoolFpMLCd44BasketPercentage.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ReferencePool referencePool) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)referencePool).mapC("getReferencePoolItem", _referencePool -> _referencePool.getReferencePoolItem()).map("getConstituentWeight", referencePoolItem -> referencePoolItem.getConstituentWeight()).map("getBasketPercentage", constituentWeight -> constituentWeight.getBasketPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)referencePool).mapC("getReferencePoolItem", _referencePool -> _referencePool.getReferencePoolItem()).map("getConstituentWeight", referencePoolItem -> referencePoolItem.getConstituentWeight()).map("getOpenUnits", constituentWeight -> constituentWeight.getOpenUnits()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

