/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.functions;

import cdm.event.common.functions.AdjustedValuationDates;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.ValuationDates;
import cdm.product.asset.PriceReturnTerms;
import cdm.product.asset.functions.ResolveEquityInitialPrice;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=ResolvePerformancePeriodStartPriceDefault.class)
public abstract class ResolvePerformancePeriodStartPrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AdjustedValuationDates adjustedValuationDates0;
    @Inject
    protected ResolveEquityInitialPrice resolveEquityInitialPrice;

    public PriceSchedule evaluate(PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
        PriceSchedule.PriceScheduleBuilder startPrice = this.doEvaluate(performancePayout, price, observable, adjustedDate);
        if (startPrice != null) {
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)startPrice);
        }
        return startPrice;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(PerformancePayout var1, List<? extends PriceSchedule> var2, Observable var3, Date var4);

    protected abstract Mapper<? extends PriceReturnTerms> priceReturnTerms(PerformancePayout var1, List<? extends PriceSchedule> var2, Observable var3, Date var4);

    protected abstract Mapper<Date> adjustedValuationDates1(PerformancePayout var1, List<? extends PriceSchedule> var2, Observable var3, Date var4);

    public static class ResolvePerformancePeriodStartPriceDefault
    extends ResolvePerformancePeriodStartPrice {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
            PriceSchedule.PriceScheduleBuilder startPrice = PriceSchedule.builder();
            return this.assignOutput(startPrice, performancePayout, price, observable, adjustedDate);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder startPrice, PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
            startPrice = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.lessThan((Mapper)MapperS.of((Object)adjustedDate), (Mapper)MapperC.of((List)this.adjustedValuationDates1(performancePayout, price, observable, adjustedDate).getMulti()).first(), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((PriceReturnTerms)this.priceReturnTerms(performancePayout, price, observable, adjustedDate).get())).map("getValuationPriceInitial", _priceReturnTerms -> _priceReturnTerms.getValuationPriceInitial());
                }
                return MapperS.of((Object)this.resolveEquityInitialPrice.evaluate(MapperC.of((List)price).getMulti()));
            }).get());
            return Optional.ofNullable(startPrice).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends PriceReturnTerms> priceReturnTerms(PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
            return MapperS.of((Object)performancePayout).map("getReturnTerms", _performancePayout -> _performancePayout.getReturnTerms()).map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms());
        }

        @Override
        protected Mapper<Date> adjustedValuationDates1(PerformancePayout performancePayout, List<? extends PriceSchedule> price, Observable observable, Date adjustedDate) {
            return MapperC.of(this.adjustedValuationDates0.evaluate((ValuationDates)MapperS.of((Object)performancePayout).map("getValuationDates", _performancePayout -> _performancePayout.getValuationDates()).get()));
        }
    }
}

