/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.calculatedrate.CalculationMethodEnum;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.functions.EvaluateCalculatedRate;
import cdm.product.asset.FloatingRate;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.Create_CalculationPeriodBase;
import cdm.product.asset.floatingrate.FloatingRateIndexProcessingTypeEnum;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.EvaluateScreenRate;
import cdm.product.asset.floatingrate.functions.GetCalculatedFROCalculationParameters;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.CalculationPeriodData;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.ResetDates;
import cdm.product.common.schedule.functions.CalculationPeriod;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;

public class ProcessFloatingRateReset {
    @Inject
    protected screen_ screen_;
    @Inject
    protected modular_ modular_;
    @Inject
    protected oIS_ oIS_;
    @Inject
    protected overnightAvg_ overnightAvg_;
    @Inject
    protected compoundIndex_ compoundIndex_;

    public FloatingRateSettingDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
        switch (processingType) {
            case SCREEN: {
                return this.screen_.evaluate(interestRatePayout, calcPeriod, processingType);
            }
            case MODULAR: {
                return this.modular_.evaluate(interestRatePayout, calcPeriod, processingType);
            }
            case OIS: {
                return this.oIS_.evaluate(interestRatePayout, calcPeriod, processingType);
            }
            case OVERNIGHT_AVG: {
                return this.overnightAvg_.evaluate(interestRatePayout, calcPeriod, processingType);
            }
            case COMPOUND_INDEX: {
                return this.compoundIndex_.evaluate(interestRatePayout, calcPeriod, processingType);
            }
        }
        throw new IllegalArgumentException("Enum value not implemented: " + (Object)((Object)processingType));
    }

    @ImplementedBy(value=compoundIndex_Default.class)
    public static abstract class compoundIndex_
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;

        public FloatingRateSettingDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = this.doEvaluate(interestRatePayout, calcPeriod, processingType);
            if (floatingRate != null) {
                this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)floatingRate);
            }
            return floatingRate;
        }

        protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        public static class compoundIndex_Default
        extends compoundIndex_ {
            @Override
            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = FloatingRateSettingDetails.builder();
                return this.assignOutput(floatingRate, interestRatePayout, calcPeriod, processingType);
            }

            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate, InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return Optional.ofNullable(floatingRate).map(o -> o.prune()).orElse(null);
            }
        }
    }

    @ImplementedBy(value=overnightAvg_Default.class)
    public static abstract class overnightAvg_
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;
        @Inject
        protected EvaluateCalculatedRate evaluateCalculatedRate;
        @Inject
        protected GetCalculatedFROCalculationParameters getCalculatedFROCalculationParameters;

        public FloatingRateSettingDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = this.doEvaluate(interestRatePayout, calcPeriod, processingType);
            if (floatingRate != null) {
                this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)floatingRate);
            }
            return floatingRate;
        }

        protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends ResetDates> resetDates(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<DayCountFractionEnum> dayCount(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateOption> rateOption(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateCalculationParameters> calcParams(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        public static class overnightAvg_Default
        extends overnightAvg_ {
            @Override
            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = FloatingRateSettingDetails.builder();
                return this.assignOutput(floatingRate, interestRatePayout, calcPeriod, processingType);
            }

            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate, InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                floatingRate = (FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.evaluateCalculatedRate.evaluate((FloatingRateOption)MapperS.of((Object)((FloatingRateOption)this.rateOption(interestRatePayout, calcPeriod, processingType).get())).get(), (FloatingRateCalculationParameters)MapperS.of((Object)((FloatingRateCalculationParameters)this.calcParams(interestRatePayout, calcPeriod, processingType).get())).get(), (ResetDates)MapperS.of((Object)((ResetDates)this.resetDates(interestRatePayout, calcPeriod, processingType).get())).get(), (CalculationPeriodBase)MapperS.of((Object)calcPeriod).get(), (CalculationPeriodBase)MapperS.of((Object)calcPeriod).get(), (DayCountFractionEnum)((Object)MapperS.of((Object)((Object)((DayCountFractionEnum)((Object)this.dayCount(interestRatePayout, calcPeriod, processingType).get())))).get()))).get());
                return Optional.ofNullable(floatingRate).map(o -> o.prune()).orElse(null);
            }

            @Override
            protected Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate());
            }

            @Override
            protected Mapper<? extends ResetDates> resetDates(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getResetDates", _interestRatePayout -> _interestRatePayout.getResetDates());
            }

            @Override
            protected Mapper<DayCountFractionEnum> dayCount(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getDayCountFraction", _interestRatePayout -> _interestRatePayout.getDayCountFraction()).map("getValue", _f -> _f.getValue());
            }

            @Override
            protected Mapper<? extends FloatingRateOption> rateOption(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)((FloatingRateSpecification)this.rateDef(interestRatePayout, calcPeriod, processingType).get())).map("getRateOption", floatingRateBase -> floatingRateBase.getRateOption()).map("getValue", _f -> _f.getValue());
            }

            @Override
            protected Mapper<? extends FloatingRateCalculationParameters> calcParams(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)this.getCalculatedFROCalculationParameters.evaluate((ResetDates)MapperS.of((Object)((ResetDates)this.resetDates(interestRatePayout, calcPeriod, processingType).get())).get(), (CalculationMethodEnum)((Object)MapperS.of((Object)((Object)CalculationMethodEnum.AVERAGING)).get())));
            }
        }
    }

    @ImplementedBy(value=oIS_Default.class)
    public static abstract class oIS_
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;
        @Inject
        protected EvaluateCalculatedRate evaluateCalculatedRate;
        @Inject
        protected GetCalculatedFROCalculationParameters getCalculatedFROCalculationParameters;

        public FloatingRateSettingDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = this.doEvaluate(interestRatePayout, calcPeriod, processingType);
            if (floatingRate != null) {
                this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)floatingRate);
            }
            return floatingRate;
        }

        protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends ResetDates> resetDates(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<DayCountFractionEnum> dayCount(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateOption> fro(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateCalculationParameters> calcParams(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        public static class oIS_Default
        extends oIS_ {
            @Override
            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = FloatingRateSettingDetails.builder();
                return this.assignOutput(floatingRate, interestRatePayout, calcPeriod, processingType);
            }

            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate, InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                floatingRate = (FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.evaluateCalculatedRate.evaluate((FloatingRateOption)MapperS.of((Object)((FloatingRateOption)this.fro(interestRatePayout, calcPeriod, processingType).get())).get(), (FloatingRateCalculationParameters)MapperS.of((Object)((FloatingRateCalculationParameters)this.calcParams(interestRatePayout, calcPeriod, processingType).get())).get(), (ResetDates)MapperS.of((Object)((ResetDates)this.resetDates(interestRatePayout, calcPeriod, processingType).get())).get(), (CalculationPeriodBase)MapperS.of((Object)calcPeriod).get(), (CalculationPeriodBase)MapperS.of((Object)calcPeriod).get(), (DayCountFractionEnum)((Object)MapperS.of((Object)((Object)((DayCountFractionEnum)((Object)this.dayCount(interestRatePayout, calcPeriod, processingType).get())))).get()))).get());
                return Optional.ofNullable(floatingRate).map(o -> o.prune()).orElse(null);
            }

            @Override
            protected Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate());
            }

            @Override
            protected Mapper<? extends ResetDates> resetDates(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getResetDates", _interestRatePayout -> _interestRatePayout.getResetDates());
            }

            @Override
            protected Mapper<DayCountFractionEnum> dayCount(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getDayCountFraction", _interestRatePayout -> _interestRatePayout.getDayCountFraction()).map("getValue", _f -> _f.getValue());
            }

            @Override
            protected Mapper<? extends FloatingRateOption> fro(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)((FloatingRateSpecification)this.rateDef(interestRatePayout, calcPeriod, processingType).get())).map("getRateOption", floatingRateBase -> floatingRateBase.getRateOption()).map("getValue", _f -> _f.getValue());
            }

            @Override
            protected Mapper<? extends FloatingRateCalculationParameters> calcParams(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)this.getCalculatedFROCalculationParameters.evaluate((ResetDates)MapperS.of((Object)((ResetDates)this.resetDates(interestRatePayout, calcPeriod, processingType).get())).get(), (CalculationMethodEnum)((Object)MapperS.of((Object)((Object)CalculationMethodEnum.COMPOUNDING)).get())));
            }
        }
    }

    @ImplementedBy(value=modular_Default.class)
    public static abstract class modular_
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;
        @Inject
        protected CalculationPeriod calculationPeriod;
        @Inject
        protected Create_CalculationPeriodBase create_CalculationPeriodBase;
        @Inject
        protected EvaluateCalculatedRate evaluateCalculatedRate;

        public FloatingRateSettingDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = this.doEvaluate(interestRatePayout, calcPeriod, processingType);
            if (floatingRate != null) {
                this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)floatingRate);
            }
            return floatingRate;
        }

        protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends ResetDates> resetDates(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<DayCountFractionEnum> dayCount(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateOption> fro(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateCalculationParameters> calcParams(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends CalculationPeriodBase> priorCalculationPeriod(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        public static class modular_Default
        extends modular_ {
            @Override
            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = FloatingRateSettingDetails.builder();
                return this.assignOutput(floatingRate, interestRatePayout, calcPeriod, processingType);
            }

            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate, InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                floatingRate = (FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.evaluateCalculatedRate.evaluate((FloatingRateOption)MapperS.of((Object)((FloatingRateOption)this.fro(interestRatePayout, calcPeriod, processingType).get())).get(), (FloatingRateCalculationParameters)MapperS.of((Object)((FloatingRateCalculationParameters)this.calcParams(interestRatePayout, calcPeriod, processingType).get())).get(), (ResetDates)MapperS.of((Object)((ResetDates)this.resetDates(interestRatePayout, calcPeriod, processingType).get())).get(), (CalculationPeriodBase)MapperS.of((Object)calcPeriod).get(), (CalculationPeriodBase)MapperS.of((Object)((CalculationPeriodBase)this.priorCalculationPeriod(interestRatePayout, calcPeriod, processingType).get())).get(), (DayCountFractionEnum)((Object)MapperS.of((Object)((Object)((DayCountFractionEnum)((Object)this.dayCount(interestRatePayout, calcPeriod, processingType).get())))).get()))).get());
                return Optional.ofNullable(floatingRate).map(o -> o.prune()).orElse(null);
            }

            @Override
            protected Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate());
            }

            @Override
            protected Mapper<? extends ResetDates> resetDates(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getResetDates", _interestRatePayout -> _interestRatePayout.getResetDates());
            }

            @Override
            protected Mapper<DayCountFractionEnum> dayCount(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getDayCountFraction", _interestRatePayout -> _interestRatePayout.getDayCountFraction()).map("getValue", _f -> _f.getValue());
            }

            @Override
            protected Mapper<? extends FloatingRateOption> fro(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)((FloatingRateSpecification)this.rateDef(interestRatePayout, calcPeriod, processingType).get())).map("getRateOption", floatingRateBase -> floatingRateBase.getRateOption()).map("getValue", _f -> _f.getValue());
            }

            @Override
            protected Mapper<? extends FloatingRateCalculationParameters> calcParams(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)((FloatingRateSpecification)this.rateDef(interestRatePayout, calcPeriod, processingType).get())).map("getCalculationParameters", floatingRate -> floatingRate.getCalculationParameters());
            }

            @Override
            protected Mapper<? extends CalculationPeriodBase> priorCalculationPeriod(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)this.create_CalculationPeriodBase.evaluate((CalculationPeriodData)MapperS.of((Object)this.calculationPeriod.evaluate((CalculationPeriodDates)MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).get(), (Date)MapperS.of((Object)calcPeriod).map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate()).get())).get()));
            }
        }
    }

    @ImplementedBy(value=screen_Default.class)
    public static abstract class screen_
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;
        @Inject
        protected EvaluateScreenRate evaluateScreenRate;

        public FloatingRateSettingDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = this.doEvaluate(interestRatePayout, calcPeriod, processingType);
            if (floatingRate != null) {
                this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)floatingRate);
            }
            return floatingRate;
        }

        protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends ResetDates> resetDates(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        protected abstract Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout var1, CalculationPeriodBase var2, FloatingRateIndexProcessingTypeEnum var3);

        public static class screen_Default
        extends screen_ {
            @Override
            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = FloatingRateSettingDetails.builder();
                return this.assignOutput(floatingRate, interestRatePayout, calcPeriod, processingType);
            }

            protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate, InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                floatingRate = (FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.evaluateScreenRate.evaluate((FloatingRate)MapperS.of((Object)((FloatingRateSpecification)this.rateDef(interestRatePayout, calcPeriod, processingType).get())).get(), (ResetDates)MapperS.of((Object)((ResetDates)this.resetDates(interestRatePayout, calcPeriod, processingType).get())).get(), (CalculationPeriodBase)MapperS.of((Object)calcPeriod).get())).get());
                return Optional.ofNullable(floatingRate).map(o -> o.prune()).orElse(null);
            }

            @Override
            protected Mapper<? extends ResetDates> resetDates(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getResetDates", _interestRatePayout -> _interestRatePayout.getResetDates());
            }

            @Override
            protected Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod, FloatingRateIndexProcessingTypeEnum processingType) {
                return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate());
            }
        }
    }
}

