/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.observable.asset.fro.FloatingRateIndexCalculationDefaults;
import cdm.observable.asset.fro.FloatingRateIndexCalculationMethodEnum;
import cdm.observable.asset.fro.FloatingRateIndexCategoryEnum;
import cdm.observable.asset.fro.FloatingRateIndexDefinition;
import cdm.observable.asset.fro.FloatingRateIndexStyleEnum;
import cdm.observable.asset.fro.functions.FloatingRateIndexMetadata;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.floatingrate.FloatingRateIndexProcessingTypeEnum;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;

@ImplementedBy(value=GetFloatingRateProcessingTypeDefault.class)
public abstract class GetFloatingRateProcessingType
implements RosettaFunction {
    @Inject
    protected FloatingRateIndexMetadata floatingRateIndexMetadata;

    public FloatingRateIndexProcessingTypeEnum evaluate(FloatingRateSpecification rateDef) {
        FloatingRateIndexProcessingTypeEnum processingType = this.doEvaluate(rateDef);
        return processingType;
    }

    protected abstract FloatingRateIndexProcessingTypeEnum doEvaluate(FloatingRateSpecification var1);

    protected abstract Mapper<Boolean> isCalculatedRate(FloatingRateSpecification var1);

    protected abstract Mapper<? extends FloatingRateIndexDefinition> floatingRateDefinition(FloatingRateSpecification var1);

    protected abstract Mapper<? extends FloatingRateIndexCalculationDefaults> calcDefaults(FloatingRateSpecification var1);

    protected abstract Mapper<FloatingRateIndexCategoryEnum> category(FloatingRateSpecification var1);

    protected abstract Mapper<FloatingRateIndexStyleEnum> idxStyle(FloatingRateSpecification var1);

    protected abstract Mapper<FloatingRateIndexCalculationMethodEnum> method(FloatingRateSpecification var1);

    protected abstract Mapper<FloatingRateIndexProcessingTypeEnum> calcProcessingType(FloatingRateSpecification var1);

    protected abstract Mapper<FloatingRateIndexProcessingTypeEnum> definitionProcessingType(FloatingRateSpecification var1);

    protected abstract Mapper<FloatingRateIndexProcessingTypeEnum> processingCategory(FloatingRateSpecification var1);

    public static class GetFloatingRateProcessingTypeDefault
    extends GetFloatingRateProcessingType {
        @Override
        protected FloatingRateIndexProcessingTypeEnum doEvaluate(FloatingRateSpecification rateDef) {
            FloatingRateIndexProcessingTypeEnum processingType = null;
            return this.assignOutput(processingType, rateDef);
        }

        protected FloatingRateIndexProcessingTypeEnum assignOutput(FloatingRateIndexProcessingTypeEnum processingType, FloatingRateSpecification rateDef) {
            processingType = (FloatingRateIndexProcessingTypeEnum)((Object)MapperS.of((Object)((Object)((FloatingRateIndexProcessingTypeEnum)((Object)this.processingCategory(rateDef).get())))).get());
            return processingType;
        }

        @Override
        protected Mapper<Boolean> isCalculatedRate(FloatingRateSpecification rateDef) {
            return ExpressionOperators.exists((Mapper)MapperS.of((Object)rateDef).map("getCalculationParameters", floatingRate -> floatingRate.getCalculationParameters()));
        }

        @Override
        protected Mapper<? extends FloatingRateIndexDefinition> floatingRateDefinition(FloatingRateSpecification rateDef) {
            return MapperS.of((Object)this.floatingRateIndexMetadata.evaluate((FloatingRateIndexEnum)((Object)MapperS.of((Object)rateDef).map("getRateOption", floatingRateBase -> floatingRateBase.getRateOption()).map("getValue", _f -> _f.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex()).map("getValue", _f -> _f.getValue()).get())));
        }

        @Override
        protected Mapper<? extends FloatingRateIndexCalculationDefaults> calcDefaults(FloatingRateSpecification rateDef) {
            return MapperS.of((Object)((FloatingRateIndexDefinition)this.floatingRateDefinition(rateDef).get())).map("getCalculationDefaults", floatingRateIndexDefinition -> floatingRateIndexDefinition.getCalculationDefaults());
        }

        @Override
        protected Mapper<FloatingRateIndexCategoryEnum> category(FloatingRateSpecification rateDef) {
            return MapperS.of((Object)((FloatingRateIndexCalculationDefaults)this.calcDefaults(rateDef).get())).map("getCategory", floatingRateIndexCalculationDefaults -> floatingRateIndexCalculationDefaults.getCategory());
        }

        @Override
        protected Mapper<FloatingRateIndexStyleEnum> idxStyle(FloatingRateSpecification rateDef) {
            return MapperS.of((Object)((FloatingRateIndexCalculationDefaults)this.calcDefaults(rateDef).get())).map("getIndexStyle", floatingRateIndexCalculationDefaults -> floatingRateIndexCalculationDefaults.getIndexStyle());
        }

        @Override
        protected Mapper<FloatingRateIndexCalculationMethodEnum> method(FloatingRateSpecification rateDef) {
            return MapperS.of((Object)((FloatingRateIndexCalculationDefaults)this.calcDefaults(rateDef).get())).map("getMethod", floatingRateIndexCalculationDefaults -> floatingRateIndexCalculationDefaults.getMethod());
        }

        @Override
        protected Mapper<FloatingRateIndexProcessingTypeEnum> calcProcessingType(FloatingRateSpecification rateDef) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((FloatingRateIndexStyleEnum)((Object)((Object)this.idxStyle(rateDef).get()))))), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexStyleEnum.COMPOUNDED_FRO)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((FloatingRateIndexCalculationMethodEnum)((Object)((Object)this.method(rateDef).get()))))), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexCalculationMethodEnum.OIS_COMPOUND)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.OIS));
                }
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((FloatingRateIndexStyleEnum)((Object)((Object)this.idxStyle(rateDef).get()))))), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexStyleEnum.AVERAGE_FRO)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((FloatingRateIndexCalculationMethodEnum)((Object)((Object)this.method(rateDef).get()))))), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexCalculationMethodEnum.AVERAGE)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.OVERNIGHT_AVG));
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected Mapper<FloatingRateIndexProcessingTypeEnum> definitionProcessingType(FloatingRateSpecification rateDef) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((FloatingRateIndexCategoryEnum)((Object)((Object)this.category(rateDef).get()))))), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexCategoryEnum.SCREEN_RATE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.SCREEN));
                }
                return MapperS.of((Object)((Object)((FloatingRateIndexProcessingTypeEnum)((Object)((Object)this.calcProcessingType(rateDef).get())))));
            });
        }

        @Override
        protected Mapper<FloatingRateIndexProcessingTypeEnum> processingCategory(FloatingRateSpecification rateDef) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.isCalculatedRate(rateDef).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.MODULAR));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((FloatingRateIndexDefinition)this.floatingRateDefinition(rateDef).get())).map("getFro", floatingRateIndexDefinition -> floatingRateIndexDefinition.getFro())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)((FloatingRateIndexProcessingTypeEnum)((Object)((Object)this.definitionProcessingType(rateDef).get())))));
                }
                return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.SCREEN));
            });
        }
    }
}

