/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.fro.functions.IndexValueObservation;
import cdm.product.asset.FloatingRate;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.DetermineFixingDate;
import cdm.product.asset.floatingrate.functions.DetermineResetDate;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.ResetDates;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=EvaluateScreenRateDefault.class)
public abstract class EvaluateScreenRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected DetermineFixingDate determineFixingDate;
    @Inject
    protected DetermineResetDate determineResetDate;
    @Inject
    protected IndexValueObservation indexValueObservation;

    public FloatingRateSettingDetails evaluate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
        FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder details = this.doEvaluate(rateDef, resetDates, calculationPeriod);
        if (details != null) {
            this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)details);
        }
        return details;
    }

    protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    protected abstract Mapper<Date> resetDate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    protected abstract Mapper<Date> fixingDate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    protected abstract Mapper<BigDecimal> observedRate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    public static class EvaluateScreenRateDefault
    extends EvaluateScreenRate {
        @Override
        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder details = FloatingRateSettingDetails.builder();
            return this.assignOutput(details, rateDef, resetDates, calculationPeriod);
        }

        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder details, FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            details.setResetDate((Date)MapperS.of((Object)((Date)this.resetDate(rateDef, resetDates, calculationPeriod).get())).get());
            details.setObservationDate((Date)MapperS.of((Object)((Date)this.fixingDate(rateDef, resetDates, calculationPeriod).get())).get());
            details.setFloatingRate((BigDecimal)MapperS.of((Object)((BigDecimal)this.observedRate(rateDef, resetDates, calculationPeriod).get())).get());
            return Optional.ofNullable(details).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<Date> resetDate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.determineResetDate.evaluate((ResetDates)MapperS.of((Object)resetDates).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<Date> fixingDate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.determineFixingDate.evaluate((ResetDates)MapperS.of((Object)resetDates).get(), (Date)MapperS.of((Object)((Date)this.resetDate(rateDef, resetDates, calculationPeriod).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> observedRate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.indexValueObservation.evaluate((Date)MapperS.of((Object)((Date)this.fixingDate(rateDef, resetDates, calculationPeriod).get())).get(), (FloatingRateOption)MapperS.of((Object)rateDef).map("getRateOption", floatingRateBase -> floatingRateBase.getRateOption()).map("getValue", _f -> _f.getValue()).get()));
        }
    }
}

