/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.floatingrate.FloatingRateIndexProcessingTypeEnum;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.GetFloatingRateProcessingType;
import cdm.product.asset.floatingrate.functions.ProcessFloatingRateReset;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;

@ImplementedBy(value=DetermineFloatingRateResetDefault.class)
public abstract class DetermineFloatingRateReset
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetFloatingRateProcessingType getFloatingRateProcessingType;
    @Inject
    protected ProcessFloatingRateReset processFloatingRateReset;

    public FloatingRateSettingDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod) {
        FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = this.doEvaluate(interestRatePayout, calcPeriod);
        if (floatingRate != null) {
            this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)floatingRate);
        }
        return floatingRate;
    }

    protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract Mapper<FloatingRateIndexProcessingTypeEnum> processingType(InterestRatePayout var1, CalculationPeriodBase var2);

    public static class DetermineFloatingRateResetDefault
    extends DetermineFloatingRateReset {
        @Override
        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate = FloatingRateSettingDetails.builder();
            return this.assignOutput(floatingRate, interestRatePayout, calcPeriod);
        }

        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder floatingRate, InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod) {
            floatingRate = (FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.processFloatingRateReset.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calcPeriod).get(), (FloatingRateIndexProcessingTypeEnum)((Object)MapperS.of((Object)((Object)((FloatingRateIndexProcessingTypeEnum)((Object)this.processingType(interestRatePayout, calcPeriod).get())))).get()))).get());
            return Optional.ofNullable(floatingRate).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends FloatingRateSpecification> rateDef(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate());
        }

        @Override
        protected Mapper<FloatingRateIndexProcessingTypeEnum> processingType(InterestRatePayout interestRatePayout, CalculationPeriodBase calcPeriod) {
            return MapperS.of((Object)((Object)this.getFloatingRateProcessingType.evaluate((FloatingRateSpecification)MapperS.of((Object)((FloatingRateSpecification)this.rateDef(interestRatePayout, calcPeriod).get())).get())));
        }
    }
}

