/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.math.functions.Max;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.functions.ApplyFloatingRatePostSpreadProcessing;
import cdm.product.asset.floatingrate.functions.ApplyUSRateTreatment;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=ApplyFloatingRateProcessingDefault.class)
public abstract class ApplyFloatingRateProcessing
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyFloatingRatePostSpreadProcessing applyFloatingRatePostSpreadProcessing;
    @Inject
    protected ApplyUSRateTreatment applyUSRateTreatment;
    @Inject
    protected Max max;

    public FloatingRateProcessingDetails evaluate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
        FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder details = this.doEvaluate(processing, rawRate, calculationPeriod, isInitialPeriod);
        if (details != null) {
            this.objectValidator.validate(FloatingRateProcessingDetails.class, (RosettaModelObject)details);
        }
        return details;
    }

    protected abstract FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> multiplier(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> multiplied(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> multipliedRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> treatedRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<NegativeInterestRateTreatmentEnum> negativeTreatment(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> negativeTreatedRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> spreadRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> added(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> ratePlusSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> negativeTreatedRatePlusSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<Boolean> doInitialRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> initialRate(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> initialRatePluSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    protected abstract Mapper<BigDecimal> initialRatePlusSpread(FloatingRateProcessingParameters var1, BigDecimal var2, CalculationPeriodBase var3, Boolean var4);

    public static class ApplyFloatingRateProcessingDefault
    extends ApplyFloatingRateProcessing {
        @Override
        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder details = FloatingRateProcessingDetails.builder();
            return this.assignOutput(details, processing, rawRate, calculationPeriod, isInitialPeriod);
        }

        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder assignOutput(FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder details, FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            details.setProcessingParameters((FloatingRateProcessingParameters)MapperS.of((Object)processing).get());
            details.setRawRate((BigDecimal)MapperS.of((Object)rawRate).get());
            details.setProcessedRate((BigDecimal)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.doInitialRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.initialRatePluSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
                }
                return MapperS.of((Object)this.applyFloatingRatePostSpreadProcessing.evaluate((BigDecimal)MapperS.of((Object)((BigDecimal)this.ratePlusSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get())).get(), (FloatingRateProcessingParameters)MapperS.of((Object)processing).get()));
            }).get());
            details.setSpreadExclusiveRate((BigDecimal)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Boolean)this.doInitialRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.initialRate(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
                }
                return MapperS.of((Object)this.applyFloatingRatePostSpreadProcessing.evaluate((BigDecimal)MapperS.of((Object)((BigDecimal)this.negativeTreatedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())).get(), (FloatingRateProcessingParameters)MapperS.of((Object)processing).get()));
            }).get());
            return Optional.ofNullable(details).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> multiplier(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getMultiplier", floatingRateProcessingParameters -> floatingRateProcessingParameters.getMultiplier());
        }

        @Override
        protected Mapper<BigDecimal> multiplied(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)rawRate), (Mapper)MapperS.of((Object)((BigDecimal)this.multiplier(processing, rawRate, calculationPeriod, isInitialPeriod).get())));
        }

        @Override
        protected Mapper<BigDecimal> multipliedRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.multiplier(processing, rawRate, calculationPeriod, isInitialPeriod).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.multiplied(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
                }
                return MapperS.of((Object)rawRate);
            });
        }

        @Override
        protected Mapper<BigDecimal> treatedRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)this.applyUSRateTreatment.evaluate((BigDecimal)MapperS.of((Object)((BigDecimal)this.multipliedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())).get(), (RateTreatmentEnum)((Object)MapperS.of((Object)processing).map("getTreatment", floatingRateProcessingParameters -> floatingRateProcessingParameters.getTreatment()).get()), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get())), (Mapper)MapperS.of((Object)new BigDecimal("1.0")));
        }

        @Override
        protected Mapper<NegativeInterestRateTreatmentEnum> negativeTreatment(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getNegativeTreatment", floatingRateProcessingParameters -> floatingRateProcessingParameters.getNegativeTreatment());
        }

        @Override
        protected Mapper<BigDecimal> negativeTreatedRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((NegativeInterestRateTreatmentEnum)((Object)((Object)this.negativeTreatment(processing, rawRate, calculationPeriod, isInitialPeriod).get()))))), (Mapper)MapperS.of((Object)((Object)NegativeInterestRateTreatmentEnum.ZERO_INTEREST_RATE_EXCLUDING_SPREAD_METHOD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.max.evaluate((BigDecimal)MapperS.of((Object)new BigDecimal("0.0")).get(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.treatedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())).get()));
                }
                return MapperS.of((Object)((BigDecimal)this.treatedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
            });
        }

        @Override
        protected Mapper<BigDecimal> spreadRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getSpread", floatingRateProcessingParameters -> floatingRateProcessingParameters.getSpread());
        }

        @Override
        protected Mapper<BigDecimal> added(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.add((Mapper)MapperS.of((Object)((BigDecimal)this.negativeTreatedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())));
        }

        @Override
        protected Mapper<BigDecimal> ratePlusSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.added(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
                }
                return MapperS.of((Object)((BigDecimal)this.negativeTreatedRate(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
            });
        }

        @Override
        protected Mapper<BigDecimal> negativeTreatedRatePlusSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((NegativeInterestRateTreatmentEnum)((Object)((Object)this.negativeTreatment(processing, rawRate, calculationPeriod, isInitialPeriod).get()))))), (Mapper)MapperS.of((Object)((Object)NegativeInterestRateTreatmentEnum.ZERO_INTEREST_RATE_METHOD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.max.evaluate((BigDecimal)MapperS.of((Object)new BigDecimal("0.0")).get(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.ratePlusSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get())).get()));
                }
                return MapperS.of((Object)((BigDecimal)this.ratePlusSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
            });
        }

        @Override
        protected Mapper<Boolean> doInitialRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)isInitialPeriod), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)processing).map("getInitialRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getInitialRate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)true);
                }
                return MapperS.of((Object)false);
            });
        }

        @Override
        protected Mapper<BigDecimal> initialRate(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperS.of((Object)processing).map("getInitialRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getInitialRate()).map("getValue", measureBase -> measureBase.getValue());
        }

        @Override
        protected Mapper<BigDecimal> initialRatePluSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperMaths.add((Mapper)MapperS.of((Object)((BigDecimal)this.initialRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod).get())));
        }

        @Override
        protected Mapper<BigDecimal> initialRatePlusSpread(FloatingRateProcessingParameters processing, BigDecimal rawRate, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.spreadRate(processing, rawRate, calculationPeriod, isInitialPeriod).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.initialRatePluSpread(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
                }
                return MapperS.of((Object)((BigDecimal)this.initialRate(processing, rawRate, calculationPeriod, isInitialPeriod).get()));
            });
        }
    }
}

