/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.math.Rounding;
import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;

@ImplementedBy(value=ApplyFinalRateRoundingDefault.class)
public abstract class ApplyFinalRateRounding
implements RosettaFunction {
    @Inject
    protected RoundToPrecision roundToPrecision;

    public BigDecimal evaluate(BigDecimal baseRate, Rounding finalRateRounding) {
        BigDecimal roundedRate = this.doEvaluate(baseRate, finalRateRounding);
        return roundedRate;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, Rounding var2);

    protected abstract Mapper<Integer> precision(BigDecimal var1, Rounding var2);

    protected abstract Mapper<RoundingDirectionEnum> direction(BigDecimal var1, Rounding var2);

    public static class ApplyFinalRateRoundingDefault
    extends ApplyFinalRateRounding {
        @Override
        protected BigDecimal doEvaluate(BigDecimal baseRate, Rounding finalRateRounding) {
            BigDecimal roundedRate = null;
            return this.assignOutput(roundedRate, baseRate, finalRateRounding);
        }

        protected BigDecimal assignOutput(BigDecimal roundedRate, BigDecimal baseRate, Rounding finalRateRounding) {
            roundedRate = (BigDecimal)MapperS.of((Object)this.roundToPrecision.evaluate((BigDecimal)MapperS.of((Object)baseRate).get(), (Integer)MapperS.of((Object)((Integer)this.precision(baseRate, finalRateRounding).get())).get(), (RoundingDirectionEnum)((Object)MapperS.of((Object)((Object)((RoundingDirectionEnum)((Object)this.direction(baseRate, finalRateRounding).get())))).get()))).get();
            return roundedRate;
        }

        @Override
        protected Mapper<Integer> precision(BigDecimal baseRate, Rounding finalRateRounding) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)finalRateRounding).map("getPrecision", rounding -> rounding.getPrecision())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)finalRateRounding).map("getPrecision", rounding -> rounding.getPrecision());
                }
                return MapperS.of((Object)7);
            });
        }

        @Override
        protected Mapper<RoundingDirectionEnum> direction(BigDecimal baseRate, Rounding finalRateRounding) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)finalRateRounding).map("getRoundingDirection", rounding -> rounding.getRoundingDirection())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)finalRateRounding).map("getRoundingDirection", rounding -> rounding.getRoundingDirection());
                }
                return MapperS.of((Object)((Object)RoundingDirectionEnum.NEAREST));
            });
        }
    }
}

