/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate;

import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.meta.FloatingRateProcessingDetailsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FloatingRateProcessingDetails
extends RosettaModelObject {
    public static final FloatingRateProcessingDetailsMeta metaData = new FloatingRateProcessingDetailsMeta();

    public FloatingRateProcessingDetails build();

    public FloatingRateProcessingDetailsBuilder toBuilder();

    public BigDecimal getProcessedRate();

    public FloatingRateProcessingParameters getProcessingParameters();

    public BigDecimal getRawRate();

    public BigDecimal getSpreadExclusiveRate();

    default public RosettaMetaData<? extends FloatingRateProcessingDetails> metaData() {
        return metaData;
    }

    public static FloatingRateProcessingDetailsBuilder builder() {
        return new FloatingRateProcessingDetailsBuilderImpl();
    }

    default public Class<? extends FloatingRateProcessingDetails> getType() {
        return FloatingRateProcessingDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("processedRate"), BigDecimal.class, (Object)this.getProcessedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rawRate"), BigDecimal.class, (Object)this.getRawRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadExclusiveRate"), BigDecimal.class, (Object)this.getSpreadExclusiveRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("processingParameters"), processor, FloatingRateProcessingParameters.class, this.getProcessingParameters(), new AttributeMeta[0]);
    }

    public static class FloatingRateProcessingDetailsBuilderImpl
    implements FloatingRateProcessingDetailsBuilder {
        protected BigDecimal processedRate;
        protected FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParameters;
        protected BigDecimal rawRate;
        protected BigDecimal spreadExclusiveRate;

        @Override
        public BigDecimal getProcessedRate() {
            return this.processedRate;
        }

        @Override
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getProcessingParameters() {
            return this.processingParameters;
        }

        @Override
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getOrCreateProcessingParameters() {
            FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder result = this.processingParameters != null ? this.processingParameters : (this.processingParameters = FloatingRateProcessingParameters.builder());
            return result;
        }

        @Override
        public BigDecimal getRawRate() {
            return this.rawRate;
        }

        @Override
        public BigDecimal getSpreadExclusiveRate() {
            return this.spreadExclusiveRate;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder setProcessedRate(BigDecimal processedRate) {
            this.processedRate = processedRate == null ? null : processedRate;
            return this;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder setProcessingParameters(FloatingRateProcessingParameters processingParameters) {
            this.processingParameters = processingParameters == null ? null : processingParameters.toBuilder();
            return this;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder setRawRate(BigDecimal rawRate) {
            this.rawRate = rawRate == null ? null : rawRate;
            return this;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder setSpreadExclusiveRate(BigDecimal spreadExclusiveRate) {
            this.spreadExclusiveRate = spreadExclusiveRate == null ? null : spreadExclusiveRate;
            return this;
        }

        @Override
        public FloatingRateProcessingDetails build() {
            return new FloatingRateProcessingDetailsImpl(this);
        }

        @Override
        public FloatingRateProcessingDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder prune() {
            if (this.processingParameters != null && !this.processingParameters.prune().hasData()) {
                this.processingParameters = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getProcessedRate() != null) {
                return true;
            }
            if (this.getProcessingParameters() != null && this.getProcessingParameters().hasData()) {
                return true;
            }
            if (this.getRawRate() != null) {
                return true;
            }
            return this.getSpreadExclusiveRate() != null;
        }

        public FloatingRateProcessingDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateProcessingDetailsBuilder o = (FloatingRateProcessingDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProcessingParameters(), (RosettaModelObjectBuilder)o.getProcessingParameters(), this::setProcessingParameters);
            merger.mergeBasic((Object)this.getProcessedRate(), (Object)o.getProcessedRate(), this::setProcessedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRawRate(), (Object)o.getRawRate(), this::setRawRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadExclusiveRate(), (Object)o.getSpreadExclusiveRate(), this::setSpreadExclusiveRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateProcessingDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.processedRate, _that.getProcessedRate())) {
                return false;
            }
            if (!Objects.equals(this.processingParameters, _that.getProcessingParameters())) {
                return false;
            }
            if (!Objects.equals(this.rawRate, _that.getRawRate())) {
                return false;
            }
            return Objects.equals(this.spreadExclusiveRate, _that.getSpreadExclusiveRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.processedRate != null ? this.processedRate.hashCode() : 0);
            _result = 31 * _result + (this.processingParameters != null ? this.processingParameters.hashCode() : 0);
            _result = 31 * _result + (this.rawRate != null ? this.rawRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadExclusiveRate != null ? this.spreadExclusiveRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateProcessingDetailsBuilder {processedRate=" + this.processedRate + ", processingParameters=" + this.processingParameters + ", rawRate=" + this.rawRate + ", spreadExclusiveRate=" + this.spreadExclusiveRate + '}';
        }
    }

    public static class FloatingRateProcessingDetailsImpl
    implements FloatingRateProcessingDetails {
        private final BigDecimal processedRate;
        private final FloatingRateProcessingParameters processingParameters;
        private final BigDecimal rawRate;
        private final BigDecimal spreadExclusiveRate;

        protected FloatingRateProcessingDetailsImpl(FloatingRateProcessingDetailsBuilder builder) {
            this.processedRate = builder.getProcessedRate();
            this.processingParameters = Optional.ofNullable(builder.getProcessingParameters()).map(f -> f.build()).orElse(null);
            this.rawRate = builder.getRawRate();
            this.spreadExclusiveRate = builder.getSpreadExclusiveRate();
        }

        @Override
        public BigDecimal getProcessedRate() {
            return this.processedRate;
        }

        @Override
        public FloatingRateProcessingParameters getProcessingParameters() {
            return this.processingParameters;
        }

        @Override
        public BigDecimal getRawRate() {
            return this.rawRate;
        }

        @Override
        public BigDecimal getSpreadExclusiveRate() {
            return this.spreadExclusiveRate;
        }

        @Override
        public FloatingRateProcessingDetails build() {
            return this;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder toBuilder() {
            FloatingRateProcessingDetailsBuilder builder = FloatingRateProcessingDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateProcessingDetailsBuilder builder) {
            Optional.ofNullable(this.getProcessedRate()).ifPresent(builder::setProcessedRate);
            Optional.ofNullable(this.getProcessingParameters()).ifPresent(builder::setProcessingParameters);
            Optional.ofNullable(this.getRawRate()).ifPresent(builder::setRawRate);
            Optional.ofNullable(this.getSpreadExclusiveRate()).ifPresent(builder::setSpreadExclusiveRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateProcessingDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.processedRate, _that.getProcessedRate())) {
                return false;
            }
            if (!Objects.equals(this.processingParameters, _that.getProcessingParameters())) {
                return false;
            }
            if (!Objects.equals(this.rawRate, _that.getRawRate())) {
                return false;
            }
            return Objects.equals(this.spreadExclusiveRate, _that.getSpreadExclusiveRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.processedRate != null ? this.processedRate.hashCode() : 0);
            _result = 31 * _result + (this.processingParameters != null ? this.processingParameters.hashCode() : 0);
            _result = 31 * _result + (this.rawRate != null ? this.rawRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadExclusiveRate != null ? this.spreadExclusiveRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateProcessingDetails {processedRate=" + this.processedRate + ", processingParameters=" + this.processingParameters + ", rawRate=" + this.rawRate + ", spreadExclusiveRate=" + this.spreadExclusiveRate + '}';
        }
    }

    public static interface FloatingRateProcessingDetailsBuilder
    extends FloatingRateProcessingDetails,
    RosettaModelObjectBuilder {
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getOrCreateProcessingParameters();

        @Override
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getProcessingParameters();

        public FloatingRateProcessingDetailsBuilder setProcessedRate(BigDecimal var1);

        public FloatingRateProcessingDetailsBuilder setProcessingParameters(FloatingRateProcessingParameters var1);

        public FloatingRateProcessingDetailsBuilder setRawRate(BigDecimal var1);

        public FloatingRateProcessingDetailsBuilder setSpreadExclusiveRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("processedRate"), BigDecimal.class, (Object)this.getProcessedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rawRate"), BigDecimal.class, (Object)this.getRawRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadExclusiveRate"), BigDecimal.class, (Object)this.getSpreadExclusiveRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("processingParameters"), processor, FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder.class, this.getProcessingParameters(), new AttributeMeta[0]);
        }

        public FloatingRateProcessingDetailsBuilder prune();
    }
}

