/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.ApplyFloatingRateSetting;
import cdm.product.asset.floatingrate.FloatingAmountCalculationDetails;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.DetermineFloatingRateReset;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=FloatingAmountCalculationDefault.class)
public abstract class FloatingAmountCalculation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyFloatingRateSetting applyFloatingRateSetting;
    @Inject
    protected DetermineFloatingRateReset determineFloatingRateReset;

    public FloatingAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
        FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = this.doEvaluate(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate);
        if (result != null) {
            this.objectValidator.validate(FloatingAmountCalculationDetails.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5);

    protected abstract Mapper<? extends FloatingRateSettingDetails> floatingRateSetting(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5);

    public static class FloatingAmountCalculationDefault
    extends FloatingAmountCalculation {
        @Override
        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
            FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = FloatingAmountCalculationDetails.builder();
            return this.assignOutput(result, interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate);
        }

        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder assignOutput(FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
            result = (FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.applyFloatingRateSetting.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get(), (Boolean)MapperS.of((Object)isInitialPeriod).get(), (BigDecimal)MapperS.of((Object)suppliedNotional).get(), (BigDecimal)MapperS.of((Object)suppliedRate).get(), (FloatingRateSettingDetails)MapperS.of((Object)((FloatingRateSettingDetails)this.floatingRateSetting(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate).get())).get())).get());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends FloatingRateSettingDetails> floatingRateSetting(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate) {
            return MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)suppliedRate)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.determineFloatingRateReset.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
                }
                return MapperS.ofNull();
            });
        }
    }
}

