/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.observable.asset.Money;
import cdm.product.asset.FixedAmountCalculationDetails;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.CalculateYearFraction;
import cdm.product.asset.calculation.functions.GetFixedRate;
import cdm.product.asset.calculation.functions.GetNotionalAmount;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=FixedAmountCalculationDefault.class)
public abstract class FixedAmountCalculation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculateYearFraction calculateYearFraction;
    @Inject
    protected GetFixedRate getFixedRate;
    @Inject
    protected GetNotionalAmount getNotionalAmount;

    public FixedAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
        FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder fixedAmountDetails = this.doEvaluate(interestRatePayout, calculationPeriod, notional);
        if (fixedAmountDetails != null) {
            this.objectValidator.validate(FixedAmountCalculationDetails.class, (RosettaModelObject)fixedAmountDetails);
        }
        return fixedAmountDetails;
    }

    protected abstract FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> fixedRate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract Mapper<? extends Money> calculationAmount(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract Mapper<DayCountFractionEnum> dcf(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> yearFraction(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> calcAmt(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    public static class FixedAmountCalculationDefault
    extends FixedAmountCalculation {
        @Override
        protected FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder fixedAmountDetails = FixedAmountCalculationDetails.builder();
            return this.assignOutput(fixedAmountDetails, interestRatePayout, calculationPeriod, notional);
        }

        protected FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder assignOutput(FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder fixedAmountDetails, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            fixedAmountDetails.setCalculationPeriod((CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get());
            fixedAmountDetails.getOrCreateCalculationPeriodNotionalAmount().setValue((BigDecimal)MapperS.of((Object)((BigDecimal)this.calcAmt(interestRatePayout, calculationPeriod, notional).get())).get());
            fixedAmountDetails.getOrCreateCalculationPeriodNotionalAmount().getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)((Money)this.calculationAmount(interestRatePayout, calculationPeriod, notional).get())).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()).get());
            fixedAmountDetails.setFixedRate((BigDecimal)MapperS.of((Object)((BigDecimal)this.fixedRate(interestRatePayout, calculationPeriod, notional).get())).get());
            fixedAmountDetails.setYearFraction((BigDecimal)MapperS.of((Object)((BigDecimal)this.yearFraction(interestRatePayout, calculationPeriod, notional).get())).get());
            fixedAmountDetails.setCalculatedAmount((BigDecimal)MapperMaths.multiply((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)((BigDecimal)this.calcAmt(interestRatePayout, calculationPeriod, notional).get())), (Mapper)MapperS.of((Object)fixedAmountDetails).map("getFixedRate", fixedAmountCalculationDetails -> fixedAmountCalculationDetails.getFixedRate())), (Mapper)MapperS.of((Object)fixedAmountDetails).map("getYearFraction", fixedAmountCalculationDetails -> fixedAmountCalculationDetails.getYearFraction())).get());
            return Optional.ofNullable(fixedAmountDetails).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> fixedRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperS.of((Object)this.getFixedRate.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<? extends Money> calculationAmount(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperS.of((Object)this.getNotionalAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<DayCountFractionEnum> dcf(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperS.of((Object)interestRatePayout).map("getDayCountFraction", _interestRatePayout -> _interestRatePayout.getDayCountFraction()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<BigDecimal> yearFraction(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperS.of((Object)this.calculateYearFraction.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (DayCountFractionEnum)((Object)MapperS.of((Object)((Object)((DayCountFractionEnum)((Object)this.dcf(interestRatePayout, calculationPeriod, notional).get())))).get()), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<BigDecimal> calcAmt(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)notional)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)notional);
                }
                return MapperS.of((Object)((Money)this.calculationAmount(interestRatePayout, calculationPeriod, notional).get())).map("getValue", measureBase -> measureBase.getValue());
            });
        }
    }
}

