/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=DefaultFloatingRateDefault.class)
public abstract class DefaultFloatingRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public FloatingRateProcessingDetails evaluate(BigDecimal suppliedRate) {
        FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder processedRateDetails = this.doEvaluate(suppliedRate);
        if (processedRateDetails != null) {
            this.objectValidator.validate(FloatingRateProcessingDetails.class, (RosettaModelObject)processedRateDetails);
        }
        return processedRateDetails;
    }

    protected abstract FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(BigDecimal var1);

    public static class DefaultFloatingRateDefault
    extends DefaultFloatingRate {
        @Override
        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder doEvaluate(BigDecimal suppliedRate) {
            FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder processedRateDetails = FloatingRateProcessingDetails.builder();
            return this.assignOutput(processedRateDetails, suppliedRate);
        }

        protected FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder assignOutput(FloatingRateProcessingDetails.FloatingRateProcessingDetailsBuilder processedRateDetails, BigDecimal suppliedRate) {
            processedRateDetails.setProcessedRate((BigDecimal)MapperS.of((Object)suppliedRate).get());
            return Optional.ofNullable(processedRateDetails).map(o -> o.prune()).orElse(null);
        }
    }
}

