/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.CalculateYearFraction;
import cdm.product.asset.floatingrate.FloatingAmountCalculationDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=CalculateFloatingCashFlowDefault.class)
public abstract class CalculateFloatingCashFlow
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculateYearFraction calculateYearFraction;

    public FloatingAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
        FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = this.doEvaluate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails);
        if (result != null) {
            this.objectValidator.validate(FloatingAmountCalculationDetails.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<BigDecimal> appliedRate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<BigDecimal> spreadExclusiveRate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<DayCountFractionEnum> dcf(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<BigDecimal> yearFraction(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<BigDecimal> annualAccrual(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<BigDecimal> notionalAccrual(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<BigDecimal> cashflow(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    protected abstract Mapper<BigDecimal> spreadExclusiveCashflow(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3, String var4, FloatingRateSettingDetails var5, FloatingRateProcessingDetails var6);

    public static class CalculateFloatingCashFlowDefault
    extends CalculateFloatingCashFlow {
        @Override
        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = FloatingAmountCalculationDetails.builder();
            return this.assignOutput(result, interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails);
        }

        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder assignOutput(FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            result.setCalculationPeriod((CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get());
            result.getOrCreateCalculationPeriodNotionalAmount().setValue((BigDecimal)MapperS.of((Object)notional).get());
            result.getOrCreateCalculationPeriodNotionalAmount().getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)currency).get());
            result.setFloatingRate((FloatingRateSettingDetails)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)floatingRateSetting)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)floatingRateSetting);
                }
                return MapperS.ofNull();
            }).get());
            result.setProcessingDetails((FloatingRateProcessingDetails)MapperS.of((Object)processedRateDetails).get());
            result.setAppliedRate((BigDecimal)MapperS.of((Object)((BigDecimal)this.appliedRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())).get());
            result.setYearFraction((BigDecimal)MapperS.of((Object)((BigDecimal)this.yearFraction(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())).get());
            result.setCalculatedAmount((BigDecimal)MapperS.of((Object)((BigDecimal)this.cashflow(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())).get());
            result.setSpreadExclusiveCalculatedAMount((BigDecimal)MapperS.of((Object)((BigDecimal)this.spreadExclusiveCashflow(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())).get());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> appliedRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperS.of((Object)processedRateDetails).map("getProcessedRate", floatingRateProcessingDetails -> floatingRateProcessingDetails.getProcessedRate());
        }

        @Override
        protected Mapper<BigDecimal> spreadExclusiveRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperS.of((Object)processedRateDetails).map("getSpreadExclusiveRate", floatingRateProcessingDetails -> floatingRateProcessingDetails.getSpreadExclusiveRate());
        }

        @Override
        protected Mapper<DayCountFractionEnum> dcf(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperS.of((Object)interestRatePayout).map("getDayCountFraction", _interestRatePayout -> _interestRatePayout.getDayCountFraction()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<BigDecimal> yearFraction(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperS.of((Object)this.calculateYearFraction.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (DayCountFractionEnum)((Object)MapperS.of((Object)((Object)((DayCountFractionEnum)((Object)this.dcf(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())))).get()), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<BigDecimal> annualAccrual(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)notional), (Mapper)MapperS.of((Object)((BigDecimal)this.appliedRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())));
        }

        @Override
        protected Mapper<BigDecimal> notionalAccrual(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)notional), (Mapper)MapperS.of((Object)((BigDecimal)this.yearFraction(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())));
        }

        @Override
        protected Mapper<BigDecimal> cashflow(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)((BigDecimal)this.notionalAccrual(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.appliedRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())));
        }

        @Override
        protected Mapper<BigDecimal> spreadExclusiveCashflow(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional, String currency, FloatingRateSettingDetails floatingRateSetting, FloatingRateProcessingDetails processedRateDetails) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)((BigDecimal)this.notionalAccrual(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.spreadExclusiveRate(interestRatePayout, calculationPeriod, notional, currency, floatingRateSetting, processedRateDetails).get())));
        }
    }
}

