/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.observable.asset.Money;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.CalculateFloatingCashFlow;
import cdm.product.asset.calculation.functions.DefaultFloatingRate;
import cdm.product.asset.calculation.functions.GetNotionalAmount;
import cdm.product.asset.floatingrate.FloatingAmountCalculationDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.ApplyFloatingRateProcessing;
import cdm.product.asset.floatingrate.functions.GetFloatingRateProcessingParameters;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=ApplyFloatingRateSettingDefault.class)
public abstract class ApplyFloatingRateSetting
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyFloatingRateProcessing applyFloatingRateProcessing;
    @Inject
    protected CalculateFloatingCashFlow calculateFloatingCashFlow;
    @Inject
    protected DefaultFloatingRate defaultFloatingRate;
    @Inject
    protected GetFloatingRateProcessingParameters getFloatingRateProcessingParameters;
    @Inject
    protected GetNotionalAmount getNotionalAmount;

    public FloatingAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
        FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = this.doEvaluate(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting);
        if (result != null) {
            this.objectValidator.validate(FloatingAmountCalculationDetails.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract Mapper<BigDecimal> floatingRate(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract Mapper<? extends FloatingRateProcessingParameters> processingParameters(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract Mapper<? extends FloatingRateProcessingDetails> processedRateDetails(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract Mapper<? extends Money> periodNotional(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract Mapper<BigDecimal> notional(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract Mapper<String> currency(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    public static class ApplyFloatingRateSettingDefault
    extends ApplyFloatingRateSetting {
        @Override
        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = FloatingAmountCalculationDetails.builder();
            return this.assignOutput(result, interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting);
        }

        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder assignOutput(FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            result = (FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.calculateFloatingCashFlow.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.notional(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get())).get(), (String)MapperS.of((Object)((String)this.currency(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get())).get(), (FloatingRateSettingDetails)MapperS.of((Object)floatingRateSetting).get(), (FloatingRateProcessingDetails)MapperS.of((Object)((FloatingRateProcessingDetails)this.processedRateDetails(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get())).get())).get());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> floatingRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperS.of((Object)floatingRateSetting).map("getFloatingRate", floatingRateSettingDetails -> floatingRateSettingDetails.getFloatingRate());
        }

        @Override
        protected Mapper<? extends FloatingRateProcessingParameters> processingParameters(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperS.of((Object)this.getFloatingRateProcessingParameters.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<? extends FloatingRateProcessingDetails> processedRateDetails(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)suppliedRate)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.defaultFloatingRate.evaluate((BigDecimal)MapperS.of((Object)suppliedRate).get()));
                }
                return MapperS.of((Object)this.applyFloatingRateProcessing.evaluate((FloatingRateProcessingParameters)MapperS.of((Object)((FloatingRateProcessingParameters)this.processingParameters(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get())).get(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.floatingRate(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get())).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get(), (Boolean)MapperS.of((Object)isInitialPeriod).get()));
            });
        }

        @Override
        protected Mapper<? extends Money> periodNotional(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperS.of((Object)this.getNotionalAmount.evaluate((InterestRatePayout)MapperS.of((Object)interestRatePayout).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get()));
        }

        @Override
        protected Mapper<BigDecimal> notional(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)suppliedNotional)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)suppliedNotional);
                }
                return MapperS.of((Object)((Money)this.periodNotional(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get())).map("getValue", measureBase -> measureBase.getValue());
            });
        }

        @Override
        protected Mapper<String> currency(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperS.of((Object)((Money)this.periodNotional(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get())).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue());
        }
    }
}

