/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.observable.asset.DividendApplicability;
import cdm.observable.asset.Observable;
import cdm.observable.asset.Price;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.product.asset.EquityUnderlierProvisions;
import cdm.product.asset.ReturnTermsBase;
import cdm.product.asset.ValuationTerms;
import cdm.product.asset.VolatilityCapFloor;
import cdm.product.asset.meta.VolatilityReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface VolatilityReturnTerms
extends ReturnTermsBase {
    public static final VolatilityReturnTermsMeta metaData = new VolatilityReturnTermsMeta();

    @Override
    public VolatilityReturnTerms build();

    @Override
    public VolatilityReturnTermsBuilder toBuilder();

    public Observable getExchangeTradedContractNearest();

    public VolatilityCapFloor getVolatilityCapFloor();

    public Price getVolatilityStrikePrice();

    default public RosettaMetaData<? extends VolatilityReturnTerms> metaData() {
        return metaData;
    }

    public static VolatilityReturnTermsBuilder builder() {
        return new VolatilityReturnTermsBuilderImpl();
    }

    default public Class<? extends VolatilityReturnTerms> getType() {
        return VolatilityReturnTerms.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        ReturnTermsBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, Observable.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityCapFloor"), processor, VolatilityCapFloor.class, this.getVolatilityCapFloor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityStrikePrice"), processor, Price.class, this.getVolatilityStrikePrice(), new AttributeMeta[0]);
    }

    public static class VolatilityReturnTermsBuilderImpl
    extends ReturnTermsBase.ReturnTermsBaseBuilderImpl
    implements VolatilityReturnTermsBuilder {
        protected Observable.ObservableBuilder exchangeTradedContractNearest;
        protected VolatilityCapFloor.VolatilityCapFloorBuilder volatilityCapFloor;
        protected Price.PriceBuilder volatilityStrikePrice;

        @Override
        public Observable.ObservableBuilder getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public Observable.ObservableBuilder getOrCreateExchangeTradedContractNearest() {
            Observable.ObservableBuilder result = this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest : (this.exchangeTradedContractNearest = Observable.builder());
            return result;
        }

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getVolatilityCapFloor() {
            return this.volatilityCapFloor;
        }

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getOrCreateVolatilityCapFloor() {
            VolatilityCapFloor.VolatilityCapFloorBuilder result = this.volatilityCapFloor != null ? this.volatilityCapFloor : (this.volatilityCapFloor = VolatilityCapFloor.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateVolatilityStrikePrice() {
            Price.PriceBuilder result = this.volatilityStrikePrice != null ? this.volatilityStrikePrice : (this.volatilityStrikePrice = Price.builder());
            return result;
        }

        @Override
        public VolatilityReturnTermsBuilder setExchangeTradedContractNearest(Observable exchangeTradedContractNearest) {
            this.exchangeTradedContractNearest = exchangeTradedContractNearest == null ? null : exchangeTradedContractNearest.toBuilder();
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setVolatilityCapFloor(VolatilityCapFloor volatilityCapFloor) {
            this.volatilityCapFloor = volatilityCapFloor == null ? null : volatilityCapFloor.toBuilder();
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setVolatilityStrikePrice(Price volatilityStrikePrice) {
            this.volatilityStrikePrice = volatilityStrikePrice == null ? null : volatilityStrikePrice.toBuilder();
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setAnnualizationFactor(Integer annualizationFactor) {
            this.annualizationFactor = annualizationFactor == null ? null : annualizationFactor;
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setDividendApplicability(DividendApplicability dividendApplicability) {
            this.dividendApplicability = dividendApplicability == null ? null : dividendApplicability.toBuilder();
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions equityUnderlierProvisions) {
            this.equityUnderlierProvisions = equityUnderlierProvisions == null ? null : equityUnderlierProvisions.toBuilder();
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setExpectedN(Integer expectedN) {
            this.expectedN = expectedN == null ? null : expectedN;
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setInitialLevel(BigDecimal initialLevel) {
            this.initialLevel = initialLevel == null ? null : initialLevel;
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum initialLevelSource) {
            this.initialLevelSource = initialLevelSource == null ? null : initialLevelSource;
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setMeanAdjustment(Boolean meanAdjustment) {
            this.meanAdjustment = meanAdjustment == null ? null : meanAdjustment;
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setPerformance(String performance) {
            this.performance = performance == null ? null : performance;
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setSharePriceDividendAdjustment(Boolean sharePriceDividendAdjustment) {
            this.sharePriceDividendAdjustment = sharePriceDividendAdjustment == null ? null : sharePriceDividendAdjustment;
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder setValuationTerms(ValuationTerms valuationTerms) {
            this.valuationTerms = valuationTerms == null ? null : valuationTerms.toBuilder();
            return this;
        }

        @Override
        public VolatilityReturnTerms build() {
            return new VolatilityReturnTermsImpl(this);
        }

        @Override
        public VolatilityReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder prune() {
            super.prune();
            if (this.exchangeTradedContractNearest != null && !this.exchangeTradedContractNearest.prune().hasData()) {
                this.exchangeTradedContractNearest = null;
            }
            if (this.volatilityCapFloor != null && !this.volatilityCapFloor.prune().hasData()) {
                this.volatilityCapFloor = null;
            }
            if (this.volatilityStrikePrice != null && !this.volatilityStrikePrice.prune().hasData()) {
                this.volatilityStrikePrice = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExchangeTradedContractNearest() != null && this.getExchangeTradedContractNearest().hasData()) {
                return true;
            }
            if (this.getVolatilityCapFloor() != null && this.getVolatilityCapFloor().hasData()) {
                return true;
            }
            return this.getVolatilityStrikePrice() != null && this.getVolatilityStrikePrice().hasData();
        }

        @Override
        public VolatilityReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilityReturnTermsBuilder o = (VolatilityReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedContractNearest(), (RosettaModelObjectBuilder)o.getExchangeTradedContractNearest(), this::setExchangeTradedContractNearest);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityCapFloor(), (RosettaModelObjectBuilder)o.getVolatilityCapFloor(), this::setVolatilityCapFloor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityStrikePrice(), (RosettaModelObjectBuilder)o.getVolatilityStrikePrice(), this::setVolatilityStrikePrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityReturnTerms _that = (VolatilityReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            if (!Objects.equals(this.volatilityCapFloor, _that.getVolatilityCapFloor())) {
                return false;
            }
            return Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapFloor != null ? this.volatilityCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityReturnTermsBuilder {exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + ", volatilityCapFloor=" + this.volatilityCapFloor + ", volatilityStrikePrice=" + this.volatilityStrikePrice + '}' + " " + super.toString();
        }
    }

    public static class VolatilityReturnTermsImpl
    extends ReturnTermsBase.ReturnTermsBaseImpl
    implements VolatilityReturnTerms {
        private final Observable exchangeTradedContractNearest;
        private final VolatilityCapFloor volatilityCapFloor;
        private final Price volatilityStrikePrice;

        protected VolatilityReturnTermsImpl(VolatilityReturnTermsBuilder builder) {
            super(builder);
            this.exchangeTradedContractNearest = Optional.ofNullable(builder.getExchangeTradedContractNearest()).map(f -> f.build()).orElse(null);
            this.volatilityCapFloor = Optional.ofNullable(builder.getVolatilityCapFloor()).map(f -> f.build()).orElse(null);
            this.volatilityStrikePrice = Optional.ofNullable(builder.getVolatilityStrikePrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Observable getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public VolatilityCapFloor getVolatilityCapFloor() {
            return this.volatilityCapFloor;
        }

        @Override
        public Price getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        public VolatilityReturnTerms build() {
            return this;
        }

        @Override
        public VolatilityReturnTermsBuilder toBuilder() {
            VolatilityReturnTermsBuilder builder = VolatilityReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityReturnTermsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExchangeTradedContractNearest()).ifPresent(builder::setExchangeTradedContractNearest);
            Optional.ofNullable(this.getVolatilityCapFloor()).ifPresent(builder::setVolatilityCapFloor);
            Optional.ofNullable(this.getVolatilityStrikePrice()).ifPresent(builder::setVolatilityStrikePrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityReturnTerms _that = (VolatilityReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            if (!Objects.equals(this.volatilityCapFloor, _that.getVolatilityCapFloor())) {
                return false;
            }
            return Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapFloor != null ? this.volatilityCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityReturnTerms {exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + ", volatilityCapFloor=" + this.volatilityCapFloor + ", volatilityStrikePrice=" + this.volatilityStrikePrice + '}' + " " + super.toString();
        }
    }

    public static interface VolatilityReturnTermsBuilder
    extends VolatilityReturnTerms,
    ReturnTermsBase.ReturnTermsBaseBuilder,
    RosettaModelObjectBuilder {
        public Observable.ObservableBuilder getOrCreateExchangeTradedContractNearest();

        @Override
        public Observable.ObservableBuilder getExchangeTradedContractNearest();

        public VolatilityCapFloor.VolatilityCapFloorBuilder getOrCreateVolatilityCapFloor();

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getVolatilityCapFloor();

        public Price.PriceBuilder getOrCreateVolatilityStrikePrice();

        @Override
        public Price.PriceBuilder getVolatilityStrikePrice();

        public VolatilityReturnTermsBuilder setExchangeTradedContractNearest(Observable var1);

        public VolatilityReturnTermsBuilder setVolatilityCapFloor(VolatilityCapFloor var1);

        public VolatilityReturnTermsBuilder setVolatilityStrikePrice(Price var1);

        @Override
        public VolatilityReturnTermsBuilder setAnnualizationFactor(Integer var1);

        @Override
        public VolatilityReturnTermsBuilder setDividendApplicability(DividendApplicability var1);

        @Override
        public VolatilityReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions var1);

        @Override
        public VolatilityReturnTermsBuilder setExpectedN(Integer var1);

        @Override
        public VolatilityReturnTermsBuilder setInitialLevel(BigDecimal var1);

        @Override
        public VolatilityReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum var1);

        @Override
        public VolatilityReturnTermsBuilder setMeanAdjustment(Boolean var1);

        @Override
        public VolatilityReturnTermsBuilder setPerformance(String var1);

        @Override
        public VolatilityReturnTermsBuilder setSharePriceDividendAdjustment(Boolean var1);

        @Override
        public VolatilityReturnTermsBuilder setValuationTerms(ValuationTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            ReturnTermsBase.ReturnTermsBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, Observable.ObservableBuilder.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityCapFloor"), processor, VolatilityCapFloor.VolatilityCapFloorBuilder.class, this.getVolatilityCapFloor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityStrikePrice"), processor, Price.PriceBuilder.class, this.getVolatilityStrikePrice(), new AttributeMeta[0]);
        }

        @Override
        public VolatilityReturnTermsBuilder prune();
    }
}

