/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.observable.asset.DividendApplicability;
import cdm.observable.asset.Observable;
import cdm.observable.asset.Price;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.product.asset.EquityUnderlierProvisions;
import cdm.product.asset.ReturnTermsBase;
import cdm.product.asset.ValuationTerms;
import cdm.product.asset.VarianceCapFloor;
import cdm.product.asset.VolatilityCapFloor;
import cdm.product.asset.meta.VarianceReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface VarianceReturnTerms
extends ReturnTermsBase {
    public static final VarianceReturnTermsMeta metaData = new VarianceReturnTermsMeta();

    @Override
    public VarianceReturnTerms build();

    @Override
    public VarianceReturnTermsBuilder toBuilder();

    public Observable getExchangeTradedContractNearest();

    public VarianceCapFloor getVarianceCapFloor();

    public Price getVarianceStrikePrice();

    public NonNegativeQuantitySchedule getVegaNotionalAmount();

    public VolatilityCapFloor getVolatilityCapFloor();

    public Price getVolatilityStrikePrice();

    default public RosettaMetaData<? extends VarianceReturnTerms> metaData() {
        return metaData;
    }

    public static VarianceReturnTermsBuilder builder() {
        return new VarianceReturnTermsBuilderImpl();
    }

    default public Class<? extends VarianceReturnTerms> getType() {
        return VarianceReturnTerms.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        ReturnTermsBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, Observable.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("varianceCapFloor"), processor, VarianceCapFloor.class, this.getVarianceCapFloor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("varianceStrikePrice"), processor, Price.class, this.getVarianceStrikePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("vegaNotionalAmount"), processor, NonNegativeQuantitySchedule.class, this.getVegaNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityCapFloor"), processor, VolatilityCapFloor.class, this.getVolatilityCapFloor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityStrikePrice"), processor, Price.class, this.getVolatilityStrikePrice(), new AttributeMeta[0]);
    }

    public static class VarianceReturnTermsBuilderImpl
    extends ReturnTermsBase.ReturnTermsBaseBuilderImpl
    implements VarianceReturnTermsBuilder {
        protected Observable.ObservableBuilder exchangeTradedContractNearest;
        protected VarianceCapFloor.VarianceCapFloorBuilder varianceCapFloor;
        protected Price.PriceBuilder varianceStrikePrice;
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder vegaNotionalAmount;
        protected VolatilityCapFloor.VolatilityCapFloorBuilder volatilityCapFloor;
        protected Price.PriceBuilder volatilityStrikePrice;

        @Override
        public Observable.ObservableBuilder getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public Observable.ObservableBuilder getOrCreateExchangeTradedContractNearest() {
            Observable.ObservableBuilder result = this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest : (this.exchangeTradedContractNearest = Observable.builder());
            return result;
        }

        @Override
        public VarianceCapFloor.VarianceCapFloorBuilder getVarianceCapFloor() {
            return this.varianceCapFloor;
        }

        @Override
        public VarianceCapFloor.VarianceCapFloorBuilder getOrCreateVarianceCapFloor() {
            VarianceCapFloor.VarianceCapFloorBuilder result = this.varianceCapFloor != null ? this.varianceCapFloor : (this.varianceCapFloor = VarianceCapFloor.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getVarianceStrikePrice() {
            return this.varianceStrikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateVarianceStrikePrice() {
            Price.PriceBuilder result = this.varianceStrikePrice != null ? this.varianceStrikePrice : (this.varianceStrikePrice = Price.builder());
            return result;
        }

        @Override
        public NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder getVegaNotionalAmount() {
            return this.vegaNotionalAmount;
        }

        @Override
        public NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder getOrCreateVegaNotionalAmount() {
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result = this.vegaNotionalAmount != null ? this.vegaNotionalAmount : (this.vegaNotionalAmount = NonNegativeQuantitySchedule.builder());
            return result;
        }

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getVolatilityCapFloor() {
            return this.volatilityCapFloor;
        }

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getOrCreateVolatilityCapFloor() {
            VolatilityCapFloor.VolatilityCapFloorBuilder result = this.volatilityCapFloor != null ? this.volatilityCapFloor : (this.volatilityCapFloor = VolatilityCapFloor.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateVolatilityStrikePrice() {
            Price.PriceBuilder result = this.volatilityStrikePrice != null ? this.volatilityStrikePrice : (this.volatilityStrikePrice = Price.builder());
            return result;
        }

        @Override
        public VarianceReturnTermsBuilder setExchangeTradedContractNearest(Observable exchangeTradedContractNearest) {
            this.exchangeTradedContractNearest = exchangeTradedContractNearest == null ? null : exchangeTradedContractNearest.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setVarianceCapFloor(VarianceCapFloor varianceCapFloor) {
            this.varianceCapFloor = varianceCapFloor == null ? null : varianceCapFloor.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setVarianceStrikePrice(Price varianceStrikePrice) {
            this.varianceStrikePrice = varianceStrikePrice == null ? null : varianceStrikePrice.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setVegaNotionalAmount(NonNegativeQuantitySchedule vegaNotionalAmount) {
            this.vegaNotionalAmount = vegaNotionalAmount == null ? null : vegaNotionalAmount.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setVolatilityCapFloor(VolatilityCapFloor volatilityCapFloor) {
            this.volatilityCapFloor = volatilityCapFloor == null ? null : volatilityCapFloor.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setVolatilityStrikePrice(Price volatilityStrikePrice) {
            this.volatilityStrikePrice = volatilityStrikePrice == null ? null : volatilityStrikePrice.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setAnnualizationFactor(Integer annualizationFactor) {
            this.annualizationFactor = annualizationFactor == null ? null : annualizationFactor;
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setDividendApplicability(DividendApplicability dividendApplicability) {
            this.dividendApplicability = dividendApplicability == null ? null : dividendApplicability.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions equityUnderlierProvisions) {
            this.equityUnderlierProvisions = equityUnderlierProvisions == null ? null : equityUnderlierProvisions.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setExpectedN(Integer expectedN) {
            this.expectedN = expectedN == null ? null : expectedN;
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setInitialLevel(BigDecimal initialLevel) {
            this.initialLevel = initialLevel == null ? null : initialLevel;
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum initialLevelSource) {
            this.initialLevelSource = initialLevelSource == null ? null : initialLevelSource;
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setMeanAdjustment(Boolean meanAdjustment) {
            this.meanAdjustment = meanAdjustment == null ? null : meanAdjustment;
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setPerformance(String performance) {
            this.performance = performance == null ? null : performance;
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setSharePriceDividendAdjustment(Boolean sharePriceDividendAdjustment) {
            this.sharePriceDividendAdjustment = sharePriceDividendAdjustment == null ? null : sharePriceDividendAdjustment;
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder setValuationTerms(ValuationTerms valuationTerms) {
            this.valuationTerms = valuationTerms == null ? null : valuationTerms.toBuilder();
            return this;
        }

        @Override
        public VarianceReturnTerms build() {
            return new VarianceReturnTermsImpl(this);
        }

        @Override
        public VarianceReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder prune() {
            super.prune();
            if (this.exchangeTradedContractNearest != null && !this.exchangeTradedContractNearest.prune().hasData()) {
                this.exchangeTradedContractNearest = null;
            }
            if (this.varianceCapFloor != null && !this.varianceCapFloor.prune().hasData()) {
                this.varianceCapFloor = null;
            }
            if (this.varianceStrikePrice != null && !this.varianceStrikePrice.prune().hasData()) {
                this.varianceStrikePrice = null;
            }
            if (this.vegaNotionalAmount != null && !this.vegaNotionalAmount.prune().hasData()) {
                this.vegaNotionalAmount = null;
            }
            if (this.volatilityCapFloor != null && !this.volatilityCapFloor.prune().hasData()) {
                this.volatilityCapFloor = null;
            }
            if (this.volatilityStrikePrice != null && !this.volatilityStrikePrice.prune().hasData()) {
                this.volatilityStrikePrice = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExchangeTradedContractNearest() != null && this.getExchangeTradedContractNearest().hasData()) {
                return true;
            }
            if (this.getVarianceCapFloor() != null && this.getVarianceCapFloor().hasData()) {
                return true;
            }
            if (this.getVarianceStrikePrice() != null && this.getVarianceStrikePrice().hasData()) {
                return true;
            }
            if (this.getVegaNotionalAmount() != null && this.getVegaNotionalAmount().hasData()) {
                return true;
            }
            if (this.getVolatilityCapFloor() != null && this.getVolatilityCapFloor().hasData()) {
                return true;
            }
            return this.getVolatilityStrikePrice() != null && this.getVolatilityStrikePrice().hasData();
        }

        @Override
        public VarianceReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VarianceReturnTermsBuilder o = (VarianceReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedContractNearest(), (RosettaModelObjectBuilder)o.getExchangeTradedContractNearest(), this::setExchangeTradedContractNearest);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVarianceCapFloor(), (RosettaModelObjectBuilder)o.getVarianceCapFloor(), this::setVarianceCapFloor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVarianceStrikePrice(), (RosettaModelObjectBuilder)o.getVarianceStrikePrice(), this::setVarianceStrikePrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVegaNotionalAmount(), (RosettaModelObjectBuilder)o.getVegaNotionalAmount(), this::setVegaNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityCapFloor(), (RosettaModelObjectBuilder)o.getVolatilityCapFloor(), this::setVolatilityCapFloor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityStrikePrice(), (RosettaModelObjectBuilder)o.getVolatilityStrikePrice(), this::setVolatilityStrikePrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceReturnTerms _that = (VarianceReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            if (!Objects.equals(this.varianceCapFloor, _that.getVarianceCapFloor())) {
                return false;
            }
            if (!Objects.equals(this.varianceStrikePrice, _that.getVarianceStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.vegaNotionalAmount, _that.getVegaNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.volatilityCapFloor, _that.getVolatilityCapFloor())) {
                return false;
            }
            return Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.varianceCapFloor != null ? this.varianceCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.varianceStrikePrice != null ? this.varianceStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotionalAmount != null ? this.vegaNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapFloor != null ? this.volatilityCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceReturnTermsBuilder {exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + ", varianceCapFloor=" + this.varianceCapFloor + ", varianceStrikePrice=" + this.varianceStrikePrice + ", vegaNotionalAmount=" + this.vegaNotionalAmount + ", volatilityCapFloor=" + this.volatilityCapFloor + ", volatilityStrikePrice=" + this.volatilityStrikePrice + '}' + " " + super.toString();
        }
    }

    public static class VarianceReturnTermsImpl
    extends ReturnTermsBase.ReturnTermsBaseImpl
    implements VarianceReturnTerms {
        private final Observable exchangeTradedContractNearest;
        private final VarianceCapFloor varianceCapFloor;
        private final Price varianceStrikePrice;
        private final NonNegativeQuantitySchedule vegaNotionalAmount;
        private final VolatilityCapFloor volatilityCapFloor;
        private final Price volatilityStrikePrice;

        protected VarianceReturnTermsImpl(VarianceReturnTermsBuilder builder) {
            super(builder);
            this.exchangeTradedContractNearest = Optional.ofNullable(builder.getExchangeTradedContractNearest()).map(f -> f.build()).orElse(null);
            this.varianceCapFloor = Optional.ofNullable(builder.getVarianceCapFloor()).map(f -> f.build()).orElse(null);
            this.varianceStrikePrice = Optional.ofNullable(builder.getVarianceStrikePrice()).map(f -> f.build()).orElse(null);
            this.vegaNotionalAmount = Optional.ofNullable(builder.getVegaNotionalAmount()).map(f -> f.build()).orElse(null);
            this.volatilityCapFloor = Optional.ofNullable(builder.getVolatilityCapFloor()).map(f -> f.build()).orElse(null);
            this.volatilityStrikePrice = Optional.ofNullable(builder.getVolatilityStrikePrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Observable getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public VarianceCapFloor getVarianceCapFloor() {
            return this.varianceCapFloor;
        }

        @Override
        public Price getVarianceStrikePrice() {
            return this.varianceStrikePrice;
        }

        @Override
        public NonNegativeQuantitySchedule getVegaNotionalAmount() {
            return this.vegaNotionalAmount;
        }

        @Override
        public VolatilityCapFloor getVolatilityCapFloor() {
            return this.volatilityCapFloor;
        }

        @Override
        public Price getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        public VarianceReturnTerms build() {
            return this;
        }

        @Override
        public VarianceReturnTermsBuilder toBuilder() {
            VarianceReturnTermsBuilder builder = VarianceReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VarianceReturnTermsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExchangeTradedContractNearest()).ifPresent(builder::setExchangeTradedContractNearest);
            Optional.ofNullable(this.getVarianceCapFloor()).ifPresent(builder::setVarianceCapFloor);
            Optional.ofNullable(this.getVarianceStrikePrice()).ifPresent(builder::setVarianceStrikePrice);
            Optional.ofNullable(this.getVegaNotionalAmount()).ifPresent(builder::setVegaNotionalAmount);
            Optional.ofNullable(this.getVolatilityCapFloor()).ifPresent(builder::setVolatilityCapFloor);
            Optional.ofNullable(this.getVolatilityStrikePrice()).ifPresent(builder::setVolatilityStrikePrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceReturnTerms _that = (VarianceReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            if (!Objects.equals(this.varianceCapFloor, _that.getVarianceCapFloor())) {
                return false;
            }
            if (!Objects.equals(this.varianceStrikePrice, _that.getVarianceStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.vegaNotionalAmount, _that.getVegaNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.volatilityCapFloor, _that.getVolatilityCapFloor())) {
                return false;
            }
            return Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.varianceCapFloor != null ? this.varianceCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.varianceStrikePrice != null ? this.varianceStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotionalAmount != null ? this.vegaNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapFloor != null ? this.volatilityCapFloor.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceReturnTerms {exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + ", varianceCapFloor=" + this.varianceCapFloor + ", varianceStrikePrice=" + this.varianceStrikePrice + ", vegaNotionalAmount=" + this.vegaNotionalAmount + ", volatilityCapFloor=" + this.volatilityCapFloor + ", volatilityStrikePrice=" + this.volatilityStrikePrice + '}' + " " + super.toString();
        }
    }

    public static interface VarianceReturnTermsBuilder
    extends VarianceReturnTerms,
    ReturnTermsBase.ReturnTermsBaseBuilder,
    RosettaModelObjectBuilder {
        public Observable.ObservableBuilder getOrCreateExchangeTradedContractNearest();

        @Override
        public Observable.ObservableBuilder getExchangeTradedContractNearest();

        public VarianceCapFloor.VarianceCapFloorBuilder getOrCreateVarianceCapFloor();

        @Override
        public VarianceCapFloor.VarianceCapFloorBuilder getVarianceCapFloor();

        public Price.PriceBuilder getOrCreateVarianceStrikePrice();

        @Override
        public Price.PriceBuilder getVarianceStrikePrice();

        public NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder getOrCreateVegaNotionalAmount();

        @Override
        public NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder getVegaNotionalAmount();

        public VolatilityCapFloor.VolatilityCapFloorBuilder getOrCreateVolatilityCapFloor();

        @Override
        public VolatilityCapFloor.VolatilityCapFloorBuilder getVolatilityCapFloor();

        public Price.PriceBuilder getOrCreateVolatilityStrikePrice();

        @Override
        public Price.PriceBuilder getVolatilityStrikePrice();

        public VarianceReturnTermsBuilder setExchangeTradedContractNearest(Observable var1);

        public VarianceReturnTermsBuilder setVarianceCapFloor(VarianceCapFloor var1);

        public VarianceReturnTermsBuilder setVarianceStrikePrice(Price var1);

        public VarianceReturnTermsBuilder setVegaNotionalAmount(NonNegativeQuantitySchedule var1);

        public VarianceReturnTermsBuilder setVolatilityCapFloor(VolatilityCapFloor var1);

        public VarianceReturnTermsBuilder setVolatilityStrikePrice(Price var1);

        @Override
        public VarianceReturnTermsBuilder setAnnualizationFactor(Integer var1);

        @Override
        public VarianceReturnTermsBuilder setDividendApplicability(DividendApplicability var1);

        @Override
        public VarianceReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions var1);

        @Override
        public VarianceReturnTermsBuilder setExpectedN(Integer var1);

        @Override
        public VarianceReturnTermsBuilder setInitialLevel(BigDecimal var1);

        @Override
        public VarianceReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum var1);

        @Override
        public VarianceReturnTermsBuilder setMeanAdjustment(Boolean var1);

        @Override
        public VarianceReturnTermsBuilder setPerformance(String var1);

        @Override
        public VarianceReturnTermsBuilder setSharePriceDividendAdjustment(Boolean var1);

        @Override
        public VarianceReturnTermsBuilder setValuationTerms(ValuationTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            ReturnTermsBase.ReturnTermsBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, Observable.ObservableBuilder.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("varianceCapFloor"), processor, VarianceCapFloor.VarianceCapFloorBuilder.class, this.getVarianceCapFloor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("varianceStrikePrice"), processor, Price.PriceBuilder.class, this.getVarianceStrikePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("vegaNotionalAmount"), processor, NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder.class, this.getVegaNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityCapFloor"), processor, VolatilityCapFloor.VolatilityCapFloorBuilder.class, this.getVolatilityCapFloor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityStrikePrice"), processor, Price.PriceBuilder.class, this.getVolatilityStrikePrice(), new AttributeMeta[0]);
        }

        @Override
        public VarianceReturnTermsBuilder prune();
    }
}

