/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.meta.TrancheMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Tranche
extends RosettaModelObject {
    public static final TrancheMeta metaData = new TrancheMeta();

    public Tranche build();

    public TrancheBuilder toBuilder();

    public BigDecimal getAttachmentPoint();

    public BigDecimal getExhaustionPoint();

    public Boolean getIncurredRecoveryApplicable();

    default public RosettaMetaData<? extends Tranche> metaData() {
        return metaData;
    }

    public static TrancheBuilder builder() {
        return new TrancheBuilderImpl();
    }

    default public Class<? extends Tranche> getType() {
        return Tranche.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("attachmentPoint"), BigDecimal.class, (Object)this.getAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exhaustionPoint"), BigDecimal.class, (Object)this.getExhaustionPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("incurredRecoveryApplicable"), Boolean.class, (Object)this.getIncurredRecoveryApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TrancheBuilderImpl
    implements TrancheBuilder {
        protected BigDecimal attachmentPoint;
        protected BigDecimal exhaustionPoint;
        protected Boolean incurredRecoveryApplicable;

        @Override
        public BigDecimal getAttachmentPoint() {
            return this.attachmentPoint;
        }

        @Override
        public BigDecimal getExhaustionPoint() {
            return this.exhaustionPoint;
        }

        @Override
        public Boolean getIncurredRecoveryApplicable() {
            return this.incurredRecoveryApplicable;
        }

        @Override
        public TrancheBuilder setAttachmentPoint(BigDecimal attachmentPoint) {
            this.attachmentPoint = attachmentPoint == null ? null : attachmentPoint;
            return this;
        }

        @Override
        public TrancheBuilder setExhaustionPoint(BigDecimal exhaustionPoint) {
            this.exhaustionPoint = exhaustionPoint == null ? null : exhaustionPoint;
            return this;
        }

        @Override
        public TrancheBuilder setIncurredRecoveryApplicable(Boolean incurredRecoveryApplicable) {
            this.incurredRecoveryApplicable = incurredRecoveryApplicable == null ? null : incurredRecoveryApplicable;
            return this;
        }

        @Override
        public Tranche build() {
            return new TrancheImpl(this);
        }

        @Override
        public TrancheBuilder toBuilder() {
            return this;
        }

        @Override
        public TrancheBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getAttachmentPoint() != null) {
                return true;
            }
            if (this.getExhaustionPoint() != null) {
                return true;
            }
            return this.getIncurredRecoveryApplicable() != null;
        }

        public TrancheBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TrancheBuilder o = (TrancheBuilder)other;
            merger.mergeBasic((Object)this.getAttachmentPoint(), (Object)o.getAttachmentPoint(), this::setAttachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExhaustionPoint(), (Object)o.getExhaustionPoint(), this::setExhaustionPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIncurredRecoveryApplicable(), (Object)o.getIncurredRecoveryApplicable(), this::setIncurredRecoveryApplicable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Tranche _that = this.getType().cast(o);
            if (!Objects.equals(this.attachmentPoint, _that.getAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.exhaustionPoint, _that.getExhaustionPoint())) {
                return false;
            }
            return Objects.equals(this.incurredRecoveryApplicable, _that.getIncurredRecoveryApplicable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.attachmentPoint != null ? this.attachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.exhaustionPoint != null ? this.exhaustionPoint.hashCode() : 0);
            _result = 31 * _result + (this.incurredRecoveryApplicable != null ? this.incurredRecoveryApplicable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TrancheBuilder {attachmentPoint=" + this.attachmentPoint + ", exhaustionPoint=" + this.exhaustionPoint + ", incurredRecoveryApplicable=" + this.incurredRecoveryApplicable + '}';
        }
    }

    public static class TrancheImpl
    implements Tranche {
        private final BigDecimal attachmentPoint;
        private final BigDecimal exhaustionPoint;
        private final Boolean incurredRecoveryApplicable;

        protected TrancheImpl(TrancheBuilder builder) {
            this.attachmentPoint = builder.getAttachmentPoint();
            this.exhaustionPoint = builder.getExhaustionPoint();
            this.incurredRecoveryApplicable = builder.getIncurredRecoveryApplicable();
        }

        @Override
        public BigDecimal getAttachmentPoint() {
            return this.attachmentPoint;
        }

        @Override
        public BigDecimal getExhaustionPoint() {
            return this.exhaustionPoint;
        }

        @Override
        public Boolean getIncurredRecoveryApplicable() {
            return this.incurredRecoveryApplicable;
        }

        @Override
        public Tranche build() {
            return this;
        }

        @Override
        public TrancheBuilder toBuilder() {
            TrancheBuilder builder = Tranche.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TrancheBuilder builder) {
            Optional.ofNullable(this.getAttachmentPoint()).ifPresent(builder::setAttachmentPoint);
            Optional.ofNullable(this.getExhaustionPoint()).ifPresent(builder::setExhaustionPoint);
            Optional.ofNullable(this.getIncurredRecoveryApplicable()).ifPresent(builder::setIncurredRecoveryApplicable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Tranche _that = this.getType().cast(o);
            if (!Objects.equals(this.attachmentPoint, _that.getAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.exhaustionPoint, _that.getExhaustionPoint())) {
                return false;
            }
            return Objects.equals(this.incurredRecoveryApplicable, _that.getIncurredRecoveryApplicable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.attachmentPoint != null ? this.attachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.exhaustionPoint != null ? this.exhaustionPoint.hashCode() : 0);
            _result = 31 * _result + (this.incurredRecoveryApplicable != null ? this.incurredRecoveryApplicable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Tranche {attachmentPoint=" + this.attachmentPoint + ", exhaustionPoint=" + this.exhaustionPoint + ", incurredRecoveryApplicable=" + this.incurredRecoveryApplicable + '}';
        }
    }

    public static interface TrancheBuilder
    extends Tranche,
    RosettaModelObjectBuilder {
        public TrancheBuilder setAttachmentPoint(BigDecimal var1);

        public TrancheBuilder setExhaustionPoint(BigDecimal var1);

        public TrancheBuilder setIncurredRecoveryApplicable(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("attachmentPoint"), BigDecimal.class, (Object)this.getAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exhaustionPoint"), BigDecimal.class, (Object)this.getExhaustionPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("incurredRecoveryApplicable"), Boolean.class, (Object)this.getIncurredRecoveryApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TrancheBuilder prune();
    }
}

