/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.observable.asset.Money;
import cdm.product.asset.StubFloatingRate;
import cdm.product.asset.meta.StubValueMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface StubValue
extends RosettaModelObject {
    public static final StubValueMeta metaData = new StubValueMeta();

    public StubValue build();

    public StubValueBuilder toBuilder();

    public List<? extends StubFloatingRate> getFloatingRate();

    public Money getStubAmount();

    public BigDecimal getStubRate();

    default public RosettaMetaData<? extends StubValue> metaData() {
        return metaData;
    }

    public static StubValueBuilder builder() {
        return new StubValueBuilderImpl();
    }

    default public Class<? extends StubValue> getType() {
        return StubValue.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("stubRate"), BigDecimal.class, (Object)this.getStubRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRate"), processor, StubFloatingRate.class, this.getFloatingRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubAmount"), processor, Money.class, this.getStubAmount(), new AttributeMeta[0]);
    }

    public static class StubValueBuilderImpl
    implements StubValueBuilder {
        protected List<StubFloatingRate.StubFloatingRateBuilder> floatingRate = new ArrayList<StubFloatingRate.StubFloatingRateBuilder>();
        protected Money.MoneyBuilder stubAmount;
        protected BigDecimal stubRate;

        @Override
        public List<? extends StubFloatingRate.StubFloatingRateBuilder> getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public StubFloatingRate.StubFloatingRateBuilder getOrCreateFloatingRate(int _index) {
            if (this.floatingRate == null) {
                this.floatingRate = new ArrayList<StubFloatingRate.StubFloatingRateBuilder>();
            }
            return (StubFloatingRate.StubFloatingRateBuilder)this.getIndex(this.floatingRate, _index, () -> {
                StubFloatingRate.StubFloatingRateBuilder newFloatingRate = StubFloatingRate.builder();
                return newFloatingRate;
            });
        }

        @Override
        public Money.MoneyBuilder getStubAmount() {
            return this.stubAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateStubAmount() {
            Money.MoneyBuilder result = this.stubAmount != null ? this.stubAmount : (this.stubAmount = Money.builder());
            return result;
        }

        @Override
        public BigDecimal getStubRate() {
            return this.stubRate;
        }

        @Override
        public StubValueBuilder addFloatingRate(StubFloatingRate floatingRate) {
            if (floatingRate != null) {
                this.floatingRate.add(floatingRate.toBuilder());
            }
            return this;
        }

        @Override
        public StubValueBuilder addFloatingRate(StubFloatingRate floatingRate, int _idx) {
            this.getIndex(this.floatingRate, _idx, () -> floatingRate.toBuilder());
            return this;
        }

        @Override
        public StubValueBuilder addFloatingRate(List<? extends StubFloatingRate> floatingRates) {
            if (floatingRates != null) {
                for (StubFloatingRate stubFloatingRate : floatingRates) {
                    this.floatingRate.add(stubFloatingRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        public StubValueBuilder setFloatingRate(List<? extends StubFloatingRate> floatingRates) {
            this.floatingRate = floatingRates == null ? new ArrayList<StubFloatingRate.StubFloatingRateBuilder>() : (List)floatingRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public StubValueBuilder setStubAmount(Money stubAmount) {
            this.stubAmount = stubAmount == null ? null : stubAmount.toBuilder();
            return this;
        }

        @Override
        public StubValueBuilder setStubRate(BigDecimal stubRate) {
            this.stubRate = stubRate == null ? null : stubRate;
            return this;
        }

        @Override
        public StubValue build() {
            return new StubValueImpl(this);
        }

        @Override
        public StubValueBuilder toBuilder() {
            return this;
        }

        @Override
        public StubValueBuilder prune() {
            this.floatingRate = this.floatingRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.stubAmount != null && !this.stubAmount.prune().hasData()) {
                this.stubAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFloatingRate() != null && this.getFloatingRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStubAmount() != null && this.getStubAmount().hasData()) {
                return true;
            }
            return this.getStubRate() != null;
        }

        public StubValueBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StubValueBuilder o = (StubValueBuilder)other;
            merger.mergeRosetta(this.getFloatingRate(), o.getFloatingRate(), this::getOrCreateFloatingRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStubAmount(), (RosettaModelObjectBuilder)o.getStubAmount(), this::setStubAmount);
            merger.mergeBasic((Object)this.getStubRate(), (Object)o.getStubRate(), this::setStubRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StubValue _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.stubAmount, _that.getStubAmount())) {
                return false;
            }
            return Objects.equals(this.stubRate, _that.getStubRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.stubAmount != null ? this.stubAmount.hashCode() : 0);
            _result = 31 * _result + (this.stubRate != null ? this.stubRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StubValueBuilder {floatingRate=" + this.floatingRate + ", stubAmount=" + this.stubAmount + ", stubRate=" + this.stubRate + '}';
        }
    }

    public static class StubValueImpl
    implements StubValue {
        private final List<? extends StubFloatingRate> floatingRate;
        private final Money stubAmount;
        private final BigDecimal stubRate;

        protected StubValueImpl(StubValueBuilder builder) {
            this.floatingRate = Optional.ofNullable(builder.getFloatingRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.stubAmount = Optional.ofNullable(builder.getStubAmount()).map(f -> f.build()).orElse(null);
            this.stubRate = builder.getStubRate();
        }

        @Override
        public List<? extends StubFloatingRate> getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public Money getStubAmount() {
            return this.stubAmount;
        }

        @Override
        public BigDecimal getStubRate() {
            return this.stubRate;
        }

        @Override
        public StubValue build() {
            return this;
        }

        @Override
        public StubValueBuilder toBuilder() {
            StubValueBuilder builder = StubValue.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StubValueBuilder builder) {
            Optional.ofNullable(this.getFloatingRate()).ifPresent(builder::setFloatingRate);
            Optional.ofNullable(this.getStubAmount()).ifPresent(builder::setStubAmount);
            Optional.ofNullable(this.getStubRate()).ifPresent(builder::setStubRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StubValue _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.stubAmount, _that.getStubAmount())) {
                return false;
            }
            return Objects.equals(this.stubRate, _that.getStubRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.stubAmount != null ? this.stubAmount.hashCode() : 0);
            _result = 31 * _result + (this.stubRate != null ? this.stubRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StubValue {floatingRate=" + this.floatingRate + ", stubAmount=" + this.stubAmount + ", stubRate=" + this.stubRate + '}';
        }
    }

    public static interface StubValueBuilder
    extends StubValue,
    RosettaModelObjectBuilder {
        public StubFloatingRate.StubFloatingRateBuilder getOrCreateFloatingRate(int var1);

        public List<? extends StubFloatingRate.StubFloatingRateBuilder> getFloatingRate();

        public Money.MoneyBuilder getOrCreateStubAmount();

        @Override
        public Money.MoneyBuilder getStubAmount();

        public StubValueBuilder addFloatingRate(StubFloatingRate var1);

        public StubValueBuilder addFloatingRate(StubFloatingRate var1, int var2);

        public StubValueBuilder addFloatingRate(List<? extends StubFloatingRate> var1);

        public StubValueBuilder setFloatingRate(List<? extends StubFloatingRate> var1);

        public StubValueBuilder setStubAmount(Money var1);

        public StubValueBuilder setStubRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("stubRate"), BigDecimal.class, (Object)this.getStubRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRate"), processor, StubFloatingRate.StubFloatingRateBuilder.class, this.getFloatingRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubAmount"), processor, Money.MoneyBuilder.class, this.getStubAmount(), new AttributeMeta[0]);
        }

        public StubValueBuilder prune();
    }
}

