/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.party.LegalEntity;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaLegalEntity;
import cdm.product.asset.meta.ReferenceObligationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ReferenceObligation
extends RosettaModelObject {
    public static final ReferenceObligationMeta metaData = new ReferenceObligationMeta();

    public ReferenceObligation build();

    public ReferenceObligationBuilder toBuilder();

    public LegalEntity getGuarantor();

    public String getGuarantorReference();

    public Loan getLoan();

    public LegalEntity getPrimaryObligor();

    public ReferenceWithMetaLegalEntity getPrimaryObligorReference();

    public Security getSecurity();

    public Boolean getStandardReferenceObligation();

    default public RosettaMetaData<? extends ReferenceObligation> metaData() {
        return metaData;
    }

    public static ReferenceObligationBuilder builder() {
        return new ReferenceObligationBuilderImpl();
    }

    default public Class<? extends ReferenceObligation> getType() {
        return ReferenceObligation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("guarantorReference"), String.class, (Object)this.getGuarantorReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("standardReferenceObligation"), Boolean.class, (Object)this.getStandardReferenceObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("guarantor"), processor, LegalEntity.class, this.getGuarantor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loan"), processor, Loan.class, this.getLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryObligor"), processor, LegalEntity.class, this.getPrimaryObligor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryObligorReference"), processor, ReferenceWithMetaLegalEntity.class, this.getPrimaryObligorReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("security"), processor, Security.class, this.getSecurity(), new AttributeMeta[0]);
    }

    public static class ReferenceObligationBuilderImpl
    implements ReferenceObligationBuilder {
        protected LegalEntity.LegalEntityBuilder guarantor;
        protected String guarantorReference;
        protected Loan.LoanBuilder loan;
        protected LegalEntity.LegalEntityBuilder primaryObligor;
        protected ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder primaryObligorReference;
        protected Security.SecurityBuilder security;
        protected Boolean standardReferenceObligation;

        @Override
        public LegalEntity.LegalEntityBuilder getGuarantor() {
            return this.guarantor;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateGuarantor() {
            LegalEntity.LegalEntityBuilder result = this.guarantor != null ? this.guarantor : (this.guarantor = LegalEntity.builder());
            return result;
        }

        @Override
        public String getGuarantorReference() {
            return this.guarantorReference;
        }

        @Override
        public Loan.LoanBuilder getLoan() {
            return this.loan;
        }

        @Override
        public Loan.LoanBuilder getOrCreateLoan() {
            Loan.LoanBuilder result = this.loan != null ? this.loan : (this.loan = Loan.builder());
            return result;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getPrimaryObligor() {
            return this.primaryObligor;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreatePrimaryObligor() {
            LegalEntity.LegalEntityBuilder result = this.primaryObligor != null ? this.primaryObligor : (this.primaryObligor = LegalEntity.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getPrimaryObligorReference() {
            return this.primaryObligorReference;
        }

        @Override
        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getOrCreatePrimaryObligorReference() {
            ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder result = this.primaryObligorReference != null ? this.primaryObligorReference : (this.primaryObligorReference = ReferenceWithMetaLegalEntity.builder());
            return result;
        }

        @Override
        public Security.SecurityBuilder getSecurity() {
            return this.security;
        }

        @Override
        public Security.SecurityBuilder getOrCreateSecurity() {
            Security.SecurityBuilder result = this.security != null ? this.security : (this.security = Security.builder());
            return result;
        }

        @Override
        public Boolean getStandardReferenceObligation() {
            return this.standardReferenceObligation;
        }

        @Override
        public ReferenceObligationBuilder setGuarantor(LegalEntity guarantor) {
            this.guarantor = guarantor == null ? null : guarantor.toBuilder();
            return this;
        }

        @Override
        public ReferenceObligationBuilder setGuarantorReference(String guarantorReference) {
            this.guarantorReference = guarantorReference == null ? null : guarantorReference;
            return this;
        }

        @Override
        public ReferenceObligationBuilder setLoan(Loan loan) {
            this.loan = loan == null ? null : loan.toBuilder();
            return this;
        }

        @Override
        public ReferenceObligationBuilder setPrimaryObligor(LegalEntity primaryObligor) {
            this.primaryObligor = primaryObligor == null ? null : primaryObligor.toBuilder();
            return this;
        }

        @Override
        public ReferenceObligationBuilder setPrimaryObligorReference(ReferenceWithMetaLegalEntity primaryObligorReference) {
            this.primaryObligorReference = primaryObligorReference == null ? null : primaryObligorReference.toBuilder();
            return this;
        }

        @Override
        public ReferenceObligationBuilder setPrimaryObligorReferenceValue(LegalEntity primaryObligorReference) {
            this.getOrCreatePrimaryObligorReference().setValue(primaryObligorReference);
            return this;
        }

        @Override
        public ReferenceObligationBuilder setSecurity(Security security) {
            this.security = security == null ? null : security.toBuilder();
            return this;
        }

        @Override
        public ReferenceObligationBuilder setStandardReferenceObligation(Boolean standardReferenceObligation) {
            this.standardReferenceObligation = standardReferenceObligation == null ? null : standardReferenceObligation;
            return this;
        }

        @Override
        public ReferenceObligation build() {
            return new ReferenceObligationImpl(this);
        }

        @Override
        public ReferenceObligationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReferenceObligationBuilder prune() {
            if (this.guarantor != null && !this.guarantor.prune().hasData()) {
                this.guarantor = null;
            }
            if (this.loan != null && !this.loan.prune().hasData()) {
                this.loan = null;
            }
            if (this.primaryObligor != null && !this.primaryObligor.prune().hasData()) {
                this.primaryObligor = null;
            }
            if (this.primaryObligorReference != null && !this.primaryObligorReference.prune().hasData()) {
                this.primaryObligorReference = null;
            }
            if (this.security != null && !this.security.prune().hasData()) {
                this.security = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getGuarantor() != null && this.getGuarantor().hasData()) {
                return true;
            }
            if (this.getGuarantorReference() != null) {
                return true;
            }
            if (this.getLoan() != null && this.getLoan().hasData()) {
                return true;
            }
            if (this.getPrimaryObligor() != null && this.getPrimaryObligor().hasData()) {
                return true;
            }
            if (this.getPrimaryObligorReference() != null && this.getPrimaryObligorReference().hasData()) {
                return true;
            }
            if (this.getSecurity() != null && this.getSecurity().hasData()) {
                return true;
            }
            return this.getStandardReferenceObligation() != null;
        }

        public ReferenceObligationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceObligationBuilder o = (ReferenceObligationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGuarantor(), (RosettaModelObjectBuilder)o.getGuarantor(), this::setGuarantor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoan(), (RosettaModelObjectBuilder)o.getLoan(), this::setLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryObligor(), (RosettaModelObjectBuilder)o.getPrimaryObligor(), this::setPrimaryObligor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryObligorReference(), (RosettaModelObjectBuilder)o.getPrimaryObligorReference(), this::setPrimaryObligorReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurity(), (RosettaModelObjectBuilder)o.getSecurity(), this::setSecurity);
            merger.mergeBasic((Object)this.getGuarantorReference(), (Object)o.getGuarantorReference(), this::setGuarantorReference, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStandardReferenceObligation(), (Object)o.getStandardReferenceObligation(), this::setStandardReferenceObligation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.guarantor, _that.getGuarantor())) {
                return false;
            }
            if (!Objects.equals(this.guarantorReference, _that.getGuarantorReference())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligor, _that.getPrimaryObligor())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligorReference, _that.getPrimaryObligorReference())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            return Objects.equals(this.standardReferenceObligation, _that.getStandardReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.guarantor != null ? this.guarantor.hashCode() : 0);
            _result = 31 * _result + (this.guarantorReference != null ? this.guarantorReference.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligor != null ? this.primaryObligor.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligorReference != null ? this.primaryObligorReference.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.standardReferenceObligation != null ? this.standardReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceObligationBuilder {guarantor=" + this.guarantor + ", guarantorReference=" + this.guarantorReference + ", loan=" + this.loan + ", primaryObligor=" + this.primaryObligor + ", primaryObligorReference=" + this.primaryObligorReference + ", security=" + this.security + ", standardReferenceObligation=" + this.standardReferenceObligation + '}';
        }
    }

    public static class ReferenceObligationImpl
    implements ReferenceObligation {
        private final LegalEntity guarantor;
        private final String guarantorReference;
        private final Loan loan;
        private final LegalEntity primaryObligor;
        private final ReferenceWithMetaLegalEntity primaryObligorReference;
        private final Security security;
        private final Boolean standardReferenceObligation;

        protected ReferenceObligationImpl(ReferenceObligationBuilder builder) {
            this.guarantor = Optional.ofNullable(builder.getGuarantor()).map(f -> f.build()).orElse(null);
            this.guarantorReference = builder.getGuarantorReference();
            this.loan = Optional.ofNullable(builder.getLoan()).map(f -> f.build()).orElse(null);
            this.primaryObligor = Optional.ofNullable(builder.getPrimaryObligor()).map(f -> f.build()).orElse(null);
            this.primaryObligorReference = Optional.ofNullable(builder.getPrimaryObligorReference()).map(f -> f.build()).orElse(null);
            this.security = Optional.ofNullable(builder.getSecurity()).map(f -> f.build()).orElse(null);
            this.standardReferenceObligation = builder.getStandardReferenceObligation();
        }

        @Override
        public LegalEntity getGuarantor() {
            return this.guarantor;
        }

        @Override
        public String getGuarantorReference() {
            return this.guarantorReference;
        }

        @Override
        public Loan getLoan() {
            return this.loan;
        }

        @Override
        public LegalEntity getPrimaryObligor() {
            return this.primaryObligor;
        }

        @Override
        public ReferenceWithMetaLegalEntity getPrimaryObligorReference() {
            return this.primaryObligorReference;
        }

        @Override
        public Security getSecurity() {
            return this.security;
        }

        @Override
        public Boolean getStandardReferenceObligation() {
            return this.standardReferenceObligation;
        }

        @Override
        public ReferenceObligation build() {
            return this;
        }

        @Override
        public ReferenceObligationBuilder toBuilder() {
            ReferenceObligationBuilder builder = ReferenceObligation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReferenceObligationBuilder builder) {
            Optional.ofNullable(this.getGuarantor()).ifPresent(builder::setGuarantor);
            Optional.ofNullable(this.getGuarantorReference()).ifPresent(builder::setGuarantorReference);
            Optional.ofNullable(this.getLoan()).ifPresent(builder::setLoan);
            Optional.ofNullable(this.getPrimaryObligor()).ifPresent(builder::setPrimaryObligor);
            Optional.ofNullable(this.getPrimaryObligorReference()).ifPresent(builder::setPrimaryObligorReference);
            Optional.ofNullable(this.getSecurity()).ifPresent(builder::setSecurity);
            Optional.ofNullable(this.getStandardReferenceObligation()).ifPresent(builder::setStandardReferenceObligation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.guarantor, _that.getGuarantor())) {
                return false;
            }
            if (!Objects.equals(this.guarantorReference, _that.getGuarantorReference())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligor, _that.getPrimaryObligor())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligorReference, _that.getPrimaryObligorReference())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            return Objects.equals(this.standardReferenceObligation, _that.getStandardReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.guarantor != null ? this.guarantor.hashCode() : 0);
            _result = 31 * _result + (this.guarantorReference != null ? this.guarantorReference.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligor != null ? this.primaryObligor.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligorReference != null ? this.primaryObligorReference.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.standardReferenceObligation != null ? this.standardReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceObligation {guarantor=" + this.guarantor + ", guarantorReference=" + this.guarantorReference + ", loan=" + this.loan + ", primaryObligor=" + this.primaryObligor + ", primaryObligorReference=" + this.primaryObligorReference + ", security=" + this.security + ", standardReferenceObligation=" + this.standardReferenceObligation + '}';
        }
    }

    public static interface ReferenceObligationBuilder
    extends ReferenceObligation,
    RosettaModelObjectBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateGuarantor();

        @Override
        public LegalEntity.LegalEntityBuilder getGuarantor();

        public Loan.LoanBuilder getOrCreateLoan();

        @Override
        public Loan.LoanBuilder getLoan();

        public LegalEntity.LegalEntityBuilder getOrCreatePrimaryObligor();

        @Override
        public LegalEntity.LegalEntityBuilder getPrimaryObligor();

        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getOrCreatePrimaryObligorReference();

        @Override
        public ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder getPrimaryObligorReference();

        public Security.SecurityBuilder getOrCreateSecurity();

        @Override
        public Security.SecurityBuilder getSecurity();

        public ReferenceObligationBuilder setGuarantor(LegalEntity var1);

        public ReferenceObligationBuilder setGuarantorReference(String var1);

        public ReferenceObligationBuilder setLoan(Loan var1);

        public ReferenceObligationBuilder setPrimaryObligor(LegalEntity var1);

        public ReferenceObligationBuilder setPrimaryObligorReference(ReferenceWithMetaLegalEntity var1);

        public ReferenceObligationBuilder setPrimaryObligorReferenceValue(LegalEntity var1);

        public ReferenceObligationBuilder setSecurity(Security var1);

        public ReferenceObligationBuilder setStandardReferenceObligation(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("guarantorReference"), String.class, (Object)this.getGuarantorReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("standardReferenceObligation"), Boolean.class, (Object)this.getStandardReferenceObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("guarantor"), processor, LegalEntity.LegalEntityBuilder.class, this.getGuarantor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loan"), processor, Loan.LoanBuilder.class, this.getLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryObligor"), processor, LegalEntity.LegalEntityBuilder.class, this.getPrimaryObligor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryObligorReference"), processor, ReferenceWithMetaLegalEntity.ReferenceWithMetaLegalEntityBuilder.class, this.getPrimaryObligorReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("security"), processor, Security.SecurityBuilder.class, this.getSecurity(), new AttributeMeta[0]);
        }

        public ReferenceObligationBuilder prune();
    }
}

