/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.Price;
import cdm.product.asset.ReferenceObligation;
import cdm.product.asset.meta.ReferenceInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface ReferenceInformation
extends RosettaModelObject {
    public static final ReferenceInformationMeta metaData = new ReferenceInformationMeta();

    public ReferenceInformation build();

    public ReferenceInformationBuilder toBuilder();

    public Boolean getAllGuarantees();

    public Boolean getNoReferenceObligation();

    public LegalEntity getReferenceEntity();

    public List<? extends ReferenceObligation> getReferenceObligation();

    public Boolean getReferencePolicy();

    public Price getReferencePrice();

    public Boolean getSecuredList();

    public Boolean getUnknownReferenceObligation();

    default public RosettaMetaData<? extends ReferenceInformation> metaData() {
        return metaData;
    }

    public static ReferenceInformationBuilder builder() {
        return new ReferenceInformationBuilderImpl();
    }

    default public Class<? extends ReferenceInformation> getType() {
        return ReferenceInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("allGuarantees"), Boolean.class, (Object)this.getAllGuarantees(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noReferenceObligation"), Boolean.class, (Object)this.getNoReferenceObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referencePolicy"), Boolean.class, (Object)this.getReferencePolicy(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("securedList"), Boolean.class, (Object)this.getSecuredList(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("unknownReferenceObligation"), Boolean.class, (Object)this.getUnknownReferenceObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceEntity"), processor, LegalEntity.class, this.getReferenceEntity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceObligation"), processor, ReferenceObligation.class, this.getReferenceObligation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referencePrice"), processor, Price.class, this.getReferencePrice(), new AttributeMeta[0]);
    }

    public static class ReferenceInformationBuilderImpl
    implements ReferenceInformationBuilder {
        protected Boolean allGuarantees;
        protected Boolean noReferenceObligation;
        protected LegalEntity.LegalEntityBuilder referenceEntity;
        protected List<ReferenceObligation.ReferenceObligationBuilder> referenceObligation = new ArrayList<ReferenceObligation.ReferenceObligationBuilder>();
        protected Boolean referencePolicy;
        protected Price.PriceBuilder referencePrice;
        protected Boolean securedList;
        protected Boolean unknownReferenceObligation;

        @Override
        public Boolean getAllGuarantees() {
            return this.allGuarantees;
        }

        @Override
        public Boolean getNoReferenceObligation() {
            return this.noReferenceObligation;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateReferenceEntity() {
            LegalEntity.LegalEntityBuilder result = this.referenceEntity != null ? this.referenceEntity : (this.referenceEntity = LegalEntity.builder());
            return result;
        }

        @Override
        public List<? extends ReferenceObligation.ReferenceObligationBuilder> getReferenceObligation() {
            return this.referenceObligation;
        }

        @Override
        public ReferenceObligation.ReferenceObligationBuilder getOrCreateReferenceObligation(int _index) {
            if (this.referenceObligation == null) {
                this.referenceObligation = new ArrayList<ReferenceObligation.ReferenceObligationBuilder>();
            }
            return (ReferenceObligation.ReferenceObligationBuilder)this.getIndex(this.referenceObligation, _index, () -> {
                ReferenceObligation.ReferenceObligationBuilder newReferenceObligation = ReferenceObligation.builder();
                return newReferenceObligation;
            });
        }

        @Override
        public Boolean getReferencePolicy() {
            return this.referencePolicy;
        }

        @Override
        public Price.PriceBuilder getReferencePrice() {
            return this.referencePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateReferencePrice() {
            Price.PriceBuilder result = this.referencePrice != null ? this.referencePrice : (this.referencePrice = Price.builder());
            return result;
        }

        @Override
        public Boolean getSecuredList() {
            return this.securedList;
        }

        @Override
        public Boolean getUnknownReferenceObligation() {
            return this.unknownReferenceObligation;
        }

        @Override
        public ReferenceInformationBuilder setAllGuarantees(Boolean allGuarantees) {
            this.allGuarantees = allGuarantees == null ? null : allGuarantees;
            return this;
        }

        @Override
        public ReferenceInformationBuilder setNoReferenceObligation(Boolean noReferenceObligation) {
            this.noReferenceObligation = noReferenceObligation == null ? null : noReferenceObligation;
            return this;
        }

        @Override
        public ReferenceInformationBuilder setReferenceEntity(LegalEntity referenceEntity) {
            this.referenceEntity = referenceEntity == null ? null : referenceEntity.toBuilder();
            return this;
        }

        @Override
        public ReferenceInformationBuilder addReferenceObligation(ReferenceObligation referenceObligation) {
            if (referenceObligation != null) {
                this.referenceObligation.add(referenceObligation.toBuilder());
            }
            return this;
        }

        @Override
        public ReferenceInformationBuilder addReferenceObligation(ReferenceObligation referenceObligation, int _idx) {
            this.getIndex(this.referenceObligation, _idx, () -> referenceObligation.toBuilder());
            return this;
        }

        @Override
        public ReferenceInformationBuilder addReferenceObligation(List<? extends ReferenceObligation> referenceObligations) {
            if (referenceObligations != null) {
                for (ReferenceObligation referenceObligation : referenceObligations) {
                    this.referenceObligation.add(referenceObligation.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ReferenceInformationBuilder setReferenceObligation(List<? extends ReferenceObligation> referenceObligations) {
            this.referenceObligation = referenceObligations == null ? new ArrayList<ReferenceObligation.ReferenceObligationBuilder>() : (List)referenceObligations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ReferenceInformationBuilder setReferencePolicy(Boolean referencePolicy) {
            this.referencePolicy = referencePolicy == null ? null : referencePolicy;
            return this;
        }

        @Override
        public ReferenceInformationBuilder setReferencePrice(Price referencePrice) {
            this.referencePrice = referencePrice == null ? null : referencePrice.toBuilder();
            return this;
        }

        @Override
        public ReferenceInformationBuilder setSecuredList(Boolean securedList) {
            this.securedList = securedList == null ? null : securedList;
            return this;
        }

        @Override
        public ReferenceInformationBuilder setUnknownReferenceObligation(Boolean unknownReferenceObligation) {
            this.unknownReferenceObligation = unknownReferenceObligation == null ? null : unknownReferenceObligation;
            return this;
        }

        @Override
        public ReferenceInformation build() {
            return new ReferenceInformationImpl(this);
        }

        @Override
        public ReferenceInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReferenceInformationBuilder prune() {
            if (this.referenceEntity != null && !this.referenceEntity.prune().hasData()) {
                this.referenceEntity = null;
            }
            this.referenceObligation = this.referenceObligation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.referencePrice != null && !this.referencePrice.prune().hasData()) {
                this.referencePrice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAllGuarantees() != null) {
                return true;
            }
            if (this.getNoReferenceObligation() != null) {
                return true;
            }
            if (this.getReferenceEntity() != null && this.getReferenceEntity().hasData()) {
                return true;
            }
            if (this.getReferenceObligation() != null && this.getReferenceObligation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getReferencePolicy() != null) {
                return true;
            }
            if (this.getReferencePrice() != null && this.getReferencePrice().hasData()) {
                return true;
            }
            if (this.getSecuredList() != null) {
                return true;
            }
            return this.getUnknownReferenceObligation() != null;
        }

        public ReferenceInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceInformationBuilder o = (ReferenceInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceEntity(), (RosettaModelObjectBuilder)o.getReferenceEntity(), this::setReferenceEntity);
            merger.mergeRosetta(this.getReferenceObligation(), o.getReferenceObligation(), this::getOrCreateReferenceObligation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferencePrice(), (RosettaModelObjectBuilder)o.getReferencePrice(), this::setReferencePrice);
            merger.mergeBasic((Object)this.getAllGuarantees(), (Object)o.getAllGuarantees(), this::setAllGuarantees, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNoReferenceObligation(), (Object)o.getNoReferenceObligation(), this::setNoReferenceObligation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReferencePolicy(), (Object)o.getReferencePolicy(), this::setReferencePolicy, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSecuredList(), (Object)o.getSecuredList(), this::setSecuredList, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnknownReferenceObligation(), (Object)o.getUnknownReferenceObligation(), this::setUnknownReferenceObligation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.allGuarantees, _that.getAllGuarantees())) {
                return false;
            }
            if (!Objects.equals(this.noReferenceObligation, _that.getNoReferenceObligation())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.referenceObligation, _that.getReferenceObligation())) {
                return false;
            }
            if (!Objects.equals(this.referencePolicy, _that.getReferencePolicy())) {
                return false;
            }
            if (!Objects.equals(this.referencePrice, _that.getReferencePrice())) {
                return false;
            }
            if (!Objects.equals(this.securedList, _that.getSecuredList())) {
                return false;
            }
            return Objects.equals(this.unknownReferenceObligation, _that.getUnknownReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allGuarantees != null ? this.allGuarantees.hashCode() : 0);
            _result = 31 * _result + (this.noReferenceObligation != null ? this.noReferenceObligation.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.referenceObligation != null ? this.referenceObligation.hashCode() : 0);
            _result = 31 * _result + (this.referencePolicy != null ? this.referencePolicy.hashCode() : 0);
            _result = 31 * _result + (this.referencePrice != null ? this.referencePrice.hashCode() : 0);
            _result = 31 * _result + (this.securedList != null ? this.securedList.hashCode() : 0);
            _result = 31 * _result + (this.unknownReferenceObligation != null ? this.unknownReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceInformationBuilder {allGuarantees=" + this.allGuarantees + ", noReferenceObligation=" + this.noReferenceObligation + ", referenceEntity=" + this.referenceEntity + ", referenceObligation=" + this.referenceObligation + ", referencePolicy=" + this.referencePolicy + ", referencePrice=" + this.referencePrice + ", securedList=" + this.securedList + ", unknownReferenceObligation=" + this.unknownReferenceObligation + '}';
        }
    }

    public static class ReferenceInformationImpl
    implements ReferenceInformation {
        private final Boolean allGuarantees;
        private final Boolean noReferenceObligation;
        private final LegalEntity referenceEntity;
        private final List<? extends ReferenceObligation> referenceObligation;
        private final Boolean referencePolicy;
        private final Price referencePrice;
        private final Boolean securedList;
        private final Boolean unknownReferenceObligation;

        protected ReferenceInformationImpl(ReferenceInformationBuilder builder) {
            this.allGuarantees = builder.getAllGuarantees();
            this.noReferenceObligation = builder.getNoReferenceObligation();
            this.referenceEntity = Optional.ofNullable(builder.getReferenceEntity()).map(f -> f.build()).orElse(null);
            this.referenceObligation = Optional.ofNullable(builder.getReferenceObligation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.referencePolicy = builder.getReferencePolicy();
            this.referencePrice = Optional.ofNullable(builder.getReferencePrice()).map(f -> f.build()).orElse(null);
            this.securedList = builder.getSecuredList();
            this.unknownReferenceObligation = builder.getUnknownReferenceObligation();
        }

        @Override
        public Boolean getAllGuarantees() {
            return this.allGuarantees;
        }

        @Override
        public Boolean getNoReferenceObligation() {
            return this.noReferenceObligation;
        }

        @Override
        public LegalEntity getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        public List<? extends ReferenceObligation> getReferenceObligation() {
            return this.referenceObligation;
        }

        @Override
        public Boolean getReferencePolicy() {
            return this.referencePolicy;
        }

        @Override
        public Price getReferencePrice() {
            return this.referencePrice;
        }

        @Override
        public Boolean getSecuredList() {
            return this.securedList;
        }

        @Override
        public Boolean getUnknownReferenceObligation() {
            return this.unknownReferenceObligation;
        }

        @Override
        public ReferenceInformation build() {
            return this;
        }

        @Override
        public ReferenceInformationBuilder toBuilder() {
            ReferenceInformationBuilder builder = ReferenceInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReferenceInformationBuilder builder) {
            Optional.ofNullable(this.getAllGuarantees()).ifPresent(builder::setAllGuarantees);
            Optional.ofNullable(this.getNoReferenceObligation()).ifPresent(builder::setNoReferenceObligation);
            Optional.ofNullable(this.getReferenceEntity()).ifPresent(builder::setReferenceEntity);
            Optional.ofNullable(this.getReferenceObligation()).ifPresent(builder::setReferenceObligation);
            Optional.ofNullable(this.getReferencePolicy()).ifPresent(builder::setReferencePolicy);
            Optional.ofNullable(this.getReferencePrice()).ifPresent(builder::setReferencePrice);
            Optional.ofNullable(this.getSecuredList()).ifPresent(builder::setSecuredList);
            Optional.ofNullable(this.getUnknownReferenceObligation()).ifPresent(builder::setUnknownReferenceObligation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.allGuarantees, _that.getAllGuarantees())) {
                return false;
            }
            if (!Objects.equals(this.noReferenceObligation, _that.getNoReferenceObligation())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.referenceObligation, _that.getReferenceObligation())) {
                return false;
            }
            if (!Objects.equals(this.referencePolicy, _that.getReferencePolicy())) {
                return false;
            }
            if (!Objects.equals(this.referencePrice, _that.getReferencePrice())) {
                return false;
            }
            if (!Objects.equals(this.securedList, _that.getSecuredList())) {
                return false;
            }
            return Objects.equals(this.unknownReferenceObligation, _that.getUnknownReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allGuarantees != null ? this.allGuarantees.hashCode() : 0);
            _result = 31 * _result + (this.noReferenceObligation != null ? this.noReferenceObligation.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.referenceObligation != null ? this.referenceObligation.hashCode() : 0);
            _result = 31 * _result + (this.referencePolicy != null ? this.referencePolicy.hashCode() : 0);
            _result = 31 * _result + (this.referencePrice != null ? this.referencePrice.hashCode() : 0);
            _result = 31 * _result + (this.securedList != null ? this.securedList.hashCode() : 0);
            _result = 31 * _result + (this.unknownReferenceObligation != null ? this.unknownReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceInformation {allGuarantees=" + this.allGuarantees + ", noReferenceObligation=" + this.noReferenceObligation + ", referenceEntity=" + this.referenceEntity + ", referenceObligation=" + this.referenceObligation + ", referencePolicy=" + this.referencePolicy + ", referencePrice=" + this.referencePrice + ", securedList=" + this.securedList + ", unknownReferenceObligation=" + this.unknownReferenceObligation + '}';
        }
    }

    public static interface ReferenceInformationBuilder
    extends ReferenceInformation,
    RosettaModelObjectBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateReferenceEntity();

        @Override
        public LegalEntity.LegalEntityBuilder getReferenceEntity();

        public ReferenceObligation.ReferenceObligationBuilder getOrCreateReferenceObligation(int var1);

        public List<? extends ReferenceObligation.ReferenceObligationBuilder> getReferenceObligation();

        public Price.PriceBuilder getOrCreateReferencePrice();

        @Override
        public Price.PriceBuilder getReferencePrice();

        public ReferenceInformationBuilder setAllGuarantees(Boolean var1);

        public ReferenceInformationBuilder setNoReferenceObligation(Boolean var1);

        public ReferenceInformationBuilder setReferenceEntity(LegalEntity var1);

        public ReferenceInformationBuilder addReferenceObligation(ReferenceObligation var1);

        public ReferenceInformationBuilder addReferenceObligation(ReferenceObligation var1, int var2);

        public ReferenceInformationBuilder addReferenceObligation(List<? extends ReferenceObligation> var1);

        public ReferenceInformationBuilder setReferenceObligation(List<? extends ReferenceObligation> var1);

        public ReferenceInformationBuilder setReferencePolicy(Boolean var1);

        public ReferenceInformationBuilder setReferencePrice(Price var1);

        public ReferenceInformationBuilder setSecuredList(Boolean var1);

        public ReferenceInformationBuilder setUnknownReferenceObligation(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("allGuarantees"), Boolean.class, (Object)this.getAllGuarantees(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noReferenceObligation"), Boolean.class, (Object)this.getNoReferenceObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referencePolicy"), Boolean.class, (Object)this.getReferencePolicy(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("securedList"), Boolean.class, (Object)this.getSecuredList(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("unknownReferenceObligation"), Boolean.class, (Object)this.getUnknownReferenceObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceEntity"), processor, LegalEntity.LegalEntityBuilder.class, this.getReferenceEntity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceObligation"), processor, ReferenceObligation.ReferenceObligationBuilder.class, this.getReferenceObligation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referencePrice"), processor, Price.PriceBuilder.class, this.getReferencePrice(), new AttributeMeta[0]);
        }

        public ReferenceInformationBuilder prune();
    }
}

