/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.observable.asset.PriceSchedule;
import cdm.product.asset.ReturnTypeEnum;
import cdm.product.asset.meta.PriceReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface PriceReturnTerms
extends RosettaModelObject {
    public static final PriceReturnTermsMeta metaData = new PriceReturnTermsMeta();

    public PriceReturnTerms build();

    public PriceReturnTermsBuilder toBuilder();

    public BigDecimal getConversionFactor();

    public String getPerformance();

    public ReturnTypeEnum getReturnType();

    public PriceSchedule getValuationPriceFinal();

    public PriceSchedule getValuationPriceInitial();

    default public RosettaMetaData<? extends PriceReturnTerms> metaData() {
        return metaData;
    }

    public static PriceReturnTermsBuilder builder() {
        return new PriceReturnTermsBuilderImpl();
    }

    default public Class<? extends PriceReturnTerms> getType() {
        return PriceReturnTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("performance"), String.class, (Object)this.getPerformance(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("returnType"), ReturnTypeEnum.class, (Object)this.getReturnType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationPriceFinal"), processor, PriceSchedule.class, this.getValuationPriceFinal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationPriceInitial"), processor, PriceSchedule.class, this.getValuationPriceInitial(), new AttributeMeta[0]);
    }

    public static class PriceReturnTermsBuilderImpl
    implements PriceReturnTermsBuilder {
        protected BigDecimal conversionFactor;
        protected String performance;
        protected ReturnTypeEnum returnType;
        protected PriceSchedule.PriceScheduleBuilder valuationPriceFinal;
        protected PriceSchedule.PriceScheduleBuilder valuationPriceInitial;

        @Override
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        public String getPerformance() {
            return this.performance;
        }

        @Override
        public ReturnTypeEnum getReturnType() {
            return this.returnType;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getValuationPriceFinal() {
            return this.valuationPriceFinal;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getOrCreateValuationPriceFinal() {
            PriceSchedule.PriceScheduleBuilder result = this.valuationPriceFinal != null ? this.valuationPriceFinal : (this.valuationPriceFinal = PriceSchedule.builder());
            return result;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getValuationPriceInitial() {
            return this.valuationPriceInitial;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getOrCreateValuationPriceInitial() {
            PriceSchedule.PriceScheduleBuilder result = this.valuationPriceInitial != null ? this.valuationPriceInitial : (this.valuationPriceInitial = PriceSchedule.builder());
            return result;
        }

        @Override
        public PriceReturnTermsBuilder setConversionFactor(BigDecimal conversionFactor) {
            this.conversionFactor = conversionFactor == null ? null : conversionFactor;
            return this;
        }

        @Override
        public PriceReturnTermsBuilder setPerformance(String performance) {
            this.performance = performance == null ? null : performance;
            return this;
        }

        @Override
        public PriceReturnTermsBuilder setReturnType(ReturnTypeEnum returnType) {
            this.returnType = returnType == null ? null : returnType;
            return this;
        }

        @Override
        public PriceReturnTermsBuilder setValuationPriceFinal(PriceSchedule valuationPriceFinal) {
            this.valuationPriceFinal = valuationPriceFinal == null ? null : valuationPriceFinal.toBuilder();
            return this;
        }

        @Override
        public PriceReturnTermsBuilder setValuationPriceInitial(PriceSchedule valuationPriceInitial) {
            this.valuationPriceInitial = valuationPriceInitial == null ? null : valuationPriceInitial.toBuilder();
            return this;
        }

        @Override
        public PriceReturnTerms build() {
            return new PriceReturnTermsImpl(this);
        }

        @Override
        public PriceReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceReturnTermsBuilder prune() {
            if (this.valuationPriceFinal != null && !this.valuationPriceFinal.prune().hasData()) {
                this.valuationPriceFinal = null;
            }
            if (this.valuationPriceInitial != null && !this.valuationPriceInitial.prune().hasData()) {
                this.valuationPriceInitial = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getConversionFactor() != null) {
                return true;
            }
            if (this.getPerformance() != null) {
                return true;
            }
            if (this.getReturnType() != null) {
                return true;
            }
            if (this.getValuationPriceFinal() != null && this.getValuationPriceFinal().hasData()) {
                return true;
            }
            return this.getValuationPriceInitial() != null && this.getValuationPriceInitial().hasData();
        }

        public PriceReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PriceReturnTermsBuilder o = (PriceReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationPriceFinal(), (RosettaModelObjectBuilder)o.getValuationPriceFinal(), this::setValuationPriceFinal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationPriceInitial(), (RosettaModelObjectBuilder)o.getValuationPriceInitial(), this::setValuationPriceInitial);
            merger.mergeBasic((Object)this.getConversionFactor(), (Object)o.getConversionFactor(), this::setConversionFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPerformance(), (Object)o.getPerformance(), this::setPerformance, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReturnType(), (Object)o.getReturnType(), this::setReturnType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceReturnTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            if (!Objects.equals(this.performance, _that.getPerformance())) {
                return false;
            }
            if (!Objects.equals((Object)this.returnType, (Object)_that.getReturnType())) {
                return false;
            }
            if (!Objects.equals(this.valuationPriceFinal, _that.getValuationPriceFinal())) {
                return false;
            }
            return Objects.equals(this.valuationPriceInitial, _that.getValuationPriceInitial());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.performance != null ? this.performance.hashCode() : 0);
            _result = 31 * _result + (this.returnType != null ? ((Object)((Object)this.returnType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceFinal != null ? this.valuationPriceFinal.hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceInitial != null ? this.valuationPriceInitial.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceReturnTermsBuilder {conversionFactor=" + this.conversionFactor + ", performance=" + this.performance + ", returnType=" + (Object)((Object)this.returnType) + ", valuationPriceFinal=" + this.valuationPriceFinal + ", valuationPriceInitial=" + this.valuationPriceInitial + '}';
        }
    }

    public static class PriceReturnTermsImpl
    implements PriceReturnTerms {
        private final BigDecimal conversionFactor;
        private final String performance;
        private final ReturnTypeEnum returnType;
        private final PriceSchedule valuationPriceFinal;
        private final PriceSchedule valuationPriceInitial;

        protected PriceReturnTermsImpl(PriceReturnTermsBuilder builder) {
            this.conversionFactor = builder.getConversionFactor();
            this.performance = builder.getPerformance();
            this.returnType = builder.getReturnType();
            this.valuationPriceFinal = Optional.ofNullable(builder.getValuationPriceFinal()).map(f -> f.build()).orElse(null);
            this.valuationPriceInitial = Optional.ofNullable(builder.getValuationPriceInitial()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        public String getPerformance() {
            return this.performance;
        }

        @Override
        public ReturnTypeEnum getReturnType() {
            return this.returnType;
        }

        @Override
        public PriceSchedule getValuationPriceFinal() {
            return this.valuationPriceFinal;
        }

        @Override
        public PriceSchedule getValuationPriceInitial() {
            return this.valuationPriceInitial;
        }

        @Override
        public PriceReturnTerms build() {
            return this;
        }

        @Override
        public PriceReturnTermsBuilder toBuilder() {
            PriceReturnTermsBuilder builder = PriceReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceReturnTermsBuilder builder) {
            Optional.ofNullable(this.getConversionFactor()).ifPresent(builder::setConversionFactor);
            Optional.ofNullable(this.getPerformance()).ifPresent(builder::setPerformance);
            Optional.ofNullable(this.getReturnType()).ifPresent(builder::setReturnType);
            Optional.ofNullable(this.getValuationPriceFinal()).ifPresent(builder::setValuationPriceFinal);
            Optional.ofNullable(this.getValuationPriceInitial()).ifPresent(builder::setValuationPriceInitial);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceReturnTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            if (!Objects.equals(this.performance, _that.getPerformance())) {
                return false;
            }
            if (!Objects.equals((Object)this.returnType, (Object)_that.getReturnType())) {
                return false;
            }
            if (!Objects.equals(this.valuationPriceFinal, _that.getValuationPriceFinal())) {
                return false;
            }
            return Objects.equals(this.valuationPriceInitial, _that.getValuationPriceInitial());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.performance != null ? this.performance.hashCode() : 0);
            _result = 31 * _result + (this.returnType != null ? ((Object)((Object)this.returnType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceFinal != null ? this.valuationPriceFinal.hashCode() : 0);
            _result = 31 * _result + (this.valuationPriceInitial != null ? this.valuationPriceInitial.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceReturnTerms {conversionFactor=" + this.conversionFactor + ", performance=" + this.performance + ", returnType=" + (Object)((Object)this.returnType) + ", valuationPriceFinal=" + this.valuationPriceFinal + ", valuationPriceInitial=" + this.valuationPriceInitial + '}';
        }
    }

    public static interface PriceReturnTermsBuilder
    extends PriceReturnTerms,
    RosettaModelObjectBuilder {
        public PriceSchedule.PriceScheduleBuilder getOrCreateValuationPriceFinal();

        @Override
        public PriceSchedule.PriceScheduleBuilder getValuationPriceFinal();

        public PriceSchedule.PriceScheduleBuilder getOrCreateValuationPriceInitial();

        @Override
        public PriceSchedule.PriceScheduleBuilder getValuationPriceInitial();

        public PriceReturnTermsBuilder setConversionFactor(BigDecimal var1);

        public PriceReturnTermsBuilder setPerformance(String var1);

        public PriceReturnTermsBuilder setReturnType(ReturnTypeEnum var1);

        public PriceReturnTermsBuilder setValuationPriceFinal(PriceSchedule var1);

        public PriceReturnTermsBuilder setValuationPriceInitial(PriceSchedule var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("performance"), String.class, (Object)this.getPerformance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("returnType"), ReturnTypeEnum.class, (Object)this.getReturnType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationPriceFinal"), processor, PriceSchedule.PriceScheduleBuilder.class, this.getValuationPriceFinal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationPriceInitial"), processor, PriceSchedule.PriceScheduleBuilder.class, this.getValuationPriceInitial(), new AttributeMeta[0]);
        }

        public PriceReturnTermsBuilder prune();
    }
}

