/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.BondReference;
import cdm.product.asset.CashflowRepresentation;
import cdm.product.asset.CompoundingMethodEnum;
import cdm.product.asset.DiscountingMethod;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.meta.InterestRatePayoutMeta;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.schedule.ResetDates;
import cdm.product.common.schedule.StubPeriod;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface InterestRatePayout
extends PayoutBase,
GlobalKey {
    public static final InterestRatePayoutMeta metaData = new InterestRatePayoutMeta();

    @Override
    public InterestRatePayout build();

    @Override
    public InterestRatePayoutBuilder toBuilder();

    public BondReference getBondReference();

    public CalculationPeriodDates getCalculationPeriodDates();

    public CashflowRepresentation getCashflowRepresentation();

    public CompoundingMethodEnum getCompoundingMethod();

    public FieldWithMetaDayCountFractionEnum getDayCountFraction();

    public DiscountingMethod getDiscountingMethod();

    public String getFixedAmount();

    public String getFloatingAmount();

    public MetaFields getMeta();

    public AdjustableDate getPaymentDate();

    public PaymentDates getPaymentDates();

    public Boolean getPaymentDelay();

    public RateSpecification getRateSpecification();

    public ResetDates getResetDates();

    public StubPeriod getStubPeriod();

    default public RosettaMetaData<? extends InterestRatePayout> metaData() {
        return metaData;
    }

    public static InterestRatePayoutBuilder builder() {
        return new InterestRatePayoutBuilderImpl();
    }

    default public Class<? extends InterestRatePayout> getType() {
        return InterestRatePayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedAmount"), String.class, (Object)this.getFixedAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingAmount"), String.class, (Object)this.getFloatingAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentDelay"), Boolean.class, (Object)this.getPaymentDelay(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondReference"), processor, BondReference.class, this.getBondReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashflowRepresentation"), processor, CashflowRepresentation.class, this.getCashflowRepresentation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, FieldWithMetaDayCountFractionEnum.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("discountingMethod"), processor, DiscountingMethod.class, this.getDiscountingMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateSpecification"), processor, RateSpecification.class, this.getRateSpecification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resetDates"), processor, ResetDates.class, this.getResetDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubPeriod"), processor, StubPeriod.class, this.getStubPeriod(), new AttributeMeta[0]);
    }

    public static class InterestRatePayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements InterestRatePayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected BondReference.BondReferenceBuilder bondReference;
        protected CalculationPeriodDates.CalculationPeriodDatesBuilder calculationPeriodDates;
        protected CashflowRepresentation.CashflowRepresentationBuilder cashflowRepresentation;
        protected CompoundingMethodEnum compoundingMethod;
        protected FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder dayCountFraction;
        protected DiscountingMethod.DiscountingMethodBuilder discountingMethod;
        protected String fixedAmount;
        protected String floatingAmount;
        protected MetaFields.MetaFieldsBuilder meta;
        protected AdjustableDate.AdjustableDateBuilder paymentDate;
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected Boolean paymentDelay;
        protected RateSpecification.RateSpecificationBuilder rateSpecification;
        protected ResetDates.ResetDatesBuilder resetDates;
        protected StubPeriod.StubPeriodBuilder stubPeriod;

        @Override
        public BondReference.BondReferenceBuilder getBondReference() {
            return this.bondReference;
        }

        @Override
        public BondReference.BondReferenceBuilder getOrCreateBondReference() {
            BondReference.BondReferenceBuilder result = this.bondReference != null ? this.bondReference : (this.bondReference = BondReference.builder());
            return result;
        }

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates() {
            CalculationPeriodDates.CalculationPeriodDatesBuilder result = this.calculationPeriodDates != null ? this.calculationPeriodDates : (this.calculationPeriodDates = CalculationPeriodDates.builder());
            return result;
        }

        @Override
        public CashflowRepresentation.CashflowRepresentationBuilder getCashflowRepresentation() {
            return this.cashflowRepresentation;
        }

        @Override
        public CashflowRepresentation.CashflowRepresentationBuilder getOrCreateCashflowRepresentation() {
            CashflowRepresentation.CashflowRepresentationBuilder result = this.cashflowRepresentation != null ? this.cashflowRepresentation : (this.cashflowRepresentation = CashflowRepresentation.builder());
            return result;
        }

        @Override
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getOrCreateDayCountFraction() {
            FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = FieldWithMetaDayCountFractionEnum.builder());
            return result;
        }

        @Override
        public DiscountingMethod.DiscountingMethodBuilder getDiscountingMethod() {
            return this.discountingMethod;
        }

        @Override
        public DiscountingMethod.DiscountingMethodBuilder getOrCreateDiscountingMethod() {
            DiscountingMethod.DiscountingMethodBuilder result = this.discountingMethod != null ? this.discountingMethod : (this.discountingMethod = DiscountingMethod.builder());
            return result;
        }

        @Override
        public String getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        public String getFloatingAmount() {
            return this.floatingAmount;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate() {
            AdjustableDate.AdjustableDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableDate.builder());
            return result;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        public Boolean getPaymentDelay() {
            return this.paymentDelay;
        }

        @Override
        public RateSpecification.RateSpecificationBuilder getRateSpecification() {
            return this.rateSpecification;
        }

        @Override
        public RateSpecification.RateSpecificationBuilder getOrCreateRateSpecification() {
            RateSpecification.RateSpecificationBuilder result = this.rateSpecification != null ? this.rateSpecification : (this.rateSpecification = RateSpecification.builder());
            return result;
        }

        @Override
        public ResetDates.ResetDatesBuilder getResetDates() {
            return this.resetDates;
        }

        @Override
        public ResetDates.ResetDatesBuilder getOrCreateResetDates() {
            ResetDates.ResetDatesBuilder result = this.resetDates != null ? this.resetDates : (this.resetDates = ResetDates.builder());
            return result;
        }

        @Override
        public StubPeriod.StubPeriodBuilder getStubPeriod() {
            return this.stubPeriod;
        }

        @Override
        public StubPeriod.StubPeriodBuilder getOrCreateStubPeriod() {
            StubPeriod.StubPeriodBuilder result = this.stubPeriod != null ? this.stubPeriod : (this.stubPeriod = StubPeriod.builder());
            return result;
        }

        @Override
        public InterestRatePayoutBuilder setBondReference(BondReference bondReference) {
            this.bondReference = bondReference == null ? null : bondReference.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setCalculationPeriodDates(CalculationPeriodDates calculationPeriodDates) {
            this.calculationPeriodDates = calculationPeriodDates == null ? null : calculationPeriodDates.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setCashflowRepresentation(CashflowRepresentation cashflowRepresentation) {
            this.cashflowRepresentation = cashflowRepresentation == null ? null : cashflowRepresentation.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setCompoundingMethod(CompoundingMethodEnum compoundingMethod) {
            this.compoundingMethod = compoundingMethod == null ? null : compoundingMethod;
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setDayCountFraction(FieldWithMetaDayCountFractionEnum dayCountFraction) {
            this.dayCountFraction = dayCountFraction == null ? null : dayCountFraction.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setDayCountFractionValue(DayCountFractionEnum dayCountFraction) {
            this.getOrCreateDayCountFraction().setValue(dayCountFraction);
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setDiscountingMethod(DiscountingMethod discountingMethod) {
            this.discountingMethod = discountingMethod == null ? null : discountingMethod.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setFixedAmount(String fixedAmount) {
            this.fixedAmount = fixedAmount == null ? null : fixedAmount;
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setFloatingAmount(String floatingAmount) {
            this.floatingAmount = floatingAmount == null ? null : floatingAmount;
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setPaymentDate(AdjustableDate paymentDate) {
            this.paymentDate = paymentDate == null ? null : paymentDate.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setPaymentDates(PaymentDates paymentDates) {
            this.paymentDates = paymentDates == null ? null : paymentDates.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setPaymentDelay(Boolean paymentDelay) {
            this.paymentDelay = paymentDelay == null ? null : paymentDelay;
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setRateSpecification(RateSpecification rateSpecification) {
            this.rateSpecification = rateSpecification == null ? null : rateSpecification.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setResetDates(ResetDates resetDates) {
            this.resetDates = resetDates == null ? null : resetDates.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setStubPeriod(StubPeriod stubPeriod) {
            this.stubPeriod = stubPeriod == null ? null : stubPeriod.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public InterestRatePayout build() {
            return new InterestRatePayoutImpl(this);
        }

        @Override
        public InterestRatePayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public InterestRatePayoutBuilder prune() {
            super.prune();
            if (this.bondReference != null && !this.bondReference.prune().hasData()) {
                this.bondReference = null;
            }
            if (this.calculationPeriodDates != null && !this.calculationPeriodDates.prune().hasData()) {
                this.calculationPeriodDates = null;
            }
            if (this.cashflowRepresentation != null && !this.cashflowRepresentation.prune().hasData()) {
                this.cashflowRepresentation = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.discountingMethod != null && !this.discountingMethod.prune().hasData()) {
                this.discountingMethod = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.rateSpecification != null && !this.rateSpecification.prune().hasData()) {
                this.rateSpecification = null;
            }
            if (this.resetDates != null && !this.resetDates.prune().hasData()) {
                this.resetDates = null;
            }
            if (this.stubPeriod != null && !this.stubPeriod.prune().hasData()) {
                this.stubPeriod = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBondReference() != null && this.getBondReference().hasData()) {
                return true;
            }
            if (this.getCalculationPeriodDates() != null && this.getCalculationPeriodDates().hasData()) {
                return true;
            }
            if (this.getCashflowRepresentation() != null && this.getCashflowRepresentation().hasData()) {
                return true;
            }
            if (this.getCompoundingMethod() != null) {
                return true;
            }
            if (this.getDayCountFraction() != null) {
                return true;
            }
            if (this.getDiscountingMethod() != null && this.getDiscountingMethod().hasData()) {
                return true;
            }
            if (this.getFixedAmount() != null) {
                return true;
            }
            if (this.getFloatingAmount() != null) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            if (this.getPaymentDelay() != null) {
                return true;
            }
            if (this.getRateSpecification() != null && this.getRateSpecification().hasData()) {
                return true;
            }
            if (this.getResetDates() != null && this.getResetDates().hasData()) {
                return true;
            }
            return this.getStubPeriod() != null && this.getStubPeriod().hasData();
        }

        @Override
        public InterestRatePayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InterestRatePayoutBuilder o = (InterestRatePayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBondReference(), (RosettaModelObjectBuilder)o.getBondReference(), this::setBondReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriodDates(), (RosettaModelObjectBuilder)o.getCalculationPeriodDates(), this::setCalculationPeriodDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashflowRepresentation(), (RosettaModelObjectBuilder)o.getCashflowRepresentation(), this::setCashflowRepresentation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDiscountingMethod(), (RosettaModelObjectBuilder)o.getDiscountingMethod(), this::setDiscountingMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateSpecification(), (RosettaModelObjectBuilder)o.getRateSpecification(), this::setRateSpecification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResetDates(), (RosettaModelObjectBuilder)o.getResetDates(), this::setResetDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStubPeriod(), (RosettaModelObjectBuilder)o.getStubPeriod(), this::setStubPeriod);
            merger.mergeBasic((Object)this.getCompoundingMethod(), (Object)o.getCompoundingMethod(), this::setCompoundingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedAmount(), (Object)o.getFixedAmount(), this::setFixedAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingAmount(), (Object)o.getFloatingAmount(), this::setFloatingAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPaymentDelay(), (Object)o.getPaymentDelay(), this::setPaymentDelay, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestRatePayout _that = (InterestRatePayout)this.getType().cast(o);
            if (!Objects.equals(this.bondReference, _that.getBondReference())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.cashflowRepresentation, _that.getCashflowRepresentation())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.discountingMethod, _that.getDiscountingMethod())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmount, _that.getFixedAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingAmount, _that.getFloatingAmount())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDelay, _that.getPaymentDelay())) {
                return false;
            }
            if (!Objects.equals(this.rateSpecification, _that.getRateSpecification())) {
                return false;
            }
            if (!Objects.equals(this.resetDates, _that.getResetDates())) {
                return false;
            }
            return Objects.equals(this.stubPeriod, _that.getStubPeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.bondReference != null ? this.bondReference.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.cashflowRepresentation != null ? this.cashflowRepresentation.hashCode() : 0);
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.discountingMethod != null ? this.discountingMethod.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingAmount != null ? this.floatingAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDelay != null ? this.paymentDelay.hashCode() : 0);
            _result = 31 * _result + (this.rateSpecification != null ? this.rateSpecification.hashCode() : 0);
            _result = 31 * _result + (this.resetDates != null ? this.resetDates.hashCode() : 0);
            _result = 31 * _result + (this.stubPeriod != null ? this.stubPeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestRatePayoutBuilder {bondReference=" + this.bondReference + ", calculationPeriodDates=" + this.calculationPeriodDates + ", cashflowRepresentation=" + this.cashflowRepresentation + ", compoundingMethod=" + (Object)((Object)this.compoundingMethod) + ", dayCountFraction=" + this.dayCountFraction + ", discountingMethod=" + this.discountingMethod + ", fixedAmount=" + this.fixedAmount + ", floatingAmount=" + this.floatingAmount + ", meta=" + this.meta + ", paymentDate=" + this.paymentDate + ", paymentDates=" + this.paymentDates + ", paymentDelay=" + this.paymentDelay + ", rateSpecification=" + this.rateSpecification + ", resetDates=" + this.resetDates + ", stubPeriod=" + this.stubPeriod + '}' + " " + super.toString();
        }
    }

    public static class InterestRatePayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements InterestRatePayout {
        private final BondReference bondReference;
        private final CalculationPeriodDates calculationPeriodDates;
        private final CashflowRepresentation cashflowRepresentation;
        private final CompoundingMethodEnum compoundingMethod;
        private final FieldWithMetaDayCountFractionEnum dayCountFraction;
        private final DiscountingMethod discountingMethod;
        private final String fixedAmount;
        private final String floatingAmount;
        private final MetaFields meta;
        private final AdjustableDate paymentDate;
        private final PaymentDates paymentDates;
        private final Boolean paymentDelay;
        private final RateSpecification rateSpecification;
        private final ResetDates resetDates;
        private final StubPeriod stubPeriod;

        protected InterestRatePayoutImpl(InterestRatePayoutBuilder builder) {
            super(builder);
            this.bondReference = Optional.ofNullable(builder.getBondReference()).map(f -> f.build()).orElse(null);
            this.calculationPeriodDates = Optional.ofNullable(builder.getCalculationPeriodDates()).map(f -> f.build()).orElse(null);
            this.cashflowRepresentation = Optional.ofNullable(builder.getCashflowRepresentation()).map(f -> f.build()).orElse(null);
            this.compoundingMethod = builder.getCompoundingMethod();
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.discountingMethod = Optional.ofNullable(builder.getDiscountingMethod()).map(f -> f.build()).orElse(null);
            this.fixedAmount = builder.getFixedAmount();
            this.floatingAmount = builder.getFloatingAmount();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.paymentDelay = builder.getPaymentDelay();
            this.rateSpecification = Optional.ofNullable(builder.getRateSpecification()).map(f -> f.build()).orElse(null);
            this.resetDates = Optional.ofNullable(builder.getResetDates()).map(f -> f.build()).orElse(null);
            this.stubPeriod = Optional.ofNullable(builder.getStubPeriod()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BondReference getBondReference() {
            return this.bondReference;
        }

        @Override
        public CalculationPeriodDates getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        public CashflowRepresentation getCashflowRepresentation() {
            return this.cashflowRepresentation;
        }

        @Override
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        public FieldWithMetaDayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DiscountingMethod getDiscountingMethod() {
            return this.discountingMethod;
        }

        @Override
        public String getFixedAmount() {
            return this.fixedAmount;
        }

        @Override
        public String getFloatingAmount() {
            return this.floatingAmount;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public AdjustableDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public Boolean getPaymentDelay() {
            return this.paymentDelay;
        }

        @Override
        public RateSpecification getRateSpecification() {
            return this.rateSpecification;
        }

        @Override
        public ResetDates getResetDates() {
            return this.resetDates;
        }

        @Override
        public StubPeriod getStubPeriod() {
            return this.stubPeriod;
        }

        @Override
        public InterestRatePayout build() {
            return this;
        }

        @Override
        public InterestRatePayoutBuilder toBuilder() {
            InterestRatePayoutBuilder builder = InterestRatePayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InterestRatePayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBondReference()).ifPresent(builder::setBondReference);
            Optional.ofNullable(this.getCalculationPeriodDates()).ifPresent(builder::setCalculationPeriodDates);
            Optional.ofNullable(this.getCashflowRepresentation()).ifPresent(builder::setCashflowRepresentation);
            Optional.ofNullable(this.getCompoundingMethod()).ifPresent(builder::setCompoundingMethod);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getDiscountingMethod()).ifPresent(builder::setDiscountingMethod);
            Optional.ofNullable(this.getFixedAmount()).ifPresent(builder::setFixedAmount);
            Optional.ofNullable(this.getFloatingAmount()).ifPresent(builder::setFloatingAmount);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getPaymentDelay()).ifPresent(builder::setPaymentDelay);
            Optional.ofNullable(this.getRateSpecification()).ifPresent(builder::setRateSpecification);
            Optional.ofNullable(this.getResetDates()).ifPresent(builder::setResetDates);
            Optional.ofNullable(this.getStubPeriod()).ifPresent(builder::setStubPeriod);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestRatePayout _that = (InterestRatePayout)this.getType().cast(o);
            if (!Objects.equals(this.bondReference, _that.getBondReference())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.cashflowRepresentation, _that.getCashflowRepresentation())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.discountingMethod, _that.getDiscountingMethod())) {
                return false;
            }
            if (!Objects.equals(this.fixedAmount, _that.getFixedAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingAmount, _that.getFloatingAmount())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDelay, _that.getPaymentDelay())) {
                return false;
            }
            if (!Objects.equals(this.rateSpecification, _that.getRateSpecification())) {
                return false;
            }
            if (!Objects.equals(this.resetDates, _that.getResetDates())) {
                return false;
            }
            return Objects.equals(this.stubPeriod, _that.getStubPeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.bondReference != null ? this.bondReference.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.cashflowRepresentation != null ? this.cashflowRepresentation.hashCode() : 0);
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.discountingMethod != null ? this.discountingMethod.hashCode() : 0);
            _result = 31 * _result + (this.fixedAmount != null ? this.fixedAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingAmount != null ? this.floatingAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDelay != null ? this.paymentDelay.hashCode() : 0);
            _result = 31 * _result + (this.rateSpecification != null ? this.rateSpecification.hashCode() : 0);
            _result = 31 * _result + (this.resetDates != null ? this.resetDates.hashCode() : 0);
            _result = 31 * _result + (this.stubPeriod != null ? this.stubPeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestRatePayout {bondReference=" + this.bondReference + ", calculationPeriodDates=" + this.calculationPeriodDates + ", cashflowRepresentation=" + this.cashflowRepresentation + ", compoundingMethod=" + (Object)((Object)this.compoundingMethod) + ", dayCountFraction=" + this.dayCountFraction + ", discountingMethod=" + this.discountingMethod + ", fixedAmount=" + this.fixedAmount + ", floatingAmount=" + this.floatingAmount + ", meta=" + this.meta + ", paymentDate=" + this.paymentDate + ", paymentDates=" + this.paymentDates + ", paymentDelay=" + this.paymentDelay + ", rateSpecification=" + this.rateSpecification + ", resetDates=" + this.resetDates + ", stubPeriod=" + this.stubPeriod + '}' + " " + super.toString();
        }
    }

    public static interface InterestRatePayoutBuilder
    extends InterestRatePayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public BondReference.BondReferenceBuilder getOrCreateBondReference();

        @Override
        public BondReference.BondReferenceBuilder getBondReference();

        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates();

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates();

        public CashflowRepresentation.CashflowRepresentationBuilder getOrCreateCashflowRepresentation();

        @Override
        public CashflowRepresentation.CashflowRepresentationBuilder getCashflowRepresentation();

        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getOrCreateDayCountFraction();

        @Override
        public FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder getDayCountFraction();

        public DiscountingMethod.DiscountingMethodBuilder getOrCreateDiscountingMethod();

        @Override
        public DiscountingMethod.DiscountingMethodBuilder getDiscountingMethod();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getPaymentDate();

        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public RateSpecification.RateSpecificationBuilder getOrCreateRateSpecification();

        @Override
        public RateSpecification.RateSpecificationBuilder getRateSpecification();

        public ResetDates.ResetDatesBuilder getOrCreateResetDates();

        @Override
        public ResetDates.ResetDatesBuilder getResetDates();

        public StubPeriod.StubPeriodBuilder getOrCreateStubPeriod();

        @Override
        public StubPeriod.StubPeriodBuilder getStubPeriod();

        public InterestRatePayoutBuilder setBondReference(BondReference var1);

        public InterestRatePayoutBuilder setCalculationPeriodDates(CalculationPeriodDates var1);

        public InterestRatePayoutBuilder setCashflowRepresentation(CashflowRepresentation var1);

        public InterestRatePayoutBuilder setCompoundingMethod(CompoundingMethodEnum var1);

        public InterestRatePayoutBuilder setDayCountFraction(FieldWithMetaDayCountFractionEnum var1);

        public InterestRatePayoutBuilder setDayCountFractionValue(DayCountFractionEnum var1);

        public InterestRatePayoutBuilder setDiscountingMethod(DiscountingMethod var1);

        public InterestRatePayoutBuilder setFixedAmount(String var1);

        public InterestRatePayoutBuilder setFloatingAmount(String var1);

        public InterestRatePayoutBuilder setMeta(MetaFields var1);

        public InterestRatePayoutBuilder setPaymentDate(AdjustableDate var1);

        public InterestRatePayoutBuilder setPaymentDates(PaymentDates var1);

        public InterestRatePayoutBuilder setPaymentDelay(Boolean var1);

        public InterestRatePayoutBuilder setRateSpecification(RateSpecification var1);

        public InterestRatePayoutBuilder setResetDates(ResetDates var1);

        public InterestRatePayoutBuilder setStubPeriod(StubPeriod var1);

        @Override
        public InterestRatePayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public InterestRatePayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public InterestRatePayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public InterestRatePayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedAmount"), String.class, (Object)this.getFixedAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingAmount"), String.class, (Object)this.getFloatingAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentDelay"), Boolean.class, (Object)this.getPaymentDelay(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondReference"), processor, BondReference.BondReferenceBuilder.class, this.getBondReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.CalculationPeriodDatesBuilder.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashflowRepresentation"), processor, CashflowRepresentation.CashflowRepresentationBuilder.class, this.getCashflowRepresentation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, FieldWithMetaDayCountFractionEnum.FieldWithMetaDayCountFractionEnumBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("discountingMethod"), processor, DiscountingMethod.DiscountingMethodBuilder.class, this.getDiscountingMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateSpecification"), processor, RateSpecification.RateSpecificationBuilder.class, this.getRateSpecification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resetDates"), processor, ResetDates.ResetDatesBuilder.class, this.getResetDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubPeriod"), processor, StubPeriod.StubPeriodBuilder.class, this.getStubPeriod(), new AttributeMeta[0]);
        }

        @Override
        public InterestRatePayoutBuilder prune();
    }
}

