/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.Offset;
import cdm.base.math.AveragingWeightingMethodEnum;
import cdm.base.math.Rounding;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.InterpolationMethodEnum;
import cdm.observable.asset.Price;
import cdm.observable.asset.calculatedrate.FallbackRateParameters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.InflationCalculationMethodEnum;
import cdm.observable.asset.calculatedrate.InflationCalculationStyleEnum;
import cdm.observable.asset.metafields.FieldWithMetaInterpolationMethodEnum;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.SpreadSchedule;
import cdm.product.asset.meta.InflationRateSpecificationMeta;
import cdm.product.common.schedule.RateSchedule;
import cdm.product.template.StrikeSchedule;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface InflationRateSpecification
extends FloatingRateSpecification {
    public static final InflationRateSpecificationMeta metaData = new InflationRateSpecificationMeta();

    @Override
    public InflationRateSpecification build();

    @Override
    public InflationRateSpecificationBuilder toBuilder();

    public InflationCalculationMethodEnum getCalculationMethod();

    public InflationCalculationStyleEnum getCalculationStyle();

    public Boolean getFallbackBondApplicable();

    public FieldWithMetaString getIndexSource();

    public Offset getInflationLag();

    public BigDecimal getInitialIndexLevel();

    public FieldWithMetaInterpolationMethodEnum getInterpolationMethod();

    public FieldWithMetaString getMainPublication();

    default public RosettaMetaData<? extends InflationRateSpecification> metaData() {
        return metaData;
    }

    public static InflationRateSpecificationBuilder builder() {
        return new InflationRateSpecificationBuilderImpl();
    }

    default public Class<? extends InflationRateSpecification> getType() {
        return InflationRateSpecification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        FloatingRateSpecification.super.process(path, processor);
        processor.processBasic(path.newSubPath("calculationMethod"), InflationCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationStyle"), InflationCalculationStyleEnum.class, (Object)this.getCalculationStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fallbackBondApplicable"), Boolean.class, (Object)this.getFallbackBondApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialIndexLevel"), BigDecimal.class, (Object)this.getInitialIndexLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexSource"), processor, FieldWithMetaString.class, this.getIndexSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("inflationLag"), processor, Offset.class, this.getInflationLag(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interpolationMethod"), processor, FieldWithMetaInterpolationMethodEnum.class, this.getInterpolationMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("mainPublication"), processor, FieldWithMetaString.class, this.getMainPublication(), new AttributeMeta[0]);
    }

    public static class InflationRateSpecificationBuilderImpl
    extends FloatingRateSpecification.FloatingRateSpecificationBuilderImpl
    implements InflationRateSpecificationBuilder {
        protected InflationCalculationMethodEnum calculationMethod;
        protected InflationCalculationStyleEnum calculationStyle;
        protected Boolean fallbackBondApplicable;
        protected FieldWithMetaString.FieldWithMetaStringBuilder indexSource;
        protected Offset.OffsetBuilder inflationLag;
        protected BigDecimal initialIndexLevel;
        protected FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder interpolationMethod;
        protected FieldWithMetaString.FieldWithMetaStringBuilder mainPublication;

        @Override
        public InflationCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        public InflationCalculationStyleEnum getCalculationStyle() {
            return this.calculationStyle;
        }

        @Override
        public Boolean getFallbackBondApplicable() {
            return this.fallbackBondApplicable;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getIndexSource() {
            return this.indexSource;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIndexSource() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.indexSource != null ? this.indexSource : (this.indexSource = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public Offset.OffsetBuilder getInflationLag() {
            return this.inflationLag;
        }

        @Override
        public Offset.OffsetBuilder getOrCreateInflationLag() {
            Offset.OffsetBuilder result = this.inflationLag != null ? this.inflationLag : (this.inflationLag = Offset.builder());
            return result;
        }

        @Override
        public BigDecimal getInitialIndexLevel() {
            return this.initialIndexLevel;
        }

        @Override
        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getOrCreateInterpolationMethod() {
            FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder result = this.interpolationMethod != null ? this.interpolationMethod : (this.interpolationMethod = FieldWithMetaInterpolationMethodEnum.builder());
            return result;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getMainPublication() {
            return this.mainPublication;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateMainPublication() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.mainPublication != null ? this.mainPublication : (this.mainPublication = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public InflationRateSpecificationBuilder setCalculationMethod(InflationCalculationMethodEnum calculationMethod) {
            this.calculationMethod = calculationMethod == null ? null : calculationMethod;
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setCalculationStyle(InflationCalculationStyleEnum calculationStyle) {
            this.calculationStyle = calculationStyle == null ? null : calculationStyle;
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setFallbackBondApplicable(Boolean fallbackBondApplicable) {
            this.fallbackBondApplicable = fallbackBondApplicable == null ? null : fallbackBondApplicable;
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setIndexSource(FieldWithMetaString indexSource) {
            this.indexSource = indexSource == null ? null : indexSource.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setIndexSourceValue(String indexSource) {
            this.getOrCreateIndexSource().setValue(indexSource);
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setInflationLag(Offset inflationLag) {
            this.inflationLag = inflationLag == null ? null : inflationLag.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setInitialIndexLevel(BigDecimal initialIndexLevel) {
            this.initialIndexLevel = initialIndexLevel == null ? null : initialIndexLevel;
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setInterpolationMethod(FieldWithMetaInterpolationMethodEnum interpolationMethod) {
            this.interpolationMethod = interpolationMethod == null ? null : interpolationMethod.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setInterpolationMethodValue(InterpolationMethodEnum interpolationMethod) {
            this.getOrCreateInterpolationMethod().setValue(interpolationMethod);
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setMainPublication(FieldWithMetaString mainPublication) {
            this.mainPublication = mainPublication == null ? null : mainPublication.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setMainPublicationValue(String mainPublication) {
            this.getOrCreateMainPublication().setValue(mainPublication);
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum averagingMethod) {
            this.averagingMethod = averagingMethod == null ? null : averagingMethod;
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setFinalRateRounding(Rounding finalRateRounding) {
            this.finalRateRounding = finalRateRounding == null ? null : finalRateRounding.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setInitialRate(Price initialRate) {
            this.initialRate = initialRate == null ? null : initialRate.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum negativeInterestRateTreatment) {
            this.negativeInterestRateTreatment = negativeInterestRateTreatment == null ? null : negativeInterestRateTreatment;
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters calculationParameters) {
            this.calculationParameters = calculationParameters == null ? null : calculationParameters.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setFallbackRate(FallbackRateParameters fallbackRate) {
            this.fallbackRate = fallbackRate == null ? null : fallbackRate.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule floatingRateMultiplierSchedule) {
            this.floatingRateMultiplierSchedule = floatingRateMultiplierSchedule == null ? null : floatingRateMultiplierSchedule.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setRateTreatment(RateTreatmentEnum rateTreatment) {
            this.rateTreatment = rateTreatment == null ? null : rateTreatment;
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setCapRateSchedule(StrikeSchedule capRateSchedule) {
            this.capRateSchedule = capRateSchedule == null ? null : capRateSchedule.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule floorRateSchedule) {
            this.floorRateSchedule = floorRateSchedule == null ? null : floorRateSchedule.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption rateOption) {
            this.rateOption = rateOption == null ? null : rateOption.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setRateOptionValue(FloatingRateOption rateOption) {
            this.getOrCreateRateOption().setValue(rateOption);
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setSpreadSchedule(SpreadSchedule spreadSchedule) {
            this.spreadSchedule = spreadSchedule == null ? null : spreadSchedule.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecification build() {
            return new InflationRateSpecificationImpl(this);
        }

        @Override
        public InflationRateSpecificationBuilder toBuilder() {
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder prune() {
            super.prune();
            if (this.indexSource != null && !this.indexSource.prune().hasData()) {
                this.indexSource = null;
            }
            if (this.inflationLag != null && !this.inflationLag.prune().hasData()) {
                this.inflationLag = null;
            }
            if (this.interpolationMethod != null && !this.interpolationMethod.prune().hasData()) {
                this.interpolationMethod = null;
            }
            if (this.mainPublication != null && !this.mainPublication.prune().hasData()) {
                this.mainPublication = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCalculationMethod() != null) {
                return true;
            }
            if (this.getCalculationStyle() != null) {
                return true;
            }
            if (this.getFallbackBondApplicable() != null) {
                return true;
            }
            if (this.getIndexSource() != null) {
                return true;
            }
            if (this.getInflationLag() != null && this.getInflationLag().hasData()) {
                return true;
            }
            if (this.getInitialIndexLevel() != null) {
                return true;
            }
            if (this.getInterpolationMethod() != null) {
                return true;
            }
            return this.getMainPublication() != null;
        }

        @Override
        public InflationRateSpecificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InflationRateSpecificationBuilder o = (InflationRateSpecificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexSource(), (RosettaModelObjectBuilder)o.getIndexSource(), this::setIndexSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInflationLag(), (RosettaModelObjectBuilder)o.getInflationLag(), this::setInflationLag);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterpolationMethod(), (RosettaModelObjectBuilder)o.getInterpolationMethod(), this::setInterpolationMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMainPublication(), (RosettaModelObjectBuilder)o.getMainPublication(), this::setMainPublication);
            merger.mergeBasic((Object)this.getCalculationMethod(), (Object)o.getCalculationMethod(), this::setCalculationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCalculationStyle(), (Object)o.getCalculationStyle(), this::setCalculationStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFallbackBondApplicable(), (Object)o.getFallbackBondApplicable(), this::setFallbackBondApplicable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialIndexLevel(), (Object)o.getInitialIndexLevel(), this::setInitialIndexLevel, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InflationRateSpecification _that = (InflationRateSpecification)this.getType().cast(o);
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationStyle, (Object)_that.getCalculationStyle())) {
                return false;
            }
            if (!Objects.equals(this.fallbackBondApplicable, _that.getFallbackBondApplicable())) {
                return false;
            }
            if (!Objects.equals(this.indexSource, _that.getIndexSource())) {
                return false;
            }
            if (!Objects.equals(this.inflationLag, _that.getInflationLag())) {
                return false;
            }
            if (!Objects.equals(this.initialIndexLevel, _that.getInitialIndexLevel())) {
                return false;
            }
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            return Objects.equals(this.mainPublication, _that.getMainPublication());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.calculationStyle != null ? ((Object)((Object)this.calculationStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fallbackBondApplicable != null ? this.fallbackBondApplicable.hashCode() : 0);
            _result = 31 * _result + (this.indexSource != null ? this.indexSource.hashCode() : 0);
            _result = 31 * _result + (this.inflationLag != null ? this.inflationLag.hashCode() : 0);
            _result = 31 * _result + (this.initialIndexLevel != null ? this.initialIndexLevel.hashCode() : 0);
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.mainPublication != null ? this.mainPublication.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InflationRateSpecificationBuilder {calculationMethod=" + (Object)((Object)this.calculationMethod) + ", calculationStyle=" + (Object)((Object)this.calculationStyle) + ", fallbackBondApplicable=" + this.fallbackBondApplicable + ", indexSource=" + this.indexSource + ", inflationLag=" + this.inflationLag + ", initialIndexLevel=" + this.initialIndexLevel + ", interpolationMethod=" + this.interpolationMethod + ", mainPublication=" + this.mainPublication + '}' + " " + super.toString();
        }
    }

    public static class InflationRateSpecificationImpl
    extends FloatingRateSpecification.FloatingRateSpecificationImpl
    implements InflationRateSpecification {
        private final InflationCalculationMethodEnum calculationMethod;
        private final InflationCalculationStyleEnum calculationStyle;
        private final Boolean fallbackBondApplicable;
        private final FieldWithMetaString indexSource;
        private final Offset inflationLag;
        private final BigDecimal initialIndexLevel;
        private final FieldWithMetaInterpolationMethodEnum interpolationMethod;
        private final FieldWithMetaString mainPublication;

        protected InflationRateSpecificationImpl(InflationRateSpecificationBuilder builder) {
            super(builder);
            this.calculationMethod = builder.getCalculationMethod();
            this.calculationStyle = builder.getCalculationStyle();
            this.fallbackBondApplicable = builder.getFallbackBondApplicable();
            this.indexSource = Optional.ofNullable(builder.getIndexSource()).map(f -> f.build()).orElse(null);
            this.inflationLag = Optional.ofNullable(builder.getInflationLag()).map(f -> f.build()).orElse(null);
            this.initialIndexLevel = builder.getInitialIndexLevel();
            this.interpolationMethod = Optional.ofNullable(builder.getInterpolationMethod()).map(f -> f.build()).orElse(null);
            this.mainPublication = Optional.ofNullable(builder.getMainPublication()).map(f -> f.build()).orElse(null);
        }

        @Override
        public InflationCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        public InflationCalculationStyleEnum getCalculationStyle() {
            return this.calculationStyle;
        }

        @Override
        public Boolean getFallbackBondApplicable() {
            return this.fallbackBondApplicable;
        }

        @Override
        public FieldWithMetaString getIndexSource() {
            return this.indexSource;
        }

        @Override
        public Offset getInflationLag() {
            return this.inflationLag;
        }

        @Override
        public BigDecimal getInitialIndexLevel() {
            return this.initialIndexLevel;
        }

        @Override
        public FieldWithMetaInterpolationMethodEnum getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public FieldWithMetaString getMainPublication() {
            return this.mainPublication;
        }

        @Override
        public InflationRateSpecification build() {
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder toBuilder() {
            InflationRateSpecificationBuilder builder = InflationRateSpecification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InflationRateSpecificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCalculationMethod()).ifPresent(builder::setCalculationMethod);
            Optional.ofNullable(this.getCalculationStyle()).ifPresent(builder::setCalculationStyle);
            Optional.ofNullable(this.getFallbackBondApplicable()).ifPresent(builder::setFallbackBondApplicable);
            Optional.ofNullable(this.getIndexSource()).ifPresent(builder::setIndexSource);
            Optional.ofNullable(this.getInflationLag()).ifPresent(builder::setInflationLag);
            Optional.ofNullable(this.getInitialIndexLevel()).ifPresent(builder::setInitialIndexLevel);
            Optional.ofNullable(this.getInterpolationMethod()).ifPresent(builder::setInterpolationMethod);
            Optional.ofNullable(this.getMainPublication()).ifPresent(builder::setMainPublication);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InflationRateSpecification _that = (InflationRateSpecification)this.getType().cast(o);
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationStyle, (Object)_that.getCalculationStyle())) {
                return false;
            }
            if (!Objects.equals(this.fallbackBondApplicable, _that.getFallbackBondApplicable())) {
                return false;
            }
            if (!Objects.equals(this.indexSource, _that.getIndexSource())) {
                return false;
            }
            if (!Objects.equals(this.inflationLag, _that.getInflationLag())) {
                return false;
            }
            if (!Objects.equals(this.initialIndexLevel, _that.getInitialIndexLevel())) {
                return false;
            }
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            return Objects.equals(this.mainPublication, _that.getMainPublication());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.calculationStyle != null ? ((Object)((Object)this.calculationStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fallbackBondApplicable != null ? this.fallbackBondApplicable.hashCode() : 0);
            _result = 31 * _result + (this.indexSource != null ? this.indexSource.hashCode() : 0);
            _result = 31 * _result + (this.inflationLag != null ? this.inflationLag.hashCode() : 0);
            _result = 31 * _result + (this.initialIndexLevel != null ? this.initialIndexLevel.hashCode() : 0);
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.mainPublication != null ? this.mainPublication.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InflationRateSpecification {calculationMethod=" + (Object)((Object)this.calculationMethod) + ", calculationStyle=" + (Object)((Object)this.calculationStyle) + ", fallbackBondApplicable=" + this.fallbackBondApplicable + ", indexSource=" + this.indexSource + ", inflationLag=" + this.inflationLag + ", initialIndexLevel=" + this.initialIndexLevel + ", interpolationMethod=" + this.interpolationMethod + ", mainPublication=" + this.mainPublication + '}' + " " + super.toString();
        }
    }

    public static interface InflationRateSpecificationBuilder
    extends InflationRateSpecification,
    FloatingRateSpecification.FloatingRateSpecificationBuilder,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIndexSource();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getIndexSource();

        public Offset.OffsetBuilder getOrCreateInflationLag();

        @Override
        public Offset.OffsetBuilder getInflationLag();

        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getOrCreateInterpolationMethod();

        @Override
        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getInterpolationMethod();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateMainPublication();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getMainPublication();

        public InflationRateSpecificationBuilder setCalculationMethod(InflationCalculationMethodEnum var1);

        public InflationRateSpecificationBuilder setCalculationStyle(InflationCalculationStyleEnum var1);

        public InflationRateSpecificationBuilder setFallbackBondApplicable(Boolean var1);

        public InflationRateSpecificationBuilder setIndexSource(FieldWithMetaString var1);

        public InflationRateSpecificationBuilder setIndexSourceValue(String var1);

        public InflationRateSpecificationBuilder setInflationLag(Offset var1);

        public InflationRateSpecificationBuilder setInitialIndexLevel(BigDecimal var1);

        public InflationRateSpecificationBuilder setInterpolationMethod(FieldWithMetaInterpolationMethodEnum var1);

        public InflationRateSpecificationBuilder setInterpolationMethodValue(InterpolationMethodEnum var1);

        public InflationRateSpecificationBuilder setMainPublication(FieldWithMetaString var1);

        public InflationRateSpecificationBuilder setMainPublicationValue(String var1);

        @Override
        public InflationRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum var1);

        @Override
        public InflationRateSpecificationBuilder setFinalRateRounding(Rounding var1);

        @Override
        public InflationRateSpecificationBuilder setInitialRate(Price var1);

        @Override
        public InflationRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum var1);

        @Override
        public InflationRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters var1);

        @Override
        public InflationRateSpecificationBuilder setFallbackRate(FallbackRateParameters var1);

        @Override
        public InflationRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule var1);

        @Override
        public InflationRateSpecificationBuilder setRateTreatment(RateTreatmentEnum var1);

        @Override
        public InflationRateSpecificationBuilder setCapRateSchedule(StrikeSchedule var1);

        @Override
        public InflationRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule var1);

        @Override
        public InflationRateSpecificationBuilder setMeta(MetaFields var1);

        @Override
        public InflationRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption var1);

        @Override
        public InflationRateSpecificationBuilder setRateOptionValue(FloatingRateOption var1);

        @Override
        public InflationRateSpecificationBuilder setSpreadSchedule(SpreadSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            FloatingRateSpecification.FloatingRateSpecificationBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("calculationMethod"), InflationCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationStyle"), InflationCalculationStyleEnum.class, (Object)this.getCalculationStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fallbackBondApplicable"), Boolean.class, (Object)this.getFallbackBondApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialIndexLevel"), BigDecimal.class, (Object)this.getInitialIndexLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexSource"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getIndexSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("inflationLag"), processor, Offset.OffsetBuilder.class, this.getInflationLag(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interpolationMethod"), processor, FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder.class, this.getInterpolationMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("mainPublication"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getMainPublication(), new AttributeMeta[0]);
        }

        @Override
        public InflationRateSpecificationBuilder prune();
    }
}

