/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.meta.FutureValueAmountMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FutureValueAmount
extends RosettaModelObject {
    public static final FutureValueAmountMeta metaData = new FutureValueAmountMeta();

    public FutureValueAmount build();

    public FutureValueAmountBuilder toBuilder();

    public Integer getCalculationPeriodNumberOfDays();

    public FieldWithMetaString getCurrency();

    public ReferenceWithMetaNonNegativeQuantitySchedule getQuantity();

    public Date getValueDate();

    default public RosettaMetaData<? extends FutureValueAmount> metaData() {
        return metaData;
    }

    public static FutureValueAmountBuilder builder() {
        return new FutureValueAmountBuilderImpl();
    }

    default public Class<? extends FutureValueAmount> getType() {
        return FutureValueAmount.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valueDate"), Date.class, (Object)this.getValueDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, ReferenceWithMetaNonNegativeQuantitySchedule.class, this.getQuantity(), new AttributeMeta[0]);
    }

    public static class FutureValueAmountBuilderImpl
    implements FutureValueAmountBuilder {
        protected Integer calculationPeriodNumberOfDays;
        protected FieldWithMetaString.FieldWithMetaStringBuilder currency;
        protected ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder quantity;
        protected Date valueDate;

        @Override
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.currency != null ? this.currency : (this.currency = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getQuantity() {
            return this.quantity;
        }

        @Override
        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity() {
            ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder result = this.quantity != null ? this.quantity : (this.quantity = ReferenceWithMetaNonNegativeQuantitySchedule.builder());
            return result;
        }

        @Override
        public Date getValueDate() {
            return this.valueDate;
        }

        @Override
        public FutureValueAmountBuilder setCalculationPeriodNumberOfDays(Integer calculationPeriodNumberOfDays) {
            this.calculationPeriodNumberOfDays = calculationPeriodNumberOfDays == null ? null : calculationPeriodNumberOfDays;
            return this;
        }

        @Override
        public FutureValueAmountBuilder setCurrency(FieldWithMetaString currency) {
            this.currency = currency == null ? null : currency.toBuilder();
            return this;
        }

        @Override
        public FutureValueAmountBuilder setCurrencyValue(String currency) {
            this.getOrCreateCurrency().setValue(currency);
            return this;
        }

        @Override
        public FutureValueAmountBuilder setQuantity(ReferenceWithMetaNonNegativeQuantitySchedule quantity) {
            this.quantity = quantity == null ? null : quantity.toBuilder();
            return this;
        }

        @Override
        public FutureValueAmountBuilder setQuantityValue(NonNegativeQuantitySchedule quantity) {
            this.getOrCreateQuantity().setValue(quantity);
            return this;
        }

        @Override
        public FutureValueAmountBuilder setValueDate(Date valueDate) {
            this.valueDate = valueDate == null ? null : valueDate;
            return this;
        }

        @Override
        public FutureValueAmount build() {
            return new FutureValueAmountImpl(this);
        }

        @Override
        public FutureValueAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public FutureValueAmountBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.quantity != null && !this.quantity.prune().hasData()) {
                this.quantity = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCalculationPeriodNumberOfDays() != null) {
                return true;
            }
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().hasData()) {
                return true;
            }
            return this.getValueDate() != null;
        }

        public FutureValueAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FutureValueAmountBuilder o = (FutureValueAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuantity(), (RosettaModelObjectBuilder)o.getQuantity(), this::setQuantity);
            merger.mergeBasic((Object)this.getCalculationPeriodNumberOfDays(), (Object)o.getCalculationPeriodNumberOfDays(), this::setCalculationPeriodNumberOfDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValueDate(), (Object)o.getValueDate(), this::setValueDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FutureValueAmount _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            return Objects.equals(this.valueDate, _that.getValueDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FutureValueAmountBuilder {calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", currency=" + this.currency + ", quantity=" + this.quantity + ", valueDate=" + this.valueDate + '}';
        }
    }

    public static class FutureValueAmountImpl
    implements FutureValueAmount {
        private final Integer calculationPeriodNumberOfDays;
        private final FieldWithMetaString currency;
        private final ReferenceWithMetaNonNegativeQuantitySchedule quantity;
        private final Date valueDate;

        protected FutureValueAmountImpl(FutureValueAmountBuilder builder) {
            this.calculationPeriodNumberOfDays = builder.getCalculationPeriodNumberOfDays();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.quantity = Optional.ofNullable(builder.getQuantity()).map(f -> f.build()).orElse(null);
            this.valueDate = builder.getValueDate();
        }

        @Override
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        public FieldWithMetaString getCurrency() {
            return this.currency;
        }

        @Override
        public ReferenceWithMetaNonNegativeQuantitySchedule getQuantity() {
            return this.quantity;
        }

        @Override
        public Date getValueDate() {
            return this.valueDate;
        }

        @Override
        public FutureValueAmount build() {
            return this;
        }

        @Override
        public FutureValueAmountBuilder toBuilder() {
            FutureValueAmountBuilder builder = FutureValueAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FutureValueAmountBuilder builder) {
            Optional.ofNullable(this.getCalculationPeriodNumberOfDays()).ifPresent(builder::setCalculationPeriodNumberOfDays);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getValueDate()).ifPresent(builder::setValueDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FutureValueAmount _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            return Objects.equals(this.valueDate, _that.getValueDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FutureValueAmount {calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", currency=" + this.currency + ", quantity=" + this.quantity + ", valueDate=" + this.valueDate + '}';
        }
    }

    public static interface FutureValueAmountBuilder
    extends FutureValueAmount,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency();

        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity();

        @Override
        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getQuantity();

        public FutureValueAmountBuilder setCalculationPeriodNumberOfDays(Integer var1);

        public FutureValueAmountBuilder setCurrency(FieldWithMetaString var1);

        public FutureValueAmountBuilder setCurrencyValue(String var1);

        public FutureValueAmountBuilder setQuantity(ReferenceWithMetaNonNegativeQuantitySchedule var1);

        public FutureValueAmountBuilder setQuantityValue(NonNegativeQuantitySchedule var1);

        public FutureValueAmountBuilder setValueDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valueDate"), Date.class, (Object)this.getValueDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder.class, this.getQuantity(), new AttributeMeta[0]);
        }

        public FutureValueAmountBuilder prune();
    }
}

