/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.Period;
import cdm.observable.asset.ExchangeRate;
import cdm.product.asset.meta.ForeignExchangeMeta;
import cdm.product.common.settlement.Cashflow;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ForeignExchange
extends RosettaModelObject {
    public static final ForeignExchangeMeta metaData = new ForeignExchangeMeta();

    public ForeignExchange build();

    public ForeignExchangeBuilder toBuilder();

    public ExchangeRate getExchangeRate();

    public Cashflow getExchangedCurrency1();

    public Cashflow getExchangedCurrency2();

    public Period getTenorPeriod();

    default public RosettaMetaData<? extends ForeignExchange> metaData() {
        return metaData;
    }

    public static ForeignExchangeBuilder builder() {
        return new ForeignExchangeBuilderImpl();
    }

    default public Class<? extends ForeignExchange> getType() {
        return ForeignExchange.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("exchangeRate"), processor, ExchangeRate.class, this.getExchangeRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangedCurrency1"), processor, Cashflow.class, this.getExchangedCurrency1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangedCurrency2"), processor, Cashflow.class, this.getExchangedCurrency2(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.class, this.getTenorPeriod(), new AttributeMeta[0]);
    }

    public static class ForeignExchangeBuilderImpl
    implements ForeignExchangeBuilder {
        protected ExchangeRate.ExchangeRateBuilder exchangeRate;
        protected Cashflow.CashflowBuilder exchangedCurrency1;
        protected Cashflow.CashflowBuilder exchangedCurrency2;
        protected Period.PeriodBuilder tenorPeriod;

        @Override
        public ExchangeRate.ExchangeRateBuilder getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        public ExchangeRate.ExchangeRateBuilder getOrCreateExchangeRate() {
            ExchangeRate.ExchangeRateBuilder result = this.exchangeRate != null ? this.exchangeRate : (this.exchangeRate = ExchangeRate.builder());
            return result;
        }

        @Override
        public Cashflow.CashflowBuilder getExchangedCurrency1() {
            return this.exchangedCurrency1;
        }

        @Override
        public Cashflow.CashflowBuilder getOrCreateExchangedCurrency1() {
            Cashflow.CashflowBuilder result = this.exchangedCurrency1 != null ? this.exchangedCurrency1 : (this.exchangedCurrency1 = Cashflow.builder());
            return result;
        }

        @Override
        public Cashflow.CashflowBuilder getExchangedCurrency2() {
            return this.exchangedCurrency2;
        }

        @Override
        public Cashflow.CashflowBuilder getOrCreateExchangedCurrency2() {
            Cashflow.CashflowBuilder result = this.exchangedCurrency2 != null ? this.exchangedCurrency2 : (this.exchangedCurrency2 = Cashflow.builder());
            return result;
        }

        @Override
        public Period.PeriodBuilder getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTenorPeriod() {
            Period.PeriodBuilder result = this.tenorPeriod != null ? this.tenorPeriod : (this.tenorPeriod = Period.builder());
            return result;
        }

        @Override
        public ForeignExchangeBuilder setExchangeRate(ExchangeRate exchangeRate) {
            this.exchangeRate = exchangeRate == null ? null : exchangeRate.toBuilder();
            return this;
        }

        @Override
        public ForeignExchangeBuilder setExchangedCurrency1(Cashflow exchangedCurrency1) {
            this.exchangedCurrency1 = exchangedCurrency1 == null ? null : exchangedCurrency1.toBuilder();
            return this;
        }

        @Override
        public ForeignExchangeBuilder setExchangedCurrency2(Cashflow exchangedCurrency2) {
            this.exchangedCurrency2 = exchangedCurrency2 == null ? null : exchangedCurrency2.toBuilder();
            return this;
        }

        @Override
        public ForeignExchangeBuilder setTenorPeriod(Period tenorPeriod) {
            this.tenorPeriod = tenorPeriod == null ? null : tenorPeriod.toBuilder();
            return this;
        }

        @Override
        public ForeignExchange build() {
            return new ForeignExchangeImpl(this);
        }

        @Override
        public ForeignExchangeBuilder toBuilder() {
            return this;
        }

        @Override
        public ForeignExchangeBuilder prune() {
            if (this.exchangeRate != null && !this.exchangeRate.prune().hasData()) {
                this.exchangeRate = null;
            }
            if (this.exchangedCurrency1 != null && !this.exchangedCurrency1.prune().hasData()) {
                this.exchangedCurrency1 = null;
            }
            if (this.exchangedCurrency2 != null && !this.exchangedCurrency2.prune().hasData()) {
                this.exchangedCurrency2 = null;
            }
            if (this.tenorPeriod != null && !this.tenorPeriod.prune().hasData()) {
                this.tenorPeriod = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getExchangeRate() != null && this.getExchangeRate().hasData()) {
                return true;
            }
            if (this.getExchangedCurrency1() != null && this.getExchangedCurrency1().hasData()) {
                return true;
            }
            if (this.getExchangedCurrency2() != null && this.getExchangedCurrency2().hasData()) {
                return true;
            }
            return this.getTenorPeriod() != null && this.getTenorPeriod().hasData();
        }

        public ForeignExchangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ForeignExchangeBuilder o = (ForeignExchangeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeRate(), (RosettaModelObjectBuilder)o.getExchangeRate(), this::setExchangeRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangedCurrency1(), (RosettaModelObjectBuilder)o.getExchangedCurrency1(), this::setExchangedCurrency1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangedCurrency2(), (RosettaModelObjectBuilder)o.getExchangedCurrency2(), this::setExchangedCurrency2);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTenorPeriod(), (RosettaModelObjectBuilder)o.getTenorPeriod(), this::setTenorPeriod);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ForeignExchange _that = this.getType().cast(o);
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangedCurrency1, _that.getExchangedCurrency1())) {
                return false;
            }
            if (!Objects.equals(this.exchangedCurrency2, _that.getExchangedCurrency2())) {
                return false;
            }
            return Objects.equals(this.tenorPeriod, _that.getTenorPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangedCurrency1 != null ? this.exchangedCurrency1.hashCode() : 0);
            _result = 31 * _result + (this.exchangedCurrency2 != null ? this.exchangedCurrency2.hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ForeignExchangeBuilder {exchangeRate=" + this.exchangeRate + ", exchangedCurrency1=" + this.exchangedCurrency1 + ", exchangedCurrency2=" + this.exchangedCurrency2 + ", tenorPeriod=" + this.tenorPeriod + '}';
        }
    }

    public static class ForeignExchangeImpl
    implements ForeignExchange {
        private final ExchangeRate exchangeRate;
        private final Cashflow exchangedCurrency1;
        private final Cashflow exchangedCurrency2;
        private final Period tenorPeriod;

        protected ForeignExchangeImpl(ForeignExchangeBuilder builder) {
            this.exchangeRate = Optional.ofNullable(builder.getExchangeRate()).map(f -> f.build()).orElse(null);
            this.exchangedCurrency1 = Optional.ofNullable(builder.getExchangedCurrency1()).map(f -> f.build()).orElse(null);
            this.exchangedCurrency2 = Optional.ofNullable(builder.getExchangedCurrency2()).map(f -> f.build()).orElse(null);
            this.tenorPeriod = Optional.ofNullable(builder.getTenorPeriod()).map(f -> f.build()).orElse(null);
        }

        @Override
        public ExchangeRate getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        public Cashflow getExchangedCurrency1() {
            return this.exchangedCurrency1;
        }

        @Override
        public Cashflow getExchangedCurrency2() {
            return this.exchangedCurrency2;
        }

        @Override
        public Period getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        public ForeignExchange build() {
            return this;
        }

        @Override
        public ForeignExchangeBuilder toBuilder() {
            ForeignExchangeBuilder builder = ForeignExchange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ForeignExchangeBuilder builder) {
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
            Optional.ofNullable(this.getExchangedCurrency1()).ifPresent(builder::setExchangedCurrency1);
            Optional.ofNullable(this.getExchangedCurrency2()).ifPresent(builder::setExchangedCurrency2);
            Optional.ofNullable(this.getTenorPeriod()).ifPresent(builder::setTenorPeriod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ForeignExchange _that = this.getType().cast(o);
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangedCurrency1, _that.getExchangedCurrency1())) {
                return false;
            }
            if (!Objects.equals(this.exchangedCurrency2, _that.getExchangedCurrency2())) {
                return false;
            }
            return Objects.equals(this.tenorPeriod, _that.getTenorPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangedCurrency1 != null ? this.exchangedCurrency1.hashCode() : 0);
            _result = 31 * _result + (this.exchangedCurrency2 != null ? this.exchangedCurrency2.hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ForeignExchange {exchangeRate=" + this.exchangeRate + ", exchangedCurrency1=" + this.exchangedCurrency1 + ", exchangedCurrency2=" + this.exchangedCurrency2 + ", tenorPeriod=" + this.tenorPeriod + '}';
        }
    }

    public static interface ForeignExchangeBuilder
    extends ForeignExchange,
    RosettaModelObjectBuilder {
        public ExchangeRate.ExchangeRateBuilder getOrCreateExchangeRate();

        @Override
        public ExchangeRate.ExchangeRateBuilder getExchangeRate();

        public Cashflow.CashflowBuilder getOrCreateExchangedCurrency1();

        @Override
        public Cashflow.CashflowBuilder getExchangedCurrency1();

        public Cashflow.CashflowBuilder getOrCreateExchangedCurrency2();

        @Override
        public Cashflow.CashflowBuilder getExchangedCurrency2();

        public Period.PeriodBuilder getOrCreateTenorPeriod();

        @Override
        public Period.PeriodBuilder getTenorPeriod();

        public ForeignExchangeBuilder setExchangeRate(ExchangeRate var1);

        public ForeignExchangeBuilder setExchangedCurrency1(Cashflow var1);

        public ForeignExchangeBuilder setExchangedCurrency2(Cashflow var1);

        public ForeignExchangeBuilder setTenorPeriod(Period var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("exchangeRate"), processor, ExchangeRate.ExchangeRateBuilder.class, this.getExchangeRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangedCurrency1"), processor, Cashflow.CashflowBuilder.class, this.getExchangedCurrency1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangedCurrency2"), processor, Cashflow.CashflowBuilder.class, this.getExchangedCurrency2(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.PeriodBuilder.class, this.getTenorPeriod(), new AttributeMeta[0]);
        }

        public ForeignExchangeBuilder prune();
    }
}

