/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.AveragingWeightingMethodEnum;
import cdm.base.math.Rounding;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.Price;
import cdm.observable.asset.calculatedrate.FallbackRateParameters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRate;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.SpreadSchedule;
import cdm.product.asset.meta.FloatingRateSpecificationMeta;
import cdm.product.common.schedule.RateSchedule;
import cdm.product.template.StrikeSchedule;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FloatingRateSpecification
extends FloatingRate {
    public static final FloatingRateSpecificationMeta metaData = new FloatingRateSpecificationMeta();

    @Override
    public FloatingRateSpecification build();

    @Override
    public FloatingRateSpecificationBuilder toBuilder();

    public AveragingWeightingMethodEnum getAveragingMethod();

    public Rounding getFinalRateRounding();

    public Price getInitialRate();

    public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment();

    default public RosettaMetaData<? extends FloatingRateSpecification> metaData() {
        return metaData;
    }

    public static FloatingRateSpecificationBuilder builder() {
        return new FloatingRateSpecificationBuilderImpl();
    }

    default public Class<? extends FloatingRateSpecification> getType() {
        return FloatingRateSpecification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        FloatingRate.super.process(path, processor);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingWeightingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.class, this.getFinalRateRounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialRate"), processor, Price.class, this.getInitialRate(), new AttributeMeta[0]);
    }

    public static class FloatingRateSpecificationBuilderImpl
    extends FloatingRate.FloatingRateBuilderImpl
    implements FloatingRateSpecificationBuilder {
        protected AveragingWeightingMethodEnum averagingMethod;
        protected Rounding.RoundingBuilder finalRateRounding;
        protected Price.PriceBuilder initialRate;
        protected NegativeInterestRateTreatmentEnum negativeInterestRateTreatment;

        @Override
        public AveragingWeightingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        public Rounding.RoundingBuilder getFinalRateRounding() {
            return this.finalRateRounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateFinalRateRounding() {
            Rounding.RoundingBuilder result = this.finalRateRounding != null ? this.finalRateRounding : (this.finalRateRounding = Rounding.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getInitialRate() {
            return this.initialRate;
        }

        @Override
        public Price.PriceBuilder getOrCreateInitialRate() {
            Price.PriceBuilder result = this.initialRate != null ? this.initialRate : (this.initialRate = Price.builder());
            return result;
        }

        @Override
        public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment() {
            return this.negativeInterestRateTreatment;
        }

        @Override
        public FloatingRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum averagingMethod) {
            this.averagingMethod = averagingMethod == null ? null : averagingMethod;
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setFinalRateRounding(Rounding finalRateRounding) {
            this.finalRateRounding = finalRateRounding == null ? null : finalRateRounding.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setInitialRate(Price initialRate) {
            this.initialRate = initialRate == null ? null : initialRate.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum negativeInterestRateTreatment) {
            this.negativeInterestRateTreatment = negativeInterestRateTreatment == null ? null : negativeInterestRateTreatment;
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters calculationParameters) {
            this.calculationParameters = calculationParameters == null ? null : calculationParameters.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setFallbackRate(FallbackRateParameters fallbackRate) {
            this.fallbackRate = fallbackRate == null ? null : fallbackRate.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule floatingRateMultiplierSchedule) {
            this.floatingRateMultiplierSchedule = floatingRateMultiplierSchedule == null ? null : floatingRateMultiplierSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setRateTreatment(RateTreatmentEnum rateTreatment) {
            this.rateTreatment = rateTreatment == null ? null : rateTreatment;
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setCapRateSchedule(StrikeSchedule capRateSchedule) {
            this.capRateSchedule = capRateSchedule == null ? null : capRateSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule floorRateSchedule) {
            this.floorRateSchedule = floorRateSchedule == null ? null : floorRateSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption rateOption) {
            this.rateOption = rateOption == null ? null : rateOption.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setRateOptionValue(FloatingRateOption rateOption) {
            this.getOrCreateRateOption().setValue(rateOption);
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder setSpreadSchedule(SpreadSchedule spreadSchedule) {
            this.spreadSchedule = spreadSchedule == null ? null : spreadSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRateSpecification build() {
            return new FloatingRateSpecificationImpl(this);
        }

        @Override
        public FloatingRateSpecificationBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder prune() {
            super.prune();
            if (this.finalRateRounding != null && !this.finalRateRounding.prune().hasData()) {
                this.finalRateRounding = null;
            }
            if (this.initialRate != null && !this.initialRate.prune().hasData()) {
                this.initialRate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAveragingMethod() != null) {
                return true;
            }
            if (this.getFinalRateRounding() != null && this.getFinalRateRounding().hasData()) {
                return true;
            }
            if (this.getInitialRate() != null && this.getInitialRate().hasData()) {
                return true;
            }
            return this.getNegativeInterestRateTreatment() != null;
        }

        @Override
        public FloatingRateSpecificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FloatingRateSpecificationBuilder o = (FloatingRateSpecificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalRateRounding(), (RosettaModelObjectBuilder)o.getFinalRateRounding(), this::setFinalRateRounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialRate(), (RosettaModelObjectBuilder)o.getInitialRate(), this::setInitialRate);
            merger.mergeBasic((Object)this.getAveragingMethod(), (Object)o.getAveragingMethod(), this::setAveragingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNegativeInterestRateTreatment(), (Object)o.getNegativeInterestRateTreatment(), this::setNegativeInterestRateTreatment, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRateSpecification _that = (FloatingRateSpecification)this.getType().cast(o);
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            if (!Objects.equals(this.finalRateRounding, _that.getFinalRateRounding())) {
                return false;
            }
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            return Objects.equals((Object)this.negativeInterestRateTreatment, (Object)_that.getNegativeInterestRateTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalRateRounding != null ? this.finalRateRounding.hashCode() : 0);
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRateTreatment != null ? ((Object)((Object)this.negativeInterestRateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRateSpecificationBuilder {averagingMethod=" + (Object)((Object)this.averagingMethod) + ", finalRateRounding=" + this.finalRateRounding + ", initialRate=" + this.initialRate + ", negativeInterestRateTreatment=" + (Object)((Object)this.negativeInterestRateTreatment) + '}' + " " + super.toString();
        }
    }

    public static class FloatingRateSpecificationImpl
    extends FloatingRate.FloatingRateImpl
    implements FloatingRateSpecification {
        private final AveragingWeightingMethodEnum averagingMethod;
        private final Rounding finalRateRounding;
        private final Price initialRate;
        private final NegativeInterestRateTreatmentEnum negativeInterestRateTreatment;

        protected FloatingRateSpecificationImpl(FloatingRateSpecificationBuilder builder) {
            super(builder);
            this.averagingMethod = builder.getAveragingMethod();
            this.finalRateRounding = Optional.ofNullable(builder.getFinalRateRounding()).map(f -> f.build()).orElse(null);
            this.initialRate = Optional.ofNullable(builder.getInitialRate()).map(f -> f.build()).orElse(null);
            this.negativeInterestRateTreatment = builder.getNegativeInterestRateTreatment();
        }

        @Override
        public AveragingWeightingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        public Rounding getFinalRateRounding() {
            return this.finalRateRounding;
        }

        @Override
        public Price getInitialRate() {
            return this.initialRate;
        }

        @Override
        public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment() {
            return this.negativeInterestRateTreatment;
        }

        @Override
        public FloatingRateSpecification build() {
            return this;
        }

        @Override
        public FloatingRateSpecificationBuilder toBuilder() {
            FloatingRateSpecificationBuilder builder = FloatingRateSpecification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateSpecificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAveragingMethod()).ifPresent(builder::setAveragingMethod);
            Optional.ofNullable(this.getFinalRateRounding()).ifPresent(builder::setFinalRateRounding);
            Optional.ofNullable(this.getInitialRate()).ifPresent(builder::setInitialRate);
            Optional.ofNullable(this.getNegativeInterestRateTreatment()).ifPresent(builder::setNegativeInterestRateTreatment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRateSpecification _that = (FloatingRateSpecification)this.getType().cast(o);
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            if (!Objects.equals(this.finalRateRounding, _that.getFinalRateRounding())) {
                return false;
            }
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            return Objects.equals((Object)this.negativeInterestRateTreatment, (Object)_that.getNegativeInterestRateTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalRateRounding != null ? this.finalRateRounding.hashCode() : 0);
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRateTreatment != null ? ((Object)((Object)this.negativeInterestRateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRateSpecification {averagingMethod=" + (Object)((Object)this.averagingMethod) + ", finalRateRounding=" + this.finalRateRounding + ", initialRate=" + this.initialRate + ", negativeInterestRateTreatment=" + (Object)((Object)this.negativeInterestRateTreatment) + '}' + " " + super.toString();
        }
    }

    public static interface FloatingRateSpecificationBuilder
    extends FloatingRateSpecification,
    FloatingRate.FloatingRateBuilder,
    RosettaModelObjectBuilder {
        public Rounding.RoundingBuilder getOrCreateFinalRateRounding();

        @Override
        public Rounding.RoundingBuilder getFinalRateRounding();

        public Price.PriceBuilder getOrCreateInitialRate();

        @Override
        public Price.PriceBuilder getInitialRate();

        public FloatingRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum var1);

        public FloatingRateSpecificationBuilder setFinalRateRounding(Rounding var1);

        public FloatingRateSpecificationBuilder setInitialRate(Price var1);

        public FloatingRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum var1);

        @Override
        public FloatingRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters var1);

        @Override
        public FloatingRateSpecificationBuilder setFallbackRate(FallbackRateParameters var1);

        @Override
        public FloatingRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule var1);

        @Override
        public FloatingRateSpecificationBuilder setRateTreatment(RateTreatmentEnum var1);

        @Override
        public FloatingRateSpecificationBuilder setCapRateSchedule(StrikeSchedule var1);

        @Override
        public FloatingRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule var1);

        @Override
        public FloatingRateSpecificationBuilder setMeta(MetaFields var1);

        @Override
        public FloatingRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption var1);

        @Override
        public FloatingRateSpecificationBuilder setRateOptionValue(FloatingRateOption var1);

        @Override
        public FloatingRateSpecificationBuilder setSpreadSchedule(SpreadSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            FloatingRate.FloatingRateBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingWeightingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.RoundingBuilder.class, this.getFinalRateRounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialRate"), processor, Price.PriceBuilder.class, this.getInitialRate(), new AttributeMeta[0]);
        }

        @Override
        public FloatingRateSpecificationBuilder prune();
    }
}

