/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.calculatedrate.FallbackRateParameters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateBase;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.SpreadSchedule;
import cdm.product.asset.meta.FloatingRateMeta;
import cdm.product.common.schedule.RateSchedule;
import cdm.product.template.StrikeSchedule;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FloatingRate
extends FloatingRateBase {
    public static final FloatingRateMeta metaData = new FloatingRateMeta();

    @Override
    public FloatingRate build();

    @Override
    public FloatingRateBuilder toBuilder();

    public FloatingRateCalculationParameters getCalculationParameters();

    public FallbackRateParameters getFallbackRate();

    public RateSchedule getFloatingRateMultiplierSchedule();

    public RateTreatmentEnum getRateTreatment();

    default public RosettaMetaData<? extends FloatingRate> metaData() {
        return metaData;
    }

    public static FloatingRateBuilder builder() {
        return new FloatingRateBuilderImpl();
    }

    default public Class<? extends FloatingRate> getType() {
        return FloatingRate.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        FloatingRateBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationParameters"), processor, FloatingRateCalculationParameters.class, this.getCalculationParameters(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fallbackRate"), processor, FallbackRateParameters.class, this.getFallbackRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, RateSchedule.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
    }

    public static class FloatingRateBuilderImpl
    extends FloatingRateBase.FloatingRateBaseBuilderImpl
    implements FloatingRateBuilder {
        protected FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder calculationParameters;
        protected FallbackRateParameters.FallbackRateParametersBuilder fallbackRate;
        protected RateSchedule.RateScheduleBuilder floatingRateMultiplierSchedule;
        protected RateTreatmentEnum rateTreatment;

        @Override
        public FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder getCalculationParameters() {
            return this.calculationParameters;
        }

        @Override
        public FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder getOrCreateCalculationParameters() {
            FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder result = this.calculationParameters != null ? this.calculationParameters : (this.calculationParameters = FloatingRateCalculationParameters.builder());
            return result;
        }

        @Override
        public FallbackRateParameters.FallbackRateParametersBuilder getFallbackRate() {
            return this.fallbackRate;
        }

        @Override
        public FallbackRateParameters.FallbackRateParametersBuilder getOrCreateFallbackRate() {
            FallbackRateParameters.FallbackRateParametersBuilder result = this.fallbackRate != null ? this.fallbackRate : (this.fallbackRate = FallbackRateParameters.builder());
            return result;
        }

        @Override
        public RateSchedule.RateScheduleBuilder getFloatingRateMultiplierSchedule() {
            return this.floatingRateMultiplierSchedule;
        }

        @Override
        public RateSchedule.RateScheduleBuilder getOrCreateFloatingRateMultiplierSchedule() {
            RateSchedule.RateScheduleBuilder result = this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule : (this.floatingRateMultiplierSchedule = RateSchedule.builder());
            return result;
        }

        @Override
        public RateTreatmentEnum getRateTreatment() {
            return this.rateTreatment;
        }

        @Override
        public FloatingRateBuilder setCalculationParameters(FloatingRateCalculationParameters calculationParameters) {
            this.calculationParameters = calculationParameters == null ? null : calculationParameters.toBuilder();
            return this;
        }

        @Override
        public FloatingRateBuilder setFallbackRate(FallbackRateParameters fallbackRate) {
            this.fallbackRate = fallbackRate == null ? null : fallbackRate.toBuilder();
            return this;
        }

        @Override
        public FloatingRateBuilder setFloatingRateMultiplierSchedule(RateSchedule floatingRateMultiplierSchedule) {
            this.floatingRateMultiplierSchedule = floatingRateMultiplierSchedule == null ? null : floatingRateMultiplierSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRateBuilder setRateTreatment(RateTreatmentEnum rateTreatment) {
            this.rateTreatment = rateTreatment == null ? null : rateTreatment;
            return this;
        }

        @Override
        public FloatingRateBuilder setCapRateSchedule(StrikeSchedule capRateSchedule) {
            this.capRateSchedule = capRateSchedule == null ? null : capRateSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRateBuilder setFloorRateSchedule(StrikeSchedule floorRateSchedule) {
            this.floorRateSchedule = floorRateSchedule == null ? null : floorRateSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRateBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public FloatingRateBuilder setRateOption(ReferenceWithMetaFloatingRateOption rateOption) {
            this.rateOption = rateOption == null ? null : rateOption.toBuilder();
            return this;
        }

        @Override
        public FloatingRateBuilder setRateOptionValue(FloatingRateOption rateOption) {
            this.getOrCreateRateOption().setValue(rateOption);
            return this;
        }

        @Override
        public FloatingRateBuilder setSpreadSchedule(SpreadSchedule spreadSchedule) {
            this.spreadSchedule = spreadSchedule == null ? null : spreadSchedule.toBuilder();
            return this;
        }

        @Override
        public FloatingRate build() {
            return new FloatingRateImpl(this);
        }

        @Override
        public FloatingRateBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateBuilder prune() {
            super.prune();
            if (this.calculationParameters != null && !this.calculationParameters.prune().hasData()) {
                this.calculationParameters = null;
            }
            if (this.fallbackRate != null && !this.fallbackRate.prune().hasData()) {
                this.fallbackRate = null;
            }
            if (this.floatingRateMultiplierSchedule != null && !this.floatingRateMultiplierSchedule.prune().hasData()) {
                this.floatingRateMultiplierSchedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCalculationParameters() != null && this.getCalculationParameters().hasData()) {
                return true;
            }
            if (this.getFallbackRate() != null && this.getFallbackRate().hasData()) {
                return true;
            }
            if (this.getFloatingRateMultiplierSchedule() != null && this.getFloatingRateMultiplierSchedule().hasData()) {
                return true;
            }
            return this.getRateTreatment() != null;
        }

        @Override
        public FloatingRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FloatingRateBuilder o = (FloatingRateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationParameters(), (RosettaModelObjectBuilder)o.getCalculationParameters(), this::setCalculationParameters);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFallbackRate(), (RosettaModelObjectBuilder)o.getFallbackRate(), this::setFallbackRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateMultiplierSchedule(), (RosettaModelObjectBuilder)o.getFloatingRateMultiplierSchedule(), this::setFloatingRateMultiplierSchedule);
            merger.mergeBasic((Object)this.getRateTreatment(), (Object)o.getRateTreatment(), this::setRateTreatment, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRate _that = (FloatingRate)this.getType().cast(o);
            if (!Objects.equals(this.calculationParameters, _that.getCalculationParameters())) {
                return false;
            }
            if (!Objects.equals(this.fallbackRate, _that.getFallbackRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateMultiplierSchedule, _that.getFloatingRateMultiplierSchedule())) {
                return false;
            }
            return Objects.equals((Object)this.rateTreatment, (Object)_that.getRateTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.calculationParameters != null ? this.calculationParameters.hashCode() : 0);
            _result = 31 * _result + (this.fallbackRate != null ? this.fallbackRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule.hashCode() : 0);
            _result = 31 * _result + (this.rateTreatment != null ? ((Object)((Object)this.rateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRateBuilder {calculationParameters=" + this.calculationParameters + ", fallbackRate=" + this.fallbackRate + ", floatingRateMultiplierSchedule=" + this.floatingRateMultiplierSchedule + ", rateTreatment=" + (Object)((Object)this.rateTreatment) + '}' + " " + super.toString();
        }
    }

    public static class FloatingRateImpl
    extends FloatingRateBase.FloatingRateBaseImpl
    implements FloatingRate {
        private final FloatingRateCalculationParameters calculationParameters;
        private final FallbackRateParameters fallbackRate;
        private final RateSchedule floatingRateMultiplierSchedule;
        private final RateTreatmentEnum rateTreatment;

        protected FloatingRateImpl(FloatingRateBuilder builder) {
            super(builder);
            this.calculationParameters = Optional.ofNullable(builder.getCalculationParameters()).map(f -> f.build()).orElse(null);
            this.fallbackRate = Optional.ofNullable(builder.getFallbackRate()).map(f -> f.build()).orElse(null);
            this.floatingRateMultiplierSchedule = Optional.ofNullable(builder.getFloatingRateMultiplierSchedule()).map(f -> f.build()).orElse(null);
            this.rateTreatment = builder.getRateTreatment();
        }

        @Override
        public FloatingRateCalculationParameters getCalculationParameters() {
            return this.calculationParameters;
        }

        @Override
        public FallbackRateParameters getFallbackRate() {
            return this.fallbackRate;
        }

        @Override
        public RateSchedule getFloatingRateMultiplierSchedule() {
            return this.floatingRateMultiplierSchedule;
        }

        @Override
        public RateTreatmentEnum getRateTreatment() {
            return this.rateTreatment;
        }

        @Override
        public FloatingRate build() {
            return this;
        }

        @Override
        public FloatingRateBuilder toBuilder() {
            FloatingRateBuilder builder = FloatingRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCalculationParameters()).ifPresent(builder::setCalculationParameters);
            Optional.ofNullable(this.getFallbackRate()).ifPresent(builder::setFallbackRate);
            Optional.ofNullable(this.getFloatingRateMultiplierSchedule()).ifPresent(builder::setFloatingRateMultiplierSchedule);
            Optional.ofNullable(this.getRateTreatment()).ifPresent(builder::setRateTreatment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRate _that = (FloatingRate)this.getType().cast(o);
            if (!Objects.equals(this.calculationParameters, _that.getCalculationParameters())) {
                return false;
            }
            if (!Objects.equals(this.fallbackRate, _that.getFallbackRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateMultiplierSchedule, _that.getFloatingRateMultiplierSchedule())) {
                return false;
            }
            return Objects.equals((Object)this.rateTreatment, (Object)_that.getRateTreatment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.calculationParameters != null ? this.calculationParameters.hashCode() : 0);
            _result = 31 * _result + (this.fallbackRate != null ? this.fallbackRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule.hashCode() : 0);
            _result = 31 * _result + (this.rateTreatment != null ? ((Object)((Object)this.rateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRate {calculationParameters=" + this.calculationParameters + ", fallbackRate=" + this.fallbackRate + ", floatingRateMultiplierSchedule=" + this.floatingRateMultiplierSchedule + ", rateTreatment=" + (Object)((Object)this.rateTreatment) + '}' + " " + super.toString();
        }
    }

    public static interface FloatingRateBuilder
    extends FloatingRate,
    FloatingRateBase.FloatingRateBaseBuilder,
    RosettaModelObjectBuilder {
        public FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder getOrCreateCalculationParameters();

        @Override
        public FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder getCalculationParameters();

        public FallbackRateParameters.FallbackRateParametersBuilder getOrCreateFallbackRate();

        @Override
        public FallbackRateParameters.FallbackRateParametersBuilder getFallbackRate();

        public RateSchedule.RateScheduleBuilder getOrCreateFloatingRateMultiplierSchedule();

        @Override
        public RateSchedule.RateScheduleBuilder getFloatingRateMultiplierSchedule();

        public FloatingRateBuilder setCalculationParameters(FloatingRateCalculationParameters var1);

        public FloatingRateBuilder setFallbackRate(FallbackRateParameters var1);

        public FloatingRateBuilder setFloatingRateMultiplierSchedule(RateSchedule var1);

        public FloatingRateBuilder setRateTreatment(RateTreatmentEnum var1);

        @Override
        public FloatingRateBuilder setCapRateSchedule(StrikeSchedule var1);

        @Override
        public FloatingRateBuilder setFloorRateSchedule(StrikeSchedule var1);

        @Override
        public FloatingRateBuilder setMeta(MetaFields var1);

        @Override
        public FloatingRateBuilder setRateOption(ReferenceWithMetaFloatingRateOption var1);

        @Override
        public FloatingRateBuilder setRateOptionValue(FloatingRateOption var1);

        @Override
        public FloatingRateBuilder setSpreadSchedule(SpreadSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            FloatingRateBase.FloatingRateBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationParameters"), processor, FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder.class, this.getCalculationParameters(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fallbackRate"), processor, FallbackRateParameters.FallbackRateParametersBuilder.class, this.getFallbackRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, RateSchedule.RateScheduleBuilder.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
        }

        @Override
        public FloatingRateBuilder prune();
    }
}

