/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.observable.asset.Money;
import cdm.product.asset.meta.FixedAmountCalculationDetailsMeta;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FixedAmountCalculationDetails
extends RosettaModelObject {
    public static final FixedAmountCalculationDetailsMeta metaData = new FixedAmountCalculationDetailsMeta();

    public FixedAmountCalculationDetails build();

    public FixedAmountCalculationDetailsBuilder toBuilder();

    public BigDecimal getCalculatedAmount();

    public CalculationPeriodBase getCalculationPeriod();

    public Money getCalculationPeriodNotionalAmount();

    public BigDecimal getFixedRate();

    public BigDecimal getYearFraction();

    default public RosettaMetaData<? extends FixedAmountCalculationDetails> metaData() {
        return metaData;
    }

    public static FixedAmountCalculationDetailsBuilder builder() {
        return new FixedAmountCalculationDetailsBuilderImpl();
    }

    default public Class<? extends FixedAmountCalculationDetails> getType() {
        return FixedAmountCalculationDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("calculatedAmount"), BigDecimal.class, (Object)this.getCalculatedAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("yearFraction"), BigDecimal.class, (Object)this.getYearFraction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriodBase.class, this.getCalculationPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriodNotionalAmount"), processor, Money.class, this.getCalculationPeriodNotionalAmount(), new AttributeMeta[0]);
    }

    public static class FixedAmountCalculationDetailsBuilderImpl
    implements FixedAmountCalculationDetailsBuilder {
        protected BigDecimal calculatedAmount;
        protected CalculationPeriodBase.CalculationPeriodBaseBuilder calculationPeriod;
        protected Money.MoneyBuilder calculationPeriodNotionalAmount;
        protected BigDecimal fixedRate;
        protected BigDecimal yearFraction;

        @Override
        public BigDecimal getCalculatedAmount() {
            return this.calculatedAmount;
        }

        @Override
        public CalculationPeriodBase.CalculationPeriodBaseBuilder getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public CalculationPeriodBase.CalculationPeriodBaseBuilder getOrCreateCalculationPeriod() {
            CalculationPeriodBase.CalculationPeriodBaseBuilder result = this.calculationPeriod != null ? this.calculationPeriod : (this.calculationPeriod = CalculationPeriodBase.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getCalculationPeriodNotionalAmount() {
            return this.calculationPeriodNotionalAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateCalculationPeriodNotionalAmount() {
            Money.MoneyBuilder result = this.calculationPeriodNotionalAmount != null ? this.calculationPeriodNotionalAmount : (this.calculationPeriodNotionalAmount = Money.builder());
            return result;
        }

        @Override
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public BigDecimal getYearFraction() {
            return this.yearFraction;
        }

        @Override
        public FixedAmountCalculationDetailsBuilder setCalculatedAmount(BigDecimal calculatedAmount) {
            this.calculatedAmount = calculatedAmount == null ? null : calculatedAmount;
            return this;
        }

        @Override
        public FixedAmountCalculationDetailsBuilder setCalculationPeriod(CalculationPeriodBase calculationPeriod) {
            this.calculationPeriod = calculationPeriod == null ? null : calculationPeriod.toBuilder();
            return this;
        }

        @Override
        public FixedAmountCalculationDetailsBuilder setCalculationPeriodNotionalAmount(Money calculationPeriodNotionalAmount) {
            this.calculationPeriodNotionalAmount = calculationPeriodNotionalAmount == null ? null : calculationPeriodNotionalAmount.toBuilder();
            return this;
        }

        @Override
        public FixedAmountCalculationDetailsBuilder setFixedRate(BigDecimal fixedRate) {
            this.fixedRate = fixedRate == null ? null : fixedRate;
            return this;
        }

        @Override
        public FixedAmountCalculationDetailsBuilder setYearFraction(BigDecimal yearFraction) {
            this.yearFraction = yearFraction == null ? null : yearFraction;
            return this;
        }

        @Override
        public FixedAmountCalculationDetails build() {
            return new FixedAmountCalculationDetailsImpl(this);
        }

        @Override
        public FixedAmountCalculationDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedAmountCalculationDetailsBuilder prune() {
            if (this.calculationPeriod != null && !this.calculationPeriod.prune().hasData()) {
                this.calculationPeriod = null;
            }
            if (this.calculationPeriodNotionalAmount != null && !this.calculationPeriodNotionalAmount.prune().hasData()) {
                this.calculationPeriodNotionalAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCalculatedAmount() != null) {
                return true;
            }
            if (this.getCalculationPeriod() != null && this.getCalculationPeriod().hasData()) {
                return true;
            }
            if (this.getCalculationPeriodNotionalAmount() != null && this.getCalculationPeriodNotionalAmount().hasData()) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            return this.getYearFraction() != null;
        }

        public FixedAmountCalculationDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FixedAmountCalculationDetailsBuilder o = (FixedAmountCalculationDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriod(), (RosettaModelObjectBuilder)o.getCalculationPeriod(), this::setCalculationPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriodNotionalAmount(), (RosettaModelObjectBuilder)o.getCalculationPeriodNotionalAmount(), this::setCalculationPeriodNotionalAmount);
            merger.mergeBasic((Object)this.getCalculatedAmount(), (Object)o.getCalculatedAmount(), this::setCalculatedAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getYearFraction(), (Object)o.getYearFraction(), this::setYearFraction, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FixedAmountCalculationDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.calculatedAmount, _that.getCalculatedAmount())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodNotionalAmount, _that.getCalculationPeriodNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return Objects.equals(this.yearFraction, _that.getYearFraction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculatedAmount != null ? this.calculatedAmount.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodNotionalAmount != null ? this.calculationPeriodNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.yearFraction != null ? this.yearFraction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FixedAmountCalculationDetailsBuilder {calculatedAmount=" + this.calculatedAmount + ", calculationPeriod=" + this.calculationPeriod + ", calculationPeriodNotionalAmount=" + this.calculationPeriodNotionalAmount + ", fixedRate=" + this.fixedRate + ", yearFraction=" + this.yearFraction + '}';
        }
    }

    public static class FixedAmountCalculationDetailsImpl
    implements FixedAmountCalculationDetails {
        private final BigDecimal calculatedAmount;
        private final CalculationPeriodBase calculationPeriod;
        private final Money calculationPeriodNotionalAmount;
        private final BigDecimal fixedRate;
        private final BigDecimal yearFraction;

        protected FixedAmountCalculationDetailsImpl(FixedAmountCalculationDetailsBuilder builder) {
            this.calculatedAmount = builder.getCalculatedAmount();
            this.calculationPeriod = Optional.ofNullable(builder.getCalculationPeriod()).map(f -> f.build()).orElse(null);
            this.calculationPeriodNotionalAmount = Optional.ofNullable(builder.getCalculationPeriodNotionalAmount()).map(f -> f.build()).orElse(null);
            this.fixedRate = builder.getFixedRate();
            this.yearFraction = builder.getYearFraction();
        }

        @Override
        public BigDecimal getCalculatedAmount() {
            return this.calculatedAmount;
        }

        @Override
        public CalculationPeriodBase getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public Money getCalculationPeriodNotionalAmount() {
            return this.calculationPeriodNotionalAmount;
        }

        @Override
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public BigDecimal getYearFraction() {
            return this.yearFraction;
        }

        @Override
        public FixedAmountCalculationDetails build() {
            return this;
        }

        @Override
        public FixedAmountCalculationDetailsBuilder toBuilder() {
            FixedAmountCalculationDetailsBuilder builder = FixedAmountCalculationDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedAmountCalculationDetailsBuilder builder) {
            Optional.ofNullable(this.getCalculatedAmount()).ifPresent(builder::setCalculatedAmount);
            Optional.ofNullable(this.getCalculationPeriod()).ifPresent(builder::setCalculationPeriod);
            Optional.ofNullable(this.getCalculationPeriodNotionalAmount()).ifPresent(builder::setCalculationPeriodNotionalAmount);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getYearFraction()).ifPresent(builder::setYearFraction);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FixedAmountCalculationDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.calculatedAmount, _that.getCalculatedAmount())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodNotionalAmount, _that.getCalculationPeriodNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return Objects.equals(this.yearFraction, _that.getYearFraction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculatedAmount != null ? this.calculatedAmount.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodNotionalAmount != null ? this.calculationPeriodNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.yearFraction != null ? this.yearFraction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FixedAmountCalculationDetails {calculatedAmount=" + this.calculatedAmount + ", calculationPeriod=" + this.calculationPeriod + ", calculationPeriodNotionalAmount=" + this.calculationPeriodNotionalAmount + ", fixedRate=" + this.fixedRate + ", yearFraction=" + this.yearFraction + '}';
        }
    }

    public static interface FixedAmountCalculationDetailsBuilder
    extends FixedAmountCalculationDetails,
    RosettaModelObjectBuilder {
        public CalculationPeriodBase.CalculationPeriodBaseBuilder getOrCreateCalculationPeriod();

        @Override
        public CalculationPeriodBase.CalculationPeriodBaseBuilder getCalculationPeriod();

        public Money.MoneyBuilder getOrCreateCalculationPeriodNotionalAmount();

        @Override
        public Money.MoneyBuilder getCalculationPeriodNotionalAmount();

        public FixedAmountCalculationDetailsBuilder setCalculatedAmount(BigDecimal var1);

        public FixedAmountCalculationDetailsBuilder setCalculationPeriod(CalculationPeriodBase var1);

        public FixedAmountCalculationDetailsBuilder setCalculationPeriodNotionalAmount(Money var1);

        public FixedAmountCalculationDetailsBuilder setFixedRate(BigDecimal var1);

        public FixedAmountCalculationDetailsBuilder setYearFraction(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("calculatedAmount"), BigDecimal.class, (Object)this.getCalculatedAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("yearFraction"), BigDecimal.class, (Object)this.getYearFraction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriodBase.CalculationPeriodBaseBuilder.class, this.getCalculationPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriodNotionalAmount"), processor, Money.MoneyBuilder.class, this.getCalculationPeriodNotionalAmount(), new AttributeMeta[0]);
        }

        public FixedAmountCalculationDetailsBuilder prune();
    }
}

