/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.BusinessDayAdjustments;
import cdm.product.asset.DividendPaymentDate;
import cdm.product.asset.meta.DividendPeriodMeta;
import cdm.product.template.Product;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface DividendPeriod
extends RosettaModelObject {
    public static final DividendPeriodMeta metaData = new DividendPeriodMeta();

    public DividendPeriod build();

    public DividendPeriodBuilder toBuilder();

    public Product getBasketConstituent();

    public BusinessDayAdjustments getDateAdjustments();

    public DividendPaymentDate getDividendPaymentDate();

    public AdjustableOrRelativeDate getDividendValuationDate();

    public DividendPaymentDate getEndDate();

    public DividendPaymentDate getStartDate();

    default public RosettaMetaData<? extends DividendPeriod> metaData() {
        return metaData;
    }

    public static DividendPeriodBuilder builder() {
        return new DividendPeriodBuilderImpl();
    }

    default public Class<? extends DividendPeriod> getType() {
        return DividendPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.class, this.getBasketConstituent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendPaymentDate"), processor, DividendPaymentDate.class, this.getDividendPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendValuationDate"), processor, AdjustableOrRelativeDate.class, this.getDividendValuationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("endDate"), processor, DividendPaymentDate.class, this.getEndDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("startDate"), processor, DividendPaymentDate.class, this.getStartDate(), new AttributeMeta[0]);
    }

    public static class DividendPeriodBuilderImpl
    implements DividendPeriodBuilder {
        protected Product.ProductBuilder basketConstituent;
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected DividendPaymentDate.DividendPaymentDateBuilder dividendPaymentDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder dividendValuationDate;
        protected DividendPaymentDate.DividendPaymentDateBuilder endDate;
        protected DividendPaymentDate.DividendPaymentDateBuilder startDate;

        @Override
        public Product.ProductBuilder getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public Product.ProductBuilder getOrCreateBasketConstituent() {
            Product.ProductBuilder result = this.basketConstituent != null ? this.basketConstituent : (this.basketConstituent = Product.builder());
            return result;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getDividendPaymentDate() {
            return this.dividendPaymentDate;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateDividendPaymentDate() {
            DividendPaymentDate.DividendPaymentDateBuilder result = this.dividendPaymentDate != null ? this.dividendPaymentDate : (this.dividendPaymentDate = DividendPaymentDate.builder());
            return result;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getDividendValuationDate() {
            return this.dividendValuationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateDividendValuationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.dividendValuationDate != null ? this.dividendValuationDate : (this.dividendValuationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getEndDate() {
            return this.endDate;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateEndDate() {
            DividendPaymentDate.DividendPaymentDateBuilder result = this.endDate != null ? this.endDate : (this.endDate = DividendPaymentDate.builder());
            return result;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getStartDate() {
            return this.startDate;
        }

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateStartDate() {
            DividendPaymentDate.DividendPaymentDateBuilder result = this.startDate != null ? this.startDate : (this.startDate = DividendPaymentDate.builder());
            return result;
        }

        @Override
        public DividendPeriodBuilder setBasketConstituent(Product basketConstituent) {
            this.basketConstituent = basketConstituent == null ? null : basketConstituent.toBuilder();
            return this;
        }

        @Override
        public DividendPeriodBuilder setDateAdjustments(BusinessDayAdjustments dateAdjustments) {
            this.dateAdjustments = dateAdjustments == null ? null : dateAdjustments.toBuilder();
            return this;
        }

        @Override
        public DividendPeriodBuilder setDividendPaymentDate(DividendPaymentDate dividendPaymentDate) {
            this.dividendPaymentDate = dividendPaymentDate == null ? null : dividendPaymentDate.toBuilder();
            return this;
        }

        @Override
        public DividendPeriodBuilder setDividendValuationDate(AdjustableOrRelativeDate dividendValuationDate) {
            this.dividendValuationDate = dividendValuationDate == null ? null : dividendValuationDate.toBuilder();
            return this;
        }

        @Override
        public DividendPeriodBuilder setEndDate(DividendPaymentDate endDate) {
            this.endDate = endDate == null ? null : endDate.toBuilder();
            return this;
        }

        @Override
        public DividendPeriodBuilder setStartDate(DividendPaymentDate startDate) {
            this.startDate = startDate == null ? null : startDate.toBuilder();
            return this;
        }

        @Override
        public DividendPeriod build() {
            return new DividendPeriodImpl(this);
        }

        @Override
        public DividendPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendPeriodBuilder prune() {
            if (this.basketConstituent != null && !this.basketConstituent.prune().hasData()) {
                this.basketConstituent = null;
            }
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            if (this.dividendPaymentDate != null && !this.dividendPaymentDate.prune().hasData()) {
                this.dividendPaymentDate = null;
            }
            if (this.dividendValuationDate != null && !this.dividendValuationDate.prune().hasData()) {
                this.dividendValuationDate = null;
            }
            if (this.endDate != null && !this.endDate.prune().hasData()) {
                this.endDate = null;
            }
            if (this.startDate != null && !this.startDate.prune().hasData()) {
                this.startDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBasketConstituent() != null && this.getBasketConstituent().hasData()) {
                return true;
            }
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            if (this.getDividendPaymentDate() != null && this.getDividendPaymentDate().hasData()) {
                return true;
            }
            if (this.getDividendValuationDate() != null && this.getDividendValuationDate().hasData()) {
                return true;
            }
            if (this.getEndDate() != null && this.getEndDate().hasData()) {
                return true;
            }
            return this.getStartDate() != null && this.getStartDate().hasData();
        }

        public DividendPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DividendPeriodBuilder o = (DividendPeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketConstituent(), (RosettaModelObjectBuilder)o.getBasketConstituent(), this::setBasketConstituent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendPaymentDate(), (RosettaModelObjectBuilder)o.getDividendPaymentDate(), this::setDividendPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendValuationDate(), (RosettaModelObjectBuilder)o.getDividendValuationDate(), this::setDividendValuationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEndDate(), (RosettaModelObjectBuilder)o.getEndDate(), this::setEndDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStartDate(), (RosettaModelObjectBuilder)o.getStartDate(), this::setStartDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.dividendPaymentDate, _that.getDividendPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.dividendValuationDate, _that.getDividendValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            return Objects.equals(this.startDate, _that.getStartDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.dividendPaymentDate != null ? this.dividendPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.dividendValuationDate != null ? this.dividendValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendPeriodBuilder {basketConstituent=" + this.basketConstituent + ", dateAdjustments=" + this.dateAdjustments + ", dividendPaymentDate=" + this.dividendPaymentDate + ", dividendValuationDate=" + this.dividendValuationDate + ", endDate=" + this.endDate + ", startDate=" + this.startDate + '}';
        }
    }

    public static class DividendPeriodImpl
    implements DividendPeriod {
        private final Product basketConstituent;
        private final BusinessDayAdjustments dateAdjustments;
        private final DividendPaymentDate dividendPaymentDate;
        private final AdjustableOrRelativeDate dividendValuationDate;
        private final DividendPaymentDate endDate;
        private final DividendPaymentDate startDate;

        protected DividendPeriodImpl(DividendPeriodBuilder builder) {
            this.basketConstituent = Optional.ofNullable(builder.getBasketConstituent()).map(f -> f.build()).orElse(null);
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.dividendPaymentDate = Optional.ofNullable(builder.getDividendPaymentDate()).map(f -> f.build()).orElse(null);
            this.dividendValuationDate = Optional.ofNullable(builder.getDividendValuationDate()).map(f -> f.build()).orElse(null);
            this.endDate = Optional.ofNullable(builder.getEndDate()).map(f -> f.build()).orElse(null);
            this.startDate = Optional.ofNullable(builder.getStartDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Product getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public DividendPaymentDate getDividendPaymentDate() {
            return this.dividendPaymentDate;
        }

        @Override
        public AdjustableOrRelativeDate getDividendValuationDate() {
            return this.dividendValuationDate;
        }

        @Override
        public DividendPaymentDate getEndDate() {
            return this.endDate;
        }

        @Override
        public DividendPaymentDate getStartDate() {
            return this.startDate;
        }

        @Override
        public DividendPeriod build() {
            return this;
        }

        @Override
        public DividendPeriodBuilder toBuilder() {
            DividendPeriodBuilder builder = DividendPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendPeriodBuilder builder) {
            Optional.ofNullable(this.getBasketConstituent()).ifPresent(builder::setBasketConstituent);
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getDividendPaymentDate()).ifPresent(builder::setDividendPaymentDate);
            Optional.ofNullable(this.getDividendValuationDate()).ifPresent(builder::setDividendValuationDate);
            Optional.ofNullable(this.getEndDate()).ifPresent(builder::setEndDate);
            Optional.ofNullable(this.getStartDate()).ifPresent(builder::setStartDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.dividendPaymentDate, _that.getDividendPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.dividendValuationDate, _that.getDividendValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            return Objects.equals(this.startDate, _that.getStartDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.dividendPaymentDate != null ? this.dividendPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.dividendValuationDate != null ? this.dividendValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendPeriod {basketConstituent=" + this.basketConstituent + ", dateAdjustments=" + this.dateAdjustments + ", dividendPaymentDate=" + this.dividendPaymentDate + ", dividendValuationDate=" + this.dividendValuationDate + ", endDate=" + this.endDate + ", startDate=" + this.startDate + '}';
        }
    }

    public static interface DividendPeriodBuilder
    extends DividendPeriod,
    RosettaModelObjectBuilder {
        public Product.ProductBuilder getOrCreateBasketConstituent();

        @Override
        public Product.ProductBuilder getBasketConstituent();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateDividendPaymentDate();

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getDividendPaymentDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateDividendValuationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getDividendValuationDate();

        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateEndDate();

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getEndDate();

        public DividendPaymentDate.DividendPaymentDateBuilder getOrCreateStartDate();

        @Override
        public DividendPaymentDate.DividendPaymentDateBuilder getStartDate();

        public DividendPeriodBuilder setBasketConstituent(Product var1);

        public DividendPeriodBuilder setDateAdjustments(BusinessDayAdjustments var1);

        public DividendPeriodBuilder setDividendPaymentDate(DividendPaymentDate var1);

        public DividendPeriodBuilder setDividendValuationDate(AdjustableOrRelativeDate var1);

        public DividendPeriodBuilder setEndDate(DividendPaymentDate var1);

        public DividendPeriodBuilder setStartDate(DividendPaymentDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.ProductBuilder.class, this.getBasketConstituent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendPaymentDate"), processor, DividendPaymentDate.DividendPaymentDateBuilder.class, this.getDividendPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendValuationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getDividendValuationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("endDate"), processor, DividendPaymentDate.DividendPaymentDateBuilder.class, this.getEndDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("startDate"), processor, DividendPaymentDate.DividendPaymentDateBuilder.class, this.getStartDate(), new AttributeMeta[0]);
        }

        public DividendPeriodBuilder prune();
    }
}

