/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.meta.DividendPayoutRatioMeta;
import cdm.product.template.Product;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface DividendPayoutRatio
extends RosettaModelObject {
    public static final DividendPayoutRatioMeta metaData = new DividendPayoutRatioMeta();

    public DividendPayoutRatio build();

    public DividendPayoutRatioBuilder toBuilder();

    public Product getBasketConstituent();

    public BigDecimal getCashRatio();

    public BigDecimal getNonCashRatio();

    public BigDecimal getTotalRatio();

    default public RosettaMetaData<? extends DividendPayoutRatio> metaData() {
        return metaData;
    }

    public static DividendPayoutRatioBuilder builder() {
        return new DividendPayoutRatioBuilderImpl();
    }

    default public Class<? extends DividendPayoutRatio> getType() {
        return DividendPayoutRatio.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("cashRatio"), BigDecimal.class, (Object)this.getCashRatio(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonCashRatio"), BigDecimal.class, (Object)this.getNonCashRatio(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalRatio"), BigDecimal.class, (Object)this.getTotalRatio(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.class, this.getBasketConstituent(), new AttributeMeta[0]);
    }

    public static class DividendPayoutRatioBuilderImpl
    implements DividendPayoutRatioBuilder {
        protected Product.ProductBuilder basketConstituent;
        protected BigDecimal cashRatio;
        protected BigDecimal nonCashRatio;
        protected BigDecimal totalRatio;

        @Override
        public Product.ProductBuilder getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public Product.ProductBuilder getOrCreateBasketConstituent() {
            Product.ProductBuilder result = this.basketConstituent != null ? this.basketConstituent : (this.basketConstituent = Product.builder());
            return result;
        }

        @Override
        public BigDecimal getCashRatio() {
            return this.cashRatio;
        }

        @Override
        public BigDecimal getNonCashRatio() {
            return this.nonCashRatio;
        }

        @Override
        public BigDecimal getTotalRatio() {
            return this.totalRatio;
        }

        @Override
        public DividendPayoutRatioBuilder setBasketConstituent(Product basketConstituent) {
            this.basketConstituent = basketConstituent == null ? null : basketConstituent.toBuilder();
            return this;
        }

        @Override
        public DividendPayoutRatioBuilder setCashRatio(BigDecimal cashRatio) {
            this.cashRatio = cashRatio == null ? null : cashRatio;
            return this;
        }

        @Override
        public DividendPayoutRatioBuilder setNonCashRatio(BigDecimal nonCashRatio) {
            this.nonCashRatio = nonCashRatio == null ? null : nonCashRatio;
            return this;
        }

        @Override
        public DividendPayoutRatioBuilder setTotalRatio(BigDecimal totalRatio) {
            this.totalRatio = totalRatio == null ? null : totalRatio;
            return this;
        }

        @Override
        public DividendPayoutRatio build() {
            return new DividendPayoutRatioImpl(this);
        }

        @Override
        public DividendPayoutRatioBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendPayoutRatioBuilder prune() {
            if (this.basketConstituent != null && !this.basketConstituent.prune().hasData()) {
                this.basketConstituent = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBasketConstituent() != null && this.getBasketConstituent().hasData()) {
                return true;
            }
            if (this.getCashRatio() != null) {
                return true;
            }
            if (this.getNonCashRatio() != null) {
                return true;
            }
            return this.getTotalRatio() != null;
        }

        public DividendPayoutRatioBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DividendPayoutRatioBuilder o = (DividendPayoutRatioBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketConstituent(), (RosettaModelObjectBuilder)o.getBasketConstituent(), this::setBasketConstituent);
            merger.mergeBasic((Object)this.getCashRatio(), (Object)o.getCashRatio(), this::setCashRatio, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonCashRatio(), (Object)o.getNonCashRatio(), this::setNonCashRatio, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalRatio(), (Object)o.getTotalRatio(), this::setTotalRatio, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendPayoutRatio _that = this.getType().cast(o);
            if (!Objects.equals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            if (!Objects.equals(this.cashRatio, _that.getCashRatio())) {
                return false;
            }
            if (!Objects.equals(this.nonCashRatio, _that.getNonCashRatio())) {
                return false;
            }
            return Objects.equals(this.totalRatio, _that.getTotalRatio());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.cashRatio != null ? this.cashRatio.hashCode() : 0);
            _result = 31 * _result + (this.nonCashRatio != null ? this.nonCashRatio.hashCode() : 0);
            _result = 31 * _result + (this.totalRatio != null ? this.totalRatio.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendPayoutRatioBuilder {basketConstituent=" + this.basketConstituent + ", cashRatio=" + this.cashRatio + ", nonCashRatio=" + this.nonCashRatio + ", totalRatio=" + this.totalRatio + '}';
        }
    }

    public static class DividendPayoutRatioImpl
    implements DividendPayoutRatio {
        private final Product basketConstituent;
        private final BigDecimal cashRatio;
        private final BigDecimal nonCashRatio;
        private final BigDecimal totalRatio;

        protected DividendPayoutRatioImpl(DividendPayoutRatioBuilder builder) {
            this.basketConstituent = Optional.ofNullable(builder.getBasketConstituent()).map(f -> f.build()).orElse(null);
            this.cashRatio = builder.getCashRatio();
            this.nonCashRatio = builder.getNonCashRatio();
            this.totalRatio = builder.getTotalRatio();
        }

        @Override
        public Product getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public BigDecimal getCashRatio() {
            return this.cashRatio;
        }

        @Override
        public BigDecimal getNonCashRatio() {
            return this.nonCashRatio;
        }

        @Override
        public BigDecimal getTotalRatio() {
            return this.totalRatio;
        }

        @Override
        public DividendPayoutRatio build() {
            return this;
        }

        @Override
        public DividendPayoutRatioBuilder toBuilder() {
            DividendPayoutRatioBuilder builder = DividendPayoutRatio.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendPayoutRatioBuilder builder) {
            Optional.ofNullable(this.getBasketConstituent()).ifPresent(builder::setBasketConstituent);
            Optional.ofNullable(this.getCashRatio()).ifPresent(builder::setCashRatio);
            Optional.ofNullable(this.getNonCashRatio()).ifPresent(builder::setNonCashRatio);
            Optional.ofNullable(this.getTotalRatio()).ifPresent(builder::setTotalRatio);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendPayoutRatio _that = this.getType().cast(o);
            if (!Objects.equals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            if (!Objects.equals(this.cashRatio, _that.getCashRatio())) {
                return false;
            }
            if (!Objects.equals(this.nonCashRatio, _that.getNonCashRatio())) {
                return false;
            }
            return Objects.equals(this.totalRatio, _that.getTotalRatio());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.cashRatio != null ? this.cashRatio.hashCode() : 0);
            _result = 31 * _result + (this.nonCashRatio != null ? this.nonCashRatio.hashCode() : 0);
            _result = 31 * _result + (this.totalRatio != null ? this.totalRatio.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendPayoutRatio {basketConstituent=" + this.basketConstituent + ", cashRatio=" + this.cashRatio + ", nonCashRatio=" + this.nonCashRatio + ", totalRatio=" + this.totalRatio + '}';
        }
    }

    public static interface DividendPayoutRatioBuilder
    extends DividendPayoutRatio,
    RosettaModelObjectBuilder {
        public Product.ProductBuilder getOrCreateBasketConstituent();

        @Override
        public Product.ProductBuilder getBasketConstituent();

        public DividendPayoutRatioBuilder setBasketConstituent(Product var1);

        public DividendPayoutRatioBuilder setCashRatio(BigDecimal var1);

        public DividendPayoutRatioBuilder setNonCashRatio(BigDecimal var1);

        public DividendPayoutRatioBuilder setTotalRatio(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("cashRatio"), BigDecimal.class, (Object)this.getCashRatio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonCashRatio"), BigDecimal.class, (Object)this.getNonCashRatio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalRatio"), BigDecimal.class, (Object)this.getTotalRatio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.ProductBuilder.class, this.getBasketConstituent(), new AttributeMeta[0]);
        }

        public DividendPayoutRatioBuilder prune();
    }
}

