/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.Offset;
import cdm.product.asset.DividendDateReferenceEnum;
import cdm.product.asset.meta.DividendDateReferenceMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface DividendDateReference
extends RosettaModelObject {
    public static final DividendDateReferenceMeta metaData = new DividendDateReferenceMeta();

    public DividendDateReference build();

    public DividendDateReferenceBuilder toBuilder();

    public DividendDateReferenceEnum getDateReference();

    public Offset getPaymentDateOffset();

    default public RosettaMetaData<? extends DividendDateReference> metaData() {
        return metaData;
    }

    public static DividendDateReferenceBuilder builder() {
        return new DividendDateReferenceBuilderImpl();
    }

    default public Class<? extends DividendDateReference> getType() {
        return DividendDateReference.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dateReference"), DividendDateReferenceEnum.class, (Object)this.getDateReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDateOffset"), processor, Offset.class, this.getPaymentDateOffset(), new AttributeMeta[0]);
    }

    public static class DividendDateReferenceBuilderImpl
    implements DividendDateReferenceBuilder {
        protected DividendDateReferenceEnum dateReference;
        protected Offset.OffsetBuilder paymentDateOffset;

        @Override
        public DividendDateReferenceEnum getDateReference() {
            return this.dateReference;
        }

        @Override
        public Offset.OffsetBuilder getPaymentDateOffset() {
            return this.paymentDateOffset;
        }

        @Override
        public Offset.OffsetBuilder getOrCreatePaymentDateOffset() {
            Offset.OffsetBuilder result = this.paymentDateOffset != null ? this.paymentDateOffset : (this.paymentDateOffset = Offset.builder());
            return result;
        }

        @Override
        public DividendDateReferenceBuilder setDateReference(DividendDateReferenceEnum dateReference) {
            this.dateReference = dateReference == null ? null : dateReference;
            return this;
        }

        @Override
        public DividendDateReferenceBuilder setPaymentDateOffset(Offset paymentDateOffset) {
            this.paymentDateOffset = paymentDateOffset == null ? null : paymentDateOffset.toBuilder();
            return this;
        }

        @Override
        public DividendDateReference build() {
            return new DividendDateReferenceImpl(this);
        }

        @Override
        public DividendDateReferenceBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendDateReferenceBuilder prune() {
            if (this.paymentDateOffset != null && !this.paymentDateOffset.prune().hasData()) {
                this.paymentDateOffset = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDateReference() != null) {
                return true;
            }
            return this.getPaymentDateOffset() != null && this.getPaymentDateOffset().hasData();
        }

        public DividendDateReferenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DividendDateReferenceBuilder o = (DividendDateReferenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDateOffset(), (RosettaModelObjectBuilder)o.getPaymentDateOffset(), this::setPaymentDateOffset);
            merger.mergeBasic((Object)this.getDateReference(), (Object)o.getDateReference(), this::setDateReference, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendDateReference _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dateReference, (Object)_that.getDateReference())) {
                return false;
            }
            return Objects.equals(this.paymentDateOffset, _that.getPaymentDateOffset());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateReference != null ? ((Object)((Object)this.dateReference)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.paymentDateOffset != null ? this.paymentDateOffset.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendDateReferenceBuilder {dateReference=" + (Object)((Object)this.dateReference) + ", paymentDateOffset=" + this.paymentDateOffset + '}';
        }
    }

    public static class DividendDateReferenceImpl
    implements DividendDateReference {
        private final DividendDateReferenceEnum dateReference;
        private final Offset paymentDateOffset;

        protected DividendDateReferenceImpl(DividendDateReferenceBuilder builder) {
            this.dateReference = builder.getDateReference();
            this.paymentDateOffset = Optional.ofNullable(builder.getPaymentDateOffset()).map(f -> f.build()).orElse(null);
        }

        @Override
        public DividendDateReferenceEnum getDateReference() {
            return this.dateReference;
        }

        @Override
        public Offset getPaymentDateOffset() {
            return this.paymentDateOffset;
        }

        @Override
        public DividendDateReference build() {
            return this;
        }

        @Override
        public DividendDateReferenceBuilder toBuilder() {
            DividendDateReferenceBuilder builder = DividendDateReference.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendDateReferenceBuilder builder) {
            Optional.ofNullable(this.getDateReference()).ifPresent(builder::setDateReference);
            Optional.ofNullable(this.getPaymentDateOffset()).ifPresent(builder::setPaymentDateOffset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendDateReference _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dateReference, (Object)_that.getDateReference())) {
                return false;
            }
            return Objects.equals(this.paymentDateOffset, _that.getPaymentDateOffset());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateReference != null ? ((Object)((Object)this.dateReference)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.paymentDateOffset != null ? this.paymentDateOffset.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendDateReference {dateReference=" + (Object)((Object)this.dateReference) + ", paymentDateOffset=" + this.paymentDateOffset + '}';
        }
    }

    public static interface DividendDateReferenceBuilder
    extends DividendDateReference,
    RosettaModelObjectBuilder {
        public Offset.OffsetBuilder getOrCreatePaymentDateOffset();

        @Override
        public Offset.OffsetBuilder getPaymentDateOffset();

        public DividendDateReferenceBuilder setDateReference(DividendDateReferenceEnum var1);

        public DividendDateReferenceBuilder setPaymentDateOffset(Offset var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dateReference"), DividendDateReferenceEnum.class, (Object)this.getDateReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDateOffset"), processor, Offset.OffsetBuilder.class, this.getPaymentDateOffset(), new AttributeMeta[0]);
        }

        public DividendDateReferenceBuilder prune();
    }
}

