/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.TransactedPrice;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ProtectionTerms;
import cdm.product.asset.meta.CreditDefaultPayoutMeta;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CreditDefaultPayout
extends PayoutBase,
GlobalKey {
    public static final CreditDefaultPayoutMeta metaData = new CreditDefaultPayoutMeta();

    @Override
    public CreditDefaultPayout build();

    @Override
    public CreditDefaultPayoutBuilder toBuilder();

    public GeneralTerms getGeneralTerms();

    public MetaFields getMeta();

    public List<? extends ProtectionTerms> getProtectionTerms();

    public TransactedPrice getTransactedPrice();

    default public RosettaMetaData<? extends CreditDefaultPayout> metaData() {
        return metaData;
    }

    public static CreditDefaultPayoutBuilder builder() {
        return new CreditDefaultPayoutBuilderImpl();
    }

    default public Class<? extends CreditDefaultPayout> getType() {
        return CreditDefaultPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("generalTerms"), processor, GeneralTerms.class, this.getGeneralTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("protectionTerms"), processor, ProtectionTerms.class, this.getProtectionTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transactedPrice"), processor, TransactedPrice.class, this.getTransactedPrice(), new AttributeMeta[0]);
    }

    public static class CreditDefaultPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements CreditDefaultPayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected GeneralTerms.GeneralTermsBuilder generalTerms;
        protected MetaFields.MetaFieldsBuilder meta;
        protected List<ProtectionTerms.ProtectionTermsBuilder> protectionTerms = new ArrayList<ProtectionTerms.ProtectionTermsBuilder>();
        protected TransactedPrice.TransactedPriceBuilder transactedPrice;

        @Override
        public GeneralTerms.GeneralTermsBuilder getGeneralTerms() {
            return this.generalTerms;
        }

        @Override
        public GeneralTerms.GeneralTermsBuilder getOrCreateGeneralTerms() {
            GeneralTerms.GeneralTermsBuilder result = this.generalTerms != null ? this.generalTerms : (this.generalTerms = GeneralTerms.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public List<? extends ProtectionTerms.ProtectionTermsBuilder> getProtectionTerms() {
            return this.protectionTerms;
        }

        @Override
        public ProtectionTerms.ProtectionTermsBuilder getOrCreateProtectionTerms(int _index) {
            if (this.protectionTerms == null) {
                this.protectionTerms = new ArrayList<ProtectionTerms.ProtectionTermsBuilder>();
            }
            return (ProtectionTerms.ProtectionTermsBuilder)this.getIndex(this.protectionTerms, _index, () -> {
                ProtectionTerms.ProtectionTermsBuilder newProtectionTerms = ProtectionTerms.builder();
                return newProtectionTerms;
            });
        }

        @Override
        public TransactedPrice.TransactedPriceBuilder getTransactedPrice() {
            return this.transactedPrice;
        }

        @Override
        public TransactedPrice.TransactedPriceBuilder getOrCreateTransactedPrice() {
            TransactedPrice.TransactedPriceBuilder result = this.transactedPrice != null ? this.transactedPrice : (this.transactedPrice = TransactedPrice.builder());
            return result;
        }

        @Override
        public CreditDefaultPayoutBuilder setGeneralTerms(GeneralTerms generalTerms) {
            this.generalTerms = generalTerms == null ? null : generalTerms.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms protectionTerms) {
            if (protectionTerms != null) {
                this.protectionTerms.add(protectionTerms.toBuilder());
            }
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms protectionTerms, int _idx) {
            this.getIndex(this.protectionTerms, _idx, () -> protectionTerms.toBuilder());
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder addProtectionTerms(List<? extends ProtectionTerms> protectionTermss) {
            if (protectionTermss != null) {
                for (ProtectionTerms protectionTerms : protectionTermss) {
                    this.protectionTerms.add(protectionTerms.toBuilder());
                }
            }
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder setProtectionTerms(List<? extends ProtectionTerms> protectionTermss) {
            this.protectionTerms = protectionTermss == null ? new ArrayList<ProtectionTerms.ProtectionTermsBuilder>() : (List)protectionTermss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder setTransactedPrice(TransactedPrice transactedPrice) {
            this.transactedPrice = transactedPrice == null ? null : transactedPrice.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public CreditDefaultPayout build() {
            return new CreditDefaultPayoutImpl(this);
        }

        @Override
        public CreditDefaultPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder prune() {
            super.prune();
            if (this.generalTerms != null && !this.generalTerms.prune().hasData()) {
                this.generalTerms = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            this.protectionTerms = this.protectionTerms.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.transactedPrice != null && !this.transactedPrice.prune().hasData()) {
                this.transactedPrice = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getGeneralTerms() != null && this.getGeneralTerms().hasData()) {
                return true;
            }
            if (this.getProtectionTerms() != null && this.getProtectionTerms().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getTransactedPrice() != null && this.getTransactedPrice().hasData();
        }

        @Override
        public CreditDefaultPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditDefaultPayoutBuilder o = (CreditDefaultPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGeneralTerms(), (RosettaModelObjectBuilder)o.getGeneralTerms(), this::setGeneralTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta(this.getProtectionTerms(), o.getProtectionTerms(), this::getOrCreateProtectionTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTransactedPrice(), (RosettaModelObjectBuilder)o.getTransactedPrice(), this::setTransactedPrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditDefaultPayout _that = (CreditDefaultPayout)this.getType().cast(o);
            if (!Objects.equals(this.generalTerms, _that.getGeneralTerms())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.protectionTerms, _that.getProtectionTerms())) {
                return false;
            }
            return Objects.equals(this.transactedPrice, _that.getTransactedPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.generalTerms != null ? this.generalTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.protectionTerms != null ? this.protectionTerms.hashCode() : 0);
            _result = 31 * _result + (this.transactedPrice != null ? this.transactedPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditDefaultPayoutBuilder {generalTerms=" + this.generalTerms + ", meta=" + this.meta + ", protectionTerms=" + this.protectionTerms + ", transactedPrice=" + this.transactedPrice + '}' + " " + super.toString();
        }
    }

    public static class CreditDefaultPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements CreditDefaultPayout {
        private final GeneralTerms generalTerms;
        private final MetaFields meta;
        private final List<? extends ProtectionTerms> protectionTerms;
        private final TransactedPrice transactedPrice;

        protected CreditDefaultPayoutImpl(CreditDefaultPayoutBuilder builder) {
            super(builder);
            this.generalTerms = Optional.ofNullable(builder.getGeneralTerms()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.protectionTerms = Optional.ofNullable(builder.getProtectionTerms()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.transactedPrice = Optional.ofNullable(builder.getTransactedPrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        public GeneralTerms getGeneralTerms() {
            return this.generalTerms;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public List<? extends ProtectionTerms> getProtectionTerms() {
            return this.protectionTerms;
        }

        @Override
        public TransactedPrice getTransactedPrice() {
            return this.transactedPrice;
        }

        @Override
        public CreditDefaultPayout build() {
            return this;
        }

        @Override
        public CreditDefaultPayoutBuilder toBuilder() {
            CreditDefaultPayoutBuilder builder = CreditDefaultPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditDefaultPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getGeneralTerms()).ifPresent(builder::setGeneralTerms);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getProtectionTerms()).ifPresent(builder::setProtectionTerms);
            Optional.ofNullable(this.getTransactedPrice()).ifPresent(builder::setTransactedPrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditDefaultPayout _that = (CreditDefaultPayout)this.getType().cast(o);
            if (!Objects.equals(this.generalTerms, _that.getGeneralTerms())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.protectionTerms, _that.getProtectionTerms())) {
                return false;
            }
            return Objects.equals(this.transactedPrice, _that.getTransactedPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.generalTerms != null ? this.generalTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.protectionTerms != null ? this.protectionTerms.hashCode() : 0);
            _result = 31 * _result + (this.transactedPrice != null ? this.transactedPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditDefaultPayout {generalTerms=" + this.generalTerms + ", meta=" + this.meta + ", protectionTerms=" + this.protectionTerms + ", transactedPrice=" + this.transactedPrice + '}' + " " + super.toString();
        }
    }

    public static interface CreditDefaultPayoutBuilder
    extends CreditDefaultPayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public GeneralTerms.GeneralTermsBuilder getOrCreateGeneralTerms();

        @Override
        public GeneralTerms.GeneralTermsBuilder getGeneralTerms();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ProtectionTerms.ProtectionTermsBuilder getOrCreateProtectionTerms(int var1);

        public List<? extends ProtectionTerms.ProtectionTermsBuilder> getProtectionTerms();

        public TransactedPrice.TransactedPriceBuilder getOrCreateTransactedPrice();

        @Override
        public TransactedPrice.TransactedPriceBuilder getTransactedPrice();

        public CreditDefaultPayoutBuilder setGeneralTerms(GeneralTerms var1);

        public CreditDefaultPayoutBuilder setMeta(MetaFields var1);

        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms var1);

        public CreditDefaultPayoutBuilder addProtectionTerms(ProtectionTerms var1, int var2);

        public CreditDefaultPayoutBuilder addProtectionTerms(List<? extends ProtectionTerms> var1);

        public CreditDefaultPayoutBuilder setProtectionTerms(List<? extends ProtectionTerms> var1);

        public CreditDefaultPayoutBuilder setTransactedPrice(TransactedPrice var1);

        @Override
        public CreditDefaultPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public CreditDefaultPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public CreditDefaultPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public CreditDefaultPayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("generalTerms"), processor, GeneralTerms.GeneralTermsBuilder.class, this.getGeneralTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("protectionTerms"), processor, ProtectionTerms.ProtectionTermsBuilder.class, this.getProtectionTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transactedPrice"), processor, TransactedPrice.TransactedPriceBuilder.class, this.getTransactedPrice(), new AttributeMeta[0]);
        }

        @Override
        public CreditDefaultPayoutBuilder prune();
    }
}

