/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.NumberRange;
import cdm.observable.asset.DividendApplicability;
import cdm.observable.asset.Price;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.product.asset.EquityUnderlierProvisions;
import cdm.product.asset.ReturnTermsBase;
import cdm.product.asset.ValuationTerms;
import cdm.product.asset.meta.CorrelationReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CorrelationReturnTerms
extends ReturnTermsBase {
    public static final CorrelationReturnTermsMeta metaData = new CorrelationReturnTermsMeta();

    @Override
    public CorrelationReturnTerms build();

    @Override
    public CorrelationReturnTermsBuilder toBuilder();

    public NumberRange getBoundedCorrelation();

    public Price getCorrelationStrikePrice();

    public Integer getNumberOfDataSeries();

    default public RosettaMetaData<? extends CorrelationReturnTerms> metaData() {
        return metaData;
    }

    public static CorrelationReturnTermsBuilder builder() {
        return new CorrelationReturnTermsBuilderImpl();
    }

    default public Class<? extends CorrelationReturnTerms> getType() {
        return CorrelationReturnTerms.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        ReturnTermsBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("numberOfDataSeries"), Integer.class, (Object)this.getNumberOfDataSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("boundedCorrelation"), processor, NumberRange.class, this.getBoundedCorrelation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationStrikePrice"), processor, Price.class, this.getCorrelationStrikePrice(), new AttributeMeta[0]);
    }

    public static class CorrelationReturnTermsBuilderImpl
    extends ReturnTermsBase.ReturnTermsBaseBuilderImpl
    implements CorrelationReturnTermsBuilder {
        protected NumberRange.NumberRangeBuilder boundedCorrelation;
        protected Price.PriceBuilder correlationStrikePrice;
        protected Integer numberOfDataSeries;

        @Override
        public NumberRange.NumberRangeBuilder getBoundedCorrelation() {
            return this.boundedCorrelation;
        }

        @Override
        public NumberRange.NumberRangeBuilder getOrCreateBoundedCorrelation() {
            NumberRange.NumberRangeBuilder result = this.boundedCorrelation != null ? this.boundedCorrelation : (this.boundedCorrelation = NumberRange.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getCorrelationStrikePrice() {
            return this.correlationStrikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateCorrelationStrikePrice() {
            Price.PriceBuilder result = this.correlationStrikePrice != null ? this.correlationStrikePrice : (this.correlationStrikePrice = Price.builder());
            return result;
        }

        @Override
        public Integer getNumberOfDataSeries() {
            return this.numberOfDataSeries;
        }

        @Override
        public CorrelationReturnTermsBuilder setBoundedCorrelation(NumberRange boundedCorrelation) {
            this.boundedCorrelation = boundedCorrelation == null ? null : boundedCorrelation.toBuilder();
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setCorrelationStrikePrice(Price correlationStrikePrice) {
            this.correlationStrikePrice = correlationStrikePrice == null ? null : correlationStrikePrice.toBuilder();
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setNumberOfDataSeries(Integer numberOfDataSeries) {
            this.numberOfDataSeries = numberOfDataSeries == null ? null : numberOfDataSeries;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setAnnualizationFactor(Integer annualizationFactor) {
            this.annualizationFactor = annualizationFactor == null ? null : annualizationFactor;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setDividendApplicability(DividendApplicability dividendApplicability) {
            this.dividendApplicability = dividendApplicability == null ? null : dividendApplicability.toBuilder();
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions equityUnderlierProvisions) {
            this.equityUnderlierProvisions = equityUnderlierProvisions == null ? null : equityUnderlierProvisions.toBuilder();
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setExpectedN(Integer expectedN) {
            this.expectedN = expectedN == null ? null : expectedN;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setInitialLevel(BigDecimal initialLevel) {
            this.initialLevel = initialLevel == null ? null : initialLevel;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum initialLevelSource) {
            this.initialLevelSource = initialLevelSource == null ? null : initialLevelSource;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setMeanAdjustment(Boolean meanAdjustment) {
            this.meanAdjustment = meanAdjustment == null ? null : meanAdjustment;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setPerformance(String performance) {
            this.performance = performance == null ? null : performance;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setSharePriceDividendAdjustment(Boolean sharePriceDividendAdjustment) {
            this.sharePriceDividendAdjustment = sharePriceDividendAdjustment == null ? null : sharePriceDividendAdjustment;
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder setValuationTerms(ValuationTerms valuationTerms) {
            this.valuationTerms = valuationTerms == null ? null : valuationTerms.toBuilder();
            return this;
        }

        @Override
        public CorrelationReturnTerms build() {
            return new CorrelationReturnTermsImpl(this);
        }

        @Override
        public CorrelationReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder prune() {
            super.prune();
            if (this.boundedCorrelation != null && !this.boundedCorrelation.prune().hasData()) {
                this.boundedCorrelation = null;
            }
            if (this.correlationStrikePrice != null && !this.correlationStrikePrice.prune().hasData()) {
                this.correlationStrikePrice = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBoundedCorrelation() != null && this.getBoundedCorrelation().hasData()) {
                return true;
            }
            if (this.getCorrelationStrikePrice() != null && this.getCorrelationStrikePrice().hasData()) {
                return true;
            }
            return this.getNumberOfDataSeries() != null;
        }

        @Override
        public CorrelationReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CorrelationReturnTermsBuilder o = (CorrelationReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBoundedCorrelation(), (RosettaModelObjectBuilder)o.getBoundedCorrelation(), this::setBoundedCorrelation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorrelationStrikePrice(), (RosettaModelObjectBuilder)o.getCorrelationStrikePrice(), this::setCorrelationStrikePrice);
            merger.mergeBasic((Object)this.getNumberOfDataSeries(), (Object)o.getNumberOfDataSeries(), this::setNumberOfDataSeries, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CorrelationReturnTerms _that = (CorrelationReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.boundedCorrelation, _that.getBoundedCorrelation())) {
                return false;
            }
            if (!Objects.equals(this.correlationStrikePrice, _that.getCorrelationStrikePrice())) {
                return false;
            }
            return Objects.equals(this.numberOfDataSeries, _that.getNumberOfDataSeries());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.boundedCorrelation != null ? this.boundedCorrelation.hashCode() : 0);
            _result = 31 * _result + (this.correlationStrikePrice != null ? this.correlationStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.numberOfDataSeries != null ? this.numberOfDataSeries.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CorrelationReturnTermsBuilder {boundedCorrelation=" + this.boundedCorrelation + ", correlationStrikePrice=" + this.correlationStrikePrice + ", numberOfDataSeries=" + this.numberOfDataSeries + '}' + " " + super.toString();
        }
    }

    public static class CorrelationReturnTermsImpl
    extends ReturnTermsBase.ReturnTermsBaseImpl
    implements CorrelationReturnTerms {
        private final NumberRange boundedCorrelation;
        private final Price correlationStrikePrice;
        private final Integer numberOfDataSeries;

        protected CorrelationReturnTermsImpl(CorrelationReturnTermsBuilder builder) {
            super(builder);
            this.boundedCorrelation = Optional.ofNullable(builder.getBoundedCorrelation()).map(f -> f.build()).orElse(null);
            this.correlationStrikePrice = Optional.ofNullable(builder.getCorrelationStrikePrice()).map(f -> f.build()).orElse(null);
            this.numberOfDataSeries = builder.getNumberOfDataSeries();
        }

        @Override
        public NumberRange getBoundedCorrelation() {
            return this.boundedCorrelation;
        }

        @Override
        public Price getCorrelationStrikePrice() {
            return this.correlationStrikePrice;
        }

        @Override
        public Integer getNumberOfDataSeries() {
            return this.numberOfDataSeries;
        }

        @Override
        public CorrelationReturnTerms build() {
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder toBuilder() {
            CorrelationReturnTermsBuilder builder = CorrelationReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CorrelationReturnTermsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBoundedCorrelation()).ifPresent(builder::setBoundedCorrelation);
            Optional.ofNullable(this.getCorrelationStrikePrice()).ifPresent(builder::setCorrelationStrikePrice);
            Optional.ofNullable(this.getNumberOfDataSeries()).ifPresent(builder::setNumberOfDataSeries);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CorrelationReturnTerms _that = (CorrelationReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.boundedCorrelation, _that.getBoundedCorrelation())) {
                return false;
            }
            if (!Objects.equals(this.correlationStrikePrice, _that.getCorrelationStrikePrice())) {
                return false;
            }
            return Objects.equals(this.numberOfDataSeries, _that.getNumberOfDataSeries());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.boundedCorrelation != null ? this.boundedCorrelation.hashCode() : 0);
            _result = 31 * _result + (this.correlationStrikePrice != null ? this.correlationStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.numberOfDataSeries != null ? this.numberOfDataSeries.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CorrelationReturnTerms {boundedCorrelation=" + this.boundedCorrelation + ", correlationStrikePrice=" + this.correlationStrikePrice + ", numberOfDataSeries=" + this.numberOfDataSeries + '}' + " " + super.toString();
        }
    }

    public static interface CorrelationReturnTermsBuilder
    extends CorrelationReturnTerms,
    ReturnTermsBase.ReturnTermsBaseBuilder,
    RosettaModelObjectBuilder {
        public NumberRange.NumberRangeBuilder getOrCreateBoundedCorrelation();

        @Override
        public NumberRange.NumberRangeBuilder getBoundedCorrelation();

        public Price.PriceBuilder getOrCreateCorrelationStrikePrice();

        @Override
        public Price.PriceBuilder getCorrelationStrikePrice();

        public CorrelationReturnTermsBuilder setBoundedCorrelation(NumberRange var1);

        public CorrelationReturnTermsBuilder setCorrelationStrikePrice(Price var1);

        public CorrelationReturnTermsBuilder setNumberOfDataSeries(Integer var1);

        @Override
        public CorrelationReturnTermsBuilder setAnnualizationFactor(Integer var1);

        @Override
        public CorrelationReturnTermsBuilder setDividendApplicability(DividendApplicability var1);

        @Override
        public CorrelationReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions var1);

        @Override
        public CorrelationReturnTermsBuilder setExpectedN(Integer var1);

        @Override
        public CorrelationReturnTermsBuilder setInitialLevel(BigDecimal var1);

        @Override
        public CorrelationReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum var1);

        @Override
        public CorrelationReturnTermsBuilder setMeanAdjustment(Boolean var1);

        @Override
        public CorrelationReturnTermsBuilder setPerformance(String var1);

        @Override
        public CorrelationReturnTermsBuilder setSharePriceDividendAdjustment(Boolean var1);

        @Override
        public CorrelationReturnTermsBuilder setValuationTerms(ValuationTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            ReturnTermsBase.ReturnTermsBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("numberOfDataSeries"), Integer.class, (Object)this.getNumberOfDataSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("boundedCorrelation"), processor, NumberRange.NumberRangeBuilder.class, this.getBoundedCorrelation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationStrikePrice"), processor, Price.PriceBuilder.class, this.getCorrelationStrikePrice(), new AttributeMeta[0]);
        }

        @Override
        public CorrelationReturnTermsBuilder prune();
    }
}

