/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.meta.CommodityPayoutMeta;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.CommodityPriceReturnTerms;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PricingDates;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.AveragingCalculation;
import cdm.product.template.CommoditySchedule;
import cdm.product.template.FxFeature;
import cdm.product.template.Product;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CommodityPayout
extends PayoutBase,
GlobalKey {
    public static final CommodityPayoutMeta metaData = new CommodityPayoutMeta();

    @Override
    public CommodityPayout build();

    @Override
    public CommodityPayoutBuilder toBuilder();

    public AveragingCalculation getAveragingFeature();

    public CalculationPeriodDates getCalculationPeriodDates();

    public CommodityPriceReturnTerms getCommodityPriceReturnTerms();

    public FxFeature getFxFeature();

    public MetaFields getMeta();

    public PaymentDates getPaymentDates();

    public PricingDates getPricingDates();

    public CommoditySchedule getSchedule();

    public Product getUnderlier();

    default public RosettaMetaData<? extends CommodityPayout> metaData() {
        return metaData;
    }

    public static CommodityPayoutBuilder builder() {
        return new CommodityPayoutBuilderImpl();
    }

    default public Class<? extends CommodityPayout> getType() {
        return CommodityPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("averagingFeature"), processor, AveragingCalculation.class, this.getAveragingFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityPriceReturnTerms"), processor, CommodityPriceReturnTerms.class, this.getCommodityPriceReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingDates"), processor, PricingDates.class, this.getPricingDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CommoditySchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Product.class, this.getUnderlier(), new AttributeMeta[0]);
    }

    public static class CommodityPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements CommodityPayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected AveragingCalculation.AveragingCalculationBuilder averagingFeature;
        protected CalculationPeriodDates.CalculationPeriodDatesBuilder calculationPeriodDates;
        protected CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder commodityPriceReturnTerms;
        protected FxFeature.FxFeatureBuilder fxFeature;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected PricingDates.PricingDatesBuilder pricingDates;
        protected CommoditySchedule.CommodityScheduleBuilder schedule;
        protected Product.ProductBuilder underlier;

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getAveragingFeature() {
            return this.averagingFeature;
        }

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingFeature() {
            AveragingCalculation.AveragingCalculationBuilder result = this.averagingFeature != null ? this.averagingFeature : (this.averagingFeature = AveragingCalculation.builder());
            return result;
        }

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates() {
            CalculationPeriodDates.CalculationPeriodDatesBuilder result = this.calculationPeriodDates != null ? this.calculationPeriodDates : (this.calculationPeriodDates = CalculationPeriodDates.builder());
            return result;
        }

        @Override
        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getCommodityPriceReturnTerms() {
            return this.commodityPriceReturnTerms;
        }

        @Override
        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getOrCreateCommodityPriceReturnTerms() {
            CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder result = this.commodityPriceReturnTerms != null ? this.commodityPriceReturnTerms : (this.commodityPriceReturnTerms = CommodityPriceReturnTerms.builder());
            return result;
        }

        @Override
        public FxFeature.FxFeatureBuilder getFxFeature() {
            return this.fxFeature;
        }

        @Override
        public FxFeature.FxFeatureBuilder getOrCreateFxFeature() {
            FxFeature.FxFeatureBuilder result = this.fxFeature != null ? this.fxFeature : (this.fxFeature = FxFeature.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        public PricingDates.PricingDatesBuilder getPricingDates() {
            return this.pricingDates;
        }

        @Override
        public PricingDates.PricingDatesBuilder getOrCreatePricingDates() {
            PricingDates.PricingDatesBuilder result = this.pricingDates != null ? this.pricingDates : (this.pricingDates = PricingDates.builder());
            return result;
        }

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getOrCreateSchedule() {
            CommoditySchedule.CommodityScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CommoditySchedule.builder());
            return result;
        }

        @Override
        public Product.ProductBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Product.ProductBuilder getOrCreateUnderlier() {
            Product.ProductBuilder result = this.underlier != null ? this.underlier : (this.underlier = Product.builder());
            return result;
        }

        @Override
        public CommodityPayoutBuilder setAveragingFeature(AveragingCalculation averagingFeature) {
            this.averagingFeature = averagingFeature == null ? null : averagingFeature.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setCalculationPeriodDates(CalculationPeriodDates calculationPeriodDates) {
            this.calculationPeriodDates = calculationPeriodDates == null ? null : calculationPeriodDates.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setCommodityPriceReturnTerms(CommodityPriceReturnTerms commodityPriceReturnTerms) {
            this.commodityPriceReturnTerms = commodityPriceReturnTerms == null ? null : commodityPriceReturnTerms.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setFxFeature(FxFeature fxFeature) {
            this.fxFeature = fxFeature == null ? null : fxFeature.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setPaymentDates(PaymentDates paymentDates) {
            this.paymentDates = paymentDates == null ? null : paymentDates.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setPricingDates(PricingDates pricingDates) {
            this.pricingDates = pricingDates == null ? null : pricingDates.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setSchedule(CommoditySchedule schedule) {
            this.schedule = schedule == null ? null : schedule.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setUnderlier(Product underlier) {
            this.underlier = underlier == null ? null : underlier.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        public CommodityPayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public CommodityPayout build() {
            return new CommodityPayoutImpl(this);
        }

        @Override
        public CommodityPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityPayoutBuilder prune() {
            super.prune();
            if (this.averagingFeature != null && !this.averagingFeature.prune().hasData()) {
                this.averagingFeature = null;
            }
            if (this.calculationPeriodDates != null && !this.calculationPeriodDates.prune().hasData()) {
                this.calculationPeriodDates = null;
            }
            if (this.commodityPriceReturnTerms != null && !this.commodityPriceReturnTerms.prune().hasData()) {
                this.commodityPriceReturnTerms = null;
            }
            if (this.fxFeature != null && !this.fxFeature.prune().hasData()) {
                this.fxFeature = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.pricingDates != null && !this.pricingDates.prune().hasData()) {
                this.pricingDates = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAveragingFeature() != null && this.getAveragingFeature().hasData()) {
                return true;
            }
            if (this.getCalculationPeriodDates() != null && this.getCalculationPeriodDates().hasData()) {
                return true;
            }
            if (this.getCommodityPriceReturnTerms() != null && this.getCommodityPriceReturnTerms().hasData()) {
                return true;
            }
            if (this.getFxFeature() != null && this.getFxFeature().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            if (this.getPricingDates() != null && this.getPricingDates().hasData()) {
                return true;
            }
            if (this.getSchedule() != null && this.getSchedule().hasData()) {
                return true;
            }
            return this.getUnderlier() != null && this.getUnderlier().hasData();
        }

        @Override
        public CommodityPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityPayoutBuilder o = (CommodityPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingFeature(), (RosettaModelObjectBuilder)o.getAveragingFeature(), this::setAveragingFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriodDates(), (RosettaModelObjectBuilder)o.getCalculationPeriodDates(), this::setCalculationPeriodDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityPriceReturnTerms(), (RosettaModelObjectBuilder)o.getCommodityPriceReturnTerms(), this::setCommodityPriceReturnTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFeature(), (RosettaModelObjectBuilder)o.getFxFeature(), this::setFxFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingDates(), (RosettaModelObjectBuilder)o.getPricingDates(), this::setPricingDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPayout _that = (CommodityPayout)this.getType().cast(o);
            if (!Objects.equals(this.averagingFeature, _that.getAveragingFeature())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.commodityPriceReturnTerms, _that.getCommodityPriceReturnTerms())) {
                return false;
            }
            if (!Objects.equals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.underlier, _that.getUnderlier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averagingFeature != null ? this.averagingFeature.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.commodityPriceReturnTerms != null ? this.commodityPriceReturnTerms.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPayoutBuilder {averagingFeature=" + this.averagingFeature + ", calculationPeriodDates=" + this.calculationPeriodDates + ", commodityPriceReturnTerms=" + this.commodityPriceReturnTerms + ", fxFeature=" + this.fxFeature + ", meta=" + this.meta + ", paymentDates=" + this.paymentDates + ", pricingDates=" + this.pricingDates + ", schedule=" + this.schedule + ", underlier=" + this.underlier + '}' + " " + super.toString();
        }
    }

    public static class CommodityPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements CommodityPayout {
        private final AveragingCalculation averagingFeature;
        private final CalculationPeriodDates calculationPeriodDates;
        private final CommodityPriceReturnTerms commodityPriceReturnTerms;
        private final FxFeature fxFeature;
        private final MetaFields meta;
        private final PaymentDates paymentDates;
        private final PricingDates pricingDates;
        private final CommoditySchedule schedule;
        private final Product underlier;

        protected CommodityPayoutImpl(CommodityPayoutBuilder builder) {
            super(builder);
            this.averagingFeature = Optional.ofNullable(builder.getAveragingFeature()).map(f -> f.build()).orElse(null);
            this.calculationPeriodDates = Optional.ofNullable(builder.getCalculationPeriodDates()).map(f -> f.build()).orElse(null);
            this.commodityPriceReturnTerms = Optional.ofNullable(builder.getCommodityPriceReturnTerms()).map(f -> f.build()).orElse(null);
            this.fxFeature = Optional.ofNullable(builder.getFxFeature()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.pricingDates = Optional.ofNullable(builder.getPricingDates()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AveragingCalculation getAveragingFeature() {
            return this.averagingFeature;
        }

        @Override
        public CalculationPeriodDates getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        public CommodityPriceReturnTerms getCommodityPriceReturnTerms() {
            return this.commodityPriceReturnTerms;
        }

        @Override
        public FxFeature getFxFeature() {
            return this.fxFeature;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PricingDates getPricingDates() {
            return this.pricingDates;
        }

        @Override
        public CommoditySchedule getSchedule() {
            return this.schedule;
        }

        @Override
        public Product getUnderlier() {
            return this.underlier;
        }

        @Override
        public CommodityPayout build() {
            return this;
        }

        @Override
        public CommodityPayoutBuilder toBuilder() {
            CommodityPayoutBuilder builder = CommodityPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAveragingFeature()).ifPresent(builder::setAveragingFeature);
            Optional.ofNullable(this.getCalculationPeriodDates()).ifPresent(builder::setCalculationPeriodDates);
            Optional.ofNullable(this.getCommodityPriceReturnTerms()).ifPresent(builder::setCommodityPriceReturnTerms);
            Optional.ofNullable(this.getFxFeature()).ifPresent(builder::setFxFeature);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getPricingDates()).ifPresent(builder::setPricingDates);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPayout _that = (CommodityPayout)this.getType().cast(o);
            if (!Objects.equals(this.averagingFeature, _that.getAveragingFeature())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.commodityPriceReturnTerms, _that.getCommodityPriceReturnTerms())) {
                return false;
            }
            if (!Objects.equals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.underlier, _that.getUnderlier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.averagingFeature != null ? this.averagingFeature.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.commodityPriceReturnTerms != null ? this.commodityPriceReturnTerms.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPayout {averagingFeature=" + this.averagingFeature + ", calculationPeriodDates=" + this.calculationPeriodDates + ", commodityPriceReturnTerms=" + this.commodityPriceReturnTerms + ", fxFeature=" + this.fxFeature + ", meta=" + this.meta + ", paymentDates=" + this.paymentDates + ", pricingDates=" + this.pricingDates + ", schedule=" + this.schedule + ", underlier=" + this.underlier + '}' + " " + super.toString();
        }
    }

    public static interface CommodityPayoutBuilder
    extends CommodityPayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingFeature();

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getAveragingFeature();

        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates();

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates();

        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getOrCreateCommodityPriceReturnTerms();

        @Override
        public CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder getCommodityPriceReturnTerms();

        public FxFeature.FxFeatureBuilder getOrCreateFxFeature();

        @Override
        public FxFeature.FxFeatureBuilder getFxFeature();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public PricingDates.PricingDatesBuilder getOrCreatePricingDates();

        @Override
        public PricingDates.PricingDatesBuilder getPricingDates();

        public CommoditySchedule.CommodityScheduleBuilder getOrCreateSchedule();

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getSchedule();

        public Product.ProductBuilder getOrCreateUnderlier();

        @Override
        public Product.ProductBuilder getUnderlier();

        public CommodityPayoutBuilder setAveragingFeature(AveragingCalculation var1);

        public CommodityPayoutBuilder setCalculationPeriodDates(CalculationPeriodDates var1);

        public CommodityPayoutBuilder setCommodityPriceReturnTerms(CommodityPriceReturnTerms var1);

        public CommodityPayoutBuilder setFxFeature(FxFeature var1);

        public CommodityPayoutBuilder setMeta(MetaFields var1);

        public CommodityPayoutBuilder setPaymentDates(PaymentDates var1);

        public CommodityPayoutBuilder setPricingDates(PricingDates var1);

        public CommodityPayoutBuilder setSchedule(CommoditySchedule var1);

        public CommodityPayoutBuilder setUnderlier(Product var1);

        @Override
        public CommodityPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public CommodityPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public CommodityPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public CommodityPayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("averagingFeature"), processor, AveragingCalculation.AveragingCalculationBuilder.class, this.getAveragingFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.CalculationPeriodDatesBuilder.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityPriceReturnTerms"), processor, CommodityPriceReturnTerms.CommodityPriceReturnTermsBuilder.class, this.getCommodityPriceReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingDates"), processor, PricingDates.PricingDatesBuilder.class, this.getPricingDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CommoditySchedule.CommodityScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Product.ProductBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
        }

        @Override
        public CommodityPayoutBuilder prune();
    }
}

