/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.meta.BoundedCorrelationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface BoundedCorrelation
extends RosettaModelObject {
    public static final BoundedCorrelationMeta metaData = new BoundedCorrelationMeta();

    public BoundedCorrelation build();

    public BoundedCorrelationBuilder toBuilder();

    public BigDecimal getMaximumBoundaryPercent();

    public BigDecimal getMinimumBoundaryPercent();

    default public RosettaMetaData<? extends BoundedCorrelation> metaData() {
        return metaData;
    }

    public static BoundedCorrelationBuilder builder() {
        return new BoundedCorrelationBuilderImpl();
    }

    default public Class<? extends BoundedCorrelation> getType() {
        return BoundedCorrelation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("maximumBoundaryPercent"), BigDecimal.class, (Object)this.getMaximumBoundaryPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("minimumBoundaryPercent"), BigDecimal.class, (Object)this.getMinimumBoundaryPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class BoundedCorrelationBuilderImpl
    implements BoundedCorrelationBuilder {
        protected BigDecimal maximumBoundaryPercent;
        protected BigDecimal minimumBoundaryPercent;

        @Override
        public BigDecimal getMaximumBoundaryPercent() {
            return this.maximumBoundaryPercent;
        }

        @Override
        public BigDecimal getMinimumBoundaryPercent() {
            return this.minimumBoundaryPercent;
        }

        @Override
        public BoundedCorrelationBuilder setMaximumBoundaryPercent(BigDecimal maximumBoundaryPercent) {
            this.maximumBoundaryPercent = maximumBoundaryPercent == null ? null : maximumBoundaryPercent;
            return this;
        }

        @Override
        public BoundedCorrelationBuilder setMinimumBoundaryPercent(BigDecimal minimumBoundaryPercent) {
            this.minimumBoundaryPercent = minimumBoundaryPercent == null ? null : minimumBoundaryPercent;
            return this;
        }

        @Override
        public BoundedCorrelation build() {
            return new BoundedCorrelationImpl(this);
        }

        @Override
        public BoundedCorrelationBuilder toBuilder() {
            return this;
        }

        @Override
        public BoundedCorrelationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getMaximumBoundaryPercent() != null) {
                return true;
            }
            return this.getMinimumBoundaryPercent() != null;
        }

        public BoundedCorrelationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BoundedCorrelationBuilder o = (BoundedCorrelationBuilder)other;
            merger.mergeBasic((Object)this.getMaximumBoundaryPercent(), (Object)o.getMaximumBoundaryPercent(), this::setMaximumBoundaryPercent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMinimumBoundaryPercent(), (Object)o.getMinimumBoundaryPercent(), this::setMinimumBoundaryPercent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BoundedCorrelation _that = this.getType().cast(o);
            if (!Objects.equals(this.maximumBoundaryPercent, _that.getMaximumBoundaryPercent())) {
                return false;
            }
            return Objects.equals(this.minimumBoundaryPercent, _that.getMinimumBoundaryPercent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.maximumBoundaryPercent != null ? this.maximumBoundaryPercent.hashCode() : 0);
            _result = 31 * _result + (this.minimumBoundaryPercent != null ? this.minimumBoundaryPercent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BoundedCorrelationBuilder {maximumBoundaryPercent=" + this.maximumBoundaryPercent + ", minimumBoundaryPercent=" + this.minimumBoundaryPercent + '}';
        }
    }

    public static class BoundedCorrelationImpl
    implements BoundedCorrelation {
        private final BigDecimal maximumBoundaryPercent;
        private final BigDecimal minimumBoundaryPercent;

        protected BoundedCorrelationImpl(BoundedCorrelationBuilder builder) {
            this.maximumBoundaryPercent = builder.getMaximumBoundaryPercent();
            this.minimumBoundaryPercent = builder.getMinimumBoundaryPercent();
        }

        @Override
        public BigDecimal getMaximumBoundaryPercent() {
            return this.maximumBoundaryPercent;
        }

        @Override
        public BigDecimal getMinimumBoundaryPercent() {
            return this.minimumBoundaryPercent;
        }

        @Override
        public BoundedCorrelation build() {
            return this;
        }

        @Override
        public BoundedCorrelationBuilder toBuilder() {
            BoundedCorrelationBuilder builder = BoundedCorrelation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BoundedCorrelationBuilder builder) {
            Optional.ofNullable(this.getMaximumBoundaryPercent()).ifPresent(builder::setMaximumBoundaryPercent);
            Optional.ofNullable(this.getMinimumBoundaryPercent()).ifPresent(builder::setMinimumBoundaryPercent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BoundedCorrelation _that = this.getType().cast(o);
            if (!Objects.equals(this.maximumBoundaryPercent, _that.getMaximumBoundaryPercent())) {
                return false;
            }
            return Objects.equals(this.minimumBoundaryPercent, _that.getMinimumBoundaryPercent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.maximumBoundaryPercent != null ? this.maximumBoundaryPercent.hashCode() : 0);
            _result = 31 * _result + (this.minimumBoundaryPercent != null ? this.minimumBoundaryPercent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BoundedCorrelation {maximumBoundaryPercent=" + this.maximumBoundaryPercent + ", minimumBoundaryPercent=" + this.minimumBoundaryPercent + '}';
        }
    }

    public static interface BoundedCorrelationBuilder
    extends BoundedCorrelation,
    RosettaModelObjectBuilder {
        public BoundedCorrelationBuilder setMaximumBoundaryPercent(BigDecimal var1);

        public BoundedCorrelationBuilder setMinimumBoundaryPercent(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("maximumBoundaryPercent"), BigDecimal.class, (Object)this.getMaximumBoundaryPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("minimumBoundaryPercent"), BigDecimal.class, (Object)this.getMinimumBoundaryPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public BoundedCorrelationBuilder prune();
    }
}

