/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.ReferencePool;
import cdm.product.asset.Tranche;
import cdm.product.asset.meta.BasketReferenceInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface BasketReferenceInformation
extends RosettaModelObject {
    public static final BasketReferenceInformationMeta metaData = new BasketReferenceInformationMeta();

    public BasketReferenceInformation build();

    public BasketReferenceInformationBuilder toBuilder();

    public List<? extends FieldWithMetaString> getBasketId();

    public FieldWithMetaString getBasketName();

    public Integer getMthToDefault();

    public Integer getNthToDefault();

    public ReferencePool getReferencePool();

    public Tranche getTranche();

    default public RosettaMetaData<? extends BasketReferenceInformation> metaData() {
        return metaData;
    }

    public static BasketReferenceInformationBuilder builder() {
        return new BasketReferenceInformationBuilderImpl();
    }

    default public Class<? extends BasketReferenceInformation> getType() {
        return BasketReferenceInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("mthToDefault"), Integer.class, (Object)this.getMthToDefault(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nthToDefault"), Integer.class, (Object)this.getNthToDefault(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketId"), processor, FieldWithMetaString.class, this.getBasketId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketName"), processor, FieldWithMetaString.class, this.getBasketName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referencePool"), processor, ReferencePool.class, this.getReferencePool(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tranche"), processor, Tranche.class, this.getTranche(), new AttributeMeta[0]);
    }

    public static class BasketReferenceInformationBuilderImpl
    implements BasketReferenceInformationBuilder {
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> basketId = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
        protected FieldWithMetaString.FieldWithMetaStringBuilder basketName;
        protected Integer mthToDefault;
        protected Integer nthToDefault;
        protected ReferencePool.ReferencePoolBuilder referencePool;
        protected Tranche.TrancheBuilder tranche;

        @Override
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getBasketId() {
            return this.basketId;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketId(int _index) {
            if (this.basketId == null) {
                this.basketId = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.basketId, _index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newBasketId = FieldWithMetaString.builder();
                return newBasketId;
            });
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getBasketName() {
            return this.basketName;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketName() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.basketName != null ? this.basketName : (this.basketName = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public Integer getMthToDefault() {
            return this.mthToDefault;
        }

        @Override
        public Integer getNthToDefault() {
            return this.nthToDefault;
        }

        @Override
        public ReferencePool.ReferencePoolBuilder getReferencePool() {
            return this.referencePool;
        }

        @Override
        public ReferencePool.ReferencePoolBuilder getOrCreateReferencePool() {
            ReferencePool.ReferencePoolBuilder result = this.referencePool != null ? this.referencePool : (this.referencePool = ReferencePool.builder());
            return result;
        }

        @Override
        public Tranche.TrancheBuilder getTranche() {
            return this.tranche;
        }

        @Override
        public Tranche.TrancheBuilder getOrCreateTranche() {
            Tranche.TrancheBuilder result = this.tranche != null ? this.tranche : (this.tranche = Tranche.builder());
            return result;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString basketId) {
            if (basketId != null) {
                this.basketId.add(basketId.toBuilder());
            }
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString basketId, int _idx) {
            this.getIndex(this.basketId, _idx, () -> basketId.toBuilder());
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketIdValue(String basketId) {
            this.getOrCreateBasketId(-1).setValue(basketId);
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketIdValue(String basketId, int _idx) {
            this.getOrCreateBasketId(_idx).setValue(basketId);
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketId(List<? extends FieldWithMetaString> basketIds) {
            if (basketIds != null) {
                for (FieldWithMetaString fieldWithMetaString : basketIds) {
                    this.basketId.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setBasketId(List<? extends FieldWithMetaString> basketIds) {
            this.basketId = basketIds == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)basketIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder addBasketIdValue(List<? extends String> basketIds) {
            if (basketIds != null) {
                for (String string : basketIds) {
                    this.addBasketIdValue(string);
                }
            }
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setBasketIdValue(List<? extends String> basketIds) {
            this.basketId.clear();
            if (basketIds != null) {
                basketIds.forEach(this::addBasketIdValue);
            }
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setBasketName(FieldWithMetaString basketName) {
            this.basketName = basketName == null ? null : basketName.toBuilder();
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setBasketNameValue(String basketName) {
            this.getOrCreateBasketName().setValue(basketName);
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setMthToDefault(Integer mthToDefault) {
            this.mthToDefault = mthToDefault == null ? null : mthToDefault;
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setNthToDefault(Integer nthToDefault) {
            this.nthToDefault = nthToDefault == null ? null : nthToDefault;
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setReferencePool(ReferencePool referencePool) {
            this.referencePool = referencePool == null ? null : referencePool.toBuilder();
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder setTranche(Tranche tranche) {
            this.tranche = tranche == null ? null : tranche.toBuilder();
            return this;
        }

        @Override
        public BasketReferenceInformation build() {
            return new BasketReferenceInformationImpl(this);
        }

        @Override
        public BasketReferenceInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder prune() {
            this.basketId = this.basketId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.basketName != null && !this.basketName.prune().hasData()) {
                this.basketName = null;
            }
            if (this.referencePool != null && !this.referencePool.prune().hasData()) {
                this.referencePool = null;
            }
            if (this.tranche != null && !this.tranche.prune().hasData()) {
                this.tranche = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBasketId() != null && !this.getBasketId().isEmpty()) {
                return true;
            }
            if (this.getBasketName() != null) {
                return true;
            }
            if (this.getMthToDefault() != null) {
                return true;
            }
            if (this.getNthToDefault() != null) {
                return true;
            }
            if (this.getReferencePool() != null && this.getReferencePool().hasData()) {
                return true;
            }
            return this.getTranche() != null && this.getTranche().hasData();
        }

        public BasketReferenceInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BasketReferenceInformationBuilder o = (BasketReferenceInformationBuilder)other;
            merger.mergeRosetta(this.getBasketId(), o.getBasketId(), this::getOrCreateBasketId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketName(), (RosettaModelObjectBuilder)o.getBasketName(), this::setBasketName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferencePool(), (RosettaModelObjectBuilder)o.getReferencePool(), this::setReferencePool);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTranche(), (RosettaModelObjectBuilder)o.getTranche(), this::setTranche);
            merger.mergeBasic((Object)this.getMthToDefault(), (Object)o.getMthToDefault(), this::setMthToDefault, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNthToDefault(), (Object)o.getNthToDefault(), this::setNthToDefault, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketReferenceInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.basketId, _that.getBasketId())) {
                return false;
            }
            if (!Objects.equals(this.basketName, _that.getBasketName())) {
                return false;
            }
            if (!Objects.equals(this.mthToDefault, _that.getMthToDefault())) {
                return false;
            }
            if (!Objects.equals(this.nthToDefault, _that.getNthToDefault())) {
                return false;
            }
            if (!Objects.equals(this.referencePool, _that.getReferencePool())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketId != null ? this.basketId.hashCode() : 0);
            _result = 31 * _result + (this.basketName != null ? this.basketName.hashCode() : 0);
            _result = 31 * _result + (this.mthToDefault != null ? this.mthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.nthToDefault != null ? this.nthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.referencePool != null ? this.referencePool.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketReferenceInformationBuilder {basketId=" + this.basketId + ", basketName=" + this.basketName + ", mthToDefault=" + this.mthToDefault + ", nthToDefault=" + this.nthToDefault + ", referencePool=" + this.referencePool + ", tranche=" + this.tranche + '}';
        }
    }

    public static class BasketReferenceInformationImpl
    implements BasketReferenceInformation {
        private final List<? extends FieldWithMetaString> basketId;
        private final FieldWithMetaString basketName;
        private final Integer mthToDefault;
        private final Integer nthToDefault;
        private final ReferencePool referencePool;
        private final Tranche tranche;

        protected BasketReferenceInformationImpl(BasketReferenceInformationBuilder builder) {
            this.basketId = Optional.ofNullable(builder.getBasketId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.basketName = Optional.ofNullable(builder.getBasketName()).map(f -> f.build()).orElse(null);
            this.mthToDefault = builder.getMthToDefault();
            this.nthToDefault = builder.getNthToDefault();
            this.referencePool = Optional.ofNullable(builder.getReferencePool()).map(f -> f.build()).orElse(null);
            this.tranche = Optional.ofNullable(builder.getTranche()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends FieldWithMetaString> getBasketId() {
            return this.basketId;
        }

        @Override
        public FieldWithMetaString getBasketName() {
            return this.basketName;
        }

        @Override
        public Integer getMthToDefault() {
            return this.mthToDefault;
        }

        @Override
        public Integer getNthToDefault() {
            return this.nthToDefault;
        }

        @Override
        public ReferencePool getReferencePool() {
            return this.referencePool;
        }

        @Override
        public Tranche getTranche() {
            return this.tranche;
        }

        @Override
        public BasketReferenceInformation build() {
            return this;
        }

        @Override
        public BasketReferenceInformationBuilder toBuilder() {
            BasketReferenceInformationBuilder builder = BasketReferenceInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketReferenceInformationBuilder builder) {
            Optional.ofNullable(this.getBasketId()).ifPresent(builder::setBasketId);
            Optional.ofNullable(this.getBasketName()).ifPresent(builder::setBasketName);
            Optional.ofNullable(this.getMthToDefault()).ifPresent(builder::setMthToDefault);
            Optional.ofNullable(this.getNthToDefault()).ifPresent(builder::setNthToDefault);
            Optional.ofNullable(this.getReferencePool()).ifPresent(builder::setReferencePool);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketReferenceInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.basketId, _that.getBasketId())) {
                return false;
            }
            if (!Objects.equals(this.basketName, _that.getBasketName())) {
                return false;
            }
            if (!Objects.equals(this.mthToDefault, _that.getMthToDefault())) {
                return false;
            }
            if (!Objects.equals(this.nthToDefault, _that.getNthToDefault())) {
                return false;
            }
            if (!Objects.equals(this.referencePool, _that.getReferencePool())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.basketId != null ? this.basketId.hashCode() : 0);
            _result = 31 * _result + (this.basketName != null ? this.basketName.hashCode() : 0);
            _result = 31 * _result + (this.mthToDefault != null ? this.mthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.nthToDefault != null ? this.nthToDefault.hashCode() : 0);
            _result = 31 * _result + (this.referencePool != null ? this.referencePool.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketReferenceInformation {basketId=" + this.basketId + ", basketName=" + this.basketName + ", mthToDefault=" + this.mthToDefault + ", nthToDefault=" + this.nthToDefault + ", referencePool=" + this.referencePool + ", tranche=" + this.tranche + '}';
        }
    }

    public static interface BasketReferenceInformationBuilder
    extends BasketReferenceInformation,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketId(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getBasketId();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateBasketName();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getBasketName();

        public ReferencePool.ReferencePoolBuilder getOrCreateReferencePool();

        @Override
        public ReferencePool.ReferencePoolBuilder getReferencePool();

        public Tranche.TrancheBuilder getOrCreateTranche();

        @Override
        public Tranche.TrancheBuilder getTranche();

        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString var1);

        public BasketReferenceInformationBuilder addBasketId(FieldWithMetaString var1, int var2);

        public BasketReferenceInformationBuilder addBasketIdValue(String var1);

        public BasketReferenceInformationBuilder addBasketIdValue(String var1, int var2);

        public BasketReferenceInformationBuilder addBasketId(List<? extends FieldWithMetaString> var1);

        public BasketReferenceInformationBuilder setBasketId(List<? extends FieldWithMetaString> var1);

        public BasketReferenceInformationBuilder addBasketIdValue(List<? extends String> var1);

        public BasketReferenceInformationBuilder setBasketIdValue(List<? extends String> var1);

        public BasketReferenceInformationBuilder setBasketName(FieldWithMetaString var1);

        public BasketReferenceInformationBuilder setBasketNameValue(String var1);

        public BasketReferenceInformationBuilder setMthToDefault(Integer var1);

        public BasketReferenceInformationBuilder setNthToDefault(Integer var1);

        public BasketReferenceInformationBuilder setReferencePool(ReferencePool var1);

        public BasketReferenceInformationBuilder setTranche(Tranche var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("mthToDefault"), Integer.class, (Object)this.getMthToDefault(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nthToDefault"), Integer.class, (Object)this.getNthToDefault(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketId"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getBasketId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketName"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getBasketName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referencePool"), processor, ReferencePool.ReferencePoolBuilder.class, this.getReferencePool(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tranche"), processor, Tranche.TrancheBuilder.class, this.getTranche(), new AttributeMeta[0]);
        }

        public BasketReferenceInformationBuilder prune();
    }
}

